/* ********************************************************** callback.c *** *
 * ˥塼ΥХåؿ
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/05/15 16:20:28 sugaya>
 * ************************************************************************* */
#include <dlfcn.h>
#include <gconf/gconf-client.h>
#include "teoeyes.h"
#include "gtkdirtreeview.h"
#include "assistant.h"
#include "callback.h"
#include "cripping.h"
#include "edit.h"
#include "draw.h"
#include "image_info.h"
#include "image_io.h"
#include "image_window.h"
#include "list_viewer.h"
#include "open.h"
#include "operation.h"
#include "option.h"
#include "player.h"
#include "print-callbacks.h"
#include "property.h"
#include "save.h"

#include "logo.icon"

#define	GNOME_BACKGROUND_FILENAME "/desktop/gnome/background/picture_filename"
#define	GNOME_BACKGROUND_OPTION   "/desktop/gnome/background/picture_options"

enum {
  WALLPAPER_ALIGN_TILED,
  WALLPAPER_ALIGN_CENTERED,
  WALLPAPER_ALIGN_STRETCHED,
  WALLPAPER_ALIGN_SCALED
};

/* ************************************************************************* *
 * ɥ˴ؤ륳Хåؿ
 *
 * cb_open
 * cb_save
 * cb_save_as
 * cb_print
 * cb_top_image
 * cb_previous_image
 * cb_next_image
 * cb_bottom_image
 * cb_top_frame
 * cb_previous_frame
 * cb_next_frame
 * cb_bottom_frame
 * cb_size_double
 * cb_size_half
 * cb_size_up
 * cb_size_down
 * cb_show_menubar
 * cb_draw_on_desktop
 * cb_original
 * cb_grayscale
 * cb_reverse
 * cb_normalize
 * cb_flip_horizontal
 * cb_flip_vertical
 * cb_show_lv
 * cb_show_ixp
 * cb_show_editor
 * cb_show_player
 * cb_show_image_info
 * cb_show_config
 * cb_show_about
 * cb_quit
 * ************************************************************************* */

/* ɥΥץ ************************************************ */
void
cb_new (GtkWidget	*widget,
	gpointer	data) {
  teoeyes_open_image_on_new_window (NULL);
}

/* Υץ ********************************************************** */
void
cb_open (GtkWidget	*widget,
	 gpointer	data) {
  if (!open_dialog) open_dialog = open_dialog_new (_("Open File Selection"));
  if (!GTK_WIDGET_VISIBLE (open_dialog)) gtk_widget_show_all (open_dialog);
}

/* ¸ ************************************************************** */
void
cb_save (GtkWidget	*widget,
	 gpointer	data) {
  teoeyes_save_image (ti_get_file_path (image_list),
		      tc->confirm_save, tc->confirm_overwrite);
}

/* ¸ ************************************************************** */
void
cb_save_as (GtkWidget	*widget,
	    gpointer	data) {
  if (!save_dialog) save_dialog = save_dialog_new (_("Save File Selection"));
  if (!GTK_WIDGET_VISIBLE (save_dialog)) gtk_widget_show_all (save_dialog);
}

/*  ******************************************************************** */
void
cb_print (GtkWidget	*widget,
	  gpointer	data) {
  print_dialog_show (GTK_WINDOW (image_window), image_list);
}

/* Ƭβɽ  ******************************************************* */
void
cb_top_image (GtkWidget	*widget,
	      gpointer	data) {
  image_list = g_list_first (image_list);
  if (!ti_get_pixbuf (image_list)) {
    teoeyes_image_load (ti_get_image (image_list), 0, to->min, to->max);
  }
  gtk_widget_set_size_request (get_widget (image_window, "canvas"), 
			       ti_get_width  (image_list),
			       ti_get_height (image_list));  
}

/* βɽ  ******************************************************* */
void
cb_previous_image (GtkWidget	*widget,
		   gpointer	data) {
  if (g_list_previous (image_list)) {
    image_list = g_list_previous (image_list);
    if (!ti_get_pixbuf (image_list)) {
      teoeyes_image_load (ti_get_image (image_list), 0, to->min, to->max);
    }
    gtk_widget_set_size_request (get_widget (image_window, "canvas"),
				 ti_get_width  (image_list),
				 ti_get_height (image_list));  
  }
}

/* βɽ  ******************************************************* */
void
cb_next_image (GtkWidget	*widget,
	       gpointer	data) {
  if (g_list_next (image_list)) {
    image_list = g_list_next (image_list);
    if (!ti_get_pixbuf (image_list)) {
      teoeyes_image_load (ti_get_image (image_list), 0, to->min, to->max);
    }
    gtk_widget_set_size_request (get_widget (image_window, "canvas"),
				 ti_get_width  (image_list),
				 ti_get_height (image_list));  
  }
}

/* Ǹβɽ  ******************************************************* */
void
cb_bottom_image (GtkWidget	*widget,
		 gpointer	data) {
  image_list = g_list_last (image_list);
  if (!ti_get_pixbuf (image_list)) {
    teoeyes_image_load (ti_get_image (image_list), 0, to->min, to->max);
  }
  gtk_widget_set_size_request (get_widget (image_window, "canvas"),
			       ti_get_width  (image_list),
			       ti_get_height (image_list));  
}

/* ƬΥե졼ɽ **************************************************** */
void
cb_top_frame (GtkWidget	*widget,
	      gpointer	data) {
  TEImage	*ti;

  ti = ti_get_image (image_list);
  if (!ti->fp) return;

  teoeyes_image_load (ti_get_image (image_list), 0, to->min, to->max);
  gtk_widget_set_size_request (get_widget (image_window, "canvas"),
			       ti_get_width  (image_list),
			       ti_get_height (image_list));    
}

/* Υե졼ɽ ****************************************************** */
void
cb_previous_frame (GtkWidget	*widget,
		   gpointer	data) {
  TEImage	*ti;

  ti = ti_get_image (image_list);
  if (!ti->fp) return;
  if (ti->frame > 0) {
    teoeyes_image_load (ti_get_image (image_list),
			ti->frame-1, to->min, to->max);
    gtk_widget_set_size_request (get_widget (image_window, "canvas"),
				 ti_get_width  (image_list),
				 ti_get_height (image_list));    
  }
}

/* Υե졼ɽ ****************************************************** */
void
cb_next_frame (GtkWidget	*widget,
	       gpointer		data) {
  TEImage	*ti;

  ti = ti_get_image (image_list);
  if (!ti->fp) return;
  if (ti->frame < ti->nframes-1) {
    teoeyes_image_load (ti_get_image (image_list),
			ti->frame+1, to->min, to->max);
    gtk_widget_set_size_request (get_widget (image_window, "canvas"),
				 ti_get_width  (image_list),
				 ti_get_height (image_list));    
  }
}

/* ǸΥե졼ɽ **************************************************** */
void
cb_bottom_frame (GtkWidget	*widget,
		 gpointer	data) {
  TEImage	*ti;

  ti = ti_get_image (image_list);
  if (!ti->fp) return;

  teoeyes_image_load (ti_get_image (image_list),
		      ti->nframes-1, to->min, to->max);
  gtk_widget_set_size_request (get_widget (image_window, "canvas"),
			       ti_get_width  (image_list),
			       ti_get_height (image_list));    
}

/* ץ졼ɽɽؤ ********************************************** */
void
cb_plane_mode (GtkWidget	*widget,
	       gpointer		data) {
  if (ti_get_channel (image_list) == -1) {
    ti_set_channel (image_list, 0);
  } else {
    ti_set_channel (image_list, -1);
  }
  draw_image (image_list, 
	      ti_get_current_width  (image_list), 
	      ti_get_current_height (image_list));
}

/* ƬΥץ졼ɽ **************************************************** */
void
cb_top_plane (GtkWidget	*widget,
	      gpointer	data) {
  if (ti_get_channel (image_list) == -1) return;
  ti_set_channel (image_list, 0);
  draw_image (image_list, 
	      ti_get_current_width  (image_list), 
	      ti_get_current_height (image_list));
}

/* Υץ졼ɽ ****************************************************** */
void
cb_previous_plane (GtkWidget	*widget,
		   gpointer	data) {
  int	channel;

  if (ti_get_channel (image_list) == -1) return;
  channel = ti_get_channel (image_list);
  if (channel != 0) ti_set_channel (image_list, channel-1);
  draw_image (image_list, 
	      ti_get_current_width  (image_list), 
	      ti_get_current_height (image_list));
}

/* Υץ졼ɽ ****************************************************** */
void
cb_next_plane (GtkWidget	*widget,
	       gpointer		data) {
  int	channel;

  if (ti_get_channel (image_list) == -1) return;
  channel = ti_get_channel (image_list);
  if (channel < ti_get_nchannels (image_list) - 1) {
    ti_set_channel (image_list, channel + 1);
  }
  draw_image (image_list, 
	      ti_get_current_width  (image_list), 
	      ti_get_current_height (image_list));
}

/* ǸΥץ졼ɽ **************************************************** */
void
cb_bottom_plane (GtkWidget	*widget,
		 gpointer	data) {
  if (ti_get_channel (image_list) == -1) return;
  ti_set_channel (image_list, ti_get_nchannels (image_list) - 1);
  draw_image (image_list, 
	      ti_get_current_width  (image_list), 
	      ti_get_current_height (image_list));
}

/* γ(2) *************************************************** */
void
cb_size_double (GtkWidget	*widget,
		gpointer	data) {
  scaling_by_scale (image_list, 2.0, 2.0);
}

/* ν̾(1/2) ************************************************* */
void
cb_size_half (GtkWidget	*widget,
	      gpointer	data) {
  scaling_by_scale (image_list, 0.5, 0.5);
}

/* ************************************************************************* */
void
cb_size_up (GtkWidget	*widget,
	    gpointer	data) {
  scaling_by_scale (image_list, 1.1, 1.1);
}

/* ************************************************************************* */
void
cb_size_down (GtkWidget	*widget,
	      gpointer	data) {
  scaling_by_scale (image_list, 0.9, 0.9);
}

/* ˥塼Сɽ/ɽ *********************************************** */
void
cb_show_menubar (GtkWidget	*widget,
		 gpointer	data) {
  GtkWidget	*menubar;

  menubar = G_GET_WIDGET (image_window, "menubar");
  if ((gboolean) G_GET_PARAMETER (image_window, "show_menubar")) {
    gtk_widget_hide (menubar);
    G_SET_PARAMETER (image_window, "show_menubar", FALSE);
  } else {
    gtk_widget_show (menubar);
    if (!((gboolean) G_GET_PARAMETER (image_window, "scrollable"))) {
      G_SET_PARAMETER (image_window, "forcescroll", TRUE);
      image_window_set_size (image_window,
			     ti_get_current_width  (image_list),
			     ti_get_current_height (image_list));
    }
    G_SET_PARAMETER (image_window, "show_menubar", TRUE);
  }
}

/* ǥåȥåطʤȤ ************************************** */
void
set_as_wallpaper (const gchar	*filename,
		  gint		align) {
  TeoeyesImageModule	*module;
  GConfClient 		*client;
  char  	      *options = NULL;

  if (!filename) return;
  
  module = select_module_from_file (filename);
  if (strcmp (module->module_name, "PNG")  != 0 &&
      strcmp (module->module_name, "JPEG") != 0) return;

  client = gconf_client_get_default ();
  gconf_client_set_string (client, GNOME_BACKGROUND_FILENAME, filename, NULL);

  switch (align) {
  case WALLPAPER_ALIGN_TILED:
    options = "wallpaper";
    break;
  case WALLPAPER_ALIGN_CENTERED:
    options = "centered";
    break;
  case WALLPAPER_ALIGN_STRETCHED:
    options = "stretched";
    break;
  case WALLPAPER_ALIGN_SCALED:
    options = "scaled";
    break;
  }
  gconf_client_set_string (client, GNOME_BACKGROUND_OPTION, options, NULL);
  g_object_unref (G_OBJECT (client));
}

/* ɻ˥å ************************************************************ */
void
cb_wallpaper_centered (GtkWidget	*widget,
		       gpointer		data) {
  set_as_wallpaper (ti_get_file_path (image_list), WALLPAPER_ALIGN_CENTERED);
}

/* ɻ˥å ************************************************************ */
void
cb_wallpaper_tiled (GtkWidget	*widget,
		    gpointer	data) {
  set_as_wallpaper (ti_get_file_path (image_list), WALLPAPER_ALIGN_TILED);
}

/* ɻ˥å ************************************************************ */
void
cb_wallpaper_scaled (GtkWidget	*widget,
		     gpointer	data) {
  set_as_wallpaper (ti_get_file_path (image_list), WALLPAPER_ALIGN_SCALED);
}

/* ɻ˥å ************************************************************ */
void
cb_wallpaper_stretched (GtkWidget	*widget,
			gpointer	data) {
  set_as_wallpaper (ti_get_file_path (image_list), WALLPAPER_ALIGN_STRETCHED);
}

/* ɥ **************************************************************** */
void
cb_undo (GtkWidget	*widget,
	 gpointer	data) {
  restore_backup (image_list);
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));
}

/* ꥸʥ᤹ **************************************************** */
void
cb_original (GtkWidget	*widget,
	     gpointer	data) {
  if (!ti_get_external (image_list)) return;

  do_backup (image_list);
  original_image (image_list);
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));  
}

/* 쥤 ********************************************************** */
void
cb_grayscale (GtkWidget	*widget,
	      gpointer	data) {
  do_backup (image_list);    
  grayscale_image (image_list);
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));  
}

/* ͤȿž ************************************************************ */
void
cb_reverse (GtkWidget	*widget,
	    gpointer	data) {
  do_backup (image_list);    
  reverse_image (image_list);
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));  
}

/* ͤ ********************************************************** */
void
cb_normalize (GtkWidget	*widget,
	      gpointer	data) {
  do_backup (image_list);    
  normalize_image (image_list, -1, -1);
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));  
}

/* κȿž ********************************************************** */
void
cb_flip_horizontal (GtkWidget	*widget,
		    gpointer	data) {
  do_backup (image_list);    
  flip_horizontal (image_list);
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));	      
}

/* ξ岼ȿž ********************************************************** */
void
cb_flip_vertical (GtkWidget	*widget,
		  gpointer	data) {
  do_backup (image_list);    
  flip_vertical (image_list);
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));	      
}

/* ꥹȥӥ塼ɽ ************************************************ */
void
cb_show_lv (GtkWidget	*widget,
	    gpointer	data) {
  if (!list_viewer) list_viewer = list_viewer_new ();
  if (!GTK_WIDGET_VISIBLE (list_viewer)) gtk_widget_show (list_viewer);
}

/* ץɽ ************************************************ */
void
cb_show_ixp (GtkWidget	*widget,
	     gpointer	data) {
  gchar	*dir;
  
  if (!explorer) explorer = ixp_new ();
  if (!GTK_WIDGET_VISIBLE (explorer->window)) {
    gtk_widget_show (explorer->window);
    gtk_widget_show_all (explorer->icon_window);
    dir = g_dir_get_current_dir ();
    gtk_dir_tree_view_set_dir (GTK_DIR_TREE_VIEW (explorer->dir_tree), dir);
    ixp_scan_dir (explorer, dir);
    gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (explorer->dir_combo)->entry),
			dir);
    ixp_combo_list_add (explorer, explorer->dir_combo, dir);
    g_free (dir);
  }
}

/* ************************************************************************* */
void
cb_show_editor (GtkWidget	*widget,
		gpointer	data) {
  GtkWidget	*button;
  
  if (!edit_window) edit_window = edit_window_new ();
  if (!GTK_WIDGET_VISIBLE (edit_window)) gtk_widget_show_all (edit_window);
  button = G_GET_WIDGET (edit_window, "channel_button0");
  if (button) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
  edit_draw_preview ();  
}

/* ץ졼ɽ ****************************************************** */
void
cb_show_player (GtkWidget	*widget,
		gpointer	data) {
  if (!player) player = player_new (tc->player_skin);
  if (!GTK_WIDGET_VISIBLE (player)) gtk_widget_show (player);
  player_sync_to_skin (player);
  update_timer 
    = gtk_timeout_add (50, (GtkFunction) player_update_window, NULL);
}

/* ƥȤɽ ******************************************** */
void
cb_show_assistant (GtkWidget	*widget,
		   gpointer	data) {
  AssistantSkinData	*skin;
  int			rw, rh;

  if (!assistant) assistant = assistant_new (tc->assistant_skin);

  gtk_widget_show (assistant);

  gdk_window_get_size (GDK_ROOT_PARENT (), &rw, &rh);
  skin = (AssistantSkinData *)
    gtk_object_get_data (GTK_OBJECT (assistant), "skin");
  gtk_widget_set_uposition (assistant,
			    rw - skin->width - 50, rh - skin->height - 50);
}

/* ɽ ************************************************ */
void
cb_show_image_info (GtkWidget	*widget,
		    gpointer	data) {
  if (!info_dialog) info_dialog = info_dialog_new ();
  info_dialog_set_info (info_dialog, image_list);    
  if (!GTK_WIDGET_VISIBLE (info_dialog)) gtk_widget_show_all (info_dialog);
}

/* ************************************************************************* */
void
cb_show_config (GtkWidget	*widget,
		gpointer	data) {
  if (!config_dialog) config_dialog = config_dialog_new ();
  if (!GTK_WIDGET_VISIBLE (config_dialog)) gtk_widget_show (config_dialog);
}

/* ************************************************************************* */
void
cb_show_about (GtkWidget	*widget,
	       gpointer		data) {
  GtkWidget	*about;
  const gchar	*authors[]
    = {"Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>", NULL};
  const gchar	*documents[]
    = {"Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>", NULL};
  const gchar	*translator
    = "Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>";
  GdkPixbuf	*pixbuf;

  pixbuf = gdk_pixbuf_new_from_inline (-1, logo_pixbuf, FALSE, NULL);
  about = gnome_about_new (_("Teoeyes"),
			   VERSION,
			   _("Copyright (C) 1998-2003 Yasuyuki SUGAYA"),
			   _("TEO Image Viewer\n"
			     "http://www.suri.it.okayama-u.ac.jp/~sugaya/teoeyes3/"),
			   authors,
			   documents,
			   translator,
			   pixbuf);
  gtk_window_set_icon (GTK_WINDOW (about), te_icon);
  gtk_widget_show (about);
}

/* إɽ ************************************************************** */
void
cb_show_help (GtkWidget	*widget,
	      gpointer	data) {
  gchar	*url;

  if (!html_window) html_window = html_window_new ();
    gtk_widget_set_size_request (html_window, HTML_WINDOW_W, HTML_WINDOW_H);
  if (!GTK_WIDGET_VISIBLE (html_window)) gtk_widget_show_all (html_window);
  url = g_strconcat ("file://", TEOEYES_HTML_DIR, G_DIR_SEPARATOR_S,
		     "index.html", NULL);
  assistant_set_document ((DhHtml *)
			  g_object_get_data (G_OBJECT (html_window),
					     "document"),
			  url);
  g_free (url);
}	

/* λ **************************************************************** */
void
cb_quit (GtkWidget	*widget,
	 gpointer	data) {
  /* ǡβ */
  g_list_foreach (g_list_first (image_list), (GFunc) teoeyes_image_free, NULL);

  /* ǡβ */
  if (te_icon) gdk_pixbuf_unref (te_icon);

  /* åȤβ */
  if (assistant)     assistant_destroy  (assistant);	
  if (explorer)      ixp_widget_destroy (explorer);
  if (pixel_window)  gtk_widget_destroy (pixel_window);
  if (edit_window)   gtk_widget_destroy (edit_window);
  if (html_window)   gtk_widget_destroy (html_window);
  if (config_dialog) gtk_widget_destroy (config_dialog);
  if (open_dialog)   gtk_widget_destroy (open_dialog);
  if (save_dialog)   gtk_widget_destroy (save_dialog);  
  if (info_dialog)   gtk_widget_destroy (info_dialog);
  if (loope)         gtk_widget_destroy (loope);
  if (player)	     gtk_widget_destroy (player);

  /* ץ¤β */
  if (to) teoeyes_free_option (to);

  /* ե¤β */
  if (tc) config_free_file (tc);

  /* ץ饰ơ֥β */
  if (plugin_table) g_hash_table_destroy (plugin_table);

  /* ץ饰ꥹȤβ */
  if (plugin_list) g_list_free (g_list_first (plugin_list));
  if (handle_list) {
    g_list_foreach (g_list_first (handle_list), (GFunc) dlclose, NULL);
  }
  /* ꥹȤβ */
  loader_close (image_loader);

  gtk_main_quit ();
}

/* *************************************************** End of callback.c *** */
