/* ************************************************************** save.c *** *
 * ¸
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/03/27 15:48:22 sugaya>
 * ************************************************************************* */
#include <dlfcn.h>
#include "teoeyes.h"
#include "image_loader.h"
#include "image_io.h"
#include "message.h"
#include "save.h"

#include "gtkcustomiconfilesel.h"

/* ؿ ************************************************************ */
static void	cb_set_format 		(GtkWidget		*widget,
					 gchar			*extension);
static void	cb_dialog_ok		(GtkWidget		*widget,
					 GtkCustomIconFileSel	*dialog);
static void	cb_dialog_cancel 	(GtkWidget		*widget,
					 GtkWidget		*dialog);
static void	cb_select_item 		(GtkFileList		*flist,
					 GtkFileListItem	*icon,
					 GdkEventButton		*ev,
					 gpointer		data);

/* եޥåȤŪꤹ ****************************************** */
static void
cb_set_format (GtkWidget	*widget,
	       gchar		*extension) {
  gchar	*ext, *ptr, *filename;
  gchar	head[1024];
  gchar name[1024];

  /* ե̾ */  
  filename = (char *)
    gtk_entry_get_text ((GtkEntry *)
			GTK_CUSTOM_ICON_FILESEL (save_dialog)->file_entry);
  if (!filename) return;

  if (strcmp (filename, "") == 0) {
    sprintf (name, ".%s", extension);
    gtk_entry_set_text (GTK_ENTRY
			(GTK_CUSTOM_ICON_FILESEL (save_dialog)->file_entry), 
			name);
  } else {
    /* ĥҤγ */
    ext = strrchr (filename, '.');
    /* ĥҤ˱ƥե̾ѹ */
    if (!ext) {	/* ĥҤʤ */
      sprintf (name, "%s.%s", filename, extension);
      gtk_entry_set_text (GTK_ENTRY
			  (GTK_CUSTOM_ICON_FILESEL (save_dialog)->file_entry), 
			  name);
    } else {	/* ĥҤ */
      ptr = head;
      while (filename < ext) *ptr++ = *filename++;
      *ptr = '\0';
      sprintf (name, "%s.%s", head, extension);
      gtk_entry_set_text (GTK_ENTRY
			  (GTK_CUSTOM_ICON_FILESEL (save_dialog)->file_entry), 
			  name);
    }
  }
}

/* OKܥ󤬲줿ν ********************************************** */
static void
cb_dialog_ok (GtkWidget			*widget,
	      GtkCustomIconFileSel	*dialog) {
  gchar			*filename;
  
  /* ե̾ */
  filename = (gchar *) 
    gtk_custom_icon_file_selection_get_filename (GTK_CUSTOM_ICON_FILESEL
						 (dialog));
  if (!filename || strcmp (filename, "") == 0 || g_dir_is (filename)) return;  

  /* ¸ */
  if (teoeyes_save_image (filename, tc->confirm_save, tc->confirm_overwrite)) {
    gtk_widget_hide (save_dialog);
  }
}

/* Cancelܥ󤬲줿ν ****************************************** */
static void 
cb_dialog_cancel (GtkWidget	*widget,
		  GtkWidget	*dialog) {
  gtk_widget_hide (dialog);
}

/* ************************************************************************* */
static void
cb_select_item (GtkFileList		*flist,
		GtkFileListItem		*icon,
		GdkEventButton		*ev,
		gpointer		data) {
  if (ev->type == GDK_2BUTTON_PRESS) {
    cb_dialog_ok (NULL, GTK_CUSTOM_ICON_FILESEL (data));
  }
}

/* ************************************************************************* */
static void
save_dialog_destroy (GtkWidget	*widget,
		     gpointer	data) { 
  gtk_widget_hide (widget);
}

/* ¸ ************************************************ */
GtkWidget*
save_dialog_new (const gchar	*title) {
  TeoeyesImageModule	*module;
  GtkWidget		*dialog;
  GtkWidget		*packbox;
  GtkWidget		*box;
  GtkWidget		*widget;
  GtkWidget		*menu;
  GtkWidget 		*option_menu;
  GtkWidget		*item;
  GList			*list;
  gchar 		format_str[] = N_("By Extension");
  
  /*  */
  dialog = gtk_custom_icon_file_selection_new (title);
  gtk_window_set_icon (GTK_WINDOW (dialog), te_icon);
  g_signal_connect (G_OBJECT (dialog), "destroy",
		    G_CALLBACK (save_dialog_destroy), NULL);
  g_signal_connect (G_OBJECT (dialog), "delete_event",
		    G_CALLBACK (save_dialog_destroy), NULL);

  /* եޥå˥塼ɲ */
  packbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (packbox);
  gtk_box_pack_end (GTK_BOX (GTK_CUSTOM_ICON_FILESEL(dialog)->custom_box[6]),
		    packbox, FALSE, FALSE, 8);
  gtk_widget_show (GTK_CUSTOM_ICON_FILESEL(dialog)->custom_box[6]);
  gtk_container_set_border_width (GTK_CONTAINER (packbox), 5);  
  G_SET_WIDGET (dialog, "packbox", packbox);
  {
    widget = gtk_label_new (_("Determine File Type :"));
    gtk_widget_show (widget);
    gtk_box_pack_start (GTK_BOX (packbox), widget, FALSE, FALSE, 0);
    G_SET_WIDGET (dialog, "label1", widget);

    box = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (box);
    gtk_box_pack_start (GTK_BOX (packbox), box, TRUE, TRUE, 0);
    G_SET_WIDGET (dialog, "vbox1", box);
    {
      option_menu = gtk_option_menu_new ();
      gtk_widget_show (option_menu);
      gtk_box_pack_start (GTK_BOX (box), option_menu, TRUE, TRUE, 0);
      G_SET_WIDGET (dialog, "option_menu", option_menu);
      {
	menu = gtk_menu_new ();
	gtk_widget_show (menu);
	gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
	G_SET_WIDGET (dialog, "menu", menu);
	{
	  item = gtk_menu_item_new_with_label (_(format_str));
	  gtk_widget_show (item);
#if 0
	  g_signal_connect (G_OBJECT (item), "activate",
			    G_CALLBACK (cb_set_format), NULL); 
#endif
	  gtk_menu_append (GTK_MENU (menu), item);
	  G_SET_WIDGET (dialog, "item", item);
	  list = image_loader;
	  while (list) {
	    module = dlsym (list->data, "module");
	    if ((module->info->flags & IMAGE_FORMAT_WRITABLE) != 0) {
#if 0
	      item=gtk_menu_item_new_with_label(_(((TeoeyesImageModule *)
						   list->data)->module_name));
#else
	      item = gtk_menu_item_new_with_label (_(module->module_name));
#endif
	      G_SET_WIDGET (dialog, "item", item);
	      g_signal_connect (G_OBJECT (item), "activate",
				G_CALLBACK (cb_set_format), 
				(gpointer) module->info->extensions[0]);
	      gtk_menu_append (GTK_MENU (menu), item);
	    }
	    list = g_list_next (list);
	  }
	}
      }
      gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);      
    }
  }
  /* ٥Ȥ */
  g_signal_connect (G_OBJECT (GTK_CUSTOM_ICON_FILESEL (dialog)->ok_button),
		    "clicked", G_CALLBACK (cb_dialog_ok), dialog);
  g_signal_connect (G_OBJECT (GTK_CUSTOM_ICON_FILESEL (dialog)->cancel_button),
		    "clicked", G_CALLBACK (cb_dialog_cancel), dialog);
  g_signal_connect (G_OBJECT (GTK_CUSTOM_ICON_FILESEL (dialog)->file_list),
		    "select_icon", G_CALLBACK (cb_select_item), dialog);

  return dialog;
}

/* ************************************************************************* */
gboolean
teoeyes_save_image (const gchar	*filename,
		    gboolean	flag_confirm,
		    gboolean	flag_overwrite) {
  TeoeyesImageModule	*module;  
  gchar			*ext;
  
  if (!filename) return FALSE;
  if (strcmp (filename, "") == 0) return FALSE;
  
  /* ¸ǧ */
  if (flag_confirm &&
      confirm_box_show (image_window,
			_("Confirm"),
			_("Are you sure you want to save it ?")) == FALSE) {
    return FALSE;
  }
  /* 񤭳ǧ */
  if (g_file_exist (filename) &&
      confirm_box_show (image_window,
			_("Confirm"),
			_("Already same filename exists.\n"
			  "Are you sure you want to overwrite it ?"))
      == FALSE) {
    return FALSE;
  }
  /* ¸ */

  /* ĥҤ */
  ext = strrchr (filename, '.');
  if (!ext || *(ext+1) == '\0') return FALSE;
  ext++;

  /* ĥҤǥ⥸塼 */
  module = select_module_from_extension (ext);

  if (!module || !(module->info->flags & IMAGE_FORMAT_WRITABLE)) return FALSE;
  
  if (strcmp (module->module_name, "TEO") == 0) {
    return module->save (filename, ti_get_image (image_list));
  } else {
    return module->save (filename, ti_get_pixbuf (image_list));
  }
}


/* ******************************************************* End of save.c *** */
