/* *********************************************************** teoeyes.h *** *
 * ƥ إåե
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/05/02 23:58:21 sugaya>
 * ************************************************************************* */
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkprivate.h>
#include <gnome.h>
#include "gdk-pixbuf-extension.h"
#include "gfileutils.h"
#include "macros.h"

/* ************************************************************************* */
#define	G_SET_OBJECT(parent,name,object) g_object_set_data_full (G_OBJECT (parent), name, g_object_ref (object), (GDestroyNotify) g_object_unref)

#define	G_SET_WIDGET(parent,name,widget) g_object_set_data_full (G_OBJECT (parent), name, gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define	G_SET_WIDGET_NO_REF(parent,name,widget)	g_object_set_data_full (G_OBJECT (parent), name, widget, (GDestroyNotify) gtk_widget_unref)

#define	G_SET_PARAMETER(parent,name,param) g_object_set_data (G_OBJECT (parent), name, (gpointer) (param))

#define	G_GET_OBJECT(parent,name) g_object_get_data (G_OBJECT (parent), name)
#define	G_GET_WIDGET(parent,name) g_object_get_data (G_OBJECT (parent), name)

#define	G_GET_PARAMETER(parent,name) g_object_get_data (G_OBJECT (parent), name)

#define get_widget(parent,name) g_object_get_data (G_OBJECT (parent), name)

/* TEImage¤ *********************************************************** */
typedef struct _TEImage {
  gchar			*filename;                             /* ե̾ */
  gint			xoffset;                              /* Xեå */
  gint			yoffset;                              /* Yեå */
  gint			width;                                   /*  */
  gint			height;                                /* ι⤵ */
  gint			current_width;                           /*  */
  gint			current_height;                        /* ι⤵ */
  gint			nframes;                               /* ե졼 */
  gint			nchannels;                             /* ͥ */
  gint			frame;                       /* ɽΥե졼ֹ */
  gint			channel;                     /* ɽΥֹͥ */
  guchar		type;                                  /* ͤη */
  guchar		bit;                                       /* ǥץ */
  gpointer		fp;                    /* եݥ (for TEO) */
  gpointer		original_data;     /* ꥸʥǡ (for TEO) */
  GList			*original_data_list;
  GList			*pixbuf_list;                /* ꥸʥǡ */
  GdkPixbuf		*pixbuf;                    /* GdkPixbufǡ */
  GdkPixbuf		*backup;                       /* Хååץǡ */
  GdkPixbufModifier 	*mod;                                /* ǡ */
  gboolean		has_alpha;               /* ץ졼󤬤뤫ɤ */
  gboolean		external;                      /* ǡɤ */
  gdouble		min;                                   /* Ǿ */
  gdouble		max;                                   /*  */
  gpointer		user_data1;
  gpointer		user_data2;
} TEImage;

/* ȥ ********************************************************** */
typedef struct _WindowGeometry {
  gint			width;		/* ɥ */
  gint			height;		/* ɥι⤵ */
  gint			x;		/* ɥXɸ */
  gint			y;		/* ɥYɸ */
  gint			xsign;		/* Xɸδ */
  gint			ysign;		/* Yɸδ */
} WindowGeometry;

/* ץ¤ ******************************************************** */
typedef struct _TEOption {
  gboolean		load_all;	/* ɥץ */
#if 0
  gboolean		clean_mem;	/* ǡץ */
#endif
  gboolean		normalize;	/* ץ */
  gint			frame;		/* ɽե졼ֹ */
  gint			wallpaper;	/* ɻ楿 */
  gdouble		min;		/* Ǿ */
  gdouble		max;		/*  */
  WindowGeometry	*geometry;	/* ȥ */
} TEOption;  

/* ܤι¤ ******************************************************** */
typedef struct _TEConfig {

  /* ǥեȥץ */
  gboolean		option_load_all;             /* ɥץ */
#if 0
  gboolean		option_clean_mem;            /* ǡץ */
#endif
  gboolean		option_normalize;                /* ץ */

  /* ǧ */
  gboolean		confirm_save;              /* ¸γǧץ */
  gboolean		confirm_overwrite;       /* 񤭻γǧץ */

  /* ֥饦 */
  gchar			*folder_icon;
  gchar			*thumbnail_dir;            /* ͥǥ쥯ȥ */
  gint			thumbnail_width;                   /* ͥ */
  gint			thumbnail_height;                /* ͥι⤵ */

  /*  */
  GList			*loader_dirs;                      /* ѥ */
  
  /* Ȥ */
  gchar			*assistant_skin;         /* ȥǡ */
  GList			*assistant_doc_dirs;       /* ȥǡѥ */
  gchar			*help_browser;

  /* ץ饰 */
  GList			*plugin_dirs;                      /* ץ饰ѥ */
  GList			*unuse_plugin_list;    /* Ѥʤץ饰ꥹ */

  /* 硼ȥåȤ */
  GList			*shortcut;                         /* 硼ȥå */
  GList			*shortcut_accel;     /* 硼ȥåȥ졼 */
  
  /* ¾ */
  gint			loope_scale;                               /* Ψ */
  gchar			*title_image;              /* ȥե̾ */
  gchar			*player_skin;                /* ץ졼䥹ǡ */

} TEConfig;

/* ************************************************************************* */
#include "browser.h"
#include "image.h"

/* Хѿ ********************************************************** */
GList		*image_list;
GList		*image_loader;
GList		*plugin_list;
GList		*handle_list;
GtkWidget	*image_window;
GtkWidget	*pixel_window;
GtkWidget	*edit_window;
GtkWidget	*html_window;
GtkWidget	*list_viewer;
GtkWidget	*player;
GtkWidget	*assistant;
GtkWidget	*loope;
GtkWidget	*info_dialog;
GtkWidget	*config_dialog;
GtkWidget	*open_dialog;
GtkWidget	*save_dialog;
GdkPixbuf	*te_icon;
TEBrowser	*explorer;
TEConfig	*tc;
TEOption	*to;
GHashTable	*plugin_table;
int		update_timer;

/* **************************************************** End of teoeyes.h *** */
