/* ********************************************** gnome-file-icon-list.h *** *
 * GnomeFileIconList إåե
 *
 * Copyright (C) 2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/02/28 10:17:34 sugaya>
 * ************************************************************************* */
/*
 * Copyright (C) 1998, 1999 Free Software Foundation
 * Copyright (C) 2000 Red Hat, Inc.
 * All rights reserved.
 *
 * This file is part of the Gnome Library.
 *
 * The Gnome Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The Gnome Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
  @NOTATION@
 */

/* GnomeIconList widget - scrollable icon list
 *
 *
 * Authors:
 *   Federico Mena   <federico@nuclecu.unam.mx>
 *   Miguel de Icaza <miguel@nuclecu.unam.mx>
 */

#ifndef _GNOME_FILE_ICON_LIST_H_
#define _GNOME_FILE_ICON_LIST_H_


#include <libgnomecanvas/gnome-canvas.h>
#include <libgnomecanvas/gnome-canvas-rich-text.h>
#include <libgnomecanvas/gnome-canvas-pixbuf.h>
#include <libgnomeui/gnome-icon-item.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "gnome-file-icon-list-item.h"

G_BEGIN_DECLS

#define GNOME_TYPE_FILE_ICON_LIST            (gnome_file_icon_list_get_type ())
#define GNOME_FILE_ICON_LIST(obj)            (GTK_CHECK_CAST ((obj), GNOME_TYPE_FILE_ICON_LIST, GnomeFileIconList))
#define GNOME_FILE_ICON_LIST_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_FILE_ICON_LIST, GnomeFileIconListClass))
#define GNOME_IS_FILE_ICON_LIST(obj)         (GTK_CHECK_TYPE ((obj), GNOME_TYPE_FILE_ICON_LIST))
#define GNOME_IS_FILE_ICON_LIST_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_FILE_ICON_LIST))
#define GNOME_FILE_ICON_LIST_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GNOME_TYPE_FILE_ICON_LIST, GnomeFileIconListClass))

typedef struct _GnomeFileIconList        GnomeFileIconList;
typedef struct _GnomeFileIconListPrivate GnomeFileIconListPrivate;
typedef struct _GnomeFileIconListClass   GnomeFileIconListClass;

/* This structure has been converted to use public and private parts.  To avoid
 * breaking binary compatibility, the slots for private fields have been
 * replaced with padding.  Please remove these fields when gnome-libs has
 * reached another major version and it is "fine" to break binary compatibility.
 */
struct _GnomeFileIconList {
  GnomeCanvas 			canvas;

  /* Scroll adjustments */
  GtkAdjustment 		*adj;

  /*< private >*/
  GnomeFileIconListPrivate 	*_priv;
};

struct _GnomeFileIconListClass {
  GnomeCanvasClass parent_class;

  void     (*select_icon)   (GnomeFileIconList *gil, gint num, GdkEvent *event);
  void     (*unselect_icon) (GnomeFileIconList *gil, gint num, GdkEvent *event);
  void     (*focus_icon)    (GnomeFileIconList *gil, gint num);
  gboolean (*text_changed)  (GnomeFileIconList *gil, gint num, const char *new_text);

  /* Key Binding signals */
  void     (*move_cursor)	(GnomeFileIconList *gil, GtkDirectionType dir, gboolean clear_selection);
  void     (*toggle_cursor_selection) (GnomeFileIconList *gil);
  void     (*unused)		(GnomeFileIconList *unused);
	
  /* Padding for possible expansion */
  gpointer padding1;
  gpointer padding2;
};

enum {
  GNOME_FILE_ICON_LIST_IS_EDITABLE	= 1 << 0,
  GNOME_FILE_ICON_LIST_STATIC_TEXT	= 1 << 1
};

GType		gnome_file_icon_list_get_type	(void) G_GNUC_CONST;

GtkWidget	*gnome_file_icon_list_new	(guint		icon_width,
						 guint		text_width,
						 GtkAdjustment 	*adj,
						 int		flags);

void	gnome_file_icon_list_construct	(GnomeFileIconList	*gil,
					 guint			icon_width,
					 guint			text_width,
					 GtkAdjustment		*adj,
					 int			flags);

void	gnome_file_icon_list_set_adjustment (GnomeFileIconList	*gil,
					     GtkAdjustment 	*adj);

/* To avoid excesive recomputes during insertion/deletion */
void	gnome_file_icon_list_freeze	(GnomeFileIconList 	*gil);
void	gnome_file_icon_list_thaw	(GnomeFileIconList 	*gil);

void	gnome_file_icon_list_insert	(GnomeFileIconList 	*gil,
					 int			pos,
					 const char		*icon_filename,
					 const char 		*text);
void	gnome_file_icon_list_insert_pixbuf (GnomeFileIconList 	*gil,
					    int 		pos,
					    GdkPixbuf 		*im,
					    const char 		*icon_filename,
					    const char 		*text);

int	gnome_file_icon_list_append	(GnomeFileIconList 	*gil,
					 const char 		*icon_filename,
					 const char 		*text);
int     gnome_file_icon_list_append_pixbuf (GnomeFileIconList 	*gil,
					    GdkPixbuf 		*im,
					    const char 		*icon_filename,
					    const char 		*text);

void    gnome_file_icon_list_clear	(GnomeFileIconList 	*gil);
void    gnome_file_icon_list_remove	(GnomeFileIconList 	*gil,
					 int 			pos);

guint   gnome_file_icon_list_get_num_icons (GnomeFileIconList 	*gil);


/* Managing the selection */
GtkSelectionMode
gnome_file_icon_list_get_selection_mode	(GnomeFileIconList 	*gil);
void    gnome_file_icon_list_set_selection_mode (GnomeFileIconList *gil,
						 GtkSelectionMode mode);
void    gnome_file_icon_list_select_icon (GnomeFileIconList 	*gil,
					  int 			pos);
void    gnome_file_icon_list_unselect_icon (GnomeFileIconList 	*gil,
					    int 		pos);
int     gnome_file_icon_list_unselect_all (GnomeFileIconList 	*gil);
GList * gnome_file_icon_list_get_selection (GnomeFileIconList 	*gil);

/* Managing focus */
void    gnome_file_icon_list_focus_icon	(GnomeFileIconList 	*gil,
					 gint 			idx);

/* Setting the spacing values */
void    gnome_file_icon_list_set_icon_width      (GnomeFileIconList	*gil,
						  int 			w);
void    gnome_file_icon_list_set_text_width      (GnomeFileIconList 	*gil,
						  int			w);
void    gnome_file_icon_list_set_row_spacing     (GnomeFileIconList 	*gil,
						  int 		pixels);
void    gnome_file_icon_list_set_col_spacing     (GnomeFileIconList 	*gil,
						  int 		pixels);
void    gnome_file_icon_list_set_text_spacing    (GnomeFileIconList 	*gil,
						  int 		pixels);
void    gnome_file_icon_list_set_icon_border     (GnomeFileIconList 	*gil,
						  int 		pixels);
void    gnome_file_icon_list_set_separators      (GnomeFileIconList 	*gil,
						  const char 		*sep);
/* Icon filename. */
gchar * gnome_file_icon_list_get_icon_filename   (GnomeFileIconList 	*gil,
						  int 			idx);
int     gnome_file_icon_list_find_icon_from_filename (GnomeFileIconList *gil,
						      const char *filename);

/* Attaching information to the icons */
void    gnome_file_icon_list_set_icon_data       (GnomeFileIconList 	*gil,
						  int 			idx,
						  gpointer 		data);
void    gnome_file_icon_list_set_icon_data_full  (GnomeFileIconList 	*gil,
						  int 			pos,
						  gpointer 		data,
						  GDestroyNotify destroy);
int     gnome_file_icon_list_find_icon_from_data (GnomeFileIconList 	*gil,
						  gpointer 		data);
gpointer gnome_file_icon_list_get_icon_data      (GnomeFileIconList 	*gil,
						  int 			pos);

/* Visibility */
void    gnome_file_icon_list_moveto             (GnomeFileIconList 	*gil,
						 int 			pos,
						 double		yalign);
GtkVisibility
gnome_file_icon_list_icon_is_visible		(GnomeFileIconList 	*gil,
						 int 			pos);

int     gnome_file_icon_list_get_icon_at         (GnomeFileIconList 	*gil,
						  int			x,
						  int 			y);

int     gnome_file_icon_list_get_items_per_line  (GnomeFileIconList 	*gil);

/* Accessibility functions */
GnomeFileIconTextItem
*gnome_file_icon_list_get_icon_text_item	(GnomeFileIconList 	*gil,
						 int 			idx);

GnomeCanvasPixbuf
*gnome_file_icon_list_get_icon_pixbuf_item 	(GnomeFileIconList 	*gil,
						 int			idx);

G_END_DECLS

#endif /* _GNOME_FILE_ICON_LIST_H_ */

/* *************************************** End of gnome-file-icon-list.h *** */
