/* ********************************************** gtkcustomiconfilesel.h *** *
 * ޥǽʥե
 *
 * Copyright (C) 2000-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/03/25 21:41:34 sugaya>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * gtkiconfileselection - gtkiconfileselection dialog widget for gtk+
 * Copyright 1999  Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 * Rewitten and customized for GTK+2 by Y.Sugaya
 * ************************************************************************* */

/* *** Layout of CustomFileSelection *************************************** *

  +---+---------------------------------------------------+---+
  | * | +-----------------------------------------------+ | * |
  | * | | *************** Custom Box 2 **************** | | * |
  | * | +-----------------------------------------------+ | * |
  | * | +-----------------------------------------------+ | * |
  | * | | *************** Custom Box 3 **************** | | * |
  | * | +-------+ +--------------------------+ +--+--+--+ | * |
  | * | | Label | | Combo                    | | Button | | * |
  | * | +-------+ +--------------------------+ +--+--+--+ | * |
  | * | | *************** Custom Box 3 **************** | | * |
  |   | +-----------------------------------------------+ |   |  
  | C | +-----------------------------------------------+ | C |
  |   | | *************** Custom Box 4 **************** | |   |
  | u | +-----------------------------------------------+ | u |
  |   | +-----------------------------------------------+ |   |
  | s | | *************** Custom Box 5 **************** | | s |  
  |   | +-------------+ +-------------------------------+ |   |
  | t | | Dir Tree    | |       Icon File List          | | t |	
  |   | |             | |                               | |   |	
  | u | |             | |                               | | u |	
  |   | |             | |                               | |   |	
  | m | |             | |                               | | m |
  |   | |             | |                               | |   |		
  | B | |             | |                               | | B |		
  |   | +-------------+ +-------------------------------+ |   |
  | o | | *************** Custom Box 5 **************** | | o |
  |   | +-----------------------------------------------+ |   |  
  | x | +-----------------------------------------------+ | x |
  |   | | *************** Custom Box 6 **************** | |   |
  | 0 | +-----------------------------------------------+ | 1 |
  | * | +-------+ +--------------------------+ +--------+ | * |
  | * | | Label | | Entry                    | | Button | | * |
  | * | +-------+ +--------------------------+ +--------+ | * | 
  | * | +-------+ +--------------------------+ +--------+ | * |
  | * | | Label | | Entry                    | | Button | | * |
  | * | +-------+ +--------------------------+ +--------+ | * | 
  | * | +-----------------------------------------------+ | * |
  | * | | *************** Custom Box 7 **************** | | * |
  | * | +-----------------------------------------------+ | * |
  +---+---------------------------------------------------+---+

  * ************************************************************************ */

#ifndef __GTK_CUSTOM_ICON_FILESEL_H__
#define __GTK_CUSTOM_ICON_FILESEL_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#if 0
#include <gnome.h>
#endif
#include "gtkdirtreeview.h"
#include "gtkfilelist.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define	GTK_TYPE_CUSTOM_ICON_FILESEL		(gtk_custom_icon_file_selection_get_type ())
#define GTK_CUSTOM_ICON_FILESEL(obj) 		(GTK_CHECK_CAST((obj), GTK_TYPE_CUSTOM_ICON_FILESEL, GtkCustomIconFileSel))
#define GTK_CUSTOM_ICON_FILESEL_CLASS(class) 	(GTK_CHECK_CLASS_CAST((class), GTK_TYPE_CUSTOM_ICON_FILESEL, GtkCustomIconFileSelClass))
#define GTK_IS_CUSTOM_ICON_FILESEL(obj)		(GTK_CHECK_TYPE((obj), GTK_TYPE_CUSTOM_ICON_FILESEL))
#define GTK_IS_CUSTOM_ICON_FILESEL_CLASS(class) (GTK_CHECK_CLASS_TYPE((class), GTK_TYPE_CUSTOM_ICON_FILESEL))

  typedef struct _GtkCustomIconFileSel       GtkCustomIconFileSel;
  typedef struct _GtkCustomIconFileSelClass  GtkCustomIconFileSelClass;

  struct _GtkCustomIconFileSel {
    GtkWindow	window;
    gchar	*title;
    gchar	*selected_file;
    GtkWidget	*tree_window;
    GtkWidget	*list_window;
    GtkWidget	*dir_tree;
    GtkWidget 	*file_list;
    GtkWidget	*file_entry;
    GtkWidget 	*filter_entry;
    GtkWidget 	*dir_combo;
    GtkWidget 	*folder_button_new;
    GtkWidget 	*folder_button_up;
    GtkWidget 	*folder_button_home;
    GtkWidget 	*ok_button;
    GtkWidget 	*cancel_button;
    GtkWidget	*custom_box[8];
    gboolean	show_tree;
    guint	tree_signal_id;
    GList	*dir_combo_list;
  };

  struct _GtkCustomIconFileSelClass {
    GtkWindowClass	parent_class;
  };

  GtkType
  gtk_custom_icon_file_selection_get_type		(void);

  GtkWidget*
  gtk_custom_icon_file_selection_new (const gchar	*title);

  void
  gtk_custom_icon_file_selection_show_dir_tree (GtkCustomIconFileSel *filesel,
						gboolean	show_tree);
  void
  gtk_custom_icon_file_selection_set_dir	(GtkCustomIconFileSel *filesel,
						 const gchar	*path);

  void
  gtk_custom_icon_file_selection_show_hidden	(GtkCustomIconFileSel *filesel,
						 gboolean	show_hidden);

  void
  gtk_custom_icon_file_selection_set_filter	(GtkCustomIconFileSel *filesel,
						 const gchar	*filter);

  gchar*
  gtk_custom_icon_file_selection_get_filename (GtkCustomIconFileSel *filesel);
  
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_CUSTOM_ICON_FILESEL_H__ */

/* *************************************** End of gtkcustomiconfilesel.h *** */

