/* ====================================================== */
/*  $B?'JQ49%k!<%A%s(B                         By Y.Mukaigaw  */
/*                                             1997/8/28  */
/* ====================================================== */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <teo.h>

/* ====================================================== */
/*  $B8m:9J?6Q%G%#%6$K$h$k(B $B%0%l%$(B -> $B%P%$%J%j(B $BJQ49(B          */
/*  $BJQ49B.EY:GM%@h%P!<%8%g%s$N$?$a(B, $B$-$l$$$G$O$"$j$^$;$s(B  */
/* ====================================================== */
TEOIMAGE *TeoUtilGray2Binary(TEOIMAGE *img){
  int		x,y;
  int		thres;
  TEO_BIT	now;
  TEO_UINT8	pixel;
  TEOIMAGE	*outimg;

  outimg  = TeoAllocImage(TeoWidth(img),TeoHeight(img),
			  TeoXoffset(img),TeoYoffset(img),
			  TEO_UNSIGNED, 1, 1);

  thres = 128;

  for (y=TeoYstart(img); y<=TeoYend(img); y++){
    for (x=TeoXstart(img); x<=TeoXend(img); x++){
      pixel = TeoGetPixel(img,x,y,0,TEO_UINT8);
      if (pixel > thres) now = 1; else now = 0;
      TeoPutBit(outimg,x,y,0,now);
      thres += now*255 - pixel;
    }
  }
  return outimg;
}

/* ====================================================== */
/*  $B%+%i!<(B -> $B%0%l%$(B                                      */                   
/* ====================================================== */
TEOIMAGE *TeoUtilRGB2Gray(TEOIMAGE *img){
  int		x,y;
  TEO_UINT8	rp,gp,bp,pixel;
  TEOIMAGE	*outimg;

  outimg  = TeoAllocImage(TeoWidth(img),TeoHeight(img),
			  TeoXoffset(img),TeoYoffset(img),
			  TEO_UNSIGNED, 8, 1);

  for (y=TeoYstart(img); y<=TeoYend(img); y++){
    for (x=TeoXstart(img); x<=TeoXend(img); x++){
      rp = TeoGetPixel(img,x,y,0,TEO_UINT8);
      gp = TeoGetPixel(img,x,y,1,TEO_UINT8);
      bp = TeoGetPixel(img,x,y,2,TEO_UINT8);
      pixel = (int)(0.299*rp + 0.587*gp + 0.114*bp);
      TeoPutPixel(outimg,x,y,0,TEO_UINT8,pixel);
    }
  }     
  return outimg;
}

/* ====================================================== */
/*  $B%P%$%J%j(B -> $B%0%l%$(B                                    */
/* ====================================================== */
TEOIMAGE *TeoUtilBinary2Gray(TEOIMAGE *img){
  int		x,y;
  TEOIMAGE	*outimg;

  outimg  = TeoAllocImage(TeoWidth(img),TeoHeight(img),
			  TeoXoffset(img),TeoYoffset(img),
			  TEO_UNSIGNED, 8, 1);

  for (y=TeoYstart(img); y<=TeoYend(img); y++){
    for (x=TeoXstart(img); x<=TeoXend(img); x++){
      if (TeoGetBit(img,x,y,0)==0){
	TeoPutPixel(outimg,x,y,0,TEO_UINT8,0);
      } else {
	TeoPutPixel(outimg,x,y,0,TEO_UINT8,255);
      }
    }
  }     
  return outimg;
}

/* ====================================================== */
/*  $B%0%l%$(B -> $B%+%i!<(B                                      */
/* ====================================================== */
TEOIMAGE *TeoUtilGray2RGB(TEOIMAGE *img){
  int		x,y;
  TEOIMAGE	*outimg;
  TEO_UINT8	pixel;

  outimg  = TeoAllocImage(TeoWidth(img),TeoHeight(img),
			  TeoXoffset(img),TeoYoffset(img),
			  TEO_UNSIGNED, 8, 3);

  for (y=TeoYstart(img); y<=TeoYend(img); y++){
    for (x=TeoXstart(img); x<=TeoXend(img); x++){
      pixel = TeoGetPixel(img,x,y,0,TEO_UINT8);
      TeoPutPixel(outimg,x,y,0,TEO_UINT8,pixel);
      TeoPutPixel(outimg,x,y,1,TEO_UINT8,pixel);
      TeoPutPixel(outimg,x,y,2,TEO_UINT8,pixel);
    }
  }     
  return outimg;
}

/* ====================================================== */
/*  RGV -> HSV                           By Sakaue        */
/* ====================================================== */
TEOIMAGE *TeoUtilRGB2HSV(TEOIMAGE *img){
  TEOIMAGE *imgOut;
  TEO_UINT8 *src;
  TEO_FLOAT64 *dst;
  int size,l;

  TEO_FLOAT64 R,G,B, H,S,V, C1,C2;

  if (!TeoIsUINT8(img) || TeoPlane(img)!=3 ){
    fprintf(stderr,"ERROR in teoutil(TeoUtilRGB2HSV)\n");
    fprintf(stderr,"The source image must be UINT8, 3planes.\n");
    exit(-1);
  }

  imgOut=TeoAllocImage(TeoWidth(img),TeoHeight(img),TeoXoffset(img),
                       TeoYoffset(img),TEO_FLOAT,64,3);

  src=(TEO_UINT8   *)TeoData(img);
  dst=(TEO_FLOAT64 *)TeoData(imgOut);
  
  size=TeoHeight(img)*TeoWidth(img);

  for (l=0;l<size;l++){
    R = *(src  );
    G = *(src+1);
    B = *(src+2);

    V = 0.299*(double)R+0.587*(double)G+0.114*(double)B;
    C1=(double)(R-V);
    C2=(double)(B-V);
    H = atan2(C1,C2);
    S = sqrt(C1*C1 + C2*C2);

    *dst    =H;
    *(dst+1)=S;
    *(dst+2)=V;

    src+=3;
    dst+=3;
  }
  return imgOut;
}

/* ====================================================== */
/*  RGV -> YCrCb                                          */
/* ====================================================== */
TEOIMAGE *TeoUtilRGB2YCrCb(TEOIMAGE *img){
  TEOIMAGE *imgOut;
  TEO_UINT8 *src;
  TEO_FLOAT64 *dst;
  int size,l;

  TEO_FLOAT64 R,G,B, Y,Cr,Cb;

  if (!TeoIsUINT8(img) || TeoPlane(img)!=3 ){
    fprintf(stderr,"ERROR in teoutil(TeoUtilRGB2YCrCb)\n");
    fprintf(stderr,"The source image must be UINT8, 3planes.\n");
    exit(-1);
  }

  imgOut=TeoAllocImage(TeoWidth(img),TeoHeight(img),TeoXoffset(img),
                       TeoYoffset(img),TEO_FLOAT,64,3);

  src=(TEO_UINT8   *)TeoData(img);
  dst=(TEO_FLOAT64 *)TeoData(imgOut);
  
  size = TeoHeight(img) * TeoWidth(img);

  for (l=0;l<size;l++){
    R = *(src  );
    G = *(src+1);
    B = *(src+2);

    Y = 0.299*(double)R+0.587*(double)G+0.114*(double)B;
    Cr=(double)(R-Y);
    Cb=(double)(B-Y);

    *dst    =Y;
    *(dst+1)=Cr;
    *(dst+2)=Cb;

    src+=3;
    dst+=3;
  }
  return imgOut;
}
