/**************/
/* $B;(B?$J4X?t(B */
/**************/

#include <stdio.h>
#include <stdlib.h>
#include <teo.h>

static void showErrorExit(char *msg){
  fprintf(stderr,"ERROR by TeoUtilCheck.\n");
  fprintf(stderr,msg);
  fprintf(stderr,"\n");
  exit(-1);
}
  
void TeoUtilCheckImage(TEOIMAGE *img, int width, int height,
		      int xoffset, int yoffset, int type, int bit, int plane){

  if (width != -1)
    if (TeoWidth(img) != width)
      showErrorExit("The width is incorrect.");

  if (height != -1)
    if (TeoHeight(img) != height)
      showErrorExit("The height is incorrect.");

  if (xoffset != -1)
    if (TeoXoffset(img) != xoffset)
      showErrorExit("The xoffset is incorrect.");

  if (yoffset != -1)
    if (TeoYoffset(img) != yoffset)
      showErrorExit("The yoffset is incorrect.");

  if (type != -1)
    if (TeoType(img) != type)
      showErrorExit("The type is incorrect.");

  if (bit != -1)
    if (TeoBit(img) != bit)
      showErrorExit("The number of bits is incorrect.");

  if (plane != -1)
    if (TeoPlane(img) != plane)
      showErrorExit("The number of planes is incorrect.");
}

void TeoUtilCheckFile(TEOFILE *file, int width, int height,
		      int xoffset, int yoffset, int type,
		      int bit, int plane, int frame){

  if (width != -1)
    if (TeoWidth(file) != width)
      showErrorExit("The width is incorrect.");

  if (height != -1)
    if (TeoHeight(file) != height)
      showErrorExit("The height is incorrect.");

  if (xoffset != -1)
    if (TeoXoffset(file) != xoffset)
      showErrorExit("The xoffset is incorrect.");

  if (yoffset != -1)
    if (TeoYoffset(file) != yoffset)
      showErrorExit("The yoffset is incorrect.");

  if (type != -1)
    if (TeoType(file) != type)
      showErrorExit("The type is incorrect.");

  if (bit != -1)
    if (TeoBit(file) != bit)
      showErrorExit("The number of bits is incorrect.");

  if (plane != -1)
    if (TeoPlane(file) != plane)
      showErrorExit("The number of planes is incorrect.");

  if (frame != -1)
    if (TeoFrame(file) != frame)
      showErrorExit("The number of frames is incorrect.");

}
