/* ************************************************** libteoeyesplugin.c *** *
 * This library is a auxiliary library for teoeyes-plugin programming.
 *
 * Copyright (C) 1998-2004 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <04/06/21 23:19:06 sugaya>
 * ************************************************************************* */
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gnome.h>
#include "teoeyes_plugin.h"

#define WINDOW_WIDTH	220
#define	WINDOW_HEIGHT	270
#define	CANVAS_SIZE	200

#define	G_SET_OBJECT(parent,name,object) g_object_set_data_full (G_OBJECT (parent), name, g_object_ref (object), (GDestroyNotify) g_object_unref)

#define	G_SET_WIDGET(parent,name,widget) g_object_set_data_full (G_OBJECT (parent), name, gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

/* ************************************************************************* */
static void	cb_destroy		(GtkWidget	*widget,
					 gpointer	data);	
static void 	draw_dialog_image	(GtkWidget	*canvas,
					 GdkPixbuf	*img);
static void	callback_adj 		(GtkWidget	*widget,
					 GtkSpinButton	*spin);
static void	callback_spin		(GtkWidget	*widget,
					 gpointer	data);
static void	callback_preview 	(void);
static void	callback_apply		(void);
static void	callback_cancel 	(void);

/* ************************************************************************* */
static void
cb_destroy (GtkWidget	*widget,
	    gpointer	data) {
  return;
}

/* ************************************************************************* */
static void 
draw_dialog_image (GtkWidget	*canvas,
		   GdkPixbuf	*img) {
  GdkPixbuf	*back;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  int		w, h;

  gdk_window_set_back_pixmap (canvas->window, NULL, FALSE);
  w = gdk_pixbuf_get_width  (img);
  h = gdk_pixbuf_get_height (img);

  /* 描画用データの生成 */
  back = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, w, h);

  /* 描画画像の生成 */
  gdk_pixbuf_composite_color (img, back, 0, 0, w, h, 0, 0, 1.0, 1.0,
			      GDK_INTERP_TILES, 255, 0, 0, 16,
			      0xaaaaaa, 0x555555);
  /* ピックスマップの生成 */
  gdk_pixbuf_render_pixmap_and_mask (back, &pixmap, &mask, 255);

  /* ウィンドウへの描画 */
  gdk_window_set_back_pixmap (canvas->window, pixmap, FALSE);
  gdk_window_clear (canvas->window);
  gdk_window_shape_combine_mask (canvas->window, mask, 0, 0);
  gdk_flush ();

  gdk_pixbuf_unref (back);
  gdk_pixmap_unref (pixmap);
  if (mask) gdk_bitmap_unref (mask);
  
  gtk_widget_set_size_request (canvas, w, h);
}

/* ************************************************************************* */
static void
callback_adj (GtkWidget		*widget,
	      GtkSpinButton	*spin) {
  int	val;

  val = (int) db->adjuster->value;
  gtk_spin_button_set_value (spin, val);
  if (db->action == ACTION_INTERACTIVE) callback_preview ();
}

/* ************************************************************************* */
static void
callback_spin (GtkWidget	*widget,
	       gpointer		data) {
  int	val;
  char	buf[64];

  val = (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (db->spinbutton));
  
  if (val < (int) db->adjuster->lower) {
    val = (int) db->adjuster->lower;
    sprintf (buf, "%d", val);
    gtk_entry_set_text (GTK_ENTRY (widget), buf);
  }
  if (val > (int) (db->adjuster->upper - db->adjuster->page_increment)) {
    val = (int) (db->adjuster->upper - db->adjuster->page_increment);
    sprintf (buf, "%d", val);
    gtk_entry_set_text (GTK_ENTRY (widget), buf);
  }
  if (db->action == ACTION_INTERACTIVE) {
    plugin_preview_image (db->src, db->work, (double) val, 0, 0);
    draw_dialog_image (db->canvas, db->work);
  }
}

/* ************************************************************************* */
static void
callback_preview (void) {
  plugin_preview_image (db->src,
			db->work,
			(double) gtk_spin_button_get_value_as_int
			(GTK_SPIN_BUTTON (db->spinbutton)), 0, 0);
  draw_dialog_image (db->canvas, db->work);

}

/* ************************************************************************* */
static void
callback_apply (void) {
  plugin_preview_image (db->src,
			db->dst,
			(double) gtk_spin_button_get_value_as_int
			(GTK_SPIN_BUTTON (db->spinbutton)), 0, 0);
  draw_dialog_image (db->canvas, db->dst);

  gdk_pixbuf_unref (db->work);
  
  gtk_grab_remove (db->window);
  gtk_widget_destroy (db->window);
  gtk_main_quit ();
}

/* ************************************************************************* */
static void
callback_cancel (void) {
  gtk_grab_remove (db->window);
  gtk_widget_destroy (db->window);
  gtk_main_quit ();  
}

/* ************************************************************************* */
void
plugin_progressbar_update (double	val) {
  gtk_progress_bar_update (GTK_PROGRESS_BAR (db->progressbar), val);
  while (gtk_events_pending ()) gtk_main_iteration ();
}

/* ************************************************************************* */
void
plugin_dialog_new (gchar	*title, 
		   void	(*func) (GdkPixbuf	*src,
				 GdkPixbuf	*dst,
				 double		param1,
				 double		param2,
				 double		param3),
		   GdkPixbuf	*src_img,
		   GdkPixbuf	*dst_img,		    
		   gchar	*label,
		   double	min,
		   double	max,
		   double 	step,
		   double 	page,
		   int		use_progressbar,
		   int		action) {
  GtkWidget	*obj;		
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*alignment;
  GtkWidget	*scrolledwindow;
  
  plugin_preview_image = func;

  db = (PluginDialog *) malloc (sizeof (PluginDialog));
  db->action = action;

  /* ウィンドウの生成 */
  db->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (db->window),
			  "teoeyes", "Teo Image Viewer");
  gtk_window_set_title (GTK_WINDOW (db->window), title);
  g_signal_connect (G_OBJECT (db->window),
		    "destroy", G_CALLBACK (cb_destroy), NULL);
  g_signal_connect (G_OBJECT (db->window),
		    "delete_event", G_CALLBACK (cb_destroy), NULL);

  if (use_progressbar) {
    gtk_widget_set_size_request (db->window, -1, WINDOW_HEIGHT+20);
  } else {
    gtk_widget_set_size_request (db->window, -1, WINDOW_HEIGHT);
  }
  gtk_window_set_policy (GTK_WINDOW (db->window), FALSE, FALSE, FALSE);
  gtk_widget_show (db->window);
  {
    /* ビューポートの生成 */
    obj = gtk_viewport_new (NULL, NULL);
    gtk_widget_show (obj);
    gtk_container_add (GTK_CONTAINER (db->window), obj);
    gtk_container_set_border_width (GTK_CONTAINER (obj), 2);
    G_SET_WIDGET (db->window, "viewport", obj);
    {
      vbox = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (vbox);
      gtk_container_add (GTK_CONTAINER (obj), vbox);
      G_SET_WIDGET (db->window, "vbox1", vbox);
      {
	/* スクロールウィンドウ */
	scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrolledwindow);
	gtk_box_pack_start (GTK_BOX (vbox), scrolledwindow, TRUE, TRUE, 0);
	G_SET_WIDGET (db->window, "scrolledwindow", scrolledwindow);
	{
	  /* アラインメントの生成 */
	  alignment = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
	  gtk_widget_show (alignment);
	  gtk_scrolled_window_add_with_viewport
	    (GTK_SCROLLED_WINDOW (scrolledwindow), alignment);
	  G_SET_WIDGET (db->window, "alignment", alignment);

	  /* キャンバスの生成 */
	  db->canvas = gtk_drawing_area_new ();
	  gtk_widget_show (db->canvas);
	  gtk_container_add (GTK_CONTAINER (alignment), db->canvas);
	  gtk_widget_set_size_request (GTK_WIDGET (db->canvas),
				       CANVAS_SIZE, CANVAS_SIZE);
	  G_SET_WIDGET (db->window, "canvas", db->canvas);
	}
	hbox = gtk_hbox_new (FALSE, 3);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	G_SET_WIDGET (db->window, "hbox1", hbox);
	{
	  /* ラベル */
	  obj = gtk_label_new (label);
	  gtk_widget_show (obj);
	  gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);
	  G_SET_WIDGET (db->window, "label1", obj);

	  /* スピンボタンの生成 */
	  db->adjuster
	    = GTK_ADJUSTMENT (gtk_adjustment_new (min, min,
						  max, step, page, page));
	  db->spinbutton =
	    gtk_spin_button_new (db->adjuster, 1, 0);
	  g_signal_connect (G_OBJECT (db->spinbutton), "activate",
			    G_CALLBACK (callback_spin), NULL);
	  g_signal_connect (G_OBJECT (db->adjuster), "value_changed",
			    G_CALLBACK (callback_adj),
			    (gpointer) db->spinbutton);
	  gtk_box_pack_start (GTK_BOX (hbox), db->spinbutton, TRUE, TRUE, 0);
	  gtk_widget_show (db->spinbutton);
	  G_SET_OBJECT (db->window, "adjustment", db->adjuster);
	  G_SET_WIDGET (db->window, "spinbutton", db->spinbutton);
	}
	/* カスタマイズ用の垂直BOXの追加 */
	db->box = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), db->box, FALSE, FALSE, 0);
      
	/* セパレータの生成 */
	obj = gtk_hseparator_new ();
	gtk_widget_show (obj);
	gtk_box_pack_start (GTK_BOX (vbox), obj, FALSE, FALSE, 5);
	G_SET_WIDGET (db->window, "separator1", obj);

	hbox = gtk_hbox_new (TRUE, 3);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	G_SET_WIDGET (db->window, "hbox2", hbox);
	{
	  /* プレビューボタンの生成 */
	  if (action == ACTION_NON_INTERACTIVE) {
	    obj = gtk_button_new_with_label (_("Preview"));
	    g_signal_connect (G_OBJECT (obj), "clicked",
			      G_CALLBACK (callback_preview), NULL);
	    gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);
	    gtk_widget_show (obj);
	    G_SET_WIDGET (db->window, "button1", obj);
	  }
	  /* 適用ボタンの生成 */
	  obj = gtk_button_new_from_stock (GTK_STOCK_APPLY);
	  g_signal_connect (G_OBJECT (obj), "clicked",
			    G_CALLBACK (callback_apply), NULL);
	  gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);
	  gtk_widget_show (obj);
	  G_SET_WIDGET (db->window, "button2", obj);

	  /* キャンセルボタンの生成 */
	  obj = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
	  g_signal_connect (G_OBJECT (obj), "clicked",
			    G_CALLBACK (callback_cancel), NULL);
	  gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);
	  gtk_widget_show (obj);
	  G_SET_WIDGET (db->window, "button3", obj);
	}
	/* プログレスバーの生成 */
	if (use_progressbar) {
	  obj = gtk_hseparator_new ();
	  gtk_widget_show (obj);
	  gtk_box_pack_start (GTK_BOX (vbox), obj, FALSE, FALSE, 5);
	  G_SET_WIDGET (db->window, "separator2", obj);

	  db->progressbar = gtk_progress_bar_new ();
	  
	  gtk_box_pack_start (GTK_BOX (vbox),
			      db->progressbar, FALSE, FALSE, 0);
	  gtk_widget_show (db->progressbar);
	  G_SET_WIDGET (db->window, "progressbar", db->progressbar);
	}
      }
    }
  }
  /* 画像の表示 */
  db->src  = src_img;
  db->dst  = dst_img;
  db->work = gdk_pixbuf_copy (db->src);

  gdk_pixbuf_copy_area (db->src, 
			0, 0,
			gdk_pixbuf_get_width  (db->src),
			gdk_pixbuf_get_height (db->src),
			db->dst, 
			0, 0);
  
  plugin_preview_image (db->src, db->work, min, 0, 0);
  draw_dialog_image (db->canvas, db->work);

  gtk_grab_add (db->window);
}

/* ******************************************* End of libteoeyesplugin.c *** */
