/* ************************************************************ io-bmp.c *** *
 * BMP⥸塼
 *
 * Copyright (C) 2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/01/14 21:13:11 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "bmp.h"
#include "gdk-pixbuf-extension.h"
#include "image_loader.h"
#include "format_bmp.icon"

/* ************************************************************************* */
static ImageFormatPattern signature[] = {
  {"BM", NULL, 100},
  {NULL, NULL, 0}
};
static gchar *mime_types[] = {
  "image/bmp",
  "image/x-bmp",
  "image/x-MS-bmp",
  NULL
};
static gchar *extensions[] = {
  "bmp",
  NULL
};

/* ************************************************************************* */
GdkPixbuf*
load_bmp (const gchar	*filename,
	  gpointer	data) {
  return gdk_pixbuf_new_from_file (filename, NULL);
}

/* ************************************************************************* */
gboolean
save_bmp (const gchar	*filename,
	  gpointer	data) {
  GdkPixbuf	*src = (GdkPixbuf *) data;
  GdkPixbuf	*aligned = NULL, *dst = NULL;

  if (gdk_pixbuf_get_rowstride (src) !=
      gdk_pixbuf_get_width (src) * gdk_pixbuf_get_n_channels (src)) {
    aligned = gdk_pixbuf_align_rowstride (src);
  }
  if ((aligned && gdk_pixbuf_get_has_alpha (aligned)) ||
      gdk_pixbuf_get_has_alpha (src)) {
    dst = gdk_pixbuf_remove_alpha ((aligned) ? aligned : src);
  }
  WriteBMP (filename, (dst) ? dst : ((aligned) ? aligned : src));
  if (aligned) gdk_pixbuf_unref (aligned);
  if (dst)     gdk_pixbuf_unref (dst);

  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = (ImageFormat *) g_malloc (sizeof (ImageFormat));
  module->info->signature	= signature;
  module->info->name		= "BMP";
  module->info->description	= "The BMP image format";
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= IMAGE_FORMAT_WRITABLE;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_bmp, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  "BMP",
  NULL,
  NULL,
  load_bmp,
  save_bmp,
  load_info
};

/* ***************************************************** End of io-bmp.c *** */
