/* ************************************************************ io-png.c *** *
 * PNG⥸塼
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/01/14 20:29:56 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "image_loader.h"
#include "format_png.icon"

/* ************************************************************************* */
static ImageFormatPattern signature[] = {
  {"\x89PNG\r\n\x1a\x0a", NULL, 100},
  {NULL, NULL, 0}
};
static gchar *mime_types[] = {
  "image/png",
  NULL
};
static gchar *extensions[] = {
  "png",
  NULL
};

/* ************************************************************************* */
GdkPixbuf*
load_png (const gchar	*filename,
	  gpointer	data) {
  return gdk_pixbuf_new_from_file (filename, NULL);
}

/* ************************************************************************* */
gboolean
save_png (const gchar	*filename,
	  gpointer	data) {
  gdk_pixbuf_save ((GdkPixbuf *) data, filename, "png", NULL, NULL);
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = (ImageFormat *) g_malloc (sizeof (ImageFormat));
  module->info->signature	= signature;
  module->info->name		= "PNG";
  module->info->description	= "The PNG image format";
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= IMAGE_FORMAT_WRITABLE;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_png, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  "PNG",
  NULL,
  NULL,
  load_png,
  save_png,
  load_info
};

/* ***************************************************** End of io-png.c *** */
