/* ************************************************************ io-wmf.c *** *
 * WMF⥸塼
 *
 * Copyright (C) 2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/01/14 21:13:11 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "image_loader.h"
#include "format_wmf.icon"
#include "wmf.h"

/* ************************************************************************* */
static ImageFormatPattern signature[] = {
  {"\xd7\xcd\xc6\x9a", NULL, 100},
  {NULL, NULL, 0}
};
static gchar *mime_types[] = {
  "image/x-wmf",
  NULL
};
static gchar *extensions[] = {
  "wmf",
  NULL
};

/* ************************************************************************* */
GdkPixbuf*
load_wmf (const gchar	*filename,
	  gpointer	data) {
  return load_wmf_image (filename);
}

/* ************************************************************************* */
gboolean
save_wmf (const gchar	*filename,
	  gpointer	data) {
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = (ImageFormat *) g_malloc (sizeof (ImageFormat));
  module->info->signature	= signature;
  module->info->name		= "WMF";
  module->info->description	= "The Windows Meta File image format";
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= 0;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_wmf, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  "WMF",
  NULL,
  NULL,
  load_wmf,
  save_wmf,
  load_info
};

/* ***************************************************** End of io-wmf.c *** */
