/* ************************************************************ binary.c *** *
 * Teoeyes Plugin Collection ($B#2CM2=(B)
 *
 * Copyright (C) 2001-2004 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <04/06/21 23:36:19 sugaya>
 * ************************************************************************* */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gnome.h>
#include "teoeyes_plugin.h"

#define	MIN_VAL			0
#define	MAX_VAL			255
#define	STEP_SIZE		1
#define	PAGE_SIZE		5
/* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
#define	USE_PROGRESS_BAR	0

/* ************************************************************************* *
   $B%W%i%0%$%s4X?tK\BN(B
 * ************************************************************************* */
void
exec_binary (GdkPixbuf	*src,
	     GdkPixbuf	*dst,
	     double	param1,
	     double	param2,
	     double	param3) {
  int		row, col, has_alpha_src, has_alpha_dst;
  guchar	r, g, b, y, val, th;

  has_alpha_src = gdk_pixbuf_get_has_alpha (src);
  has_alpha_dst = gdk_pixbuf_get_has_alpha (dst);
  th	  = (guchar) param1;

  for (row = 0; row < gdk_pixbuf_get_height (src); row++) {
    for (col = 0; col < gdk_pixbuf_get_width (src); col++) {
      r = gdk_pixbuf_get_pixel (src, col, row, 0);
      g = gdk_pixbuf_get_pixel (src, col, row, 1);
      b = gdk_pixbuf_get_pixel (src, col, row, 2);
      y = (guchar) (0.299 * r + 0.587 * g + 0.114 * b);
      val = (y > th) ? 255 : 0;
      gdk_pixbuf_put_pixel (dst, col, row, 0, val);
      gdk_pixbuf_put_pixel (dst, col, row, 1, val);
      gdk_pixbuf_put_pixel (dst, col, row, 2, val);
      if (has_alpha_dst) {
	if (has_alpha_src) {
	  gdk_pixbuf_put_pixel (dst, col, row, 3, val);
	} else {
	  gdk_pixbuf_put_pixel (dst, col, row, 3, 255);
	}
      }
#if USE_PROGRESS_BAR /* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
      plugin_progressbar_update ((double) (row - gdk_pixbuf_get_heigth (src))/
				 (gdk_pixbuf_get_height (src)));
#endif
    }
  }
#if USE_PROGRESS_BAR 
  plugin_progressbar_update (0.0);
#endif
}

/* ************************************************************************* *
   $B%W%i%0%$%s<B9TMQ4X?t(B
 * ************************************************************************* */
void
plugin_binary (GdkPixbuf	*src,
	       GdkPixbuf	*dst) {
  /* $B%W%i%0%$%s%@%$%"%m%0$NI=<((B */
  plugin_dialog_new (_("Binary Plugin"),	/* $B%@%$%"%m%0%?%$%H%k(B */
		     exec_binary,		/* $B%W%i%0%$%s4X?tK\BN(B */
		     src,			/* $BF~NO2hA|%G!<%?(B */
		     dst,			/* $B=PNO2hA|%G!<%?(B */
		     _("Threshold"),			/* $B%Q%i%a!<%?%i%Y%k(B */
		     MIN_VAL,			/* $B%Q%i%a!<%?:G>.CM(B */
		     MAX_VAL,			/* $B%Q%i%a!<%?:GBgCM(B */
		     STEP_SIZE,			/* $B%Q%i%a!<%?A}2CNL(B1 */	
		     PAGE_SIZE,			/* $B%Q%i%a!<%?A}2CNL(B2 */	
		     NON_USE_PROGRESSBAR,	/* $B%W%m%0%l%9%P!<$N;HMQ(B */
		     ACTION_INTERACTIVE);	/* $B%W%l%S%e!<2hLL$N99?7J}K!(B */

  gtk_main ();
}

/* ************************************************************************* *
   $B%W%i%0%$%s>pJs(B
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {N_("/Binarize by threshold"),
   NULL,
   0,
   0,
   "<Item>",
   NULL
  },
  N_("Binary Plugin"),
  N_("Yasuyuki Sugaya"),
  "2.0",
  N_("This plugin binarizes the image\n according to the threshold."),
  1,
  plugin_binary
};

/* ***************************************************** End of binary.c *** */
