/* ************ ********************************************* gaussian.c *** *
 * Teoeyes Plugin Collection ($B%,%&%7%"%s%U%#%k%?(B)
 *
 * Copyright (C) 2001-2004 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <04/06/21 23:36:49 sugaya>
 * ************************************************************************* */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gnome.h>
#include "teoeyes_plugin.h"

#define		MIN_VAL		1
#define		MAX_VAL		32
#define		STEP_SIZE	1
#define		PAGE_SIZE	5
/* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
#define	USE_PROGRESS_BAR	1

/* ************************************************************************* *
   $B%,%&%7%"%s4X?t(B
 * ************************************************************************* */
double
func_gaussian (double sigma, int x) {
  return exp (-0.5 * (x * x) / (sigma * sigma));
}

/* ************************************************************************* *
   $B%W%i%0%$%s4X?tK\BN(B
 * ************************************************************************* */
void
exec_gaussian (GdkPixbuf	*src,
	       GdkPixbuf	*dst,
	       double		param1,
	       double		param2,
	       double		param3) {
  GdkPixbuf	*work;
  int		row, col, p, n;
  int		rs, re, cs, ce;
  int		scope, fw, fw2;
  double	sigma, *filter;
  double	cof, base = 0;
  double	val;

  sigma = param1;
  scope = (int) sigma;
  fw	= scope * 2 + 1;
  fw2	= fw  * fw;
  cs	= 0;
  ce 	= gdk_pixbuf_get_width (src) - 1;
  rs	= 0;
  re 	= gdk_pixbuf_get_height(src) - 1;

  work = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8,
			 gdk_pixbuf_get_width (src),
			 gdk_pixbuf_get_height (src));
  for (row = rs; row <= re; row++) {
    for (col = cs; col <= ce; col++) {    
      for (p = 0; p < 3; p++) {
	gdk_pixbuf_put_pixel (work, col, row, p, 
			      gdk_pixbuf_get_pixel (src, col, row, p));
      }
    }
  }
  filter = (double *) malloc (sizeof (double) * fw) + scope;
  for (n = -scope; n <= scope; n++) {
    filter[n] = cof = func_gaussian (sigma, n);
    base += cof;
  }
  for (n = -scope; n <= scope; n++) filter[n] /= base;

  for (row = rs; row <= re; row++) {
    for (col = cs + scope; col <= ce - scope; col++) {    
      for (p = 0; p < 3; p++) {
	val = 0;
	for (n = -scope; n <= scope; n++) {
	  val += filter[n] * gdk_pixbuf_get_pixel (src, col+n, row, p);
	}
	if (val > 255) val = 255;
	gdk_pixbuf_put_pixel (work, col, row, p, (guint8) val);
      }
    }
  }
  for (row = rs + scope; row <= re - scope; row++) {
    for (col = cs; col <= ce; col++) {    
      for (p = 0; p < 3; p++) {
	val = 0;
	for (n = -scope; n <= scope; n++) {
	  val += filter[n] * gdk_pixbuf_get_pixel (work, col, row+n, p);
	}
	if (val > 255) val = 255;
	gdk_pixbuf_put_pixel (dst, col, row, p, (guint8) val);
      }
      if (gdk_pixbuf_get_has_alpha (src) && gdk_pixbuf_get_has_alpha (dst)) {
	gdk_pixbuf_put_pixel (dst, col, row, 4,
			      gdk_pixbuf_get_pixel (src, col, row, 4));
      }
    }
#if USE_PROGRESS_BAR /* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
    plugin_progressbar_update ((float) (row - rs) / (re - rs + 1));
#endif
  }
#if USE_PROGRESS_BAR /* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
  plugin_progressbar_update (0.0);
#endif
  filter -= scope;
  free (filter);
  gdk_pixbuf_unref (work);
}

/* ************************************************************************* *
   $B%W%i%0%$%s<B9TMQ4X?t(B
 * ************************************************************************* */
void
plugin_gaussian (GdkPixbuf	*src,
		 GdkPixbuf	*dst) {
  /* $B%W%i%0%$%s%@%$%"%m%0$NI=<((B */
  plugin_dialog_new (_("Gaussian Filter"),	/* $B%@%$%"%m%0%?%$%H%k(B */
		     exec_gaussian,		/* $B%W%i%0%$%s4X?tK\BN(B */
		     src,			/* $BF~NO2hA|(B */
		     dst,			/* $B=PNO2hA|(B */		      
		     _("Sigma"),		/* $B%Q%i%a!<%?%i%Y%k(B */
		     MIN_VAL,			/* $B%Q%i%a!<%?:G>.CM(B */
		     MAX_VAL,			/* $B%Q%i%a!<%?:GBgCM(B */
		     STEP_SIZE,			/* $B%Q%i%a!<%?A}2CNL(B1 */
		     PAGE_SIZE,			/* $B%Q%i%a!<%?A}2CNL(B2 */
		     USE_PROGRESSBAR,		/* $B%W%m%0%l%9%P!<$N;HMQ(B */
		     ACTION_NON_INTERACTIVE); 	/* $B%W%l%S%e!<2hLL$N99?7J}K!(B */

  gtk_main ();
}

/* ************************************************************************* *
   $B%W%i%0%$%s>pJs(B
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {N_("/Gaussian Filter"),
   NULL,
   0,
   0,
   "<Item>",
   NULL
  },
  N_("Gaussian Filter Plugin"),
  N_("Yasuyuki Sugaya"),
  "2.1",
  N_("This plugin applies\n the gaussian filter to the image."),
  1,
  plugin_gaussian
};

/* *************************************************** End of gaussian.c *** */

