/* ********************************************************* laplacian.c *** *
 * Teoeyes Plugin Collection ($B%i%W%i%7%"%s%U%#%k%?(B)
 *
 * Copyright (C) 2001-2004 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <04/06/21 23:36:53 sugaya>
 * ************************************************************************* */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gnome.h>
#include "teoeyes_plugin.h"

/* ************************************************************************* *
   $B%W%i%0%$%s4X?tK\BN(B
 * ************************************************************************* */
void
plugin_laplacian (GdkPixbuf	*src,
		  GdkPixbuf	*dst) {
  int		n, m, p, col, row;
  int		width, height;
  int		scope = 1;
  int		filter[] = {-1, -1, -1, -1, 8, -1, -1, -1, -1};
  int		val[3];

  /* $B=PNO2hA|MQ%a%b%j$N3NJ](B */
  width  = gdk_pixbuf_get_width  (src);
  height = gdk_pixbuf_get_height (src);

  for (row = 1; row < height-1; row++) {
    for (col = 1; col < width-1; col++) {
      for (p = 0; p < 3; p++) val[p] = 0;
      for (n = -scope; n <= scope; n++) {
	for (m = -scope; m <= scope; m++) {
	  for (p = 0; p < 3; p++) {
	    val[p] += gdk_pixbuf_get_pixel (src, col+m, row+n, p) * 
	      filter[(n+scope)*3+(m+scope)];
	  }
	}
      }
      for (p = 0; p < 3; p++) {
	if (val[p] < 0)   val[p] = 0;
	if (val[p] > 255) val[p] = 255;
	gdk_pixbuf_put_pixel (dst, col, row, p, val[p]);	
      }
      if (gdk_pixbuf_get_has_alpha (src) && gdk_pixbuf_get_has_alpha (dst)) {
	gdk_pixbuf_put_pixel (dst, col, row, 4,
			      gdk_pixbuf_get_pixel (src, col, row, 4));
      }
    }
  }
}

/* ************************************************************************* *
   $B%W%i%0%$%s>pJs(B
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {N_("/Laplacian Filter"),
   NULL,
   0,
   0,
   "<Item>",
   NULL
  },
  N_("Laplacian Filter Plugin"),
  N_("Yasuyuki Sugaya"),
  "2.0",
  N_("This plugin applies\n the laplacian filter to the image."),
  1,
  plugin_laplacian
};

/* ************************************************** End of laplacian.c *** */
