/* *************************************************************** dnd.c *** *
 * ɥå&ɥå״ؿ
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/03/07 23:35:00 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "dnd.h"
#include "image_io.h"
#include "open.h"

/* ɥå׻Υ٥ **************************************************** */
static void
drop_event (GtkWidget		*widget,
	    GdkDragContext	*context,
	    gint		x,
	    gint		y,
	    GtkSelectionData	*selection_data,
	    guint		info,
	    guint		time) {
  gchar	*filename;

  if (!selection_data->data) return;

  if (strncmp (selection_data->data, "file:", 5) == 0) {
    filename = selection_data->data + 5;
  } else {
    filename = selection_data->data;
  }
  filename[strlen (filename) - 2] = '\0';

  /* ե뤬¸ߤ뤫ɤĴ٤ */
  if (!filename || !g_file_exist (filename)) {
    g_print ("Dont exist %s\n", filename);
    return;
  }
  /* ꤵ줿ե뤬бե뤫ɤĴ٤ */
  if (!check_image_supported (filename)) {
    g_print ("Can not support this image type.\n");
    return;
  }
  /* 򳫤 */
  if (!teoeyes_open_image_on_same_window (filename)) exit (1);
}

/* ɥå¦ ******************************************************** */
void
dnd_drop_on_widget (GtkWidget	*widget) {
  static GtkTargetEntry drag_types[] = {
    {"text/uri-list", 0, 0},
    {"_NETSCAPE_URL", 0, 1}
  };
  static gint n_drag_types;

  n_drag_types = sizeof (drag_types) / sizeof (drag_types[0]);

  gtk_drag_dest_set (widget,
		     GTK_DEST_DEFAULT_MOTION |
		     GTK_DEST_DEFAULT_HIGHLIGHT |
		     GTK_DEST_DEFAULT_DROP,
		     drag_types,
		     n_drag_types,
		     GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (widget), "drag_data_received",
		    G_CALLBACK (drop_event), NULL);
}

/* ******************************************************** End of dnd.c *** */
