/* ********************************************** gdk-pixbuf-extension.h *** *
 * gdk-pixbufγĥؿ إåե
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/03/27 16:05:15 sugaya>
 * ************************************************************************* */
#ifndef	__GDK_PIXBUF_EXTENSION_H__
#define	__GDK_PIXBUF_EXTENSION_H__

typedef struct _GdkPixbufColorModifier {
  gint	gamma;
  gint	brightness;
  gint	contrast;
} GdkPixbufColorModifier;

typedef struct _GdkPixbufModifierMap {
  guchar	rmap[256];
  guchar	gmap[256];
  guchar	bmap[256];
} GdkPixbufModifierMap;

typedef struct _GdkPixbufModifier {
  GdkPixbufColorModifier	mod;
  GdkPixbufColorModifier	rmod;
  GdkPixbufColorModifier	gmod;
  GdkPixbufColorModifier	bmod;  
  GdkPixbufModifierMap		*map;
} GdkPixbufModifier;

/* ************************************************************************* *
 * GdkPixbufβͤФ
 *
 * gdk_pixbuf_get_pixel : ꤷɸβͤޥ
 * gdk_pixbuf_put_pixel : ꤷɸ˻ꤷͤ񤭹ޥ
 * ************************************************************************* */
#define gdk_pixbuf_get_pixel(pixbuf,x,y,p) \
(*(gdk_pixbuf_get_pixels((pixbuf)) + \
 gdk_pixbuf_get_rowstride((pixbuf)) * (y) + \
 gdk_pixbuf_get_n_channels((pixbuf)) * (x) + (p)))

#define gdk_pixbuf_put_pixel(pixbuf,x,y,p,val) \
(*(gdk_pixbuf_get_pixels((pixbuf)) + \
 gdk_pixbuf_get_rowstride((pixbuf)) * (y) + \
 gdk_pixbuf_get_n_channels((pixbuf)) * (x) + (p)) = (val))

/* ************************************************************************* */
void
gdk_pixbuf_free_buffer			(guchar			*pixels,
					 gpointer		data);
void
gdk_pixbuf_copy2 			(const GdkPixbuf	*src,
					 GdkPixbuf		*dst);
GdkPixbuf*
gdk_pixbuf_remove_alpha			(const GdkPixbuf	*src);
void
gdk_pixbuf_calc_map_tables	 	(GdkPixbufModifier	*mod);
void
gdk_pixbuf_set_image_modifier 		(GdkPixbufColorModifier	*cmod,
					 GdkPixbufModifier	*mod);
void
gdk_pixbuf_set_image_red_modifier 	(GdkPixbufColorModifier	*cmod,
					 GdkPixbufModifier	*mod);
void
gdk_pixbuf_set_image_green_modifier 	(GdkPixbufColorModifier	*cmod,
					 GdkPixbufModifier	*mod);
void
gdk_pixbuf_set_image_blue_modifier 	(GdkPixbufColorModifier	*cmod,
					 GdkPixbufModifier	*mod);
void
gdk_pixbuf_get_image_modifier		(GdkPixbufColorModifier	*src_mod,
					 GdkPixbufColorModifier	*dst_mod);
void
gdk_pixbuf_get_image_red_curve		(GdkPixbufModifierMap	*src_map,
					 guchar 		*mod);
void
gdk_pixbuf_get_image_green_curve	(GdkPixbufModifierMap	*src_map,
					 guchar 		*mod);
void
gdk_pixbuf_get_image_blue_curve		(GdkPixbufModifierMap	*src_map,
					 guchar 		*mod);
void
gdk_pixbuf_apply_modifiers_to_rgb 	(GdkPixbuf		*pbuf,
					 GdkPixbufModifier	*mod,
					 gboolean		clear_flg);
GdkPixbuf*
gdk_pixbuf_align_rowstride		(GdkPixbuf		*src);

#endif	/* __GDK_PIXBUF_EXTENSION_H__ */

/* *************************************** End of gdk-pixbuf-extension.h *** */
