/* *********************************************************** getargs.c *** *
 * ϴؿ إåե
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <04/06/22 01:02:42 sugaya>
 * ************************************************************************* */
#include <ctype.h>
#include "teoeyes.h"
#include "getargs.h"
#include "option.h"
#include "property.h"

/* ************************************************************************* */
static void
parse_geometry_size 		(gchar		*option,
				 WindowGeometry	**geometry);
static void
parse_geometry_position		(gchar		*option,
				 WindowGeometry	**geometry);
static WindowGeometry*
parse_geometry			(gchar		*option);
static void
parse_sequence_file		(GList		**list,
				 gchar		*filename,
				 gint		start,
				 gint		end,
				 gint		step);

/* ץλɽ **************************************************** */
void
usage (void) {
  g_print ("\n");
  g_print ("----------------------------------------------------------"
	   "-----------------\n");
  g_print ("TeoEyes Version%s                                         "
	   "     Usage\n", VERSION);
  g_print ("----------------------------------------------------------"
	   "-----------------\n");
  g_print ("> teoeyes file1 file2 ... [option]\n");
  g_print ("\n");
  g_print ("[option]\n");
  g_print ("   -l                         "
	   ": Load all the image.\n");
  g_print ("   -Nl                        "
	   ": Cancel -l option.\n");
  g_print ("\n");

  
  g_print ("   -N                         "
	   ": Normalize the pixel value. (min_val - max_val)\n");
  g_print ("   -NN                        "
	   ": Cancel -N option.\n");
  g_print ("   -n #1 #2                   "
	   ": Normalize the pixel value. (#1 - #2)\n");
  g_print ("\n");


  g_print ("   -f #                       "
	   ": Display #th frame. (only TEO format)\n");
  g_print ("\n");

  g_print ("   -s [file_header] #1 #2 #3  "
	   ": Read sequence files.\n"
	   "                                (#1:Start #2:End #3:Step)\n");
  g_print ("\n");

  
  g_print ("   -root #                    "
	   ": Set the image as wallpaper.\n"
	   "                                "
	   "(# 1:TILED 2:CENTERED 3:STRETCHED 4:SCALED)\n");
  g_print ("\n");
  g_print ("   -g                         "
	   ": Set the window geometry.\n");
  g_print ("\n");
  g_print ("   -h                         "
	   ": Show this usage.\n");
  g_print ("   -v                         "
	   ": Show the teoeyes version.\n");
  g_print ("----------------------------------------------------------"
	   "-----------------\n");
  g_print ("\n");

  teoeyes_free_option (to);
  config_free_file (tc);
  if (image_list) {
    g_list_foreach (image_list, (GFunc) teoeyes_image_free, NULL); 
  }
  exit (1);
}
   
/* Сɽ ********************************************************** */
void
version (void) {
  g_print ("TeoEyes Ver%s\n", VERSION);
  exit (1);
}

/* Υå ********************************************************** */
int
getargs (int		argc,		/* ο */
	 char		**argv,		/*  */
	 TEOption	**to,		/* ץ */
	 TEConfig	**tc) {		/*  */
  TEImage	*tmpimg;
  gchar		*filename;
  gint 		args, start, end, step;

  for(args = 1; args < argc; ++args) {
    if ((*argv[args] == '-') && *(argv[args]+1) && isalpha (*(argv[args]+1))) {
      if ((strcmp ("l", ++argv[args])) == 0) {		/* -l */
	(*to)->load_all = TRUE;
      } else if ((strcmp ("Nl", argv[args])) == 0) {	/* -Nl */
	(*to)->load_all = FALSE;
      } else if ((strcmp ("N", argv[args])) == 0) {	/* -N */
	(*to)->normalize = TRUE;
        (*to)->min   = -1;
        (*to)->max   = -1;
      } else if ((strcmp ("NN", argv[args])) == 0) {	/* -NN */
	(*to)->normalize = FALSE;
	(*to)->min = 0;
	(*to)->max = 0;
      } else if ((strcmp ("n", argv[args])) == 0) {	/* -n */
	(*to)->normalize = TRUE;
	if (++args >= argc) return 0;
        (*to)->min = (double) atof (argv[args]);
        if (++args >= argc) return 0;
	(*to)->max = (double) atof (argv[args]);
      } else if ((strcmp ("f", argv[args])) == 0) {	/* -f */
        if (++args >= argc) return 0;
	(*to)->frame = atoi (argv[args]);
      } else if ((strcmp ("s", argv[args])) == 0) {	/* -s */
	if (++args >= argc) return 0;
	filename = argv[args];
        if (++args >= argc) return 0;
        start = atoi (argv[args]);
        if (++args >= argc) return 0;
	end   = atoi (argv[args]);
	if (++args >= argc) return 0;
	step  = atoi (argv[args]);
	parse_sequence_file (&image_list,filename, start, end, step);
      } else if ((strcmp ("root", argv[args])) == 0) {	/* -root */
        if (++args >= argc) return 0;
        (*to)->wallpaper = atoi (argv[args]);
      } else if ((strcmp ("g", argv[args])) == 0) {	/* -g */
        if (++args >= argc) return 0;
	(*to)->geometry = parse_geometry (argv[args]);
      } else if ((strcmp ("h", argv[args])) == 0) {	/* -h */
	usage ();
      } else if ((strcmp ("v", argv[args])) == 0) {	/* -v */
	version ();
      } 
    } else {
      if (strcmp (argv[args], "-") == 0) {
	tmpimg = teoeyes_image_new (argv[args], FALSE);
      } else {
	tmpimg = teoeyes_image_new (argv[args], TRUE);
      }
      if (tmpimg) {
	image_list = g_list_append (image_list, (gpointer) tmpimg);
      }
    }
  }
  if (!image_list) {
    /* ¸ߤ뤫Ĵ٤ */
    if (!g_file_exist ((*tc)->title_image)) {
      g_printerr ("%s %s\n", _("Could not find file :"), (*tc)->title_image);
      exit (1);
    }
    /*  */
    tmpimg = teoeyes_image_new ((*tc)->title_image, TRUE);
    if (!tmpimg) exit (1);
    image_list = g_list_append (image_list, (gpointer) tmpimg);
    if (!image_list) {
      g_printerr (_("Could not allocate enough memory.\n"));
      exit (1);
    }
  }
  return 1;
}

/* ************************************************************************* *
 * ץβϥ롼
 * ************************************************************************* */
	
/* -gץΰϴؿ () ************************************* */
static void
parse_geometry_size (gchar		*option,
		     WindowGeometry	**geometry) {
  gchar	buf[64];
  gchar	*ptr;

  /*  */
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geometry)->width = atoi (buf);

  /* x */
  if (*option++ != 'x') {
    (*geometry)->height = UNDEF_VAL;
    return;
  }
  /* ⤵ */
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geometry)->height = atoi (buf);
}

/* -gץΰϴؿ () *************************************** */
static void
parse_geometry_position (gchar		*option,
			 WindowGeometry	**geometry) {
  gchar	buf[64];
  gchar	*ptr;

  /* X */
  if (*option != '+' && *option != '-') {
    (*geometry)->x = UNDEF_VAL;
    (*geometry)->y = UNDEF_VAL;
    return;
  }
  (*geometry)->xsign = (*option++ == '+') ? 1 : -1;

  /* X */
  if (!isdigit (*option)) {
    (*geometry)->x = UNDEF_VAL;
    (*geometry)->y = UNDEF_VAL;
    return;
  }
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geometry)->x = atoi (buf);

  /* Y */
  if (*option != '+' && *option != '-') {
    (*geometry)->x = UNDEF_VAL;
    (*geometry)->y = UNDEF_VAL;
    return;
  }
  (*geometry)->ysign = (*option++ == '+') ? 1 : -1;
  
  /* Y */
  if (!isdigit (*option)) {
    (*geometry)->x = UNDEF_VAL;
    (*geometry)->y = UNDEF_VAL;
    return;
  }
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geometry)->y = atoi (buf);
}

/* -gץΰϴؿ ********************************************** */
static WindowGeometry*
parse_geometry (gchar	*option) {
  WindowGeometry	*geometry = NULL;
  gchar			*tmp;

  tmp = option;
  if (*tmp == '+' || *tmp == '-') tmp++;
  /* ץλְ꤬äƤ饪ץ̵ˤ */
  if (!isdigit (*tmp)) return NULL;
  
  /* ץβ */
  while (tmp && isdigit (*tmp)) tmp++;

  if (*tmp == 'x') {
    geometry = g_new (WindowGeometry, 1);
    parse_geometry_size (option, &geometry);
    while (option && !isalpha (*option)) option++;
    if (!option || *option != 'x') {
      geometry->x = UNDEF_VAL;
      geometry->y = UNDEF_VAL;
    } else {
      option++;
      while (option && isdigit (*option)) option++;
      if (*option == '+' || *option == '-') {
	parse_geometry_position (option, &geometry);
      } else {
	geometry->x = UNDEF_VAL;
	geometry->y = UNDEF_VAL;
      }
    }
  } else if (*tmp == '+' || *tmp == '-') {
    geometry = g_new (WindowGeometry, 1);
    parse_geometry_position (option, &geometry);
    geometry->width  = UNDEF_VAL;
    geometry->height = UNDEF_VAL;
  }
  return geometry;
}

/* -sץβϴؿ ************************************************** */
static void
parse_sequence_file (GList	**list,
		     gchar	*filename,
		     gint	start,
		     gint	end,
		     gint	step) {
  TEImage	*tmpimg;
  gchar		name[1024];
  gint		n;

  for (n = start; n <= end; n+= step) {
    /* ե̾ */
    sprintf (name, filename, n);
    /*  */
    tmpimg = teoeyes_image_new ((!g_file_exist (name)) ?
				tc->title_image : name, TRUE);
    *list =  g_list_append (*list, (gpointer) tmpimg);
  }
}

/* **************************************************** End of getargs.c *** */

