/* ************************************************** gnome-image-list.h *** *
 * GnomeImageList إåե
 *
 * Copyright (C) 2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/02/28 10:17:55 sugaya>
 * ************************************************************************* */
/*
 * Copyright (C) 1998, 1999 Free Software Foundation
 * Copyright (C) 2000 Red Hat, Inc.
 * All rights reserved.
 *
 * This file is part of the Gnome Library.
 *
 * The Gnome Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The Gnome Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
  @NOTATION@
 */

/* GnomeImageList widget - scrollable icon list
 *
 *
 * Authors:
 *   Federico Mena   <federico@nuclecu.unam.mx>
 *   Miguel de Icaza <miguel@nuclecu.unam.mx>
 */

#ifndef _GNOME_IMAGE_LIST_H_
#define _GNOME_IMAGE_LIST_H_


#include <libgnomecanvas/gnome-canvas.h>
#include <libgnomecanvas/gnome-canvas-rich-text.h>
#include <libgnomecanvas/gnome-canvas-pixbuf.h>
#include <libgnomeui/gnome-icon-item.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

G_BEGIN_DECLS

#define GNOME_TYPE_IMAGE_LIST            (gnome_image_list_get_type ())
#define GNOME_IMAGE_LIST(obj)            (GTK_CHECK_CAST ((obj), GNOME_TYPE_IMAGE_LIST, GnomeImageList))
#define GNOME_IMAGE_LIST_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_IMAGE_LIST, GnomeImageListClass))
#define GNOME_IS_IMAGE_LIST(obj)         (GTK_CHECK_TYPE ((obj), GNOME_TYPE_IMAGE_LIST))
#define GNOME_IS_IMAGE_LIST_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_IMAGE_LIST))
#define GNOME_IMAGE_LIST_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GNOME_TYPE_IMAGE_LIST, GnomeImageListClass))

typedef struct _GnomeImageList        GnomeImageList;
typedef struct _GnomeImageListPrivate GnomeImageListPrivate;
typedef struct _GnomeImageListClass   GnomeImageListClass;

typedef enum {
  GNOME_IMAGE_LIST_ICONS,
  GNOME_IMAGE_LIST_TEXT_BELOW,
  GNOME_IMAGE_LIST_TEXT_RIGHT
} GnomeImageListMode;

/* This structure has been converted to use public and private parts.  To avoid
 * breaking binary compatibility, the slots for private fields have been
 * replaced with padding.  Please remove these fields when gnome-libs has
 * reached another major version and it is "fine" to break binary compatibility.
 */
struct _GnomeImageList {
  GnomeCanvas canvas;

  /* Scroll adjustments */
  GtkAdjustment *adj;
  GtkAdjustment *hadj;
	
  /*< private >*/
  GnomeImageListPrivate * _priv;
};

struct _GnomeImageListClass {
  GnomeCanvasClass parent_class;

  void     (*select_icon)      (GnomeImageList *gil, gint num, GdkEvent *event);
  void     (*unselect_icon)    (GnomeImageList *gil, gint num, GdkEvent *event);
  void     (*focus_icon)       (GnomeImageList *gil, gint num);
  gboolean (*text_changed)     (GnomeImageList *gil, gint num, const char *new_text);

  /* Key Binding signals */
  void     (*move_cursor)      (GnomeImageList *gil, GtkDirectionType dir, gboolean clear_selection);
  void     (*toggle_cursor_selection) (GnomeImageList *gil);
  void     (*unused)       (GnomeImageList *unused);
	
  /* Padding for possible expansion */
  gpointer padding1;
  gpointer padding2;
};

enum {
  GNOME_IMAGE_LIST_IS_EDITABLE	= 1 << 0,
  GNOME_IMAGE_LIST_STATIC_TEXT	= 1 << 1
};

GType          gnome_image_list_get_type            (void) G_GNUC_CONST;

GtkWidget     *gnome_image_list_new                 (guint         icon_width,
						     GtkAdjustment *adj,
						     int           flags);

void           gnome_image_list_construct           (GnomeImageList *gil,
						     guint icon_width,
						     GtkAdjustment *adj,
						     int flags);

void           gnome_image_list_set_hadjustment    (GnomeImageList *gil,
						    GtkAdjustment *hadj);

void           gnome_image_list_set_vadjustment    (GnomeImageList *gil,
						    GtkAdjustment *vadj);

/* To avoid excesive recomputes during insertion/deletion */
void           gnome_image_list_freeze              (GnomeImageList *gil);
void           gnome_image_list_thaw                (GnomeImageList *gil);


void           gnome_image_list_insert              (GnomeImageList *gil,
						     int pos,
						     const char *icon_filename,
						     const char *text);
void           gnome_image_list_insert_pixbuf       (GnomeImageList *gil,
						     int pos,
						     GdkPixbuf *im,
						     const char *icon_filename,
						     const char *text);

int            gnome_image_list_append              (GnomeImageList *gil,
						     const char *icon_filename,
						     const char *text);
int            gnome_image_list_append_pixbuf       (GnomeImageList *gil,
						     GdkPixbuf *im,
						     const char *icon_filename,
						     const char *text);

void           gnome_image_list_clear               (GnomeImageList *gil);
void           gnome_image_list_remove              (GnomeImageList *gil,
						     int pos);

guint          gnome_image_list_get_num_icons       (GnomeImageList *gil);


/* Managing the selection */
GtkSelectionMode gnome_image_list_get_selection_mode(GnomeImageList *gil);
void           gnome_image_list_set_selection_mode  (GnomeImageList *gil,
						     GtkSelectionMode mode);
void           gnome_image_list_select_icon         (GnomeImageList *gil,
						     int pos);
void           gnome_image_list_unselect_icon       (GnomeImageList *gil,
						     int pos);
int            gnome_image_list_unselect_all        (GnomeImageList *gil);
GList *        gnome_image_list_get_selection       (GnomeImageList *gil);

/* Managing focus */
void           gnome_image_list_focus_icon          (GnomeImageList *gil,
						     gint idx);

/* Setting the spacing values */
void           gnome_image_list_set_icon_width      (GnomeImageList *gil,
						     int w);
void           gnome_image_list_set_row_spacing     (GnomeImageList *gil,
						     int pixels);
void           gnome_image_list_set_col_spacing     (GnomeImageList *gil,
						     int pixels);
void           gnome_image_list_set_text_spacing    (GnomeImageList *gil,
						     int pixels);
void           gnome_image_list_set_icon_border     (GnomeImageList *gil,
						     int pixels);
void           gnome_image_list_set_separators      (GnomeImageList *gil,
						     const char *sep);
/* Icon filename. */
gchar *        gnome_image_list_get_icon_filename   (GnomeImageList *gil,
						     int idx);
int            gnome_image_list_find_icon_from_filename (GnomeImageList *gil,
							 const char *filename);

/* Attaching information to the icons */
void           gnome_image_list_set_icon_data       (GnomeImageList *gil,
						     int idx, gpointer data);
void           gnome_image_list_set_icon_data_full  (GnomeImageList *gil,
						     int pos, gpointer data,
						     GDestroyNotify destroy);
int            gnome_image_list_find_icon_from_data (GnomeImageList *gil,
						     gpointer data);
gpointer       gnome_image_list_get_icon_data       (GnomeImageList *gil,
						     int pos);

/* Visibility */
void           gnome_image_list_moveto              (GnomeImageList *gil,
						     int pos, double yalign);
GtkVisibility  gnome_image_list_icon_is_visible     (GnomeImageList *gil,
						     int pos);

int            gnome_image_list_get_icon_at         (GnomeImageList *gil,
						     int x, int y);

int            gnome_image_list_get_items_per_line  (GnomeImageList *gil);

/* Accessibility functions */
GnomeIconTextItem *gnome_image_list_get_icon_text_item (GnomeImageList *gil,
							int idx);

GnomeCanvasPixbuf *gnome_image_list_get_icon_pixbuf_item (GnomeImageList *gil,
							  int idx);

G_END_DECLS

#endif /* _GNOME_IMAGE_LIST_H_ */

/* ******************************************* End of gnome-image-list.h *** */
