/* ********************************************** gtkcustomiconfilesel.c *** *
 * $B%+%9%?%^%$%:2DG=$J%U%!%$%kA*Br%@%$%"%m%0(B
 *
 * Copyright (C) 2000-2002 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <04/06/22 01:59:34 sugaya>
 *
 * gtkiconfileselection - gtkiconfileselection dialog widget for gtk+
 * Copyright 1999  Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gnome.h>
#include "gfileutils.h"
#include "gtkiconbutton.h"
#include "gtkdirtreeview.h"
#include "gtkfilelist.h"
#include "gtkcustomiconfilesel.h"
#include "teoeyes.h"

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 		64
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN 		1024
#endif

#ifndef COMBO_LIST_LIMIT
#define COMBO_LIST_LIMIT	20
#endif

#define	BUTTON_W		34
#define	BUTTON_H		28
#define	TREE_WINDOW_W		200
#define	TREE_WINDOW_H		250
#define	LIST_WINDOW_W		380
#define	LIST_WINDOW_WIDE_W	550
#define	LIST_WINDOW_H		250

/* ************************************************************************* */

/* GdkPixbuf RGBA C-Source image dump 1-byte-run-length-encoded */

static const guint8 folder_new_pixbuf[] = 
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (542) */
  "\0\0\2""6"
  /* pixdata_type (0x2010002) */
  "\2\1\0\2"
  /* rowstride (64) */
  "\0\0\0@"
  /* width (16) */
  "\0\0\0\20"
  /* height (16) */
  "\0\0\0\20"
  /* pixel_data: */
  "\227\0\0\0\0\1\377\377\377\377\202\0\0\0\0\1\364\371J\377\202\0\0\0\0"
  "\1\364\371J\377\205\0\0\0\0\1\266\216M\377\202\236}M\377\7eM\30\377\226"
  "\212q\377\377\377\377\377\0\0\0\0\364\371J\377\0\0\0\0\364\371J\377\205"
  "\0\0\0\0\10eM\30\377\312\236]\377\232q$\377\266\216M\377\327\256y\377"
  "\236}M\377eM\30\377\377\377\377\377\202\364\371J\377\1\222\206m\377\205"
  "\0\0\0\0\1eM\30\377\202\377\316\232\377\2\312\236]\377\232q$\377\204"
  "\377\377\377\377\203\364\371J\377\204\0\0\0\0\1eM\30\377\204\377\316"
  "\232\377\2\312\236]\377\232q$\377\202\377\377\377\377\3\364\371J\377"
  "\327\256y\377eM\30\377\204\0\0\0\0\1eM\30\377\205\377\316\232\377\7\377"
  "\377\377\377\312\236]\377\377\377\377\377\266\216M\377\364\371J\377\232"
  "q$\377eM\30\377\203\0\0\0\0\1eM\30\377\204\377\316\232\377\1\377\377"
  "\377\377\202\377\316\232\377\5\377\377\377\377\312\236]\377\232q$\377"
  "\364\371J\377eM\30\377\203\0\0\0\0\1eM\30\377\207\377\316\232\377\5\377"
  "\377\377\377\377\316\232\377eM\30\377\232q$\377eM\30\377\203\0\0\0\0"
  "\1eM\30\377\211\377\316\232\377\3eM\30\377\232q$\377eM\30\377\203\0\0"
  "\0\0\1eM\30\377\211\377\316\232\377\3eM\30\377\232q$\377eM\30\377\203"
  "\0\0\0\0\3\222\206m\377eM\30\377\262\216Y\377\207\377\316\232\377\3e"
  "M\30\377\232q$\377eM\30\377\205\0\0\0\0\3\222\206m\377eM\30\377\262\216"
  "Y\377\205\377\316\232\377\3eM\30\377\232q$\377eM\30\377\207\0\0\0\0\3"
  "\222\206m\377eM\30\377\262\216Y\377\203\377\316\232\377\3eM\30\377\232"
  "q$\377eM\30\377\211\0\0\0\0\7\222\206m\377eM\30\377\262\216Y\377\377"
  "\316\232\377eM\30\377\232q$\377eM\30\377\213\0\0\0\0\1\222\206m\377\203"
  "eM\30\377\202\0\0\0\0"};

/* GdkPixbuf RGBA C-Source image dump 1-byte-run-length-encoded */

static const guint8 folder_up_pixbuf[] = 
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (553) */
  "\0\0\2A"
  /* pixdata_type (0x2010002) */
  "\2\1\0\2"
  /* rowstride (64) */
  "\0\0\0@"
  /* width (16) */
  "\0\0\0\20"
  /* height (16) */
  "\0\0\0\20"
  /* pixel_data: */
  "\227\0\0\0\0\2\377\0\0\377G\1\1\377\212\0\0\0\0\1\266\216M\377\202\236"
  "}M\377\5eM\30\377\377\0\0\377G\1\1\377\0\0\0\0\222\206m\377\207\0\0\0"
  "\0\4eM\30\377\312\236]\377\232q$\377\266\216M\377\203\377\0\0\377\4G"
  "\1\1\377\262\216Y\377iQ\40\377\222\206m\377\205\0\0\0\0\1eM\30\377\202"
  "\377\316\232\377\1\312\236]\377\203\377\0\0\377\1G\1\1\377\202\327\256"
  "y\377\2\236}M\377eM\30\377\204\0\0\0\0\1eM\30\377\202\377\316\232\377"
  "\205\377\0\0\377\1G\1\1\377\202\327\256y\377\1eM\30\377\204\0\0\0\0\1"
  "eM\30\377\202\377\316\232\377\205\377\0\0\377\5G\1\1\377\266\216M\377"
  "\327\256y\377\232q$\377eM\30\377\203\0\0\0\0\2eM\30\377\377\316\232\377"
  "\207\377\0\0\377\1G\1\1\377\202\232q$\377\1eM\30\377\203\0\0\0\0\1eM"
  "\30\377\202\377\316\232\377\1G\1\1\377\203\377\0\0\377\202G\1\1\377\4"
  "\377\316\232\377eM\30\377\232q$\377eM\30\377\203\0\0\0\0\1eM\30\377\203"
  "\377\316\232\377\203\377\0\0\377\1G\1\1\377\202\377\316\232\377\3eM\30"
  "\377\232q$\377eM\30\377\203\0\0\0\0\1eM\30\377\203\377\316\232\377\203"
  "\377\0\0\377\1G\1\1\377\202\377\316\232\377\3eM\30\377\232q$\377eM\30"
  "\377\203\0\0\0\0\3\222\206m\377eM\30\377\262\216Y\377\202\377\316\232"
  "\377\203G\1\1\377\202\377\316\232\377\3eM\30\377\232q$\377eM\30\377\205"
  "\0\0\0\0\3\222\206m\377eM\30\377\262\216Y\377\205\377\316\232\377\3e"
  "M\30\377\232q$\377eM\30\377\207\0\0\0\0\3\222\206m\377eM\30\377\262\216"
  "Y\377\203\377\316\232\377\3eM\30\377\232q$\377eM\30\377\211\0\0\0\0\7"
  "\222\206m\377eM\30\377\262\216Y\377\377\316\232\377eM\30\377\232q$\377"
  "eM\30\377\213\0\0\0\0\1\222\206m\377\203eM\30\377\202\0\0\0\0"};


/* GdkPixbuf RGBA C-Source image dump 1-byte-run-length-encoded */

static const guint8 home_pixbuf[] = 
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (777) */
  "\0\0\3!"
  /* pixdata_type (0x2010002) */
  "\2\1\0\2"
  /* rowstride (64) */
  "\0\0\0@"
  /* width (16) */
  "\0\0\0\20"
  /* height (16) */
  "\0\0\0\20"
  /* pixel_data: */
  "\207\0\0\0\0\2:::\377\24\24\24\377\212\0\0\0\0\7(((\377\0\0\0\377\0\0"
  "\0\0```\377\300\300\300\377\233\233\233\377666\377\211\0\0\0\0\10((("
  "\377\0\0\0\377UUU\377\300\300\300\377\260\260\260\377\223\223\223\377"
  "\201\201\201\377&&&\377\210\0\0\0\0\11""1)(\377FFF\377\300\300\300\377"
  "\211\211\211\377\\\\\\\377ZZZ\377___\377\201\201\201\377$$$\377\207\0"
  "\0\0\0\12TTT\377\300\300\300\377rrr\377fff\377\252\252\252\377\235\235"
  "\235\377eee\377QQQ\377\201\201\201\377!!!\377\205\0\0\0\0\5UUU\377\300"
  "\300\300\377rrr\377iii\377\275\275\275\377\202\350\350\350\377\5\265"
  "\265\265\377hhh\377OOO\377\201\201\201\377\40\40\40\377\203\0\0\0\0\6"
  "```\377\300\300\300\377rrr\377ccc\377\275\275\275\377\360\360\360\377"
  "\202\371\371\371\377\15\346\346\346\377\262\262\262\377ddd\377LLL\377"
  "\201\201\201\377!!!\377\0\0\0\0JJJ\377\300\300\300\377mmm\377ccc\377"
  "\270\270\270\377\360\360\360\377\203\370\370\370\377\26\367\367\367\377"
  "\360\360\360\377\262\262\262\377aaa\377III\377\201\201\201\377\33\33"
  "\33\377\0\0\0\0(((\377&&&\377\235\235\235\377\335\335\335\377\371\371"
  "\371\377\320\273\262\377\224kC\377i&\10\377\320\273\262\377\371\371\371"
  "\377\333\333\333\377\213\213\213\37790/\377\77\6\2\377\203\0\0\0\0\14"
  "*))\377\242\242\242\377\337\337\337\377\371\371\371\377\224kC\377\360"
  "\336\322\377\337\273\240\377i&\10\377\371\371\371\377\342\342\342\377"
  "\227\227\227\377000\377\204\0\0\0\0\14:::\377\251\251\251\377\341\341"
  "\341\377\371\371\371\377\224kC\377\343\305\256\377\324c\0\377k$\1\377"
  "\371\371\371\377\343\341\341\377\245\245\245\377)))\377\204\0\0\0\0\14"
  ":::\377\251\251\251\377\341\341\341\377\371\371\371\377\207Y+\377\337"
  "\244s\377\277U\0\377k$\1\377\371\371\371\377\343\341\341\377\250\250"
  "\250\377)))\377\204\0\0\0\0\14:::\377\251\251\251\377\341\341\341\377"
  "\371\371\371\377|G\23\377\335\223X\377\277U\0\377k$\1\377\371\371\371"
  "\377\343\341\341\377\251\251\251\377)))\377\204\0\0\0\0\14:::\377\251"
  "\251\251\377\341\341\341\377\371\371\371\377yD\20\377\325x,\377\256I"
  "\0\377k$\1\377\371\371\371\377\343\341\341\377\250\250\250\377)))\377"
  "\204\0\0\0\0\14:::\377\237\237\237\377\323\323\323\377\327\327\327\377"
  "a)\0\377\257F\0\377\236\77\0\377N\35\13\377\327\327\327\377\325\323\323"
  "\377\237\237\237\377)))\377\205\0\0\0\0\3:::\377555\377422\377\204))"
  ")\377\4""510\377555\377)))\377(((\377\202\0\0\0\0"};

/* ************************************************************************* */
static void
gtk_custom_icon_file_selection_class_init (GtkCustomIconFileSelClass *class);

static void
gtk_custom_icon_file_selection_init 	(GtkCustomIconFileSel	*filesel);

static void	cb_entry_insert_text	(GtkEditable		*editable,
					 const gchar		*new_text,
					 gint		       new_text_length,
					 gint			*position,
					 gpointer		data);
static void	cb_entry_set_file	(GtkWidget		*widget,
					 GdkEventKey		*key,
					 gpointer		data);
static void	cb_entry_set_filter 	(GtkEntry		*entry,
					 gpointer 		data);
static void
cb_filelist_select_icon 		(GnomeFileIconList	*iconlist, 
					 gint			num,
					 GdkEvent 		*event,
					 gpointer 		data);
static gboolean
cb_treeview_button_release 		(GtkWidget		*widget,
					 GdkEventButton		*ev,
					 gpointer		data);
static void	cb_folder_up		(GtkWidget		*widget,
					 gpointer		data);
static void	cb_folder_new	 	(GtkWidget		*widget,
					 gpointer		data);
static void	cb_folder_home 		(GtkWidget		*widget,
					 gpointer		data);


static GtkWidget* mkdir_window_new	(GtkCustomIconFileSel	*parent);

static void	cb_mkdir_button_ok 	(GtkWidget		*widget,
					 gpointer		data);
static void	cb_mkdir_button_cancel 	(GtkWidget		*widget,
					 gpointer		data);

/* ************************************************************************* */
static void	cb_combo_changed 	(GtkWidget		*widget,
					 GtkWidget		*child,
					 gpointer		data);
static gboolean	cb_combo_set_dir 	(GtkWidget		*widget,
					 GdkEventKey		*key,
					 gpointer		data);
static void	combo_list_add 		(GtkCustomIconFileSel	*parent,
					 const gchar		*folder);
static void	combo_set_popdown_strings(GtkCombo		*combo,
					 GList			*strings,
					 GtkWidget		*filesel);

/* ************************************************************************* */
static GtkWindowClass	*parent_class	    = NULL;
static gboolean		combo_callback_flag = TRUE;

/* ************************************************************************* *
 * Initialization Functions.
 *
 * gtk_custom_icon_file_selection_get_type
 * gtk_custom_icon_file_selection_new
 * gtk_custom_icon_file_selection_class_init
 * gtk_custom_icon_file_selection_init
 *
 * ************************************************************************* */

/* ************************************************************************* */
GtkType
gtk_custom_icon_file_selection_get_type (void) {
  static GtkType	filesel_type = 0;
  
  if (!filesel_type) {
      GtkTypeInfo filesel_info = {
	"GtkCustomIconFileSel",
	sizeof (GtkCustomIconFileSel),
	sizeof (GtkCustomIconFileSelClass),
	(GtkClassInitFunc)	gtk_custom_icon_file_selection_class_init,
	(GtkObjectInitFunc)	gtk_custom_icon_file_selection_init,
	NULL,
        NULL,
        (GtkClassInitFunc) NULL,
      };
      filesel_type = gtk_type_unique (gtk_window_get_type(), &filesel_info);
  }
  return filesel_type;
}

/* ************************************************************************* */
GtkWidget*
gtk_custom_icon_file_selection_new (const gchar	*title) {
  GtkWidget	*widget;

  widget = gtk_widget_new (gtk_custom_icon_file_selection_get_type (), NULL);
  GTK_CUSTOM_ICON_FILESEL (widget)->title = g_strdup (title);
  gtk_window_set_title (GTK_WINDOW (widget), title);

  return widget;
}

/* ************************************************************************* */
static void
gtk_custom_icon_file_selection_class_init (GtkCustomIconFileSelClass *class) {
  GtkWidgetClass	*widget_class;

  widget_class = (GtkWidgetClass *) class;
  parent_class = gtk_type_class (gtk_window_get_type ());
}

/* ************************************************************************* */
static void
gtk_custom_icon_file_selection_init (GtkCustomIconFileSel	*filesel) {
  GtkWidget	*main_vbox;
  GtkWidget 	*main_hbox;
  GtkWidget 	*box;
  GtkWidget 	*table;
  GtkWidget 	*label;
  GtkWidget 	*scrolled_window;
  GtkWidget 	*separator;
  GtkWidget 	*frame;
  GtkWidget 	*hpaned;
  GtkTooltips	*tooltips;
  gchar		dir[1024];
  gchar		*folder, *ofolder, *lfolder, *lofolder, *dfolder;

  filesel->show_tree = TRUE;
  gtk_window_set_policy (GTK_WINDOW (filesel), FALSE, TRUE, TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (filesel), 10);
  
  /* $B?eJ?%\%C%/%9$NDI2C(B */
  main_hbox = gtk_hbox_new (FALSE, 1);
  gtk_widget_ref (main_hbox);
  gtk_container_add (GTK_CONTAINER (filesel), main_hbox);
  gtk_widget_show (main_hbox);

  /* $B%+%9%?%`%\%C%/%9(B0$B$NDI2C(B */
  filesel->custom_box[0] = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (filesel->custom_box[0]);  
  gtk_box_pack_start (GTK_BOX (main_hbox),
		      filesel->custom_box[0], FALSE, FALSE, 0);
  
  main_vbox = gtk_vbox_new (FALSE, 1);
  gtk_widget_ref (main_vbox);  
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 0);
  gtk_box_pack_start (GTK_BOX (main_hbox), main_vbox, TRUE, TRUE, 0);
  gtk_widget_show (main_vbox);

  /* $B%+%9%?%`%\%C%/%9(B1$B$NDI2C(B */
  filesel->custom_box[1] = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (filesel->custom_box[1]);
  gtk_box_pack_start (GTK_BOX (main_hbox),
		      filesel->custom_box[1], FALSE, FALSE, 0);

  /* $B%+%9%?%`%\%C%/%9(B2$B$NDI2C(B */
  filesel->custom_box[2] = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (filesel->custom_box[2]);    
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box[2], FALSE, FALSE, 0);

  /* $B%G%#%l%/%H%j%(%s%H%j(B, $B%U%)%k%@%\%?%s$NDI2C(B */
  filesel->custom_box[3] = gtk_hbox_new (FALSE, 1);
  gtk_widget_ref (filesel->custom_box[3]);    
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box[3], FALSE, FALSE, 5);
  gtk_widget_show (filesel->custom_box[3]);
  {
    /* $B%i%Y%k(B */
    label = gtk_label_new (_("Current Folder:"));
    gtk_widget_ref (label);
    gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
    gtk_box_pack_start (GTK_BOX (filesel->custom_box[3]),
			label, FALSE, FALSE, 0);
    gtk_widget_show (label);

    /* $B%G%#%l%/%H%j%3%s%\(B */
    filesel->dir_combo = gtk_combo_new ();
    gtk_widget_ref (filesel->dir_combo);
    gtk_box_pack_start (GTK_BOX (filesel->custom_box[3]),
			filesel->dir_combo, TRUE, TRUE, 10);
    gtk_combo_disable_activate(GTK_COMBO(filesel->dir_combo));
    gtk_widget_show (filesel->dir_combo);
    g_signal_connect (G_OBJECT (GTK_COMBO (filesel->dir_combo)->entry),
		      "key_press_event", G_CALLBACK (cb_combo_set_dir),
		      (gpointer) filesel);
    g_signal_connect (G_OBJECT (GTK_COMBO (filesel->dir_combo)->list),
		      "select_child", G_CALLBACK (cb_combo_changed),
		      (gpointer) filesel);
    gtk_widget_show (GTK_COMBO (filesel->dir_combo)->entry);

    /* $B%D!<%k%A%C%W$N@8@.(B */
    tooltips = gtk_tooltips_new ();

    /* [$B?F%G%#%l%/%H%j$X(B]$B%\%?%s(B */
    filesel->folder_button_up
      = gtk_icon_button_new_from_inline (folder_up_pixbuf);
    gtk_widget_ref (filesel->folder_button_up);    
    gtk_widget_set_usize (filesel->folder_button_up, BUTTON_W, BUTTON_H);
    gtk_widget_show (filesel->folder_button_up);
    gtk_box_pack_start (GTK_BOX (filesel->custom_box[3]),
			filesel->folder_button_up, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (filesel->folder_button_up), "clicked",
		      G_CALLBACK (cb_folder_up), (gpointer) filesel);
    gtk_tooltips_set_tip (tooltips, filesel->folder_button_up,
			  _("Go to parent folder"), NULL);

    /* [$B%G%#%l%/%H%j$N:n@.(B]$B%\%?%s(B */    
    filesel->folder_button_new
      = gtk_icon_button_new_from_inline (folder_new_pixbuf);
    gtk_widget_ref (filesel->folder_button_new);    
    gtk_widget_set_usize (filesel->folder_button_new, BUTTON_W, BUTTON_H);
    gtk_widget_show (filesel->folder_button_new);
    gtk_box_pack_start (GTK_BOX (filesel->custom_box[3]),
			filesel->folder_button_new, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (filesel->folder_button_new), "clicked",
		      G_CALLBACK (cb_folder_new), (gpointer) filesel);
    gtk_tooltips_set_tip (tooltips, filesel->folder_button_new,
			  _("Create new folder"), NULL);

    /* [$B%[!<%`%G%#%l%/%H%j$X(B]$B%\%?%s(B */    
    filesel->folder_button_home
      = gtk_icon_button_new_from_inline (home_pixbuf);
    gtk_widget_ref (filesel->folder_button_home);    
    gtk_widget_set_usize (filesel->folder_button_home, BUTTON_W, BUTTON_H);
    gtk_widget_show (filesel->folder_button_home);
    gtk_box_pack_start (GTK_BOX (filesel->custom_box[3]),
			filesel->folder_button_home, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (filesel->folder_button_home), "clicked",
		      G_CALLBACK (cb_folder_home), (gpointer) filesel);
    gtk_tooltips_set_tip (tooltips, filesel->folder_button_home,
			  _("Go to home folder"), NULL);
  }
  /* $B%+%9%?%`%\%C%/%9$N(B4$BDI2C(B */
  filesel->custom_box[4] = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (filesel->custom_box[4]);
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box[4], FALSE, FALSE, 0);

  /* $B%+%9%?%`%\%C%/%9$N(B4$BDI2C(B */
  filesel->custom_box[5] = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (filesel->custom_box[5]);
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box[5], FALSE, FALSE, 0);
  gtk_widget_show (filesel->custom_box[5]);
  
  /* $B?eJ?$Z%$%s$N@8@.(B */
  hpaned = gtk_hpaned_new ();
  gtk_widget_ref (hpaned);
  gtk_widget_show (hpaned);
  gtk_box_pack_start (GTK_BOX (filesel->custom_box[5]),hpaned,FALSE, FALSE, 0);
  
  /* $B%U%l!<%`$NDI2C(B */
  frame = gtk_frame_new (NULL);
  gtk_widget_ref (frame);
  if (filesel->show_tree) gtk_widget_show (frame);
  gtk_container_add (GTK_CONTAINER (hpaned), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 2);

  scrolled_window =
    filesel->tree_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolled_window);
  gtk_widget_set_usize (scrolled_window, TREE_WINDOW_W, TREE_WINDOW_H);
  gtk_container_add (GTK_CONTAINER (frame), scrolled_window);

  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  if (tc->folder_icon) {
    folder   = g_build_filename (tc->folder_icon, "folder.png", NULL);
    ofolder  = g_build_filename (tc->folder_icon, "folder_open.png", NULL);
    lfolder  = g_build_filename (tc->folder_icon, "folder_link.png", NULL);
    lofolder = g_build_filename (tc->folder_icon, "folder_link_open.png",NULL);
    dfolder  = g_build_filename (tc->folder_icon, "folder_dennied.png", NULL);
    filesel->dir_tree 
      = gtk_dir_tree_view_new_from_file (G_DIR_SEPARATOR_S,
					 FALSE,
					 folder, ofolder,
					 lfolder, lofolder, dfolder);
    g_free (folder);
    g_free (ofolder);
    g_free (lfolder);
    g_free (lofolder);
    g_free (dfolder);
  } else {
    filesel->dir_tree = gtk_dir_tree_view_new (G_DIR_SEPARATOR_S, FALSE);
  }
  gtk_widget_ref (filesel->dir_tree);
  gtk_container_add (GTK_CONTAINER (scrolled_window), filesel->dir_tree);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (filesel->dir_tree), FALSE);
  gtk_dir_tree_view_set_show_hidden (GTK_DIR_TREE_VIEW (filesel->dir_tree),
				     FALSE);
  gtk_widget_show (filesel->dir_tree);
  gtk_widget_show (filesel->tree_window);  
  
  g_signal_connect (G_OBJECT (filesel->dir_tree), "button_release_event",
		    G_CALLBACK (cb_treeview_button_release),
		    (gpointer) filesel);

  /* $B%U%l!<%`$NDI2C(B */
  frame = gtk_frame_new (NULL);
  gtk_widget_ref (frame);
  gtk_widget_show (frame);
  gtk_container_add (GTK_CONTAINER (hpaned), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 2);

  scrolled_window =
    filesel->list_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolled_window);  
  gtk_widget_set_usize (scrolled_window, LIST_WINDOW_W, LIST_WINDOW_H);
  gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_ALWAYS,
				  GTK_POLICY_AUTOMATIC);

  filesel->file_list = gtk_file_list_new (80,
					  0,
					  G_DIR_SEPARATOR_S,
					  GNOME_ICON_LIST_STATIC_TEXT);
  if (tc->folder_icon) {
    folder = g_build_filename (tc->folder_icon, "folder.png", NULL);
    gtk_file_list_set_icon_from_file (GTK_FILE_LIST (filesel->file_list),
				      folder);
    g_free (folder);
  }
  gtk_widget_ref (filesel->file_list);
  GTK_FILE_LIST (filesel->file_list)->show_folders  = TRUE;
  GTK_FILE_LIST (filesel->file_list)->show_hidden   = FALSE;
  gtk_widget_show (filesel->file_list);
  gtk_container_add (GTK_CONTAINER (scrolled_window), filesel->file_list);

  gtk_widget_show (filesel->file_list);
  gtk_widget_show (filesel->list_window);
  
  g_signal_connect (G_OBJECT (filesel->file_list), "select_icon",
		    G_CALLBACK (cb_filelist_select_icon), (gpointer) filesel);

  /* $B%;%Q%l!<%?$NDI2C(B */
  separator = gtk_hseparator_new ();
  gtk_widget_ref (separator);
  gtk_widget_show (separator);
  gtk_box_pack_start(GTK_BOX(main_vbox), separator, FALSE, FALSE, 5);  

  /* $B%+%9%?%`%\%C%/%9$N(B6$BDI2C(B */
  filesel->custom_box[6] = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (filesel->custom_box[6]);
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box[6], FALSE, FALSE, 0);

  table = gtk_table_new (TRUE, 2, 4);
  gtk_widget_ref (table);
  gtk_box_pack_start(GTK_BOX(main_vbox), table, FALSE, FALSE, 0);
  gtk_widget_show(table);

  label = gtk_label_new (_("File:"));
  gtk_widget_ref (label);  
  gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
  gtk_widget_show(label);

  label = gtk_label_new (_("File type:"));
  gtk_widget_ref (label);  
  gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
  gtk_widget_show(label);

  filesel->file_entry = gtk_entry_new();
  gtk_widget_ref (filesel->file_entry);
  gtk_table_attach_defaults(GTK_TABLE(table), filesel->file_entry, 1, 3, 0, 1);
  gtk_widget_show(filesel->file_entry);
  g_signal_connect (G_OBJECT (filesel->file_entry), "activate",
		    G_CALLBACK (cb_entry_set_file), (gpointer) filesel);

  filesel->filter_entry = gtk_entry_new();
  gtk_widget_ref (filesel->filter_entry);  
  gtk_table_attach_defaults (GTK_TABLE (table),
			     filesel->filter_entry, 1, 3, 1, 2);
  gtk_widget_show (filesel->filter_entry);

  g_signal_connect (G_OBJECT (filesel->filter_entry), "activate",
		    G_CALLBACK (cb_entry_set_filter), (gpointer) filesel);
  g_signal_connect (G_OBJECT (filesel->filter_entry), "insert_text",
		    G_CALLBACK (cb_entry_insert_text), NULL);

  box = gtk_vbutton_box_new();
  gtk_widget_ref (box);  
  gtk_table_attach_defaults(GTK_TABLE(table), box, 3, 4, 0, 2);
  gtk_widget_show(box);

  filesel->ok_button = gtk_button_new_from_stock (GTK_STOCK_OK);
  gtk_widget_ref (filesel->ok_button);  
  gtk_box_pack_start (GTK_BOX (box), filesel->ok_button, TRUE, TRUE, 0);
  gtk_widget_show(filesel->ok_button);

  filesel->cancel_button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
  gtk_widget_ref (filesel->cancel_button);  
  gtk_box_pack_start (GTK_BOX (box), filesel->cancel_button, TRUE, TRUE, 0);
  gtk_widget_show(filesel->cancel_button);

  /* $B%+%9%?%`%\%C%/%9$N(B4$BDI2C(B */
  filesel->custom_box[7] = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (filesel->custom_box[7]);
  gtk_box_pack_start (GTK_BOX (main_vbox),
		      filesel->custom_box[7], FALSE, FALSE, 0);

  getcwd (dir, sizeof (dir));
#if 1
  gtk_custom_icon_file_selection_set_dir (filesel, dir);
#endif
}

/* ************************************************************************* *
 * Callback Functions.
 *
 * cb_entry_insert_text
 * cb_entry_set_file
 * cb_entry_set_filter
 *
 * ************************************************************************* */

/* ************************************************************************* */
static void
cb_entry_insert_text (GtkEditable	*editable,
		      const gchar	*new_text,
		      gint		new_text_length,
		      gint		*position,
		      gpointer		data) {
#if 0  
  gtk_signal_emit_stop_by_name (GTK_OBJECT (editable), "insert_text");
  if (new_text[0] != ' ') {
    GTK_EDITABLE_CLASS
    gtk_type_class (GTK_TYPE_ENTRY)->insert_text (editable,
						  new_text,
						  new_text_length,
						  position);
  }
#endif
}

/* ************************************************************************* */
static void
cb_entry_set_file (GtkWidget	*widget,
		   GdkEventKey	*key,
		   gpointer	data) {
  ;
}

/* ************************************************************************* */
static void
cb_entry_set_filter (GtkEntry	*entry,
		     gpointer 	data) {
  GtkCustomIconFileSel	*filesel;

  filesel = (GtkCustomIconFileSel *) data;
  gtk_file_list_set_filter (GTK_FILE_LIST (filesel->file_list), 
			    gtk_entry_get_text (entry));
}

/* ************************************************************************* *
 *
 *
 * cb_filelist_select_icon
 * get_real_path
 *
 * ************************************************************************* */

/* ************************************************************************* */
static void
cb_filelist_select_icon (GnomeFileIconList	*iconlist, 
			 gint			num,
			 GdkEvent 		*event,
			 gpointer 		data) {
  GtkCustomIconFileSel	*filesel;
  GdkModifierType 	mods;
  gchar 		*path = NULL;
  gchar 		*real_path = NULL;
  gchar 		*full_path = NULL;
  gchar 		*file = NULL;
  gchar			*locale_path;
  GtkFileListItem 	*item;
  
  item = (GtkFileListItem *)
    gnome_file_icon_list_get_icon_data (iconlist, num);

  filesel = GTK_CUSTOM_ICON_FILESEL (data);

  if (item->type != GTK_FILE_LIST_FOLDER) {
    gtk_entry_set_text (GTK_ENTRY (filesel->file_entry), item->file_name);    
    return;
  } else {
    gtk_entry_set_text (GTK_ENTRY (filesel->file_entry), "");
  }
  if (!event) return;

  if (event->type == GDK_BUTTON_PRESS || event->type == GDK_2BUTTON_PRESS) {
    gdk_window_get_pointer (event->button.window, NULL, NULL, &mods);
  } else {
    return; 
  }
  if ((mods & GDK_BUTTON1_MASK) && event->type == GDK_2BUTTON_PRESS) {
    path        = gtk_file_list_get_path (GTK_FILE_LIST (filesel->file_list));
    file        = item->file_name;
    full_path   = g_build_filename (path, file, NULL);
    real_path   = g_get_absolute_path (full_path);
    locale_path = g_filename_from_utf8 (real_path, -1, NULL, NULL, NULL);

    if (filesel->show_tree) {
      gtk_dir_tree_view_set_dir (GTK_DIR_TREE_VIEW (filesel->dir_tree),
				 locale_path);
      gtk_file_list_open_dir (GTK_FILE_LIST (filesel->file_list), locale_path);
      gtk_widget_map (filesel->file_list);
    } else {
      gtk_file_list_open_dir (GTK_FILE_LIST (filesel->file_list), locale_path);
      gtk_widget_map (filesel->file_list);
    }
    combo_callback_flag = FALSE;
    gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (filesel->dir_combo)->entry),
			real_path);
    combo_list_add (filesel, real_path);
    combo_callback_flag = TRUE;
    
    g_free (full_path);
    g_free (real_path);
    g_free (locale_path);
  }
}

/* ************************************************************************* *
 * $B%G%#%l%/%H%j%D%j!<%3!<%k%P%C%/4X?t(B
 *
 * cb_treeview_button_release
 *
 * ************************************************************************* */

/* ************************************************************************* */
static gboolean
cb_treeview_button_release (GtkWidget		*widget,
			    GdkEventButton	*ev,
			    gpointer		data) {
  GtkCustomIconFileSel	*filesel;
  gchar			*path, *utf8_path;

  g_return_val_if_fail (ev, FALSE);

  path = gtk_dir_tree_view_get_selected_path (GTK_DIR_TREE_VIEW (widget));
  utf8_path = g_locale_to_utf8 (path, -1, NULL, NULL, NULL);

  filesel = GTK_CUSTOM_ICON_FILESEL (data);
  
  combo_callback_flag = FALSE;

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (filesel->dir_combo)->entry), 
		      utf8_path);
  combo_list_add (filesel, utf8_path);

  gtk_file_list_open_dir (GTK_FILE_LIST (filesel->file_list), path);
  gtk_widget_map(filesel->file_list);
  
  combo_callback_flag = TRUE;
  
  g_free (utf8_path);

  return FALSE;
}

/* ************************************************************************* *
 * $B$U$)$k$@$\$?$s$K4X$9$k4X?t(B
 *
 * cb_folder_up
 * cb_folder_new
 * cb_folder_home
 *
 * ************************************************************************* */

/* $B!V?F%G%#%l%/%H%j$X0\F0!W%\%?%s$r2!$7$?$H$-$N=hM}(B ************************ */
static void
cb_folder_up (GtkWidget	*widget,
	      gpointer	data) {
  GtkCustomIconFileSel	*filesel;
  GtkDirTreeView	*treeview;
  gchar			*folder, *parent, *utf8_path;

  filesel  = GTK_CUSTOM_ICON_FILESEL (data);  
  treeview = GTK_DIR_TREE_VIEW (filesel->dir_tree);
  folder   = gtk_dir_tree_view_get_selected_path (treeview);
  
  if (!folder) return;

  if (strcmp (folder, G_DIR_SEPARATOR_S) == 0) {
    g_free (folder);
    return;
  }
  parent = g_dir_get_parent_dir (folder);
  utf8_path = g_filename_to_utf8 (parent, -1, NULL, NULL, NULL);

  gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(filesel->dir_combo)->entry), 
		      utf8_path);
  combo_list_add (GTK_CUSTOM_ICON_FILESEL (data), utf8_path);
  gtk_file_list_open_dir (GTK_FILE_LIST (filesel->file_list), parent);
  
  g_free (folder);
  g_free (parent);
  g_free (utf8_path);
}

/* $B!V?75,%G%#%l%/%H%j:n@.!W%\%?%s$r2!$7$?$H$-$N=hM}(B ************************ */
static void
cb_folder_new (GtkWidget	*widget,
	       gpointer	data) {
  GtkWidget	*window;

  window = mkdir_window_new (GTK_CUSTOM_ICON_FILESEL (data));
  gtk_widget_show (window);
  gtk_window_set_modal (GTK_WINDOW (window), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (window), GTK_WINDOW (data));
}

/* $B!V%[!<%`$X0\F0!W%\%?%s$r2!$7$?$H$-$N=hM}(B ******************************** */
static void
cb_folder_home (GtkWidget	*widget,
		gpointer	data) {
  GtkCustomIconFileSel	*filesel;
  GtkDirTreeView	*treeview;
  gchar			*home;
  
  filesel  = GTK_CUSTOM_ICON_FILESEL (data);
  treeview = GTK_DIR_TREE_VIEW (filesel->dir_tree);
  home     = g_locale_to_utf8 (g_get_home_dir (), -1, NULL, NULL, NULL);

  /* temporary */
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (filesel->dir_combo)->entry), home);
  combo_list_add (GTK_CUSTOM_ICON_FILESEL (data), home);
  gtk_dir_tree_view_expand_dir (treeview, home, FALSE);  
  gtk_file_list_open_dir (GTK_FILE_LIST (filesel->file_list), home);

  g_free (home);
}

/* ************************************************************************* *
 * $B?75,%G%#%l%/%H%j:n@.%&%#%s%I%&$K4X$9$k4X?t(B
 *
 * mkdir_window_new
 * cb_mkdir_button_ok
 * cb_mkdir_button_cancel
 * cb_mkdir_entry_key_press
 * 
 * ************************************************************************* */

/* $B?75,%G%#%l%/%H%j:n@.%&%#%s%I%&$N@8@.(B ************************************ */
static GtkWidget*
mkdir_window_new (GtkCustomIconFileSel	*parent) {
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *entry;
  GtkWidget *hseparator;
  GtkWidget *button;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");
  gtk_window_set_icon (GTK_WINDOW (window), te_icon);  
  gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
  gtk_window_set_title  (GTK_WINDOW (window), _("New Folder"));
  gtk_window_position   (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  gtk_object_set_data   (GTK_OBJECT (parent), "window", (gpointer) window);  
  {
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);    
    gtk_widget_ref  (vbox);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (window), vbox);
    {
      hbox = gtk_hbox_new (FALSE, 5);
      gtk_widget_ref  (hbox);
      gtk_widget_show (hbox);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 3);
      {
	label = gtk_label_new (_("New Folder:"));
	gtk_widget_ref  (label);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

	entry = gtk_entry_new ();
	gtk_object_set_data (GTK_OBJECT (window), "entry", (gpointer) entry);
	gtk_object_set_data (GTK_OBJECT (entry), "window", (gpointer) window);
	gtk_widget_ref  (entry);
	gtk_widget_show (entry);
	gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);
      }
      hseparator = gtk_hseparator_new ();
      gtk_widget_ref  (hseparator);
      gtk_widget_show (hseparator);
      gtk_box_pack_start (GTK_BOX (vbox), hseparator, FALSE, TRUE, 3);

      hbox = gtk_hbox_new (TRUE, 0);
      gtk_widget_ref  (hbox);
      gtk_widget_show (hbox);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      {
	button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
	gtk_widget_ref  (button);
	gtk_widget_show (button);
	gtk_box_pack_end (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (cb_mkdir_button_cancel),
			  (gpointer) window);
			     
	button = gtk_button_new_from_stock (GTK_STOCK_OK);
	gtk_widget_ref  (button);
	gtk_widget_show (button);
	gtk_box_pack_end (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_object_set_data (GTK_OBJECT (button), "window", (gpointer) window);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (cb_mkdir_button_ok), (gpointer) parent);
      }
    }
  }
  return window;
}

/* OK$B%\%?%s$r2!$7$?$H$-$N=hM}(B ********************************************** */
static void
cb_mkdir_button_ok (GtkWidget	*widget,
		    gpointer	data) {
  GtkCustomIconFileSel	*filesel;
  GtkWidget		*window;
  GtkWidget		*entry;
  const gchar		*text;
  gchar 		*buf;
  gchar			*path;
  gchar			*sys_full_path;
  gchar			*folder = NULL;
  GError 		*error = NULL;

  filesel = GTK_CUSTOM_ICON_FILESEL (data);

  window = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (widget), "window");
  
  entry = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (window), "entry"));
  text  = gtk_entry_get_text (GTK_ENTRY (entry));
  path  =
    gtk_dir_tree_view_get_selected_path (GTK_DIR_TREE_VIEW(filesel->dir_tree));
  folder = g_strconcat (path, G_DIR_SEPARATOR_S, text, NULL);
  sys_full_path = g_filename_from_utf8 (folder, -1, NULL, NULL, &error);

  if (error) {
    if (g_error_matches (error, 
			 G_CONVERT_ERROR, G_CONVERT_ERROR_ILLEGAL_SEQUENCE)) {
      buf = g_strdup_printf (_("The folder name \"%s\" contains symbols that are not allowed in filenames"), text);
    } else {
      buf = g_strdup_printf (_("Error creating folder \"%s\": %s\n%s\n"), 
			     text, error->message,
			     _("You probably used symbols not allowed in filenames."));
      g_printerr ("%s", buf);
      g_free (buf);
    }
    g_error_free (error);
  } else {
    g_dir_mkdir (sys_full_path);
    gtk_dir_tree_view_refresh_tree (GTK_DIR_TREE_VIEW (filesel->dir_tree));
    gtk_file_list_open_dir (GTK_FILE_LIST (filesel->file_list), path);
  }
  g_free (path);  
  g_free (folder);
  g_free (sys_full_path);
  gtk_widget_hide    (window);
  gtk_widget_destroy (window);
}

/* $B%-%c%s%;%k%\%?%s$r2!$7$?$H$-$N=hM}(B ************************************** */
static void
cb_mkdir_button_cancel (GtkWidget	*widget,
			gpointer	data) {
  gtk_widget_hide    (GTK_WIDGET (data));
  gtk_widget_destroy (GTK_WIDGET (data));
}

/* ************************************************************************* *
 * $B%G%#%l%/%H%j%3%s%\%&%#%8%'%C%H$K4X$9$k4X?t(B
 *
 * cb_combo_changed
 * cb_combo_set_dir
 * combo_list_add
 * combo_set_popdown_strings
 * 
 * ************************************************************************* */

/* $B%3%s%\%\%C%/%9$NA*Br$5$l$F$$$k%"%$%F%`$,JQ99$5$l$?$H$-$N=hM}(B ************ */
static void
cb_combo_changed (GtkWidget	*widget,
		  GtkWidget	*child,
		  gpointer	data) {
  GtkCustomIconFileSel	*filesel;
  GtkCombo		*combo;
  gchar			*folder;
  
  filesel = GTK_CUSTOM_ICON_FILESEL (data);
  combo   = GTK_COMBO (filesel->dir_combo);
  folder 
    = g_filename_from_utf8 (gtk_entry_get_text (GTK_ENTRY (combo->entry)),
			    -1, NULL, NULL, NULL);

  if (folder) {
    gtk_signal_handler_block (GTK_OBJECT (combo->list), combo->list_change_id);
    if (combo_callback_flag) {
      gtk_dir_tree_view_set_dir (GTK_DIR_TREE_VIEW(filesel->dir_tree), folder);
      gtk_file_list_open_dir (GTK_FILE_LIST (filesel->file_list), folder);
    }
    gtk_signal_handler_unblock(GTK_OBJECT (combo->list),combo->list_change_id);
    g_free (folder);
  }
}

/* ************************************************************************* */
static gboolean
cb_combo_set_dir (GtkWidget	*widget,
		  GdkEventKey	*key,
		  gpointer	data) {
  GtkCustomIconFileSel	*filesel;
  gchar			*folder = NULL;
  
  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return FALSE;

  folder = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));

  if ((!folder) || (!*folder)) return FALSE;
  if (!g_dir_is (folder)) {
    g_free (folder);
    return FALSE;
  }
  if (folder[strlen (folder)-1] != '/') {
    folder = (gchar *)
      g_realloc (folder, sizeof (gchar) * (strlen (folder) + 2));
    sprintf (folder, "%s%s", folder, G_DIR_SEPARATOR_S);
  }
  filesel = GTK_CUSTOM_ICON_FILESEL (data);
  combo_list_add (filesel, folder);
  gtk_dir_tree_view_set_dir (GTK_DIR_TREE_VIEW (filesel->dir_tree), folder);

  g_free (folder);

  return FALSE;
}

/* $B?7$7$/F~NO$5$l$?%F%-%9%H$r%3%s%\%\%C%/%9$N%"%$%F%`$KDI2C(B **************** */
static void
combo_list_add (GtkCustomIconFileSel	*parent,
		const gchar		*folder) {
  GList		*list;
  gboolean	flg = TRUE;
  
  list = g_list_first (parent->dir_combo_list);

  while (list) {
    if (strcmp (folder, (gchar *) list->data) == 0) {
      flg = FALSE;
      break;
    }
    list = g_list_next (list);
  }
  if (flg) {
    parent->dir_combo_list = g_list_prepend (parent->dir_combo_list,
					     g_strdup (folder));
    
    if (g_list_length (g_list_first (parent->dir_combo_list))
	> COMBO_LIST_LIMIT) {
      parent->dir_combo_list =
	g_list_remove (parent->dir_combo_list,
		       g_list_last (parent->dir_combo_list)->data);
    }
    combo_set_popdown_strings (GTK_COMBO (parent->dir_combo),
					  parent->dir_combo_list,
					  (GtkWidget *) parent);
  }
}

/* $B%3%s%\%\%C%/%9$K%"%$%F%`$r%;%C%H$9$k(B ************************************ */
static void
combo_set_popdown_strings (GtkCombo	*combo,
			   GList	*strings,
			   GtkWidget	*filesel) {
  GList 	*list;
  GtkWidget	*li;

  g_return_if_fail (combo);
  g_return_if_fail (GTK_IS_COMBO (combo));
  g_return_if_fail (strings);

  gtk_list_clear_items (GTK_LIST (combo->list), 0, -1);
  list = strings;
  while (list) {
    li = gtk_list_item_new_with_label ((gchar *) list->data);
    gtk_widget_show (li);
    gtk_container_add (GTK_CONTAINER (combo->list), li);
    list = list->next;
  }
}

/* ************************************************************************* *
 * $B%0%m!<%P%k4X?t(B
 * ************************************************************************* */

/* ************************************************************************* */
void
gtk_custom_icon_file_selection_show_dir_tree (GtkCustomIconFileSel *filesel,
					      gboolean 		show_tree) {
  if (show_tree == filesel->show_tree) return;

  filesel->show_tree = show_tree;

  if (show_tree) {
    gchar	*path;

    filesel->tree_signal_id =
      g_signal_connect (G_OBJECT (filesel->dir_tree), "button_release_event",
			G_CALLBACK (cb_treeview_button_release),
			(gpointer) filesel);

    path = gtk_file_list_get_path (GTK_FILE_LIST (filesel->file_list));
    gtk_dir_tree_view_set_dir (GTK_DIR_TREE_VIEW (filesel->dir_tree), path);

    gtk_widget_set_usize (filesel->list_window, LIST_WINDOW_W, LIST_WINDOW_H);
    gtk_widget_show (filesel->tree_window);
  } else {
    g_signal_handler_disconnect(G_OBJECT (filesel->dir_tree),
				filesel->tree_signal_id);
    gtk_widget_hide (filesel->tree_window);
    gtk_widget_set_usize (filesel->list_window,
			  LIST_WINDOW_WIDE_W, LIST_WINDOW_H);
  } 
}

/* ************************************************************************* */
void
gtk_custom_icon_file_selection_set_dir (GtkCustomIconFileSel	*filesel,
					const gchar 		*path) {
  gchar 	*real_path = NULL;
 
  if (!path) return;

  real_path = g_get_absolute_path (path);
  if (filesel->show_tree) {
    gtk_dir_tree_view_set_dir (GTK_DIR_TREE_VIEW (filesel->dir_tree),
			       real_path);
  }
  gtk_file_list_open_dir (GTK_FILE_LIST (filesel->file_list), real_path);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (filesel->dir_combo)->entry),
		      real_path);
  combo_list_add (filesel, real_path);
  g_free (real_path);

  return;
}

/* ************************************************************************* */
void
gtk_custom_icon_file_selection_show_hidden (GtkCustomIconFileSel *filesel,
					    gboolean		show_hidden) {
  GTK_DIR_TREE_VIEW  (filesel->dir_tree)->show_hidden  = show_hidden;
  GTK_FILE_LIST (filesel->file_list)->show_hidden = show_hidden;
  gtk_dir_tree_view_refresh_tree (GTK_DIR_TREE_VIEW (filesel->dir_tree));
  gtk_file_list_refresh (GTK_FILE_LIST (filesel->file_list));
}

/* ************************************************************************* */
void
gtk_custom_icon_file_selection_set_filter (GtkCustomIconFileSel *filesel,
					   const gchar 		*filter) {
  if (!filter) return;
  
  gtk_file_list_set_filter (GTK_FILE_LIST(filesel->file_list), filter);
#if 0  
  gtk_file_list_refresh (GTK_FILE_LIST (filesel->file_list));
#endif
  gtk_entry_set_text (GTK_ENTRY (filesel->filter_entry),filter);
}
  
/* ************************************************************************* */
gchar*
gtk_custom_icon_file_selection_get_filename (GtkCustomIconFileSel *filesel) {
  return g_build_filename (gtk_entry_get_text 
			   (GTK_ENTRY (GTK_COMBO (filesel->dir_combo)->entry)),
			   gtk_entry_get_text (GTK_ENTRY 
					       (filesel->file_entry)),
			   NULL);
}


/* ************************************************** gtkcustomfilesel.c *** */
