/* ***************************************************** gtkiconbutton.c *** *
 * GtkIconButton
 *
 * Copyright (C) 2002 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/03/08 10:47:36 sugaya>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "gtkiconbutton.h"

#define	CHILD_SPACING	1

enum {
  PRESSED,
  RELEASED,
  CLICKED,
  ENTER,
  LEAVE,
  LAST_SIGNAL
};

/* ************************************************************************* */
static void gtk_icon_button_class_init	(GtkIconButtonClass	*class);
static void gtk_icon_button_init 	(GtkIconButton		*button);
static GtkWidget* _gtk_icon_button_new	(gint			text_position);

static GtkButtonClass	*parent_class = NULL;

/* ************************************************************************* */
GtkType
gtk_icon_button_get_type (void) {
  static GtkType	icon_button_type = 0;

  if (!icon_button_type) {
    GtkTypeInfo	icon_button_info = {
      "GtkIconButton",
      sizeof (GtkIconButton),
      sizeof (GtkIconButtonClass),
      (GtkClassInitFunc)  gtk_icon_button_class_init,
      (GtkObjectInitFunc) gtk_icon_button_init,
      NULL,
      NULL,
      NULL
    };
    icon_button_type
      = gtk_type_unique (gtk_button_get_type (), &icon_button_info);
  }
  return icon_button_type;
}

/* ************************************************************************* */
static void
gtk_icon_button_class_init (GtkIconButtonClass	*class) {
  parent_class = gtk_type_class (gtk_button_get_type ());  
}

/* ************************************************************************* */
static void
gtk_icon_button_init (GtkIconButton	*button) {
  button->icon  = NULL;
  button->label = NULL;
}

/* ************************************************************************* */
static GtkWidget*
_gtk_icon_button_new (gint	text_position) {
  GtkIconButton	*ibutton;
  GtkWidget	*button;
  GtkWidget	*alignment;
  
  button = GTK_WIDGET (gtk_type_new (gtk_icon_button_get_type ()));
  ibutton = GTK_ICON_BUTTON (button);  

  alignment = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
  g_object_set_data_full (G_OBJECT (ibutton), "alignment", 
			  gtk_widget_ref (alignment),
			  (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (button), alignment);
  gtk_widget_show (alignment);
  {
    if (text_position == GTK_ICON_BUTTON_TEXT_TOP ||
	text_position == GTK_ICON_BUTTON_TEXT_BOTTOM) {
      ibutton->box = gtk_vbox_new (FALSE, 0);
    } else {
      ibutton->box = gtk_hbox_new (FALSE, 0);
    }
    g_object_set_data_full (G_OBJECT (ibutton), "box", 
			    gtk_widget_ref (ibutton->box),
			    (GtkDestroyNotify) gtk_widget_unref);
    gtk_container_add (GTK_CONTAINER (alignment), ibutton->box);
    gtk_widget_show (ibutton->box);
  }
  return button;
}
		      
/* ************************************************************************* */
GtkWidget*
gtk_icon_button_new (const gchar	*filename) {
  GtkIconButton	*ibutton;
  GtkWidget	*button;
  
  button  = _gtk_icon_button_new (GTK_ICON_BUTTON_TEXT_TOP);
  ibutton = GTK_ICON_BUTTON (button);
  if (!filename) return button;
  {
    ibutton->icon = gtk_image_new_from_file (filename);
    g_object_set_data_full (G_OBJECT (ibutton), "icon", 
			    gtk_widget_ref (ibutton->icon),
			    (GtkDestroyNotify) gtk_widget_unref);
    gtk_container_add (GTK_CONTAINER (ibutton->box), ibutton->icon);
    gtk_widget_show (GTK_ICON_BUTTON (button)->icon);
  }
  return button;
}

/* ************************************************************************* */
GtkWidget*
gtk_icon_button_new_from_inline (const guint8	*data) {
  GtkIconButton	*ibutton;
  GtkWidget	*button;
  GdkPixbuf	*pbuf = NULL;

  button  = _gtk_icon_button_new (GTK_ICON_BUTTON_TEXT_TOP);
  ibutton = GTK_ICON_BUTTON (button);  
  if (!data) return button;
  {
    pbuf = gdk_pixbuf_new_from_inline (-1, data, FALSE, NULL);
    if (!pbuf) return button;
    ibutton->icon = gtk_image_new_from_pixbuf (pbuf);
    g_object_set_data_full (G_OBJECT (ibutton), "icon", 
			    gtk_widget_ref (ibutton->icon),
			    (GtkDestroyNotify) gtk_widget_unref);
    gtk_container_add (GTK_CONTAINER (ibutton->box), ibutton->icon);
    gtk_widget_show (ibutton->icon);
    gdk_pixbuf_unref (pbuf);
  }
  return button;
}

/* ************************************************************************* */
GtkWidget*
gtk_icon_button_new_with_label (const gchar	*filename,
				const gchar	*text,
				gint		text_position,
				gint		border) {
  GtkIconButton	*ibutton;
  GtkWidget	*button;

  button  = _gtk_icon_button_new (text_position);
  ibutton = GTK_ICON_BUTTON (button);  
  if (!filename || !text) return button;
  {
    ibutton->icon = gtk_image_new_from_file (filename);
    g_object_set_data_full (G_OBJECT (ibutton), "icon", 
			    gtk_widget_ref (ibutton->icon),
			    (GtkDestroyNotify) gtk_widget_unref);

    ibutton->label = gtk_label_new_with_mnemonic (text);
    gtk_label_set_mnemonic_widget (GTK_LABEL (ibutton->label),
				   GTK_WIDGET (button));
    g_object_set_data_full (G_OBJECT (ibutton), "label", 
			    gtk_widget_ref (ibutton->label),
			    (GtkDestroyNotify) gtk_widget_unref);

    if (text_position == GTK_ICON_BUTTON_TEXT_TOP ||
	text_position == GTK_ICON_BUTTON_TEXT_LEFT) {
      gtk_box_pack_start (GTK_BOX (ibutton->box),
			  ibutton->label, FALSE, FALSE, border);
      gtk_box_pack_start (GTK_BOX (ibutton->box),
			  ibutton->icon, FALSE, FALSE, border);
    } else {
      gtk_box_pack_start (GTK_BOX (ibutton->box),
			  ibutton->icon, FALSE, FALSE, border);
      gtk_box_pack_start (GTK_BOX (ibutton->box),
			  ibutton->label, FALSE, FALSE, border);
    }
    gtk_widget_show (ibutton->icon);
    gtk_widget_show (ibutton->label);      
  }
  return button;
}

/* ************************************************************************* */
GtkWidget*
gtk_icon_button_new_from_inline_with_label (const guint8	*data,
					    const gchar		*text,
					    gint		text_position,
					    gint		border) {
  GtkIconButton	*ibutton;
  GtkWidget	*button;
  GdkPixbuf	*pbuf = NULL;

  button  = _gtk_icon_button_new (text_position);
  ibutton = GTK_ICON_BUTTON (button);    
  if (!data || !text) return button;
  {
    pbuf = gdk_pixbuf_new_from_inline (-1, data, FALSE, NULL);
    if (!pbuf) return button;
    ibutton->icon = gtk_image_new_from_pixbuf (pbuf);
    g_object_set_data_full (G_OBJECT (ibutton), "icon", 
			    gtk_widget_ref (ibutton->icon),
			    (GtkDestroyNotify) gtk_widget_unref);
    gdk_pixbuf_unref (pbuf);

    ibutton->label = gtk_label_new_with_mnemonic (text);
    gtk_label_set_mnemonic_widget (GTK_LABEL (ibutton->label),
				   GTK_WIDGET (button));
    g_object_set_data_full (G_OBJECT (ibutton), "label", 
			    gtk_widget_ref (ibutton->label),
			    (GtkDestroyNotify) gtk_widget_unref);

    if (text_position == GTK_ICON_BUTTON_TEXT_TOP ||
	text_position == GTK_ICON_BUTTON_TEXT_LEFT) {
      gtk_box_pack_start (GTK_BOX (ibutton->box),
			  ibutton->label, FALSE, FALSE, border);
      gtk_box_pack_start (GTK_BOX (ibutton->box),
			  ibutton->icon, FALSE, FALSE, border);
    } else {
      gtk_box_pack_start (GTK_BOX (ibutton->box),
			  ibutton->icon, FALSE, FALSE, border);
      gtk_box_pack_start (GTK_BOX (ibutton->box),
			  ibutton->label, FALSE, FALSE, border);
    }
    gtk_widget_show (ibutton->icon);
    gtk_widget_show (ibutton->label);      
  }
  return button;
}

/* ********************************************** End of gtkiconbutton.c *** */
