/* ************************************************************* image.h *** *
 * TEImage˴ؤؿ إåե
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/04/28 23:19:34 sugaya>
 * ************************************************************************* */
#ifndef	__IMAGE_H__
#define	__IMAGE_H__

#include <teo.h>

/* ************************************************************************* *
 * TEImage¤ΤΥФ˥ޥ
 * ************************************************************************* */
#define ti_get_image(list)     ((TEImage *) (list)->data)
#define ti_get_xoffset(list)   (((TEImage *) (list)->data)->xoffset)
#define ti_get_yoffset(list)   (((TEImage *) (list)->data)->yoffset)
#define ti_get_width(list)     (((TEImage *) (list)->data)->width)
#define ti_get_height(list)    (((TEImage *) (list)->data)->height)
#define ti_get_nframes(list)   (((TEImage *) (list)->data)->nframes)
#define ti_get_nchannels(list) (((TEImage *) (list)->data)->nchannels)
#define ti_get_frame(list)     (((TEImage *) (list)->data)->frame)
#define ti_get_channel(list)   (((TEImage *) (list)->data)->channel)
#define ti_get_type(list)      (((TEImage *) (list)->data)->type)
#define ti_get_bit(list)       (((TEImage *) (list)->data)->bit)
#define ti_get_pixbuf(list)    (((TEImage *) (list)->data)->pixbuf)
#define ti_get_mod(list)       (((TEImage *) (list)->data)->mod)
#define ti_get_min(list)       (((TEImage *) (list)->data)->min)
#define ti_get_max(list)       (((TEImage *) (list)->data)->max)
#define ti_get_pixeltype(list) (((TEImage *) (list)->data)->pixeltype)
#define ti_get_file_path(list) (((TEImage *) (list)->data)->filename)
#define ti_get_has_alpha(list) (((TEImage *) (list)->data)->has_alpha)
#define ti_get_external(list)  (((TEImage *) (list)->data)->external)
#define ti_get_original_data(list) ((TEOIMAGE *) ((TEImage *) (list)->data)->original_data)
#define ti_get_origianl_data_list(list) (((TEImage *) (list)->data)->original_data_list)
#define ti_get_fp(list)        ((TEOFILE *) ((TEImage *) (list)->data)->fp)
#define ti_get_current_width(list)  (((TEImage *) (list)->data)->current_width)
#define ti_get_current_height(list) (((TEImage *) (list)->data)->current_height)
#define ti_get_pixbuf_list(list) (((TEImage *) (list)->data)->pixbuf_list)
#define ti_get_nth_pixbuf(list,n) ((GdkPixbuf *) g_list_nth_data (((TEImage *) (list)->data)->pixbuf_list, (n)))
#define ti_get_nth_original_data(list,n) ((TEOIMAGE *) g_list_nth_data (((TEImage *) (list)->data)->original_data_list, (n)))


/* ************************************************************************* */
#define ti_set_current_width(list, val) (((TEImage *) (list)->data)->current_width = (val))
#define ti_set_current_height(list, val) (((TEImage *) (list)->data)->current_height = (val))

#define ti_set_channel(list, val) (((TEImage *) (list)->data)->channel = (val))


/* ************************************************************************* *
 * ꤷɸβͤɤ߹ߡ񤭹
 * ************************************************************************* */
#define ti_get_pixel(list,x,y,p) \
(*(gdk_pixbuf_get_pixels((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) + \
 gdk_pixbuf_get_rowstride((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) * \
 (y) + \
 gdk_pixbuf_get_n_channels((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) * \
 (x) + (p)))

#define ti_put_pixel(list,x,y,p,val) \
(*(gdk_pixbuf_get_pixels((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) + \
 gdk_pixbuf_get_rowstride((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) * \
 (y) + \
 gdk_pixbuf_get_n_channels((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) * \
 (x) + (p)) = (val))

#define ti_get_pixel_from_original_data(list,x,y,p) \
(TeoGetAnyPixel(((TEOIMAGE *) ((TEImage *) (list)->data)->original_data),\
(x)+TeoXoffset((TEOIMAGE *) ((TEImage *) (list)->data)->original_data),\
(y)+TeoYoffset((TEOIMAGE *) ((TEImage *) (list)->data)->original_data), (p)))

/* ************************************************************************* */
const gchar*	ti_get_filename 	(GList		*list);
GList*		ti_get_list_from_path 	(GList		*list,
					 const gchar	*path);
void		ti_get_pixel_range 	(GList		*list,
					 gdouble	*min,
					 gdouble	*max);
GdkPixbuf*	ti_get_nth_plane 	(GList		*list,
					 gint		plane);
void		ti_set_pixbuf 		(GList		*list,
					 GdkPixbuf	*pixbuf);
TEImage*	teoeyes_image_new	(const gchar	*filename,
					 gboolean	external);
void		teoeyes_image_free	(TEImage	*ti);
gboolean	teoeyes_image_add_list	(GList		*list,
					 const gchar	*filename,
					 gboolean	external);

#endif	/* __IMAGE_H__ */

/* ****************************************************** End of image.h *** */
