/* ************************************************************** init.c *** *
 * ؿ
 *
 * Copyright (C) 2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <04/05/19 20:40:05 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "init.h"
#include "property.h"

/* 饤֥ν ****************************************************** */
void
teoeyes_init (int	argc,
	      char	**argv) {
  /*  */
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  /* GTK/GNOME饤֥ν */
  gnome_program_init ("teoeyes", VERSION, LIBGNOMEUI_MODULE, argc, argv, NULL);

  loope		= NULL;
  pixel_window	= NULL;
  edit_window	= NULL;
  html_window	= NULL;
  explorer	= NULL;
  config_dialog	= NULL;
  open_dialog	= NULL;
  save_dialog	= NULL;
  player	= NULL;
  assistant	= NULL;
  plugin_list	= NULL;
  image_loader	= NULL;
}

/* եɤ߹ ************************************************** */
TEConfig*
teoeyes_init_config (void) {
  TEConfig	*tc = NULL;
  gchar		*path = NULL, *filename = NULL;
  gboolean 	version_result;
  
  /* եΤǥ쥯ȥ */
  path = g_strconcat (g_get_home_dir (),
		      G_DIR_SEPARATOR_S, CONFIG_FILE_DIR, NULL);

  /* ǥ쥯ȥ꤬¸ߤʤк */
  if (!g_file_exist (path)) g_dir_mkdirs (path);

  /* ե뤬¸ߤʤк */
  filename = g_strconcat (path, G_DIR_SEPARATOR_S, CONFIG_FILE, NULL);
  if (!g_file_exist (filename)) {

    /* ɸեɤ߹ */
    tc = config_load_file (TEOEYES_CONFIG);
    if (tc->thumbnail_dir) g_free (tc->thumbnail_dir);
    tc->thumbnail_dir = g_strconcat (path, G_DIR_SEPARATOR_S, "icons", NULL);

    /* ɸեɤ߹ */
    config_save_file (tc, filename);
  } else {
    version_result = config_check_version (filename);
    if (version_result == 0) {
      g_printerr (_("Do not match the version of teoeyes config file.\n"));
    } else if (version_result == -1) {
      ;
    } else {
      tc = config_load_file (filename);
    }
  }
  g_free (path);
  g_free (filename);

  return tc;
}


/* ******************************************************* End of init.c *** */
