/* ************************************************************* loope.c *** *
 * 롼(ɽɥ)˴ؤؿ
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/05/02 23:24:53 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "draw.h"
#include "image_window.h"
#include "loope.h"
#include "pixel_info.h"
#include "gtkiconitemfactory.h"
#include "stock_loope.icon"

/* ************************************************************************* */
static void	gtk_radio_menu_item_activate	(GtkMenuItem	*menu_item);
static void	change_loope_scale 		(GtkWidget	*widget,
						 gpointer	scale);

/* ************************************************************************* *
 * Хåؿ
 * ************************************************************************* */

/* ************************************************************************* */
static void
cb_close (GtkWidget	*widget,
	  gpointer	data) {
  gtk_widget_hide (widget);
}

/* ѹ٥ ****************************************************** */
static int
cb_configure (GtkWidget		*widget,
	      GdkEventConfigure	*ev) {
  gint	x, y, lx, ly, scale;

#if 0  
  x	= (gint) gtk_object_get_data (GTK_OBJECT (image_window), "x");
  y	= (gint) gtk_object_get_data (GTK_OBJECT (image_window), "y");
  lx	= (gint) gtk_object_get_data (GTK_OBJECT (image_window), "lx"); 
  ly	= (gint) gtk_object_get_data (GTK_OBJECT (image_window), "ly"); 
  scale = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
#else
  x     = (gint) G_GET_PARAMETER (image_window, "x");
  y     = (gint) G_GET_PARAMETER (image_window, "y");
  lx    = (gint) G_GET_PARAMETER (image_window, "lx");
  ly    = (gint) G_GET_PARAMETER (image_window, "ly");
  scale = (gint) G_GET_PARAMETER (image_window, "scale");
#endif
  draw_loope_image (widget, image_list, x, y, lx, ly, scale);
  
  return TRUE;
}

/* 襤٥ ********************************************************** */
static int
cb_expose (GtkWidget		*widget,
	   GdkEventExpose	*ev) {
  gint	x, y, lx, ly, scale;
  
  x	= (gint) gtk_object_get_data (GTK_OBJECT (image_window), "x");
  y	= (gint) gtk_object_get_data (GTK_OBJECT (image_window), "y");
  lx	= (gint) gtk_object_get_data (GTK_OBJECT (image_window), "lx"); 
  ly	= (gint) gtk_object_get_data (GTK_OBJECT (image_window), "ly"); 
  scale = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
  draw_loope_image (widget, image_list, x, y, lx, ly, scale);
  
  return FALSE;
}

/* ܥ󤬲줿ν ************************************************ */
static int
cb_mouse_press (GtkWidget	*widget,
		GdkEventButton	*ev) {
  gint	x, y, lx, ly, ox, oy, scale;
  gint	param;
    
  switch (ev->button) {
  case MOUSE_BUTTON_LEFT:	/* ܥ */
#if 0
    scale = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
#else
    scale = (gint) G_GET_PARAMETER (image_window, "scale");
#endif
    param = LOOPE_WINDOW_SIZE / (scale * 2) - 1;
    x	  = (gint) ev->x / scale - param;
    y     = (gint) ev->y / scale - param;
    param = LOOPE_WINDOW_SIZE / 2;
    lx    = param - (1 - x) * scale; 
    ly    = param - (1 - y) * scale; 
#if 0
    ox	  = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "x");
    oy	  = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "y");
#else
    ox    = (gint) G_GET_PARAMETER (image_window, "x");
    oy    = (gint) G_GET_PARAMETER (image_window, "y");
#endif
    if (ox + x >= 0 && ox + x < ti_get_width  (image_list) &&
	oy + y >= 0 && oy + y < ti_get_height (image_list)) {
      draw_loope_image (widget, image_list, ox, oy, lx, ly, scale);
      pixel_window_show (ox + x, oy + y,
			 (ev->state == 1) ?
			 PIXEL_TYPE_CURRENT : PIXEL_TYPE_ORIGINAL,
			 gdk_x11_drawable_get_xdisplay (ev->window), ev->time);
#if 0
      gtk_object_set_data (GTK_OBJECT (image_window), "lx", (gpointer) lx);
      gtk_object_set_data (GTK_OBJECT (image_window), "ly", (gpointer) ly);
#else
      G_SET_PARAMETER (image_window, "lx", lx);
      G_SET_PARAMETER (image_window, "ly", ly);
#endif
    }
    break;
  case MOUSE_BUTTON_CENTER:	/* ܥ */
    gtk_widget_hide (loope);
    break;
  case MOUSE_BUTTON_RIGHT:	/* ܥ */
    gtk_menu_popup (GTK_MENU (gtk_object_get_data (GTK_OBJECT (loope),"menu")),
		    NULL, NULL, NULL, NULL, ev->button, ev->time);
    break;
  case 4:
#if 0
    scale = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
#else
    scale = (gint) G_GET_PARAMETER (image_window, "scale");
#endif
    if (scale != 2) change_loope_scale (widget, (gpointer) (scale / 2));
    break;
  case 5:
#if 0
    scale = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
#else
    scale = (gint) G_GET_PARAMETER (image_window, "scale");
#endif
    if (scale != 128) change_loope_scale (widget, (gpointer) (scale * 2));
    break;
  }
  return FALSE;
}

/* ޥưν **************************************** */
static gboolean
cb_mouse_motion (GtkWidget		*widget,
		 GdkEventMotion 	*ev) {
  gint			x, y, lx, ly, ox, oy, scale, param;
  GdkModifierType	state;
  
  if (ev->is_hint) {
    gdk_window_get_pointer (ev->window, &x, &y, &state);
  } else {
    x	  = (gint) ev->x;
    y	  = (gint) ev->y;
    state = ev->state;
  }
  if ((state & GDK_BUTTON1_MASK) != 0) {
#if 0
    scale = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "scale");
#else
    scale = (gint) G_GET_PARAMETER (image_window, "scale");
#endif
    param = LOOPE_WINDOW_SIZE  / (scale * 2) - 1;
    x	  = x / scale - param;
    y     = y / scale - param; 
    param = LOOPE_WINDOW_SIZE / 2;
    lx    = param - (1 - x) * scale; 
    ly    = param - (1 - y) * scale;
#if 0
    ox	  = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "x");
    oy	  = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "y");
#else
    ox	  = (gint) G_GET_PARAMETER (image_window, "x");
    oy	  = (gint) G_GET_PARAMETER (image_window, "y");
#endif
    if (ox + x >= 0 && ox + x < ti_get_width  (image_list) &&
	oy + y >= 0 && oy + y < ti_get_height (image_list)) {
      draw_loope_image (widget, image_list, ox, oy, lx, ly, scale);
      pixel_window_show (ox + x, oy + y,
			 (ev->state == 257) ?
			 PIXEL_TYPE_CURRENT : PIXEL_TYPE_ORIGINAL,
			 gdk_x11_drawable_get_xdisplay (ev->window), ev->time);
#if 0    
      gtk_object_set_data (GTK_OBJECT (image_window), "lx",    (gpointer) lx);
      gtk_object_set_data (GTK_OBJECT (image_window), "ly",    (gpointer) ly);
#else
      G_SET_PARAMETER (image_window, "lx", lx);
      G_SET_PARAMETER (image_window, "ly", ly);
#endif
    }
  }
  return FALSE;
}

/* Ψѹ ************************************************************ */
static void
change_loope_scale (GtkWidget	*widget,
		    gpointer	scale) {
  gint	lx, ly;

  /* 롼ڥѹ */
#if 0
  gtk_object_set_data (GTK_OBJECT (image_window), "scale", (gpointer) scale);
#else
  G_SET_PARAMETER (image_window, "scale", scale);
#endif
  /* ɸη׻ */
  lx = ly = LOOPE_WINDOW_SIZE / 2 - (gint) scale;
#if 0
  gtk_object_set_data (GTK_OBJECT (image_window), "lx", (gpointer) lx);
  gtk_object_set_data (GTK_OBJECT (image_window), "ly", (gpointer) ly);  
#else
  G_SET_PARAMETER (image_window, "lx", lx);
  G_SET_PARAMETER (image_window, "ly", ly);
#endif
  /*  */
  draw_loope_image (G_GET_WIDGET (loope, "canvas"),
		    image_list, -1, -1, lx, ly, (gint) scale);
}

/* ݥåץåץ˥塼 ********************************************** */
static GtkIconItemFactoryEntry popup_menu_items[] = {
  /* ȥ */
  {"/Tearoff",		NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/Loope Size"),	NULL,	0,	0, 	"<iTitle>",	stock_loope},
  {"/separator",	NULL,	0, 	0,	"<Separator>",	NULL},

  {N_("/x   2"),	NULL,	change_loope_scale,   2, "<RadioItem>", NULL},
  {N_("/x   4"),	NULL,	change_loope_scale,   4, N_("/x   2"), NULL},
  {N_("/x   8"),	NULL,	change_loope_scale,   8, N_("/x   2"), NULL},
  {N_("/x  16"),	NULL,	change_loope_scale,  16, N_("/x   2"), NULL},
  {N_("/x  32"),	NULL,	change_loope_scale,  32, N_("/x   2"), NULL},
  {N_("/x  64"),	NULL,	change_loope_scale,  64, N_("/x   2"), NULL},
  {N_("/x 128"),	NULL,	change_loope_scale, 128, N_("/x   2"), NULL}
};

/* ************************************************************************* */
static gint
scale_to_id (gint	scale) {
  switch (scale) {
  case 2:
    return 0;
    break;
  case 4:
    return 1;
    break;
  case 8:
    return 2;
    break;
  case 16:
    return 3;
    break;
  case 32:
    return 4;
    break;
  case 64:
    return 5;
    break;
  case 128:
    return 6;
    break;
  default:
    return 0;
    break;
  }
}

/* ˥塼 ********************************************************** */
static GtkWidget*
loope_menu_new (GtkWidget	*window,
		gint		val) {
  gint			items;
  GtkIconItemFactory	*item_factory;
  GtkAccelGroup		*accel_group;
  GtkWidget		*item;
  gchar			*menu_string[] = {N_("/x   2"), N_("/x   4"),
					  N_("/x   8"), N_("/x  16"),
					  N_("/x  32"), N_("/x  64"),
					  N_("/x 128")};

  items = sizeof (popup_menu_items) / sizeof (popup_menu_items[0]);
  
  accel_group	= gtk_accel_group_new ();
  item_factory	= gtk_icon_item_factory_new (GTK_TYPE_MENU,
					     "<sub>", accel_group);
   gtk_icon_item_factory_set_translate_func 
     (item_factory, (GtkTranslateFunc) gettext, NULL, NULL);

  gtk_icon_item_factory_create_items (item_factory,
				      items, popup_menu_items, NULL);
  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

  item = gtk_icon_item_factory_get_widget (GTK_ICON_ITEM_FACTORY(item_factory),
					   menu_string[0]);
  GTK_CHECK_MENU_ITEM (item)->active = 0;
  
  item =
    gtk_icon_item_factory_get_widget (GTK_ICON_ITEM_FACTORY (item_factory),
				      menu_string[scale_to_id
						 (tc->loope_scale)]);
  GTK_CHECK_MENU_ITEM (item)->active = TRUE;
  gtk_radio_menu_item_activate (GTK_MENU_ITEM (item));

  return gtk_icon_item_factory_get_widget (item_factory, "<sub>");
}

/* 祦ɥ **************************************************** */
GtkWidget*
loope_new (gchar	*title,
	   gint		w,
	   gint		h) {
  GtkWidget	*window;
  GtkWidget	*canvas;
  GtkWidget	*menu;

  /* ɥ */  
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");
  g_signal_connect (G_OBJECT (window), "delete_event",
		    G_CALLBACK (cb_close), NULL);
  g_signal_connect (G_OBJECT (window), "destroy",
		    G_CALLBACK (cb_close), NULL);

  /* ȥ */
  gtk_window_set_title  (GTK_WINDOW (window), title);

  /* ɥ */
  gtk_widget_set_size_request (window, w, h);

  /* ɥꥵ */
  gtk_window_set_resizable (GTK_WINDOW (window), FALSE);

  /* ٥Ȥ */
  g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (cb_close),
		    NULL);
  g_signal_connect (G_OBJECT (window), "destroy", G_CALLBACK (cb_close), NULL);
  
  /* ɥꥢ åȤ */
  {
    /* åȤ */
    canvas = gtk_drawing_area_new ();

    /*  */
    gtk_drawing_area_size (GTK_DRAWING_AREA (canvas), w, h);

    /* ɥåȤإѥå */
    gtk_widget_show (canvas);
    gtk_container_add (GTK_CONTAINER (window), canvas);

    /* ̾Ͽ */
#if 0
    gtk_object_set_data (GTK_OBJECT (window), "canvas", canvas);
#else
    G_SET_WIDGET (window, "canvas", canvas);
#endif
    /* ٥ȥϥɥ */
    gtk_widget_set_events (canvas,
			   GDK_BUTTON_PRESS_MASK |
			   GDK_POINTER_MOTION_MASK |
			   GDK_POINTER_MOTION_HINT_MASK |
			   GDK_KEY_PRESS_MASK);

    g_signal_connect (G_OBJECT (canvas), "configure_event",
		      G_CALLBACK (cb_configure), NULL);
    g_signal_connect (G_OBJECT (canvas), "expose_event",
			G_CALLBACK (cb_expose), NULL);
    g_signal_connect (G_OBJECT (canvas), "button_press_event",
			G_CALLBACK (cb_mouse_press), NULL);
    g_signal_connect (G_OBJECT (canvas), "motion_notify_event",
			G_CALLBACK (cb_mouse_motion), NULL);
  }
  /* ݥåץåץ˥塼 */
  menu = loope_menu_new (window, 
			 (gint) gtk_object_get_data (GTK_OBJECT (image_window),
						     "scale"));
#if 0
  gtk_object_set_data (GTK_OBJECT (window), "menu", menu);
#else
  G_SET_WIDGET (window, "menu", menu);
#endif
  gtk_widget_realize (window);
  gtk_window_set_icon (GTK_WINDOW (window), te_icon);
  gdk_window_set_icon_name (window->window, _("TeoEyes Loope"));
  
  return window;
}

/* ************************************************************************* *
 * GtkRadioMeuItemǻϤ˥ƥ֤ˤ륢ƥѹ뤿δؿ
 * 	(This function is included in gtk+-1.2.10/gtk/gtk/gtkradiomenuitem.c)
 * ************************************************************************* */
static void
gtk_radio_menu_item_activate (GtkMenuItem	*menu_item) {
  GtkRadioMenuItem	*radio_menu_item;
  GtkCheckMenuItem	*check_menu_item;
  GtkCheckMenuItem 	*tmp_menu_item;
  GSList 		*tmp_list;
  gint 			toggled;

  g_return_if_fail (menu_item != NULL);
  g_return_if_fail (GTK_IS_RADIO_MENU_ITEM (menu_item));

  radio_menu_item = GTK_RADIO_MENU_ITEM (menu_item);
  check_menu_item = GTK_CHECK_MENU_ITEM (menu_item);
  toggled = FALSE;

  if (check_menu_item->active) {
    tmp_menu_item = NULL;
    tmp_list	  = radio_menu_item->group;

    while (tmp_list) {
      tmp_menu_item = tmp_list->data;
      tmp_list	    = tmp_list->next;

      if (tmp_menu_item->active && (tmp_menu_item != check_menu_item)) break;
      
      tmp_menu_item = NULL;
    }
    if (tmp_menu_item) {
      toggled = TRUE;
      check_menu_item->active = !check_menu_item->active;
    }
  } else {
    toggled = TRUE;
    check_menu_item->active = !check_menu_item->active;

    tmp_list = radio_menu_item->group;
    while (tmp_list) {
      tmp_menu_item = tmp_list->data;
      tmp_list	    = tmp_list->next;

      if (tmp_menu_item->active && (tmp_menu_item != check_menu_item)) {
	gtk_menu_item_activate (GTK_MENU_ITEM (tmp_menu_item));
	break;
      }
    }
  }
  if (toggled) gtk_check_menu_item_toggled (check_menu_item);
  gtk_widget_queue_draw (GTK_WIDGET (radio_menu_item));
}

/* ****************************************************** End of loope.c *** */

