/* ********************************************************* teo_pixel.h *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/01/17 14:10:49 sugaya>
 * ************************************************************************* */
#ifndef __TEO_PIXEL_H__
#define __TEO_PIXEL_H__

/* ************************************************************************* *
   These functions are about pixel access that can call without 
   explicit pixel type.
 * ************************************************************************* */
double	TeoGetAnyPixel		(TEOIMAGE	*img,
				 int		col,
				 int 		row,
				 int		p);

void	TeoPutAnyPixel		(TEOIMAGE	*img,
				 int		col,
				 int		row,
				 int		p,
				 double		val);

void	TeoGetAnyPixelRGB	(TEOIMAGE	*img,
				 int		col,
				 int 		row,
				 double 	val[3]);

void	TeoPutAnyPixelRGB	(TEOIMAGE	*img,
				 int		col,
				 int		row,
				 double		val[3]);

#endif	/* __TEO_PIXEL_H__ */

/* ************************************************** End of teo_pixel.h *** */
