<?php
/*
  $Id: remise.php,v 1.5.5 2004/07/26
  catalog/includes/modules/payment/remise.php
  http://www.endless.ne.jp/
  
  Copyright (c) 2003-2004 Endless Net
  
  Released under the GNU General Public License
*/

  class remise {
    var $code, $title, $description, $enabled;

// class constructor
    function remise() {
      global $order;

      $this->code = 'remise';
      $this->title = MODULE_PAYMENT_REMISE_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_REMISE_TEXT_DESCRIPTION;
      $this->explain = MODULE_PAYMENT_REMISE_TEXT_EXPLAIN;
      $this->sort_order = MODULE_PAYMENT_REMISE_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_REMISE_STATUS == 'True') ? true : false);

      if ((int)MODULE_PAYMENT_REMISE_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_REMISE_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();

      $this->form_action_url =MODULE_PAYMENT_REMISE_URL;
      $this->email_footer = MODULE_PAYMENT_REMISE_TEXT_EMAIL_FOOTER;//Add Japanese osCommerce
    }

// class methods
    function update_status() {
      global $order;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_REMISE_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_REMISE_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
        return false;
    }

    function selection() {
    global $order;
   

        for ($i=1; $i<13; $i++) {
          $expires_month[] = array('id' => sprintf('%02d', $i), 'text' => strftime('%B',mktime(0,0,0,$i,1,2000)));
        }

        $today = getdate(); 
        for ($i=$today['year']; $i < $today['year']+10; $i++) {
          $expires_year[] = array('id' => strftime('%y',mktime(0,0,0,1,1,$i)), 'text' => strftime('%Y',mktime(0,0,0,1,1,$i)));
        }
        
        $payway[] = array('id' => '10', 'text' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD_ONE);
        
        if(MODULE_PAYMENT_REMISE_REVO=="ON"){
        	$payway[] = array('id' => '80', 'text' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD_REVO);
        }        
        
        if(MODULE_PAYMENT_REMISE_ESPAY=="ON"){
        	$payway[] = array('id' => '61', 'text' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD_ESPAY);
        }

		if(MODULE_PAYMENT_REMISE_ESPAY=="ON" || MODULE_PAYMENT_REMISE_REVO=="ON"){
			$cc_method = tep_draw_pull_down_menu('remise_cc_method', $payway);
		}else{
			$cc_method = tep_draw_hidden_field('remise_cc_method', '10').MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD_ONE;
		}
		
      if (MODULE_PAYMENT_REMISE_INPUT_MODE == 'Local') {	
      			
			$selection = array('id' => $this->code,
			               'module' => $this->title,
			               'fields' => array(array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_CARD_OWNER,
			                                          'field' => $order->billing['firstname'] . ' ' . $order->billing['lastname']),
			                                 array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_CARD_OWNER_ROMA,
			                                       'field' => tep_draw_input_field('remise_cc_name')),
			                                 array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_CARD_NUMBER,
			                                       'field' => tep_draw_input_field('remise_cc_number')),
			                                 array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_CARD_EXPIRES,
			                                       'field' => tep_draw_pull_down_menu('remise_cc_expires_month', $expires_month) . '&nbsp;' . tep_draw_pull_down_menu('remise_cc_expires_year', $expires_year)),
			                                 array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD,
			                                       'field' => $cc_method))  
			);


      }else{
      	
		$selection = array(	'id' => $this->code,
							'module' => $this->title,
							'fields' => array(array('title' => $this->explain,'field' => ''),
										      array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD,
			                                       'field' => $cc_method))
							);
      
      } 

	return $selection;

    }

    function pre_confirmation_check() {
      global $HTTP_POST_VARS;

      if (MODULE_PAYMENT_REMISE_INPUT_MODE == 'Local') {
      	
      	if(MODULE_PAYMENT_REMISE_CARD_CHECK=='ON'){

	        include(DIR_WS_CLASSES . 'cc_validation.php');
	
	        $cc_validation = new cc_validation();
	
	        $result = $cc_validation->validate($HTTP_POST_VARS['remise_cc_number'], $HTTP_POST_VARS['remise_cc_expires_month'], $HTTP_POST_VARS['remise_cc_expires_year']);
	
	        $error = '';
	
		        switch ($result) {
		          case -1:
		            $error = sprintf(MODULE_PAYMENT_REMISE_TEXT_CC_INVALID_NUMBER, substr($cc_validation->cc_number, 0, 4));
		            break;
		          case -2:
		          case -3:
		          case -4:
		            $error = MODULE_PAYMENT_REMISE_TEXT_CC_INVALID_DATE;
		            break;
		          case false:
		            $error = MODULE_PAYMENT_REMISE_TEXT_CC_INVALID_NUMBER;
		            break;
		        }
			
			$this->cc_card_name=mb_convert_kana($HTTP_POST_VARS['remise_cc_name'],"a");
			
			if(strlen($this->cc_card_name)<3 || ereg("[^0-9a-zA-Z ]",$this->cc_card_name)){
				if ( ($result == false) || ($result < 1) ) {
						$error .= MODULE_PAYMENT_REMISE_TEXT_CC_NAME;
				}else{
						$error = MODULE_PAYMENT_REMISE_TEXT_CC_NAME;
				}
				$result=false;
			}
	
	        if ( ($result == false) || ($result < 1) ) {        	
	        	$encode =mb_http_input();			
				if($encode == 'ASCII' ){ $encode = 'UTF-8';}	
				$error=mb_convert_encoding($error,$encode);
				$payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error) ;
				
				tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
			}
	
	        $this->cc_card_type = $cc_validation->cc_type;
	        $this->cc_card_number = $cc_validation->cc_number;
	        $this->cc_expiry_month = $cc_validation->cc_expiry_month;
	        $this->cc_expiry_year = $cc_validation->cc_expiry_year;
        
        }else{
        	$this->cc_card_name=mb_convert_kana($HTTP_POST_VARS['remise_cc_name'],"a");
	        $this->cc_card_number = $HTTP_POST_VARS['remise_cc_number'];
	        $this->cc_expiry_month = $HTTP_POST_VARS['remise_cc_expires_month'];
	        $this->cc_expiry_year = $HTTP_POST_VARS['remise_cc_expires_year'];
        }

      } else {
        return false;
      }
    }

    function confirmation() {
      global $HTTP_POST_VARS, $order;
      
      $method = $HTTP_POST_VARS['remise_cc_method'];
      if($method == '10'){
      	$method_text = MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD_ONE;
      }elseif ($method == '61'){
      	$method_text = MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD_ESPAY;
      }elseif ($method == '80'){
      	$method_text = MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD_REVO;
      }
      
      if (MODULE_PAYMENT_REMISE_INPUT_MODE == 'Local') {
        $confirmation = array('title' => $this->title . ': ' . $this->cc_card_type,
                              'fields' => array(array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_CARD_OWNER,
                                                      'field' => $order->billing['firstname'] . ' ' . $order->billing['lastname']),
                                                array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_CARD_NUMBER,
                                                      'field' => substr($this->cc_card_number, 0, 4) . str_repeat('X', (strlen($this->cc_card_number) - 8)) . substr($this->cc_card_number, -4)),
                                                array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_CARD_EXPIRES,
                                                      'field' => strftime('%B, %Y', mktime(0,0,0,$HTTP_POST_VARS['remise_cc_expires_month'], 1, '20' . $HTTP_POST_VARS['remise_cc_expires_year']))),
                                                array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD,
                                                      'field' => $method_text)   ));


      } else {
        $confirmation = array('title' => $this->title ,
                              'fields' => array(array('title' => MODULE_PAYMENT_REMISE_TEXT_CREDIT_METHOD,
                                                      'field' => $method_text)   ));
      }
      
        return $confirmation;
    }

    function process_button() {
      global $HTTP_SERVER_VARS, $HTTP_POST_VARS,$currencies,$customer_id, $order, $remise_order_id,$comments;
      
	  $remise_job_code = 	MODULE_PAYMENT_REMISE_JOB_CODE;
	  
		if( strlen(MODULE_PAYMENT_REMISE_MODEL) > 0 ){
		
		    for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
		    	if( ereg(MODULE_PAYMENT_REMISE_MODEL,$order->products[$i]['model']) ){
		    		$remise_job_code = "CHECK";
		    		
					$strlen_futeikan = strlen(MODULE_PAYMENT_REMISE_MAIL_FUTEIKANN);
					$strlen_comments = strlen($comments);
					if(substr($comments,$strlen_comments-$strlen_futeikan) != MODULE_PAYMENT_REMISE_MAIL_FUTEIKANN){
						if(strlen($comments)>0){
							$comments .= "\n\n" . MODULE_PAYMENT_REMISE_MAIL_FUTEIKANN;
						}else{
							$comments = MODULE_PAYMENT_REMISE_MAIL_FUTEIKANN;
						}
					}
		    		
					break;
		    	}
		    } 
     
		}

					
      $remise_order_id = $customer_id . date('ymdHis');
      $total = ceil($order->info['total']);

      if (MODULE_PAYMENT_REMISE_INPUT_MODE == 'Local') {

      		$process_button_string = tep_draw_hidden_field('SHOPCO', MODULE_PAYMENT_REMISE_SHOP_CODE) .
                               tep_draw_hidden_field('HOSTID', MODULE_PAYMENT_REMISE_HOST_ID) .
                               tep_draw_hidden_field('JOB', $remise_job_code) .
                               tep_draw_hidden_field('ITEM', '0000120') .
                               tep_draw_hidden_field('METHOD', $HTTP_POST_VARS['remise_cc_method']) .
                               tep_draw_hidden_field('S_TORIHIKI_NO', $remise_order_id ) .
                               tep_draw_hidden_field('RETURL', tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL', true)) . 
                               tep_draw_hidden_field('AMOUNT', $total) .
                               tep_draw_hidden_field('TAX', '0') .
                               tep_draw_hidden_field('TOTAL', $total) .
                               tep_draw_hidden_field('NG_RETURL', tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=' . $this->code, 'NONSSL', true)) .  
                               tep_draw_hidden_field('CARD', $this->cc_card_number) .
                               tep_draw_hidden_field('EXPIRE', $this->cc_expiry_month . substr($this->cc_expiry_year,-2)) .
                               tep_draw_hidden_field('PTIMES', '2') .
                               tep_draw_hidden_field('NAME', $this->cc_card_name) .
                               tep_draw_hidden_field('MAIL', mb_convert_kana($order->customer['email_address'],"a")) .
                               tep_draw_hidden_field('OPT', $remise_job_code . "<>" . $this->cc_card_type . "<>" . $this->cc_card_name . "<>" . $this->cc_card_number . "<>" . $this->cc_expiry_month . substr($this->cc_expiry_year,-2) . "<>" . $HTTP_POST_VARS['remise_cc_method']) .
                               tep_draw_hidden_field('DIRECT', 'ON');
	}else{
      		$process_button_string = tep_draw_hidden_field('SHOPCO', MODULE_PAYMENT_REMISE_SHOP_CODE) .
                               tep_draw_hidden_field('HOSTID', MODULE_PAYMENT_REMISE_HOST_ID) .
                               tep_draw_hidden_field('JOB', $remise_job_code) .
                               tep_draw_hidden_field('ITEM', '0000120') .
                               tep_draw_hidden_field('METHOD', $HTTP_POST_VARS['remise_cc_method']) .
                               tep_draw_hidden_field('S_TORIHIKI_NO', $remise_order_id ) .
                               tep_draw_hidden_field('RETURL', tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL', true)) . 
                               tep_draw_hidden_field('NG_RETURL', tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=' . $this->code, 'NONSSL', true)) .  
                               tep_draw_hidden_field('EXITURL', tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=' . $this->code, 'NONSSL', true)) .  
                               tep_draw_hidden_field('AMOUNT', $total) .
                               tep_draw_hidden_field('TAX', '0') .
                               tep_draw_hidden_field('MAIL', mb_convert_kana($order->customer['email_address'],"a")) .
                               tep_draw_hidden_field('OPT', $remise_job_code . "<>" . $this->cc_card_type . "<>" . $this->cc_card_name . "<>" . $this->cc_card_number . "<>" . $this->cc_expiry_month . substr($this->cc_expiry_year,-2) . "<>" . $HTTP_POST_VARS['remise_cc_method']) .
                               tep_draw_hidden_field('TOTAL', $total) .
                               tep_draw_hidden_field('PTIMES', '2') ;
	}
	
      return $process_button_string;
    }
    

    function before_process() {
        global $order,$sales_id,$tranid,$refapproved,$refforwarded,$errcode,$errinfo,$errlevel,$r_code,$rec_type,$x_amount,$x_tax,$x_total,$remise_cc_job_code;
    	
		$sales_id=$_POST['X-S_TORIHIKI_NO'];
		$tranid=$_POST['X-TRANID'];
		$refapproved=$_POST['X-REFAPPROVED'];
		$refforwarded=$_POST['X-REFFORWARDED'];
		$errcode=$_POST['X-ERRCODE'];
		$errinfo=$_POST['X-ERRINFO'];
		$errlevel=$_POST['X-ERRLEVEL'];
		$r_code=$_POST['X-R_CODE'];
		$rec_type=$_POST['REC_TYPE'];
		$x_amount=$_POST['X-AMOUNT'];
		$x_tax=$_POST['X-TAX'];
		$x_total=$_POST['X-TOTAL'];
		$today = date('Y-m-d H:i:s');
		
		// $today = date('');
		
		if( MODULE_PAYMENT_REMISE_RET == "ON" ){
			
			$sql = "select * from remise_result where tranid='" . $tranid . "' and rec_type='RET' limit 1";
	    	$remise_query = tep_db_query($sql);

	    	if (tep_db_num_rows($remise_query ) > 0) {
	    		$remise_values = tep_db_fetch_array($remise_query);
			
	    		if(
	    			$sales_id !=  $remise_values['sales_id'] 		||
	    			$tranid != $remise_values['tranid'] 			||
	    			$refapproved != $remise_values['refapproved'] 	||
	    			$refforwarded != $remise_values['refforwarded'] ||
	    			$errinfo != $remise_values['errinfo'] 			||
	    			$errlevel != $remise_values['errlevel'] 		|| 
	    			$r_code != $remise_values['r_code'] 			|| 	    			
	    			$rec_type != "END"						 		|| 	    			
	    			$x_amount != $remise_values['x_amount'] 		|| 	    			
	    			$x_tax != $remise_values['x_tax']				|| 	    			
	    			$x_total != $remise_values['x_total']			||
	    			$errlevel > 0									||
	    			strlen($errlevel) == 0
	    		){
	    			if( MODULE_PAYMENT_REMISE_RET == "ON" )
					tep_db_query("INSERT INTO remise_result VALUES('','$sales_id','$tranid','$refapproved','$refforwarded','$errcode','$errinfo','$errlevel','$r_code','$rec_type','$x_amount','$x_tax','$x_total','failed:0','','',now())");
	    			tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, tep_session_name() . '=' . $HTTP_POST_VARS[tep_session_name()] . '&payment_error=' . $this->code, 'SSL', false, false));
	    		}
	    		
	    	}else{
	    			if( MODULE_PAYMENT_REMISE_RET == "ON" )
	    			tep_db_query("INSERT INTO remise_result VALUES('','$sales_id','$tranid','$refapproved','$refforwarded','$errcode','$errinfo','$errlevel','$r_code','$rec_type','$x_amount','$x_tax','$x_total','failed:1','" . $_SERVER['REMOTE_ADDR'] . "','" . $_SERVER['REQUEST_METHOD'] . "',now())");
	    			tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, tep_session_name() . '=' . $HTTP_POST_VARS[tep_session_name()] . '&payment_error=' . $this->code, 'SSL', false, false));

	    	}
    	
    	}else if ($errlevel > 0 || strlen($errlevel) == 0 ){    		
	    			tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, tep_session_name() . '=' . $HTTP_POST_VARS[tep_session_name()] . '&payment_error=' . $this->code, 'SSL', false, false));    		
    	}
    	
    	
		$card_info = $_POST['OPT'];
		
		$remise_cc_job_code = strtok($card_info,"<>");
	    	
			if(MODULE_PAYMENT_REMISE_CARD == "ON"){ 	
				
				$order->info['cc_type'] = strtok("<>");
				$order->info['cc_owner'] = strtok("<>");
				$order->info['cc_number'] = strtok("<>");
			    $order->info['cc_expires'] = strtok("<>");    
			
			}       
			
			if($remise_cc_job_code != MODULE_PAYMENT_REMISE_JOB_CODE){
				$order_status = MODULE_PAYMENT_REMISE_ORDER_STATUS_ID_FUTEIKAN;
				$order->info['order_status'] = $order_status;
			}

    }
    
    function after_process() {
      global $insert_id,$sales_id,$tranid,$refapproved,$refforwarded,$errcode,$errinfo,$errlevel,$r_code,$rec_type,$x_amount,$x_tax,$x_total, $order,$remise_cc_job_code,$comments;

      if( strlen($comments) > 0 ){ $newline = "\n\n"; }
      else{ $newline = ""; }
      
      if(strlen(MODULE_PAYMENT_REMISE_EXTURL)==0){
      	$comments .= $newline . "REMISEֹ桧" . $sales_id; 
      }elseif ( $remise_cc_job_code == "CAPTURE" && MODULE_PAYMENT_REMISE_CARD == "ON"){
      	$comments .= $newline . "Ѥ-<a href=\"orders_remise.php?selected_box=customers&status=1&page=1&oID=" . $insert_id . "&action=edit&salesID=".$sales_id ."\"><b><font color=\"#009900\">ʡý" . $sales_id ."</font></b></a>";  
      }elseif ( $remise_cc_job_code == "CHECK" && MODULE_PAYMENT_REMISE_CARD == "ON"){
      	$comments .= $newline . "ɤͭåѤ-<a href=\"orders_remise.php?selected_box=customers&status=1&page=1&oID=" . $insert_id . "&action=edit&salesID=".$sales_id ."\"><b><font color=\"#009900\">" . $sales_id ."</font></b></a>";        	
      }elseif ( $remise_cc_job_code == "AUTH" && MODULE_PAYMENT_REMISE_CARD == "ON"){
      	$comments .= $newline . "Ѥ-<a href=\"orders_remise.php?selected_box=customers&status=1&page=1&oID=" . $insert_id . "&action=edit&salesID=".$sales_id ."\"><b><font color=\"#009900\">塦ʡý" . $sales_id ."</font></b></a>";        	
      }elseif ( $remise_cc_job_code == "SAUTH" && MODULE_PAYMENT_REMISE_CARD == "ON"){
      	$comments .= "ͿȳݺѤ-<a href=\"orders_remise.php?selected_box=customers&status=1&page=1&oID=" . $insert_id . "&action=edit&salesID=".$sales_id ."\"><b><font color=\"#009900\">ʡý" . $sales_id ."</font></b></a>";        	
      }else{
      	$comments .= $newline . "REMISEֹ桧" . $sales_id;     	
      }
           
      tep_db_query("update " . TABLE_ORDERS_STATUS_HISTORY . " set comments='$comments' where orders_id='$insert_id'");
      
      if( MODULE_PAYMENT_REMISE_RET == "ON" )
	  tep_db_query("INSERT INTO remise_result VALUES('','$sales_id','$tranid','$refapproved','$refforwarded','$errcode','$errinfo','$errlevel','$r_code','$rec_type','$x_amount','$x_tax','$x_total','success','$remise_cc_job_code','',now())");
        
    }
    
    function output_error() {
      return false;
    }

    function get_error() {
    	global $HTTP_POST_VARS,$HTTP_GET_VARS;

 	  if (isset($HTTP_GET_VARS['error']) && (strlen($HTTP_GET_VARS['error']) > 0)) {
        $error_message = stripslashes(urldecode($HTTP_GET_VARS['error']));
      }else{
      	
    	$error_code = $HTTP_POST_VARS['X-ERRCODE'];
    	$error_info = $HTTP_POST_VARS['X-ERRINFO'];
     	
		if($error_code == "H12" && $error_info == "310030000"){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_H12_31003;
		}elseif($error_code == "H12" && $error_info == "310050000"){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_H12_31005;
		}elseif($error_code == "H12" && $error_info == "320060000"){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_H12_32006;
		}elseif($error_code == "H97" && $error_info == "220010000"){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_H97_22001;
		}elseif($error_code == "H97" && $error_info == "421010000"){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_H97_42101;
		}elseif($error_code == "H97" && $error_info == "450030000"){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_H97_45003;
		}elseif($error_code == "H97" && $error_info == "450040000"){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_H97_45004;
		}elseif($error_code == "H97" && $error_info == "450050000"){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_H97_45005;
		}elseif($error_code == "S99" && $error_info == "42S991000"){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_H97_45005;
		}elseif($error_code == "S99" && $error_info == "42S994000"){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_H97_45005;
		}elseif($error_code == 'C14'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_C14;
    	}elseif($error_code == 'G03'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G03;	
    	}elseif($error_code == 'G12'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G12;	
    	}elseif($error_code == 'G30'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G30;	
    	}elseif($error_code == 'G54'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G54;	
    	}elseif($error_code == 'G55'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G55;	
    	}elseif($error_code == 'G56'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G56;	
    	}elseif($error_code == 'G60'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G60;	    		
    	}elseif($error_code == 'G65'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G65;	
    	}elseif($error_code == 'G78'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G78;	
    	}elseif($error_code == 'G83'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G83;	
    	}elseif($error_code == 'G97'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G97;	
    	}elseif($error_code == 'G99'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_G99;	
    	}elseif($error_code == 'P90'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_P90;	
    	}elseif($error_code == 'S01'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_S01;	
    	}elseif($error_code == 'X51'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_X51;	
    	}elseif($error_code == 'X53'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_X53;	
    	}elseif($error_code == 'X65'){
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_X65;	
    	}else{
    		$error_message = MODULE_PAYMENT_REMISE_TEXT_ERROR_MESSAGE;	
    	}

    	if( strlen($error_code) > 0 )
      	$error_message = $error_code . ':' . $error_message;
      }
      

      return array('title' => MODULE_PAYMENT_REMISE_TEXT_ERROR,
                   'error' => $error_message);
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_REMISE_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
    	
    	
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Enable REMISE Module', 'MODULE_PAYMENT_REMISE_STATUS', 'True', 'ߡɷѤͭˤޤ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Remise Url', 'MODULE_PAYMENT_REMISE_URL', 'https://test.remise.jp/rpgw/paycard.asp', 'ѾURL', '6', '0', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Shop Code', 'MODULE_PAYMENT_REMISE_SHOP_CODE', '00000000', 'Ź', '6', '0', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Host Id', 'MODULE_PAYMENT_REMISE_HOST_ID', '00000000', 'ۥֹ', '6', '0', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Job Code', 'MODULE_PAYMENT_REMISE_JOB_CODE', 'AUTH', '֥', '6', '0', 'tep_cfg_select_option(array(\'CHECK\', \'CAPTURE\', \'AUTH\', \'SAUTH\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('쥸åȥɾ', 'MODULE_PAYMENT_REMISE_INPUT_MODE', 'Local', '쥸åȥɾϤǹԤ⡼ȡʣңţͣɣӣšˤǹԤ򤷤Ƥ', '6', '5', 'tep_cfg_select_option(array(\'Local\', \'Remote\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('', 'MODULE_PAYMENT_REMISE_RET', 'OFF', 'ΤԤ򤷤Ƥ', '6', '5', 'tep_cfg_select_option(array(\'ON\', \'OFF\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('ʧ', 'MODULE_PAYMENT_REMISE_REVO', 'OFF', 'ܥӥʧѤϡON򤷤Ƥ', '6', '5', 'tep_cfg_select_option(array(\'ON\', \'OFF\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('ʬʧ', 'MODULE_PAYMENT_REMISE_ESPAY', 'OFF', 'ʬʧѤϡON򤷤Ƥʬʧ2ʧޤǤˤʤޤ', '6', '5', 'tep_cfg_select_option(array(\'ON\', \'OFF\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('ϥå', 'MODULE_PAYMENT_REMISE_CARD_CHECK', 'ON', 'osCommerceǥ쥸åȥɤϥå򤹤', '6', '5', 'tep_cfg_select_option(array(\'ON\', \'OFF\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ɽν', 'MODULE_PAYMENT_REMISE_SORT_ORDER', '0', 'ɽν֤ꤷޤͽɽޤ', '6', '0', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Payment Zone', 'MODULE_PAYMENT_REMISE_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('ơ', 'MODULE_PAYMENT_REMISE_ORDER_STATUS_ID', '0', '쥸åȥɷΥơꤷƤ', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");   		
	

		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Remise ExtUrl', 'MODULE_PAYMENT_REMISE_EXTURL', 'https://test.remise.jp/rpgw/extsetcard.asp', 'ĥåURL', '6', '0', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('쥸åȥɾ¸', 'MODULE_PAYMENT_REMISE_CARD', 'OFF', '쥸åȥɾ¸뤫򤷤Ƥ', '6', '5', 'tep_cfg_select_option(array(\'ON\', \'OFF\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ưʾʤη', 'MODULE_PAYMENT_REMISE_MODEL', '', 'ʤη֤˻ʸ¸ߤ祫ɤͭåΤ߹Ԥޤ̤Ǹ夫ǤդβʤԤޤ', '6', '0', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('ĥå奪ơ', 'MODULE_PAYMENT_REMISE_ORDER_STATUS_ID_CAPTURE', '0', '쥸åȥɷΥơꤷƤ', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('ĥåʥơ', 'MODULE_PAYMENT_REMISE_ORDER_STATUS_ID_RETURN', '0', '쥸åȥɷʻΥơꤷƤ', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('ĥåȼåơ', 'MODULE_PAYMENT_REMISE_ORDER_STATUS_ID_VOID', '0', '쥸åȥɷѼûΥơꤷƤ', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('ưʾʥơ', 'MODULE_PAYMENT_REMISE_ORDER_STATUS_ID_FUTEIKAN', '0', 'ưʾʹΥơꤷƤ', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
	
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
    	if( file_exists(DIR_FS_ADMIN."orders_remise.php")){ 
      		return array('MODULE_PAYMENT_REMISE_STATUS', 'MODULE_PAYMENT_REMISE_URL', 'MODULE_PAYMENT_REMISE_EXTURL','MODULE_PAYMENT_REMISE_SHOP_CODE','MODULE_PAYMENT_REMISE_HOST_ID', 'MODULE_PAYMENT_REMISE_JOB_CODE', 'MODULE_PAYMENT_REMISE_INPUT_MODE', 'MODULE_PAYMENT_REMISE_RET', 'MODULE_PAYMENT_REMISE_CARD','MODULE_PAYMENT_REMISE_REVO','MODULE_PAYMENT_REMISE_ESPAY','MODULE_PAYMENT_REMISE_CARD_CHECK', 'MODULE_PAYMENT_REMISE_ORDER_STATUS_ID','MODULE_PAYMENT_REMISE_ORDER_STATUS_ID_CAPTURE','MODULE_PAYMENT_REMISE_ORDER_STATUS_ID_RETURN','MODULE_PAYMENT_REMISE_ORDER_STATUS_ID_VOID', 'MODULE_PAYMENT_REMISE_ORDER_STATUS_ID_FUTEIKAN','MODULE_PAYMENT_REMISE_MODEL','MODULE_PAYMENT_REMISE_SORT_ORDER','MODULE_PAYMENT_REMISE_ZONE');
    	}else{
       		return array('MODULE_PAYMENT_REMISE_STATUS', 'MODULE_PAYMENT_REMISE_URL', 'MODULE_PAYMENT_REMISE_SHOP_CODE','MODULE_PAYMENT_REMISE_HOST_ID', 'MODULE_PAYMENT_REMISE_JOB_CODE', 'MODULE_PAYMENT_REMISE_INPUT_MODE','MODULE_PAYMENT_REMISE_RET', 'MODULE_PAYMENT_REMISE_REVO','MODULE_PAYMENT_REMISE_ESPAY','MODULE_PAYMENT_REMISE_CARD_CHECK', 'MODULE_PAYMENT_REMISE_ORDER_STATUS_ID', 'MODULE_PAYMENT_REMISE_SORT_ORDER','MODULE_PAYMENT_REMISE_ZONE');   		
    	}
    }
  }
  
?>