<?php
/*
  $Id: currencies.php,v 1.3 2003/04/19 06:00:54 ptosh Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

////
// Class to handle currencies
// TABLES: currencies
  class currencies {
    var $currencies;

// class constructor
    function currencies() {
      $this->currencies = array();
      $currencies_query = tep_db_query("select code, title, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, value from " . TABLE_CURRENCIES);
      while ($currencies = tep_db_fetch_array($currencies_query)) {
        $this->currencies[$currencies['code']] = array('title' => $currencies['title'],
                                                       'symbol_left' => $currencies['symbol_left'],
                                                       'symbol_right' => $currencies['symbol_right'],
                                                       'decimal_point' => $currencies['decimal_point'],
                                                       'thousands_point' => $currencies['thousands_point'],
                                                       'decimal_places' => $currencies['decimal_places'],
                                                       'value' => $currencies['value']);
      }
    }

// class methods
    function format($number, $calculate_currency_value = true, $currency_type = '', $currency_value = '') {
      //global $_SESSION['currency'];
      //global $_SESSION['language'];

      if (empty($currency_type)) $currency_type = $_SESSION['currency'];

      $symbol_right = ($currency_type == 'JPY' && $_SESSION['language'] != 'japanese')
          ? 'YEN'
          : $this->currencies[$currency_type]['symbol_right'];

      if ($calculate_currency_value == true) {
        $rate = (tep_not_null($currency_value)) ? $currency_value : $this->currencies[$currency_type]['value'];
        $format_string = $this->currencies[$currency_type]['symbol_left'] . number_format($number * $rate, $this->currencies[$currency_type]['decimal_places'], $this->currencies[$currency_type]['decimal_point'], $this->currencies[$currency_type]['thousands_point']) . $symbol_right;
// if the selected currency is in the european euro-conversion and the default currency is euro,
// the currency will displayed in the national currency and euro currency
        if ( (DEFAULT_CURRENCY == 'EUR') && ($currency_type == 'DEM' || $currency_type == 'BEF' || $currency_type == 'LUF' || $currency_type == 'ESP' || $currency_type == 'FRF' || $currency_type == 'IEP' || $currency_type == 'ITL' || $currency_type == 'NLG' || $currency_type == 'ATS' || $currency_type == 'PTE' || $currency_type == 'FIM' || $currency_type == 'GRD') ) {
          $format_string .= ' <small>[' . $this->format($number, true, 'EUR') . ']</small>';
        }
      } else {
        $format_string = $this->currencies[$currency_type]['symbol_left'] . number_format($number, $this->currencies[$currency_type]['decimal_places'], $this->currencies[$currency_type]['decimal_point'], $this->currencies[$currency_type]['thousands_point']) . $symbol_right;
      }

      return $format_string;
    }

    function get_value($code) {
      return $this->currencies[$code]['value'];
    }

    function get_decimal_places($code) {
      return $this->currencies[$code]['decimal_places'];
    }

    function display_price($products_price, $products_tax, $quantity = 1) {
      if (tep_session_is_registered('customer_id') && $products_tax == 0){
         return $this->format($product_price * $quantity);
      } else {
         $return_this = $this->format(tep_add_tax($products_price, $products_tax) * $quantity);
         if (DISPLAY_PRICE_WITH_TAX == 'true') {
            $return_this .= '<br />(';
            // βʤɽ
            $return_this .= '<a href="' . tep_href_link(FILENAME_JPTAX, '', 'NONSSL') . '">' . TEXT_DISPLAY_TAXEXCL .'</a> ' . $this->format($products_price * $quantity);
            // Ǥɽ
//          $return_this .= '<br /> <a href="' . tep_href_link(FILENAME_JPTAX, '', 'NONSSL') . '">' . TEXT_DISPLAY_TAX . '</a> ' . $this->format(tep_calculate_tax($products_price, $products_tax) * $quantity);
            $return_this .= ')';
         }
         return $return_this;
      }
    }

// ۤüԤ
// $number: 
// $round_type: üΥ  'drop'=ڤΤ, 'round'=ͼθ, 'raise'=ڤ夲
// $currency_type: ̲ߥ () 'JPY'
// 2002/06/01 ɲ tamura
    function round_off($number, $round_type = '', $currency_type = '') {
      //global $_SESSION['currency'];
      $a_comp = array('drop'=>0.00001, 'round'=>0.50001, 'raise'=>0.99999);

      if ($round_type == '') $round_type = TAX_ROUND_OPTION;
      $comp_val = $a_comp[$round_type];
      if (!$comp_val) $comp_val = $a_comp['round'];

      if ($currency_type == '') $currency_type = $_SESSION['currency'];

      $power = pow(10.0, doubleval($this->currencies[$currency_type]['decimal_places']));

      return floor($number * $power + $comp_val) / $power;
    }
  }
?>
