/*************************************************************************************************/
/*!
   	@file		Document.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"ParserDoc.h"
#include	"Treedata.h"
#include	"PinConnectLine.h"
#include	"XmlParserProcess.h"
#include	"TextFile.h"
#include	"ComBase.h"

#pragma pack( push , 8 )		//set align

namespace document
{
using namespace std;
using namespace icubic;
using namespace treedata;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "ICallback" interface 
***************************************************************************************************/
cb_guid_define( ICallback_IID , 0x09E4CBAE , 0x8F8F4cb1 , 0xB6F8E357 , 0x357F2798 );
class ICallback;
typedef icubic::iface_object< ICallback , ICallback_IID >		iCallback;
typedef icubic::iface_reference< ICallback , ICallback_IID >	rCallback;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ICallback
{
public:
	class SetPropertyItemParam
	{
	public:
		unsigned int	m_tree_id;
		unsigned int	m_item_id;
		SetPropertyItemParam
			(
			unsigned int	tree_id , 
			unsigned int	item_id
			) : m_tree_id(tree_id) , m_item_id(item_id){}
	};
	class OutputMsgParam
	{
	public:
		enum ShowType
		{
			Remain , 
			Show , 
		};
		enum Cmd
		{
			Add , 
			Set , 
		};
		enum Type
		{
			Normal , 
			Error , 
		};
		class Msg
		{
		public:
			const wchar_t*	m_msg;
			int				m_row , m_column;
			Msg() : m_msg( 0 ) , m_row( -1 ) , m_column( -1 ){}
		};
		ShowType		m_show;
		Type			m_type;
		Cmd				m_cmd;
		Array<Msg>		m_list;
		OutputMsgParam() : m_show(Remain) , m_type(Normal) , m_cmd(Set){}
	};
	class OutputXmlParam
	{
	public:
		XERCES_CPP_NAMESPACE::DOMDocument*		m_doc;
		OutputXmlParam() : m_doc(0){}
	};
	enum Type
	{
		NewTreeItem , 
		DeleteTreeItem , 
		ModifyTreeItem , 
		MoveTreeItem , 
		SetStartParser , 
		AddNode , 
		MoveItems , 
		AddLink , 
		ReconnectLink , 
		ResizeLinkbar , 
		RemoveParserItem , 
		SetPropertyItem , 
		ModifyItemProperty , 
		PasteItems , 
		OutputMsg , 
		OutputXml , 
		Save , 
		Load , 
		New , 
		Undo , 
		Redo , 		
	};
public:
//=================================================================================================
//!	callback
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Callback
		(
		Type	type , 
		object&	obj , 
		void*	param
		) = 0;
};
/**************************************************************************************************
 "IDocument" interface 
***************************************************************************************************/
cb_guid_define( IDocument_IID , 0xD548B070 , 0xEBD94a05 , 0xA227C4F0 , 0x15B9BCD1 );
class IDocument;
typedef icubic::iface_object< IDocument , IDocument_IID >		iDocument;
typedef icubic::iface_reference< IDocument , IDocument_IID >	rDocument;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IDocument
{
public:
	class Property
	{
	public:
		wstring		m_document_tag;
		wstring		m_encode;
		wstring		m_doctype_name;
		wstring		m_doctype_public;
		wstring		m_doctype_system;
		
		Property()
		{
			m_document_tag		= L"root";
		}
		void Reset()
		{
			m_encode			= L"";
			m_doctype_name		= L"";
			m_doctype_public	= L"";
			m_doctype_system	= L"";
			m_document_tag		= L"root";
		}
	};
public:
//=================================================================================================
virtual
Property cb_call GetProperty() = 0;
//=================================================================================================
virtual
void cb_call SetProperty
		(
		Property&	prop
		) = 0;
//=================================================================================================
virtual
void cb_call Reset() = 0;
//=================================================================================================
virtual
void cb_call AddCallback
		(
		rCallback&	callback
		) = 0;
//=================================================================================================
virtual
void cb_call RemoveCallback
		(
		rCallback&	callback
		) = 0;
//=================================================================================================
virtual
void cb_call Callback
		(
		ICallback::Type	type , 
		object&			obj , 
		void*			param
		) = 0;
//=================================================================================================
virtual
treedata::iTreeNode cb_call GetRoot() = 0;
//=================================================================================================
virtual
treedata::iTreeNode cb_call SearchTreeId
		(
		unsigned int		id
		) = 0;
//=================================================================================================
virtual
iParserItem cb_call SearchParserItemId
		(
		unsigned int		parse_id , 
		unsigned int		item_id
		) = 0;
//=================================================================================================
virtual
iParserDoc cb_call GetStartParser() = 0;
//=================================================================================================
virtual
void cb_call SetStartParser
		(
		iParserDoc		doc , 
		IUndoList*		undo
		) = 0;
//=================================================================================================
virtual
IUndoList* Recode() = 0;
//=================================================================================================
virtual
bool cb_call IsUndo() = 0;
//=================================================================================================
virtual
bool cb_call IsRedo() = 0;
//=================================================================================================
virtual
bool cb_call Undo() = 0;
//=================================================================================================
virtual
bool cb_call Redo() = 0;
//=================================================================================================
virtual
bool cb_call IsModify() = 0;
//=================================================================================================
virtual
wstring cb_call GetFilepath() = 0;
//=================================================================================================
virtual
bool cb_call Save
		(
		const wstring&	path , 
		IStreamWrite*	file
		) = 0;
//=================================================================================================
virtual
bool cb_call Load
		(
		const wstring&	path , 
		IStreamRead*	file
		) = 0;
};
/**************************************************************************************************
 "IItem" interface 
***************************************************************************************************/
cb_guid_define( IItem_IID , 0xF00B5542 , 0x6AA84eba , 0x8F3F0752 , 0xD43E0EA9 );
class IItem;
typedef icubic::iface_object< IItem , IItem_IID >		iItem;
typedef icubic::iface_reference< IItem , IItem_IID >	rItem;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IItem
{
public:
	enum ItemType
	{
		Folder , 
		Parser , 
	};
	const ItemType		m_type;
	const unsigned int	m_item_id;
	bool				m_expand;
	IItem
		(
		ItemType	type
		) : 
		m_type( type ) , 
		m_item_id( (const unsigned int)&m_item_id ) , 
		m_expand( false ){}
};
/**************************************************************************************************
"ParserItem" class 
**************************************************************************************************/
class ParserItem : 
	public TreeNode , 
	public ParserDoc , 
	public IItem
{
	query_begin();
	iface_hook( IItem , IItem_IID );
	super_hook( TreeNode );
	super_hook( ParserDoc );
	query_null_end();
	
// public functions
public:
//=================================================================================================
ParserItem() : IItem( IItem::Parser )
{
}
};
/**************************************************************************************************
 "IFolerItem" interface 
***************************************************************************************************/
cb_guid_define( IFolderItem_IID , 0x34312605 , 0x6E764c92 , 0x98589626 , 0x8EDEAD19 );
class IFolderItem;
typedef icubic::iface_object< IFolderItem , IFolderItem_IID >		iFolderItem;
typedef icubic::iface_reference< IFolderItem , IFolderItem_IID >	rFolderItem;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IFolderItem
{
public:
//=================================================================================================
virtual
wstring cb_call GetName() = 0;
//=================================================================================================
virtual
void cb_call SetName
		(
		const wstring&	name , 
		IUndoList*		undo
		) = 0;
//=================================================================================================
virtual
bool cb_call Save
		(
		IStreamWrite*	file
		) = 0;
//=================================================================================================
virtual
bool cb_call Load
		(
		IStreamRead*	file
		) = 0;
};
/**************************************************************************************************
"FolderItem" class 
**************************************************************************************************/
class FolderItem : 
	public TreeNode , 
	public IItem , 
	public IFolderItem
{
	query_begin();
	iface_hook( IItem , IItem_IID )
	iface_hook( IFolderItem , IFolderItem_IID )
	query_end( TreeNode );

	//=============================================================================================
	class SetName_cmd : public UndoCmd
	{
	public:
		iFolderItem		m_this;
		wstring			m_name;
		void cb_call Execute()
		{
			m_this->SetName( m_name , 0 );
		}
	};
	
// variable member
private:
	wstring		m_name;
	
// "IFolderItem" interface functions
public:
//=================================================================================================
wstring cb_call GetName()
{
	return m_name;
}
//=================================================================================================
void cb_call SetName
		(
		const wstring&	name , 
		IUndoList*		undo
		)
{
	if( undo != 0 )
	{
		{
			instance<SetName_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_name	= name;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<SetName_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_name	= m_name;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	m_name	= name;
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	file
		)
{
	// ver
	{
		long	ver = 1;
		if( false == file->Write( &ver , sizeof( ver ) , 1 , Little_EndianType ) )
			return false;
	}	
	// name
	{
		if( false == SaveString( file , m_name ) )
			return false;
	}
	// tree
	{
		long	off , num = GetChildnum();
		if( false == file->Write( &num , sizeof(num) , 1 , Little_EndianType ) )
			return false;
		for( off = 0 ; off < num ; off++ )
		{
			iItem	child	= GetChild( off );

			// type
			if( false == file->Write( &child->m_type , sizeof( child->m_type ) , 1 , Little_EndianType ) )
				return false;
			if( child->m_type == Folder )
			{
				if( false == ((iFolderItem)child)->Save( file ) )
					return false;
			}
			else if( child->m_type == Parser )
			{
				if( false == ((iParserDoc)child)->Save( file ) )
					return false;
			}
		}
	}
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	file
		)
{
	// ver
	{
		long	ver;
		if( 1 != file->Read( &ver , sizeof( ver ) , 1 , Little_EndianType ) )
			return false;
		if( ver != 1 )
			return false;
	}	
	// name
	{
		if( false == LoadString( file , &m_name ) )
			return false;
	}
	// tree
	{
		long	off , num;
		if( 1 != file->Read( &num , sizeof(num) , 1 , Little_EndianType ) )
			return false;
		for( off = 0 ; off < num ; off++ )
		{
			// type
			IItem::ItemType	type;
			if( 1 != file->Read( &type , sizeof( type ) , 1 , Little_EndianType ) )
				return false;
			if( type == IItem::Folder )
			{
				instance<FolderItem>	item;
				if( false == item->Load( file ) )
					return false;
				if( false == AddChild( (treedata::iTreeNode)item , off , 0 ) )
					return false;
			}
			else if( type == IItem::Parser )
			{
				instance<ParserItem>	item;
				if( false == item->Load( file ) )
					return false;
				if( false == AddChild( (treedata::iTreeNode)item , off , 0 ) )
					return false;
			}
			else
				return false;
		}
	}
	return true;
}
// public functions
public:
//=================================================================================================
FolderItem() : IItem( IItem::Folder )
{
}
};
/**************************************************************************************************
"Document" class 
**************************************************************************************************/
class Document : 
	virtual public object_base , 
	public IDocument
{
	query_begin();
	iface_hook( IDocument , IDocument_IID )
	query_end( object_base );
	
// variable member
private:
	iFolderItem				m_root;
	Undo_bs					m_undo;
	Array<rCallback>		m_callback;
	wstring					m_filepath;
	bool					m_modify;
	Property			m_property;
	
// private functions
private:
//=================================================================================================
void UpdateCallback()
{
	int		off;
	for( off = 0 ; off < m_callback.GetDatanum() ; off++ )
	{
		iCallback	cb = m_callback[off].lock();
		if( cb == false )
		{
			m_callback.Delete( off );
			off--;
		}
	}
}
//=================================================================================================
treedata::iTreeNode cb_call SearchItemId
		(
		treedata::iTreeNode&	item , 
		unsigned int			id
		)
{
	if( ( (iItem)item )->m_item_id == id )
		return item;
	int	c_off , c_num = item->GetChildnum();
	for( c_off = 0 ; c_off < c_num ; c_off++ )
	{
		treedata::iTreeNode	child = SearchItemId( item->GetChild( c_off ) , id );
		if( child == true )
			return child;
	}
	return treedata::iTreeNode();
}
//=================================================================================================
iParserDoc cb_call GetStartParser
		(
		treedata::iTreeNode&	item
		)
{
	if( item  == false )
		return iParserDoc();
	iParserDoc	doc = (iParserDoc)item;
	if( doc == true && doc->GetStart() == true )
		return doc;

	int		off , num = item->GetChildnum();
	for( off = 0 ; off < num ; off++ )
	{
		iParserDoc	t = GetStartParser( item->GetChild( off ) );
		if( t == true )
			return t;
	}
	return iParserDoc();
}

// "IDocument" interface functions
public:
//=================================================================================================
Property cb_call GetProperty()
{
	return m_property;
}
//=================================================================================================
void cb_call SetProperty
		(
		Property&	prop
		)
{
	m_modify	= true;
	m_property	= prop;
}
//=================================================================================================
void cb_call Reset()
{
	m_property.Reset();
	m_undo.Reset();
	m_root.release();
	m_root		= (iFolderItem)instance<FolderItem>();
	m_filepath	= L"";
	m_modify	= false;
}
//=================================================================================================
void cb_call AddCallback
		(
		rCallback&	callback
		)
{
	UpdateCallback();
	m_callback[ m_callback.Add() ] = callback;
}
//=================================================================================================
void cb_call RemoveCallback
		(
		rCallback&	callback
		)
{
	UpdateCallback();

	object	cb = (object)callback.lock();
	if( cb == false )
		return;
	int		off;
	for( off = 0 ; off < m_callback.GetDatanum() ; off++ )
	{
		object	tcb = (object)m_callback[off].lock();
		if( tcb == cb )
		{
			m_callback.Delete( off );
			off--;
		}
	}
}
//=================================================================================================
void cb_call Callback
		(
		ICallback::Type		type , 
		object&				obj , 
		void*				param
		)
{
	UpdateCallback();
	int		off;
	for( off = 0 ; off < m_callback.GetDatanum() ; off++ )
	{
		iCallback	cb = m_callback[off].lock();
		if( cb == true )
			cb->Callback( type , obj , param );
	}
}
//=================================================================================================
treedata::iTreeNode cb_call GetRoot()
{
	return (treedata::iTreeNode)m_root;
}
//=================================================================================================
treedata::iTreeNode cb_call SearchTreeId
		(
		unsigned int		id
		)
{
	return SearchItemId( GetRoot() , id );
}
//=================================================================================================
iParserItem cb_call SearchParserItemId
		(
		unsigned int		parse_id , 
		unsigned int		item_id
		)
{
	iParserDoc	doc = (iParserDoc)SearchTreeId( parse_id );
	if( doc == false )
		return iParserItem();
	return doc->SearchParserItemId( item_id );
}
//=================================================================================================
iParserDoc cb_call GetStartParser()
{
	return GetStartParser( (treedata::iTreeNode)m_root );
}
//=================================================================================================
void cb_call SetStartParser
		(
		iParserDoc		doc , 
		IUndoList*		undo
		)
{
	iParserDoc	src	= GetStartParser();
	if( src == doc )
		return;
	
	if( src == true )
		src->SetStart( false , undo );
	if( doc == true )
		doc->SetStart( true , undo );
}
//=================================================================================================
IUndoList* Recode()
{
	m_modify	= true;
	return m_undo.Recode();
}
//=================================================================================================
bool cb_call IsUndo()
{
	return m_undo.IsUndo();
}
//=================================================================================================
bool cb_call IsRedo()
{
	return m_undo.IsRedo();
}
//=================================================================================================
bool cb_call Undo()
{
	return m_undo.Undo();
}
//=================================================================================================
bool cb_call Redo()
{
	return m_undo.Redo();
}
//=================================================================================================
bool cb_call IsModify()
{
	return m_modify;
}
//=================================================================================================
wstring cb_call GetFilepath()
{
	return m_filepath;
}
//=================================================================================================
bool cb_call Save
		(
		const wstring&	path , 
		IStreamWrite*	file
		)
{
	// sign
	const char*	sign = "texml";
	if( false == file->Write( sign , sizeof(char) , strlen( sign ) , Little_EndianType ) )
		return false;
	
	// version
	long		ver = 1;
	if( false == file->Write( &ver , sizeof(ver) , 1 , Little_EndianType) )
		return false;

	// property
	if( false == SaveString( file , m_property.m_document_tag ) )
		return false;
	if( false == SaveString( file , m_property.m_encode ) )
		return false;
	if( false == SaveString( file , m_property.m_doctype_name ) )
		return false;
	if( false == SaveString( file , m_property.m_doctype_public ) )
		return false;
	if( false == SaveString( file , m_property.m_doctype_system ) )
		return false;

	// save
	if( false == m_root->Save( file ) )
		return false;
	
	m_modify	= false;
	m_filepath	= path;
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		const wstring&	path , 
		IStreamRead*	file
		)
{
	// sign
	char sign[6];
	if( 5 != file->Read( sign , sizeof(char) , 5 , Little_EndianType ) )
		return false;
	sign[5]	= '\0';
	if( 0 != strcmp( sign , "texml" ) )
		return false;
		
	// version
	long		ver = 1;
	if( 1 != file->Read( &ver , sizeof(ver) , 1 , Little_EndianType) )
		return false;
	if( ver != 1 )
		return false;

	// property
	Property	prop;
	if( false == LoadString( file , &prop.m_document_tag ) )
		return false;
	if( false == LoadString( file , &prop.m_encode ) )
		return false;
	if( false == LoadString( file , &prop.m_doctype_name ) )
		return false;
	if( false == LoadString( file , &prop.m_doctype_public ) )
		return false;
	if( false == LoadString( file , &prop.m_doctype_system ) )
		return false;

	// load
	instance<FolderItem>	root;
	if( false == root->Load( file ) )
		return false;

	// setting
	m_property	= prop;
	m_root		= root;
	m_undo.Reset();	
	m_modify	= false;
	m_filepath	= path;
	return true;
}
// public functions
public:
//=================================================================================================
Document() : m_modify( false )
{
	m_root	= (iFolderItem)instance<FolderItem>();
}
};
/**************************************************************************************************
"CallbackListener" class 
**************************************************************************************************/
class CallbackListener : 
	virtual public object_base , 
	public ICallback
{
	query_begin();
	iface_hook( ICallback , ICallback_IID )
	query_end( object_base );
	
// variable member
private:
	ICallback*	m_ptr;

// "ICallback" interface functions
public:
//=================================================================================================
void cb_call Callback
		(
		Type	type , 
		object&	obj , 
		void*	param
		)
{
	if( m_ptr == 0 )
		return;
	m_ptr->Callback( type , obj , param );
}
// public functions
public:
//=================================================================================================
CallbackListener() : m_ptr( 0 )
{
}
//=================================================================================================
void SetCallback
		(
		ICallback*	ptr
		)
{
	m_ptr	= ptr;
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
cb_inline
iDocument GetDocument()
{
	static
	instance<Document>	m_doc;
	return (iDocument)m_doc;
}
//=================================================================================================
cb_inline
CString LoadText
		(
		int		resid
		)
{
	CString	str;
	cb_verify( TRUE == str.LoadString( resid ) );
	return str;
}
//=================================================================================================
cb_inline
UINT GetClipboardFormatParser()
{
	static
	UINT	id = 0;
	if( id == 0 )
		id = RegisterClipboardFormatW( L"Texml-parser" );
	return id;
}
//=================================================================================================
cb_inline
UINT GetClipboardFormatFolder()
{
	static
	UINT	id = 0;
	if( id == 0 )
		id = RegisterClipboardFormatW( L"Texml-folder" );
	return id;
}
//=================================================================================================
cb_inline
bool CopyClipboard
		(
		CWnd*		wnd , 
		UINT		id , 
		const void*	pdata , 
		int			size
		)
{
	// open clipboad
	if( 0 == wnd->OpenClipboard() )
		return false;
	if( 0 == EmptyClipboard() )
	{
		CloseClipboard();
	    return false;
	}
	// copy
	HGLOBAL	hmem	= ::GlobalAlloc( GHND | GMEM_DDESHARE , size );
	{
		if( hmem == NULL )
		{
			CloseClipboard();
			return false;
		}
		void*	dest	= ::GlobalLock( hmem );
		if( dest == NULL )
		{
			CloseClipboard();
			return false;
		}
		MemoryCopy( dest , pdata , size );
	}	
	::GlobalUnlock( hmem );

	// set clipboad
    if( NULL == SetClipboardData( id , hmem ) )
    {
		CloseClipboard();
	    return false;
    }

	// don't execute GlobalFree!!
	// close
	CloseClipboard();
    return true;
}
//=================================================================================================
cb_inline
bool CheckClipboardId
		(
		CWnd*		wnd , 
		UINT		id
		)
{
	if( 0 == wnd->OpenClipboard() )
		return false;
	if( NULL == GetClipboardData( id ) )
	{
	    CloseClipboard();
	    return false;
	}
	CloseClipboard();
	return true;
}
/**************************************************************************************************
"ClipboadPaste" class 
**************************************************************************************************/
class PasteClipboad
{
// variable member
private:
	HGLOBAL		m_hmem;
	
// private functions
private:
// public functions
public:
//=================================================================================================
PasteClipboad() : m_hmem( NULL )
{
}
//=================================================================================================
~PasteClipboad()
{
	Close();
}
//=================================================================================================
const void* Open
		(
		CWnd*		wnd , 
		UINT		id , 
		int*		size
		)
{
	if( 0 == wnd->OpenClipboard() )
		return 0;
	HGLOBAL	hmem = GetClipboardData( id );
	if( hmem == NULL )
	{
		CloseClipboard();
		return 0;
	}
	const void*	p = GlobalLock( hmem );
	if( p == 0 )
	{
		CloseClipboard();
		return 0;
	}
	store( size , (int)GlobalSize( hmem ) );
	m_hmem	= hmem;
	return p;
}
//=================================================================================================
void Close()
{
	if( m_hmem == NULL )
		return;
	GlobalUnlock( m_hmem );
    CloseClipboard();
    m_hmem	= NULL;
}
};


};

#pragma pack( pop )			//release align
