/*************************************************************************************************/
/*!
   	@file		ObjectAry.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IObjectAry" interface 
***************************************************************************************************/
cb_guid_define( IObjectAry_IID , 0x3A73DF24 , 0xD8A1444d , 0xA28B2EF4 , 0x98EFAD44 );
class IObjectAry;
typedef icubic::iface_object< IObjectAry , IObjectAry_IID >		iObjectAry;
typedef icubic::iface_reference< IObjectAry , IObjectAry_IID >	rObjectAry;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IObjectAry
{
public:
//=================================================================================================
virtual
int cb_call GetDatanum()const = 0;
//=================================================================================================
virtual
object cb_call Get
		(
		int		pos
		) = 0;
//=================================================================================================
virtual
void cb_call Set
		(
		int			pos , 
		object&		obj
		) = 0;
//=================================================================================================
virtual
int cb_call Add
		(
		object&		obj
		) = 0;
//=================================================================================================
virtual
int cb_call Add() = 0;
//=================================================================================================
virtual
void cb_call Add
		(
		object		*pdata ,
		int32		num
		) = 0;
//=================================================================================================
virtual
int cb_call Insert
		(
		int				insert_pos ,
		const object	&data
		) = 0;
//=================================================================================================
virtual
int cb_call Insert
		(
		int			insert_pos
		) = 0;
//=================================================================================================
virtual
void cb_call Delete
		(
		int		pos
		) = 0;
//=================================================================================================
virtual
void cb_call Delete
		(
		int		pos , 
		int		num
		) = 0;
};
/**************************************************************************************************
"ObjectAry" class 
**************************************************************************************************/
class ObjectAry : 
	virtual public object_base , 
	public IObjectAry , 
	public Array<object>
{
	query_begin();
	iface_hook( IObjectAry , IObjectAry_IID )
	query_end( object_base );
	
// variable member
private:

// private functions
private:

// "IObjectAry" interface functions
public:
//=================================================================================================
int cb_call GetDatanum()const 
{
	return Array::GetDatanum();
}
//=================================================================================================
object cb_call Get
		(
		int		pos
		)
{
	return (*((Array*)this))[ pos ];
}
//=================================================================================================
void cb_call Set
		(
		int			pos , 
		object&		obj
		)
{
	(*((Array*)this))[ pos ]	= obj;
}
//=================================================================================================
int cb_call Add
		(
		object&		obj
		)
{
	return Array::Add( obj );
}
//=================================================================================================
int cb_call Add()
{
	return Array::Add();
}
//=================================================================================================
void cb_call Add
		(
		object		*pdata ,
		int32		num
		)
{
	Array::Add( pdata , num );
}
//=================================================================================================
int cb_call Insert
		(
		int				insert_pos ,
		const object	&data
		)
{
	return Array::Insert( insert_pos , data );
}
//=================================================================================================
int cb_call Insert
		(
		int			insert_pos
		)
{
	return Array::Insert( insert_pos );
}
//=================================================================================================
void cb_call Delete
		(
		int		pos
		)
{
	Array::Delete( pos );
}
//=================================================================================================
void cb_call Delete
		(
		int		pos , 
		int		num
		)
{
	Array::Delete( pos , num );
}
// public functions
public:
//=================================================================================================
ObjectAry()
{
}
//=================================================================================================
ObjectAry
		(
		int		num
		) : Array( num )
{
}
//=================================================================================================
ObjectAry
		(
		ArrayCashType	type , 
		int				extranum
		) : Array( type , extranum )
{
}
//=================================================================================================
ObjectAry
		(
		ArrayCashType	type , 
		int				extranum , 
		int				num
		) : Array( type , extranum , num )
{
}
//=================================================================================================
~ObjectAry()
{
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
