/*************************************************************************************************/
/*!
   	@file		Treedata.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace treedata
{
using namespace icubic;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "ITreeNode" interface 
***************************************************************************************************/
cb_guid_define( ITreeNode_IID , 0x4666045C , 0x25824a5b , 0xABF3FF2B , 0xC0E84AA8 );
class ITreeNode;
typedef icubic::iface_object< ITreeNode , ITreeNode_IID >		iTreeNode;
typedef icubic::iface_reference< ITreeNode , ITreeNode_IID >	rTreeNode;
//-------------------------------------------------------------------------------------------------
class ITreeNode
{
public:
//=================================================================================================
virtual
iTreeNode cb_call GetParent() = 0;
//=================================================================================================
virtual
int cb_call GetChildnum() = 0;
//=================================================================================================
virtual
iTreeNode cb_call GetChild
		(
		int		off
		) = 0;
//=================================================================================================
virtual
int cb_call SearchChild
		(
		iTreeNode&	item
		) = 0;
//=================================================================================================
virtual
bool cb_call SearchItem
		(
		iTreeNode&	item
		) = 0;
//=================================================================================================
virtual
bool cb_call AddChild
		(
		iTreeNode&	item , 
		int			insertpos, 
		IUndoList*	undo
		) = 0;
//=================================================================================================
virtual
void cb_call Remove
		(
		IUndoList*	undo
		) = 0;
};

/**************************************************************************************************
"TreeNode" class 
**************************************************************************************************/
cb_guid_define( TreeNode_IID , 0x7BC3D635 , 0xE09341a4 , 0xB358D587 , 0x29F87A51 );
class TreeNode;
typedef icubic::iface_object< TreeNode , TreeNode_IID >		iCTreeNode;
typedef icubic::iface_reference< TreeNode , TreeNode_IID >	rCTreeNode;
//-------------------------------------------------------------------------------------------------
class TreeNode : 
	virtual public object_base , 
	public ITreeNode
{
	query_begin();
	iface_hook( ITreeNode , ITreeNode_IID )
	iface_hook( TreeNode , TreeNode_IID )
	query_end( object_base );
	
	//=============================================================================================
	class SetParent_cmd : public UndoCmd
	{
	public:
		iCTreeNode		m_this;
		iCTreeNode		parent;
		void cb_call Execute()
		{
			m_this->SetParent( parent , 0 );
		}
	};
	//=============================================================================================
	class AddChildList_cmd : public UndoCmd
	{
	public:
		iCTreeNode		m_this;
		iCTreeNode		item;
		int				insertpos;
		void cb_call Execute()
		{
			m_this->AddChildList( item , insertpos , 0 );
		}
	};
	//=============================================================================================
	class RemoveChildList_cmd : public UndoCmd
	{
	public:
		iCTreeNode		m_this;
		iCTreeNode		item;
		void cb_call Execute()
		{
			m_this->RemoveChildList( item , 0 );
		}
	};

// variable member
private:
	rCTreeNode					m_parent;
	Straightdata<iCTreeNode>	m_children;
	
// private functions
private:

// "ITreeNode" interface functions
public:
//=================================================================================================
iTreeNode cb_call GetParent()
{
	return m_parent.lock();
}
//=================================================================================================
int cb_call GetChildnum()
{
	return m_children.GetDatanum();
}
//=================================================================================================
iTreeNode cb_call GetChild
		(
		int		off
		)
{
	cb_assert( 0 <= off && off < m_children.GetDatanum() , L"invalid parameter." );
	return m_children[ off ];
}
//=================================================================================================
int cb_call SearchChild
		(
		iTreeNode&	item
		)
{
	int		off , num = m_children.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( m_children[off] == (iCTreeNode)item )
			return off;
	}
	return -1;
}
//=================================================================================================
bool cb_call SearchItem
		(
		iTreeNode&	item
		)
{
	int		off , num = m_children.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( m_children[off] == item )
			return true;
		if( true == m_children[off]->SearchItem( item ) )
			return true;
	}
	return false;
}
//=================================================================================================
bool cb_call AddChild
		(
		iTreeNode&	item , 
		int			insertpos, 
		IUndoList*	undo
		)
{
	iCTreeNode	n = (iCTreeNode)item;
	if( n == false )
		return false;
	if( this_object() == item )
		return false;
	if( true == item->SearchItem( (iTreeNode)this_object() ) )
		return false;
	
	// exe
	insertpos	= insertpos < 0 ? 0 : ( insertpos > m_children.GetDatanum() ? m_children.GetDatanum() : insertpos );
	iTreeNode	parent = item->GetParent();
	if( (object)parent == this_object() )
	{
		int	pos = SearchChild( item );
		cb_assert( pos >= 0 , L"algorithm error." );
		if( pos < insertpos )
			insertpos--;
	}
	item->Remove( undo );
	n->SetParent( (iCTreeNode)this_object() , undo );
	AddChildList( n , insertpos , undo );
	return true;
}
//=================================================================================================
void cb_call Remove
		(
		IUndoList*	undo
		)
{
	iCTreeNode	parent	= m_parent.lock();
	if( parent == false )
		return;
	parent->RemoveChildList( (iCTreeNode)this_object() , undo );
	SetParent( iCTreeNode() , undo );
}
// public functions
public:
//=================================================================================================
TreeNode()
{
}
//=================================================================================================
void SetParent
		(
		iCTreeNode&		parent , 
		IUndoList*		undo
		)
{
	// undo
	if( undo != 0 )
	{
		{
			instance<SetParent_cmd>	cmd;
			cmd->m_this	= this_object();
			cmd->parent	= parent;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<SetParent_cmd>	cmd;
			cmd->m_this	= this_object();
			cmd->parent	= m_parent.lock();
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe
	m_parent	= parent;
}
//=================================================================================================
void AddChildList
		(
		iCTreeNode&		item , 
		int				insertpos , 
		IUndoList*		undo
		)
{
	// undo
	if( undo != 0 )
	{
		{
			instance<AddChildList_cmd>	cmd;
			cmd->m_this		= this_object();
			cmd->item		= item;
			cmd->insertpos	= insertpos;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<RemoveChildList_cmd>	cmd;
			cmd->m_this	= this_object();
			cmd->item	= item;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe
	m_children[ m_children.Insert( insertpos ) ]	= item;
}
//=================================================================================================
void RemoveChildList
		(
		iCTreeNode&		item , 
		IUndoList*		undo
		)
{
	int		off = SearchChild( (iTreeNode)item );
	if( off == -1 )
		return;
	// undo
	if( undo != 0 )
	{
		{
			instance<RemoveChildList_cmd>	cmd;
			cmd->m_this	= this_object();
			cmd->item	= item;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<AddChildList_cmd>	cmd;
			cmd->m_this		= this_object();
			cmd->item		= item;
			cmd->insertpos	= off;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe
	m_children.Delete( off );
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
