// DocumentPage.cpp : t@C
//

#include "stdafx.h"
#include "Texml.h"
#include "DocumentPage.h"
#include "EditDoctypeAttrDlg.h"

/**************************************************************************************************
"CDocumentPage" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event map
IMPLEMENT_DYNAMIC(CDocumentPage, CPropertyPage)
BEGIN_MESSAGE_MAP(CDocumentPage, CPropertyPage)
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CDocumentPage::CDocumentPage() : 
		CPropertyPage(CDocumentPage::IDD)
{

}
//=================================================================================================
CDocumentPage::~CDocumentPage()
{
}
//=================================================================================================
void CDocumentPage::SetData
		(
		IDocument::Property&	prop
		)
{
	m_encode			= prop.m_encode.c_str();
	m_document_tag		= prop.m_document_tag.c_str();
	m_doctype_name		= prop.m_doctype_name.c_str();
	m_doctype_public	= prop.m_doctype_public.c_str();
	m_doctype_system	= prop.m_doctype_system.c_str();
}
//=================================================================================================
IDocument::Property CDocumentPage::GetData()
{
	IDocument::Property	prop;
	prop.m_encode			= m_encode;
	prop.m_document_tag		= m_document_tag;
	prop.m_doctype_name		= m_doctype_name;
	prop.m_doctype_public	= m_doctype_public;
	prop.m_doctype_system	= m_doctype_system;
	return prop;
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC override
//=================================================================================================
void CDocumentPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	
	DDX_CBString( pDX , IDC_COMBO_ENCODE , m_encode );
	DDX_Text( pDX , IDC_EDIT_DOCUMENTTAG , m_document_tag );
	DDX_Text( pDX , IDC_EDIT_DOCTYPENAME , m_doctype_name );
	DDX_Text( pDX , IDC_EDIT_DOCTYPEPUBLIC , m_doctype_public );
	DDX_Text( pDX , IDC_EDIT_DOCTYPESYSTEM , m_doctype_system );
}
//=================================================================================================
BOOL CDocumentPage::OnInitDialog()
{
	{
		CComboBox*	ctrl = (CComboBox*)GetDlgItem(IDC_COMBO_EDITORENCODE);
		ctrl->AddString( L"SHIFT_JIS" );
		ctrl->AddString( L"UTF-8" );
		ctrl->AddString( L"UTF-16" );
	}
	CPropertyPage::OnInitDialog();
	return TRUE;
}
//=================================================================================================
void CDocumentPage::OnOK()
{
	UpdateData();
	CPropertyPage::OnOK();
}
//=================================================================================================
BOOL CDocumentPage::OnKillActive()
{
	UpdateData();
	if( m_document_tag.IsEmpty() == TRUE )
	{
		MessageBox( LoadText( IDS_MSG_10 ) , LoadText( IDS_APPTITLE ) , MB_ICONERROR | MB_OK );
		return FALSE;
	}
	return CPropertyPage::OnKillActive();
}
