#pragma once

#include	"Document/Document.h"

using namespace icubic;
using namespace document;

/**************************************************************************************************
"CLinkPropertyWnd" class define
**************************************************************************************************/
class CLinkPropertyWnd : public CMFCPropertyGridCtrl , public ICallback
{
	DECLARE_DYNAMIC(CLinkPropertyWnd)

	enum PropId
	{
		Group1 , 
		Group2 ,
		XPos , 
		YPos , 
		Priority , 
		KnotType , 
		BarWidth , 
		Align , 
		CmdType , 
		Regular_exp , 
		Regular_seqtype , 
		Function_name , 
		PropNum
	};
// member variable
private:
	iDocument					m_document;
	instance<CallbackListener>	m_listener;
	
	unsigned int				m_parser_id;
	unsigned int				m_item_id;

	CMFCPropertyGridProperty*	m_props[PropNum];
	Array<CString>				m_linktype_list;
	Array<CString>				m_knottype_list;
	Array<CString>				m_align_list;
	Array<CString>				m_seqtype_list;
	CFont						m_fntPropList;

// private functions
private:
//=================================================================================================
void cb_call Callback
		(
		ICallback::Type	type , 
		object&			obj , 
		void*			param
		);
//=================================================================================================
iParserDoc CLinkPropertyWnd::GetParser();
//=================================================================================================
iParserLink CLinkPropertyWnd::GetLink();
//=================================================================================================
void CLinkPropertyWnd::InitProperty();
//=================================================================================================
int CLinkPropertyWnd::GetPriority
		(
		iParserLink&	link , 
		int*			num
		);
//=================================================================================================
void CLinkPropertyWnd::UpdateProperty();
//=================================================================================================
void CLinkPropertyWnd::UpdatePropertyShow();
//=================================================================================================
void CLinkPropertyWnd::SetPropListFont();
//=================================================================================================
void CLinkPropertyWnd::PropertyChanged
		(
		CMFCPropertyGridProperty* pProp 
		);

// public functions
public:
	CLinkPropertyWnd();
	virtual ~CLinkPropertyWnd();

// MFC override functions
protected:
//=================================================================================================
void CLinkPropertyWnd::OnPropertyChanged
		(
		CMFCPropertyGridProperty* pProp 
		)const;

// MFC event handler
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSettingChange(UINT uFlags, LPCTSTR lpszSection);
	afx_msg void OnDestroy();
};


