
// MainFrm.cpp : CMainFrame NX̎
//

#include	"stdafx.h"
#include	"Texml.h"

#include	"MainFrm.h"
#include	"ParseEditFrm.h"
#include	"SettingDlg.h"
#include	"ProjectDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace XERCES_CPP_NAMESPACE;

/**************************************************************************************************
"CMainFrame" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC message map

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWndEx)

const int  iMaxUserToolbars		= 10;
const UINT uiFirstUserToolBarId = AFX_IDW_CONTROLBAR_FIRST + 40;
const UINT uiLastUserToolBarId	= uiFirstUserToolBarId + iMaxUserToolbars - 1;

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWndEx)
	ON_WM_DROPFILES()
	ON_WM_CREATE()
	ON_COMMAND(ID_WINDOW_MANAGER, &CMainFrame::OnWindowManager)
	ON_COMMAND(ID_VIEW_CUSTOMIZE, &CMainFrame::OnViewCustomize)
	ON_REGISTERED_MESSAGE(AFX_WM_CREATETOOLBAR, &CMainFrame::OnToolbarCreateNew)
	ON_REGISTERED_MESSAGE(AFX_WM_RESETTOOLBAR, OnToolbarReset)

	ON_COMMAND_RANGE(ID_VIEW_APPLOOK_WIN_2000, ID_VIEW_APPLOOK_OFF_2007_AQUA, &CMainFrame::OnApplicationLook)
	ON_UPDATE_COMMAND_UI_RANGE(ID_VIEW_APPLOOK_WIN_2000, ID_VIEW_APPLOOK_OFF_2007_AQUA, &CMainFrame::OnUpdateApplicationLook)
	ON_COMMAND(ID_EDIT_REDO, &CMainFrame::OnEditRedo)
	ON_UPDATE_COMMAND_UI(ID_EDIT_REDO, &CMainFrame::OnUpdateEditRedo)
	ON_COMMAND(ID_EDIT_UNDO, &CMainFrame::OnEditUndo)
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDO, &CMainFrame::OnUpdateEditUndo)
	ON_WM_DESTROY()
	ON_COMMAND(ID_FILE_NEW, &CMainFrame::OnFileNew)

	ON_COMMAND(ID_FILE_OPEN, &CMainFrame::OnFileOpen)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, &CMainFrame::OnUpdateFileOpen)
	ON_COMMAND(ID_FILE_SAVE, &CMainFrame::OnFileSave)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, &CMainFrame::OnUpdateFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS, &CMainFrame::OnFileSaveAs)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, &CMainFrame::OnUpdateFileSaveAs)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEW, &CMainFrame::OnUpdateFileNew)
	ON_WM_CLOSE()
	ON_COMMAND(ID_EDIT_EXECUTE, &CMainFrame::OnEditExecute)
	ON_UPDATE_COMMAND_UI(ID_EDIT_EXECUTE, &CMainFrame::OnUpdateEditExecute)
	ON_COMMAND(ID_EDIT_TESTCODE, &CMainFrame::OnEditTestcode)
	ON_UPDATE_COMMAND_UI(ID_EDIT_TESTCODE, &CMainFrame::OnUpdateEditTestcode)
	ON_COMMAND(ID_EDIT_SETTING, &CMainFrame::OnEditSetting)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SETTING, &CMainFrame::OnUpdateEditSetting)
	ON_COMMAND(ID_EDIT_OUTPUTTXP, &CMainFrame::OnEditOutputtxp)
	ON_UPDATE_COMMAND_UI(ID_EDIT_OUTPUTTXP, &CMainFrame::OnUpdateEditOutputtxp)
	ON_COMMAND(ID_EDIT_PROJECT, &CMainFrame::OnEditProject)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PROJECT, &CMainFrame::OnUpdateEditProject)
	ON_COMMAND(ID_EDIT_HELP, &CMainFrame::OnEditHelp)
	ON_UPDATE_COMMAND_UI(ID_EDIT_HELP, &CMainFrame::OnUpdateEditHelp)
END_MESSAGE_MAP()

static 
UINT indicators[] =
{
	ID_SEPARATOR,           // Xe[^X C CWP[^
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call CMainFrame::Callback
		(
		ICallback::Type	type , 
		object&	obj , 
		void*	param
		)
{
	if( type == ICallback::Load
	||  type == ICallback::Save
	||  type == ICallback::New )
		UpdateCaption();
}
//=================================================================================================
CMDIChildWnd* CMainFrame::SearchParserView
		(
		unsigned int	item_id
		)
{
	CMDIChildWnd* pwnd = MDIGetActive();
	while( pwnd )
	{
		CParseEditFrame*	viewframe = DYNAMIC_DOWNCAST( CParseEditFrame, pwnd );
		if( viewframe != 0 && viewframe->GetTargetItemId() == item_id )
		{
			return pwnd;
		}
		pwnd = (CMDIChildWnd*)pwnd->GetNextWindow();
	}
	return 0;
}
//=================================================================================================
bool CMainFrame::Load
		(
		const wstring&		path
		)
{
	instance<FileReader>	file;
	if( false == file->Open( path.c_str() ) )
		return false;
	if( false == m_document->Load( path , (iFileReader)file ) )
		return false;
	return true;
}
//=================================================================================================
bool CMainFrame::Save()
{
	wstring		path	= m_document->GetFilepath();
	if( path == L"" )
		return SaveAs();

	instance<FileWriter>	file;
	if( file->Open( path.c_str() ) == false )
		return SaveAs();
	if( false == m_document->Save( path , (iFileWriter)file ) )
	{
		MessageBox( LoadText( IDS_MSG_2 ) , LoadText( IDS_MSG_1 ) , MB_OK | MB_ICONERROR );
		return false;
	}
	return true;
}
//=================================================================================================
bool CMainFrame::SaveAs()
{
	CFileDialog		dlg
			(
			FALSE ,
			L"tml" ,
			NULL ,
			OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_NOCHANGEDIR | OFN_EXPLORER ,
			L"Texml Files (*.tml)|*.tml|All Files (*.*)|*.*||"
			);
	if( IDOK != dlg.DoModal() )
		return false;
	wstring					path	= dlg.GetPathName();
	instance<FileWriter>	file;
	if( file->Open( path.c_str() ) == false )
	{
		MessageBox( LoadText( IDS_MSG_3 ) , LoadText( IDS_MSG_1 ) , MB_OK | MB_ICONERROR );
		return false;
	}
	if( false == m_document->Save( path , (iFileWriter)file ) )
	{
		MessageBox( LoadText( IDS_MSG_2 ) , LoadText( IDS_MSG_1 ) , MB_OK | MB_ICONERROR );
		return false;
	}
	return true;
}
//=================================================================================================
void CMainFrame::OutputMsg
		(
		const wstring&						msg , 
		ICallback::OutputMsgParam::Type		type , 
		ICallback::OutputMsgParam::ShowType show , 
		ICallback::OutputMsgParam::Cmd		cmd
		)
{
	ICallback::OutputMsgParam	param;
	param.m_show		= show;
	param.m_type		= type;
	param.m_cmd			= cmd;
	param.m_list.Resize( 1 );
	param.m_list[0].m_msg = msg.c_str();
	m_document->Callback( ICallback::OutputMsg , object() , &param );
}
//=================================================================================================
void CMainFrame::OutputMsg
		(
		const wstring&						msg , 
		int									row , 
		int									column , 
		ICallback::OutputMsgParam::Type		type , 
		ICallback::OutputMsgParam::ShowType show , 
		ICallback::OutputMsgParam::Cmd		cmd
		)
{
	ICallback::OutputMsgParam	param;
	param.m_show		= show;
	param.m_type		= type;
	param.m_cmd			= cmd;
	param.m_list.Resize( 1 );
	param.m_list[0].m_row		= row;
	param.m_list[0].m_column	= column;
	param.m_list[0].m_msg		= msg.c_str();
	m_document->Callback( ICallback::OutputMsg , object() , &param );
}
//=================================================================================================
void CMainFrame::OutputMsg
		(
		Array<wstring>&						msg , 
		ICallback::OutputMsgParam::Type		type , 
		ICallback::OutputMsgParam::ShowType show , 
		ICallback::OutputMsgParam::Cmd		cmd
		)
{
	ICallback::OutputMsgParam	param;
	param.m_show		= show;
	param.m_type		= type;
	param.m_cmd			= cmd;
	int		off , num = msg.GetDatanum();
	param.m_list.Resize( num );
	for( off = 0 ; off < num ; off++ )
		param.m_list[off].m_msg = msg[off].c_str();
	m_document->Callback( ICallback::OutputMsg , object() , &param );
}
//=================================================================================================
wstring CMainFrame::ReplaceText
		(
		int			resid , 
		int			row , 
		int			column
		)
{
	wstring		result = ( const wchar_t* )LoadText( resid );
	{
		wostringstream	os;
		os << (row + 1);
		result	= ReplaceAllPattern( result , L"[%row]" , os.str() );
	}
	{
		wostringstream	os;
		os << (column + 1);
		result	= ReplaceAllPattern( result , L"[%column]" , os.str() );
	}	
	return result;
}
//=================================================================================================
iXmlParserProcess CMainFrame::CreateXmlParserProcess()
{
	OutputMsg
		(
		(const wchar_t*)LoadText( IDS_OUTPUTMSG_0 ) ,  
		ICallback::OutputMsgParam::Normal , 
		ICallback::OutputMsgParam::Show , 
		ICallback::OutputMsgParam::Set
		);
	XmlParserProcessGen		gen;
	Array<wstring>			msg;
	iXmlParserProcess		pp = gen.CreateXmlParserProcess( m_document , msg );
	if( pp == false )
	{
		msg[ msg.Add() ]	= (const wchar_t*)LoadText( IDS_OUTPUTMSG_1 );
		OutputMsg
			( 
			msg , 
			ICallback::OutputMsgParam::Error
			);
		return iXmlParserProcess();
	}
	OutputMsg( (const wchar_t*)LoadText( IDS_OUTPUTMSG_12 ) );
	return pp;	
}
//=================================================================================================
bool CMainFrame::ExecuteXmlParserProcess
		(
		iXmlParserProcess&		pp
		)
{
	OutputMsg( (const wchar_t*)LoadText( IDS_OUTPUTMSG_2 ) );

	wstring	source;
	if( false == GetTestCode( source ) )
	{
		OutputMsg( (const wchar_t*)LoadText( IDS_OUTPUTMSG_13 ) );
		return false;
	}

	int		endpos = 0;
	IParserProcess::Result	result = ((iParserProcess)pp)->Execute
				(
				source , 
				&endpos
				);
	int		row , column;
	StringPosToLine( source.c_str() , endpos , &row , &column );

	// errors
	if( result == IParserProcess::Success )
	{
		if( endpos == source.length() )
			OutputMsg( ReplaceText( IDS_OUTPUTMSG_3 , row , column ) , row , column );
		else
			OutputMsg( ReplaceText( IDS_OUTPUTMSG_4 , row , column ) , row , column );
	}
	else if( result == IParserProcess::ParseError )
	{
		OutputMsg( ReplaceText( IDS_OUTPUTMSG_5 , row , column ) , row , column );
		return false;
	}
	else if( result == IParserProcess::StackOverflow ) 
	{
		OutputMsg( ReplaceText( IDS_OUTPUTMSG_6 , row , column ) , row , column );
		return false;
	}
	else if( result == IParserProcess::NodeOverflow ) 
	{
		OutputMsg( ReplaceText( IDS_OUTPUTMSG_7 , row , column ) , row , column );
		return false;
	}
	else
	{
		OutputMsg( ReplaceText( IDS_OUTPUTMSG_8 , row , column ) , row , column );
		return false;
	}
	return true;
}
//=================================================================================================
void CMainFrame::ClearOutputXml()
{
	ICallback::OutputXmlParam		param;
	m_document->Callback( ICallback::OutputXml , object() , &param );
}
//=================================================================================================
bool CMainFrame::OutputXml
		(
		iXmlParserProcess&		pp
		)
{
	OutputMsg( (const wchar_t*)LoadText( IDS_OUTPUTMSG_9 ) );

	IDocument::Property		prop = m_document->GetProperty();
	if( prop.m_document_tag == L"" )
	{
		OutputMsg( (const wchar_t*)LoadText( IDS_OUTPUTMSG_14 ) );
		return false;
	}	
	XMLPlatformUtils::Initialize();
	
	XERCES_CPP_NAMESPACE::DOMDocument*	doc		= 0;
	try
	{
		DOMImplementation*	impl	= DOMImplementationRegistry::getDOMImplementation(0);
		if( impl == 0 )
			throw 0;
		doc		= CreateXmlDoc( impl , pp , prop.m_document_tag , prop.m_doctype_name , prop.m_doctype_public , prop.m_doctype_system );
		if( doc == 0 )
			throw 0;
	}
	catch( ... )
	{
		if( doc != 0 )
			doc->release();
		XMLPlatformUtils::Terminate();
		OutputMsg( (const wchar_t*)LoadText( IDS_OUTPUTMSG_10 ) );
		return false;
	}
	OutputMsg( (const wchar_t*)LoadText( IDS_OUTPUTMSG_11 ) );
	
	// output
	{
		ICallback::OutputXmlParam		param;
		param.m_doc	= doc;
		m_document->Callback( ICallback::OutputXml , object() , &param );
	};
	
	// release
	if( doc != 0 )
		doc->release();
	XMLPlatformUtils::Terminate();
	return true;
}
//=================================================================================================
bool CMainFrame::OutputTxp
		(
		const wchar_t*		path
		)
{
	iParserProcess	pp = (iXmlParserProcess)CreateXmlParserProcess();
	if( pp == false )
		return false;

	IDocument::Property		prop = m_document->GetProperty();
	instance<FileWriter>	file;
	if( false == file->Open( path ) )
		return false;
	
	// write headers
	{
		const char	sign[] = "TexmlParser";
		if( false == file->Write( sign , 1 , strlen( sign ) , Little_EndianType ) )
			return false;
	}
	{
		long	ver = 1;
		if( false == file->Write( &ver , sizeof( ver ) , 1 , Little_EndianType ) )
			return false;
	}	
	{
		if( false == SaveString( (iStreamWrite)file , prop.m_document_tag ) )
			return false;
		if( false == SaveString( (iStreamWrite)file , prop.m_encode ) )
			return false;
		if( false == SaveString( (iStreamWrite)file , prop.m_doctype_name ) )
			return false;
		if( false == SaveString( (iStreamWrite)file , prop.m_doctype_public ) )
			return false;
		if( false == SaveString( (iStreamWrite)file , prop.m_doctype_system ) )
			return false;
	}
	// write parser
	if( false == pp->Save( (iStreamWrite)file ) )
		return false;
	return true;
}
//=================================================================================================
void CMainFrame::UpdateCaption()
{
	wstring	path = m_document->GetFilepath();
	if( path.empty() == true )
		path	= LoadText( IDS_NEW_CAPTION );
	SetWindowText( (wstring( (const wchar_t*)LoadText( IDS_APPTITLE ) ) + L" - " + path).c_str() );
}
//=================================================================================================
bool CMainFrame::WriteProfileInt
		(
		const wchar_t*	section , 
		const wchar_t*	entry , 
		int				value
		)
{
	return ( TRUE == AfxGetApp()->WriteProfileInt( section , entry , value ) ) ? true : false;
}
//=================================================================================================
bool CMainFrame::WriteProfileString
		(
		const wchar_t*	section , 
		const wchar_t*	entry , 
		const wchar_t*	value
		)
{
	return ( TRUE == AfxGetApp()->WriteProfileString( section , entry , value ) ) ? true : false;
}
//=================================================================================================
int CMainFrame::GetProfileInt
		(
		const wchar_t*	section , 
		const wchar_t*	entry , 
		int				def
		)
{
	return AfxGetApp()->GetProfileInt( section , entry , def );
}
//=================================================================================================
wstring CMainFrame::GetProfileString
		(
		const wchar_t*	section , 
		const wchar_t*	entry , 
		const wchar_t*	def
		)
{
	return wstring( (const wchar_t* )AfxGetApp()->GetProfileString( section , entry , def ) );
}
//=================================================================================================
wstring CMainFrame::GetModuleFolder()
{
	wchar_t	path[_MAX_PATH];
	if( 0 == ::GetModuleFileName( AfxGetApp()->m_hInstance , path , MAX_PATH ) )
		return wstring();

	wchar_t	drive[_MAX_DRIVE] , dir[_MAX_DIR] , name[_MAX_FNAME] , ext[_MAX_EXT];
	_wsplitpath_s( path , drive , _MAX_DRIVE , dir , _MAX_DIR , name , _MAX_FNAME , ext , _MAX_EXT );	
	return wstring(drive) + dir;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CMainFrame::CMainFrame() : 
		m_hMDIMenu( NULL ) , 
		m_hMDIAccel( NULL ) , 
		m_accel_suspend_count( 0 )
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );
	theApp.m_nAppLook = theApp.GetInt(_T("ApplicationLook"), ID_VIEW_APPLOOK_OFF_2007_BLUE);
}
//=================================================================================================
CMainFrame::~CMainFrame()
{
}
//=================================================================================================
void CMainFrame::OpenTestCodeEditor
		(
		int		row , 
		int		column
		)
{
	if( 32 >= (int)ShellExecute(NULL , L"open" , m_setting.m_editor_path.c_str() , GetEditorArgs( row , column ).c_str() , NULL , SW_SHOWNORMAL ) )
		MessageBox( LoadText( IDS_MSG_8 ) , LoadText( IDS_APPTITLE ) , MB_OK | MB_ICONERROR );
}
//=================================================================================================
wstring CMainFrame::GetTestCodePath()
{
	wstring	codepath = GetModuleFolder() + L"testcode.txt";

	CFileFind find;
	if( FALSE == find.FindFile( codepath.c_str() ) )
	{
		CFile	file( codepath.c_str() , CFile::modeCreate | CFile::modeNoTruncate );
	}
	return codepath;
}
//=================================================================================================
wstring CMainFrame::GetEditorArgs
		(
		int		row , 
		int		column
		)
{
	if( row < 0 || column < 0 )
		return ReplaceAllPattern( m_setting.m_editor_args , L"%file" , GetTestCodePath() );
	else
	{
		wstring	args = ReplaceAllPattern( m_setting.m_editor_args_row , L"%file" , GetTestCodePath() );
		{
			wostringstream	os;
			os << (row + 1);
			args	= ReplaceAllPattern( args , L"%row" , os.str() );
		}
		{
			wostringstream	os;
			os << (column + 1);
			args	= ReplaceAllPattern( args , L"%column" , os.str() );
		}
		return args;
	}
}
//=================================================================================================
bool CMainFrame::GetTestCode
		(
		wstring&	source
		)
{
	wstring	path = GetTestCodePath();

	if( false == LoadTextfile( path.c_str() , m_setting.m_editor_encode , source ) )
		return false;
	return true;
}
//=================================================================================================
void CMainFrame::CreateParserView
		(
		iItem&		item
		)
{
	if( item == false )
		return;
	if( item->m_type != IItem::Parser )
		return;

	// search same item view
	CMDIChildWnd* pwnd = SearchParserView( item->m_item_id );
	if( pwnd != 0 )
	{
		MDIActivate( pwnd );
		return;
	}
	// create
	pwnd = CreateNewChild
		(
		RUNTIME_CLASS(CParseEditFrame), 
		IDR_TexmlTYPE, 
		NULL , //m_hMDIMenu, 
		NULL //m_hMDIAccel
		);
	CParseEditFrame*	viewframe = DYNAMIC_DOWNCAST( CParseEditFrame, pwnd );
	cb_assert( viewframe != NULL , L"algorithm error." );
	viewframe->Initialize( item->m_item_id );
}
//=================================================================================================
int CMainFrame::AccelSuspend()
{
	m_accel_suspend_count++;
	return m_accel_suspend_count;
}
//=================================================================================================
int CMainFrame::AccelResume()
{
	m_accel_suspend_count--;
	return m_accel_suspend_count;
}
//=================================================================================================
void CMainFrame::RegistCmdMsgCallback
		(
		CWnd*		tgt
		)
{
	m_cmdmsg_callback[ m_cmdmsg_callback.Add() ]	= tgt;
}
//=================================================================================================
void CMainFrame::RemoveCmdMsgCallback
		(
		CWnd*		tgt
		)
{
	int		off , num = m_cmdmsg_callback.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( m_cmdmsg_callback[ off ] == tgt )
		{
			m_cmdmsg_callback.Delete( off );
			return;
		}
	}
}
//=================================================================================================
bool CMainFrame::CanExecuteParser()
{
	return true;
}
//=================================================================================================
void CMainFrame::ExecuteParser()
{
	ClearOutputXml();
	iXmlParserProcess	pp = CreateXmlParserProcess();
	if( pp == false )
		return;
	if( false == ExecuteXmlParserProcess( pp ) )
		return;
	if( false == OutputXml( pp ) )
		return;
}
//=================================================================================================
BOOL CMainFrame::CreateDockingWindows()
{
	// create project view
	{
		CString strParserView;
		VERIFY( TRUE == strParserView.LoadString( IDS_PARSER_VIEW ) );
		if (!m_wndParserView.Create(strParserView, this, CRect(0, 0, 200, 200), TRUE, ID_VIEW_PARSERVIEW, WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_LEFT | CBRS_FLOAT_MULTI))
		{
			TRACE0("fail to create view\n");
			return FALSE;
		}
	}
	// create output view
	{
		CString strOutputWnd;
		VERIFY( TRUE == strOutputWnd.LoadString( IDS_OUTPUT_WND ) );
		if (!m_wndOutput.Create(strOutputWnd, this, CRect(0, 0, 100, 100), TRUE, ID_VIEW_OUTPUTWND, WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_BOTTOM | CBRS_FLOAT_MULTI))
		{
			TRACE0("fail to create view\n");
			return FALSE;
		}
	}
	// create property view
	{
		CString strPropertiesWnd;
		VERIFY( TRUE == strPropertiesWnd.LoadString(IDS_PROPERTIES_WND) );
		if (!m_wndProperties.Create(strPropertiesWnd, this, CRect(0, 0, 200, 200), TRUE, ID_VIEW_PROPERTIESWND, WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_RIGHT | CBRS_FLOAT_MULTI))
		{
			TRACE0("fail to create view\n");
			return FALSE;
		}
	}
/*
	// create test code view
	{
		CString strTestCodeWnd;
		VERIFY( TRUE == strTestCodeWnd.LoadString(IDS_TESTCODE_WND) );
		if (!m_wndTestCode.Create(strTestCodeWnd, this, CRect(0, 0, 200, 200), TRUE, ID_VIEW_TESTCODEWND, WS_CHILD | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_RIGHT | CBRS_FLOAT_MULTI))
		{
			TRACE0("fail to create view\n");
			return FALSE;
		}
	}
*/
	// create xml output view
	{
		CString strOutputXmlWnd;
		VERIFY( TRUE == strOutputXmlWnd.LoadString(IDS_OUTPUTXML_WND) );
		if (!m_wndOutputXml.Create(strOutputXmlWnd, this, CRect(0, 0, 200, 200), TRUE, ID_VIEW_OUTPUTXMLWND, WS_CHILD | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_RIGHT | CBRS_FLOAT_MULTI))
		{
			TRACE0("fail to create view\n");
			return FALSE;
		}
	}
	SetDockingWindowIcons(theApp.m_bHiColorIcons);
	return TRUE;
}
//=================================================================================================
BOOL CMainFrame::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
	// {NXۂ̓s܂B
	if (!CMDIFrameWndEx::LoadFrame(nIDResource, dwDefaultStyle, pParentWnd, pContext))
	{
		return FALSE;
	}
	// ׂẴ[U[`c[ o[̃{^̃JX^}CYLɂ܂
	BOOL bNameValid;
	CString strCustomize;
	bNameValid = strCustomize.LoadString(IDS_TOOLBAR_CUSTOMIZE);
	ASSERT(bNameValid);

	for (int i = 0; i < iMaxUserToolbars; i ++)
	{
		CMFCToolBar* pUserToolbar = GetUserToolBarByIndex(i);
		if (pUserToolbar != NULL)
		{
			pUserToolbar->EnableCustomizeButton(TRUE, ID_VIEW_CUSTOMIZE, strCustomize);
		}
	}
	return TRUE;
}
//=================================================================================================
void CMainFrame::SetDockingWindowIcons(BOOL bHiColorIcons)
{
	HICON hParserViewIcon = (HICON) ::LoadImage(::AfxGetResourceHandle(), MAKEINTRESOURCE(bHiColorIcons ? IDI_PARSER_VIEW_HC : IDI_PARSER_VIEW), IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), 0);
	m_wndParserView.SetIcon(hParserViewIcon, FALSE);

	HICON hOutputBarIcon = (HICON) ::LoadImage(::AfxGetResourceHandle(), MAKEINTRESOURCE(bHiColorIcons ? IDI_OUTPUT_WND_HC : IDI_OUTPUT_WND), IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), 0);
	m_wndOutput.SetIcon(hOutputBarIcon, FALSE);

	HICON hPropertiesBarIcon = (HICON) ::LoadImage(::AfxGetResourceHandle(), MAKEINTRESOURCE(bHiColorIcons ? IDI_PROPERTIES_WND_HC : IDI_PROPERTIES_WND), IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), 0);
	m_wndProperties.SetIcon(hPropertiesBarIcon, FALSE);

//	HICON hTestCodeBarIcon = (HICON) ::LoadImage(::AfxGetResourceHandle(), MAKEINTRESOURCE(bHiColorIcons ? IDI_TESTCODE_WND_HC : IDI_TESTCODE_WND), IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), 0);
//	m_wndTestCode.SetIcon(hTestCodeBarIcon, FALSE);

	HICON hOutputXmlIcon = (HICON) ::LoadImage(::AfxGetResourceHandle(), MAKEINTRESOURCE(bHiColorIcons ? IDI_OUTPUTXML_WND_HC : IDI_OUTPUTXML_WND), IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), 0);
	m_wndOutputXml.SetIcon(hOutputXmlIcon, FALSE);

	UpdateMDITabbedBarsIcons();
}
//=================================================================================================
#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWndEx::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWndEx::Dump(dc);
}
#endif //_DEBUG

///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC override
//=================================================================================================
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIFrameWndEx::PreCreateWindow(cs) )
		return FALSE;

	cs.style &= ~(FWS_PREFIXTITLE | FWS_ADDTOTITLE); 
	cs.dwExStyle |= WS_EX_ACCEPTFILES;
	return TRUE;
}
//=================================================================================================
BOOL CMainFrame::PreTranslateMessage
		( 
		MSG* pmsg
		)
{
	if ( m_accel_suspend_count > 0 ) 
	{
		return CWnd::PreTranslateMessage( pmsg );
	} 
	else 
	{
		return __super::PreTranslateMessage( pmsg );
	}
}
//=================================================================================================
BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM lParam)
{
	int	off , num = m_cmdmsg_callback.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( 1 == HIWORD(wParam) || 2 == HIWORD(wParam) )
		{
			if( 0 != m_cmdmsg_callback[off] 
			 && AfxCallWndProc( m_cmdmsg_callback[off] , m_cmdmsg_callback[off]->m_hWnd , WM_COMMAND , wParam , lParam ) != 0 )
				return TRUE;
		}
	}
	return __super::OnCommand( wParam, lParam );
}
//=================================================================================================
BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	int	off , num = m_cmdmsg_callback.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( TRUE == m_cmdmsg_callback[off]->OnCmdMsg( nID , nCode , pExtra , pHandlerInfo ) )
			return TRUE;
	}
	return __super::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event hander
//=================================================================================================
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if ( CMDIFrameWndEx::OnCreate( lpCreateStruct ) == -1 )
		return -1;

	HINSTANCE hInst = AfxGetResourceHandle();
	m_hMDIMenu  = ::LoadMenu( hInst , MAKEINTRESOURCE( IDR_TexmlTYPE ) );
	m_hMDIAccel = ::LoadAccelerators( hInst , MAKEINTRESOURCE( IDR_TexmlTYPE ) );

	OnApplicationLook(theApp.m_nAppLook);

	CMDITabInfo mdiTabParams;
	mdiTabParams.m_style					= CMFCTabCtrl::STYLE_3D_ONENOTE;	// gp\Ȃ̑̎oX^C...
	mdiTabParams.m_bActiveTabCloseButton	= TRUE;								// ^ü̉E [] {^zuɂ́AFALSE ɐݒ肵܂
	mdiTabParams.m_bTabIcons				= FALSE;							// MDI ^uŃhLg ACRLɂɂ́ATRUE ɐݒ肵܂
	mdiTabParams.m_bAutoColor				= TRUE;								// MDI ^u̎Fݒ𖳌ɂɂ́AFALSE ɐݒ肵܂
	mdiTabParams.m_bDocumentMenu			= TRUE;								// ^ü̉E[ɂhLg j[Lɂ܂
	EnableMDITabbedGroups( TRUE, mdiTabParams );

	if ( !m_wndMenuBar.Create( this ) )
	{
		TRACE0("fail to create menu.\n");
		return -1;
	}
	m_wndMenuBar.SetPaneStyle( m_wndMenuBar.GetPaneStyle() | CBRS_SIZE_DYNAMIC | CBRS_TOOLTIPS | CBRS_FLYBY );

	// ANeBuɂȂƂj[ o[ɃtH[JXړȂ
	CMFCPopupMenu::SetForceMenuFocus( FALSE );
	
	// create normal toolbar
	if (!m_wndToolBarNormal.CreateEx
				(
				this, 
				TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC , 
				CRect(1,1,1,1) , 
				AFX_IDW_TOOLBAR 
				) 
		|| !m_wndToolBarNormal.LoadToolBar(theApp.m_bHiColorIcons ? IDR_MAINFRAME_256 : IDR_MAINFRAME ) )
	{
		TRACE0("fail to create toolbar.\n");
		return -1;
	}
	{
		CString strToolBarName;
		VERIFY( TRUE == strToolBarName.LoadString( IDS_TOOLBAR_STANDARD ) );
		m_wndToolBarNormal.SetWindowText( strToolBarName );
	}
	CString strCustomize;
	VERIFY( TRUE == strCustomize.LoadString( IDS_TOOLBAR_CUSTOMIZE ) );
	m_wndToolBarNormal.EnableCustomizeButton( TRUE, ID_VIEW_CUSTOMIZE, strCustomize );

	// create parser toolbar
	if (!m_wndToolBarParseEdit.CreateEx
				(
				this, 
				TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC , 
				CRect(1,1,1,1) , 
				AFX_IDW_TOOLBAR + 1
				) 
		|| !m_wndToolBarParseEdit.LoadToolBar(theApp.m_bHiColorIcons ? IDR_PARSEEDIT_256 : IDR_PARSEEDIT ) )
	{
		TRACE0("fail to create toolbar.\n");
		return -1;
	}
	{
		CString strToolBarName;
		VERIFY( TRUE == strToolBarName.LoadString(IDS_TOOLBAR_PARSEEDIT) );
		m_wndToolBarParseEdit.SetWindowText(strToolBarName);
	}
	m_wndToolBarParseEdit.EnableCustomizeButton(TRUE, ID_VIEW_CUSTOMIZE, strCustomize);

	// [U[`̃c[ o[̑܂:
	InitUserToolbars( NULL , uiFirstUserToolBarId , uiLastUserToolBarId );

	// create status bar
	if ( !m_wndStatusBar.Create( this ) )
	{
		TRACE0("fail to create status bar\n");
		return -1;
	}
	m_wndStatusBar.SetIndicators( indicators , sizeof( indicators ) / sizeof( UINT ) );

	// TODO: c[ o[уj[ o[hbLO\ɂȂꍇ́A 5 ̍s폜܂
	m_wndMenuBar.EnableDocking( CBRS_ALIGN_ANY );
	m_wndToolBarNormal.EnableDocking( CBRS_ALIGN_ANY );
	m_wndToolBarParseEdit.EnableDocking( CBRS_ALIGN_ANY );
	EnableDocking( CBRS_ALIGN_ANY );
	DockPane( &m_wndMenuBar );
	DockPane( &m_wndToolBarNormal );
	DockPane( &m_wndToolBarParseEdit );


	// Visual Studio 2005 X^C̃hbLO EBhELɂ܂
	CDockingManager::SetDockingMode( DT_SMART );
	// Visual Studio 2005 X^C̃hbLO EBhE̎\Lɂ܂
	EnableAutoHidePanes( CBRS_ALIGN_ANY );

	// j[ڃC[W (ǂ̕Wc[ o[ɂȂC[W) ǂݍ݂܂:
	CMFCToolBar::AddToolBarForImageCollection( IDR_MENU_IMAGES , theApp.m_bHiColorIcons ? IDB_MENU_IMAGES_24 : 0 );

	// hbLO EBhE쐬܂
	if ( !CreateDockingWindows() )
	{
		TRACE0("hbLO EBhE쐬ł܂ł\n");
		return -1;
	}

	m_wndParserView.EnableDocking( CBRS_ALIGN_ANY );
	DockPane( &m_wndParserView );
	m_wndOutput.EnableDocking( CBRS_ALIGN_ANY );
	DockPane( &m_wndOutput );
	m_wndProperties.EnableDocking( CBRS_ALIGN_ANY );
	DockPane( &m_wndProperties );
//	m_wndTestCode.EnableDocking( CBRS_ALIGN_ANY );
//	AddPane(&m_wndTestCode);
//	DockPane( &m_wndTestCode );
	m_wndOutputXml.EnableDocking( CBRS_ALIGN_ANY );
	DockPane( &m_wndOutputXml );

//	CDockablePane* pTabbedBar = NULL;
//	m_wndOutputXml.AttachToTabWnd( &m_wndTestCode , DM_SHOW , TRUE, &pTabbedBar );


	// gEBhEǗ_CAO {bNXLɂ܂
	EnableWindowsDialog( ID_WINDOW_MANAGER , IDS_WINDOWS_MANAGER , TRUE );

	// c[ o[ƃhbLO EBhE j[̔zuύXLɂ܂
	EnablePaneMenu( TRUE , ID_VIEW_CUSTOMIZE , strCustomize , ID_VIEW_TOOLBAR);

	// c[ o[̃NCbN (Alt L[ȂhbO) JX^}CYLɂ܂
	CMFCToolBar::EnableQuickCustomization();

	if ( CMFCToolBar::GetUserImages() == NULL )
	{
		// [U[`̃c[ o[ C[Wǂݍ݂܂
		if ( m_UserImages.Load( _T(".\\UserImages.bmp") ) )
		{
			m_UserImages.SetImageSize( CSize(16, 16) , FALSE );
			CMFCToolBar::SetUserImages( &m_UserImages );
		}
	}
	// j[̃p[\i (ŋߎgpꂽR}h) Lɂ܂
	// TODO: [U[ŗL̊{R}h`Aej[NbNƂɊ{R}h 1 ȏ\悤ɂ܂B
	CList<UINT, UINT> lstBasicCommands;
	lstBasicCommands.AddTail(ID_FILE_NEW);
	lstBasicCommands.AddTail(ID_APP_EXIT);
	lstBasicCommands.AddTail(ID_EDIT_CUT);
	lstBasicCommands.AddTail(ID_EDIT_PASTE);
	lstBasicCommands.AddTail(ID_EDIT_UNDO);
	lstBasicCommands.AddTail(ID_APP_ABOUT);
	lstBasicCommands.AddTail(ID_VIEW_STATUS_BAR);
	lstBasicCommands.AddTail(ID_VIEW_TOOLBAR);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_OFF_2003);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_VS_2005);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_OFF_2007_BLUE);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_OFF_2007_SILVER);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_OFF_2007_BLACK);
	lstBasicCommands.AddTail(ID_VIEW_APPLOOK_OFF_2007_AQUA);
	CMFCToolBar::SetBasicCommands(lstBasicCommands);

	// load
	UpdateCaption();
	wstring		lastfile = GetProfileString( L"mainframe" , L"lastfile" , L"" );
	if( lastfile.empty() == false )
	{
		if( true == Load( lastfile ) )
			m_document->Callback( ICallback::Load , object() , 0 );
	}
	m_setting.Load();
	return 0;
}
//=================================================================================================
void CMainFrame::OnDestroy()
{
	__super::OnDestroy();

	// save
	m_setting.Save();
	WriteProfileString( L"mainframe" , L"lastfile" , m_document->GetFilepath().c_str() );

	// destroy
	if ( m_hMDIMenu != NULL )
		FreeResource( m_hMDIMenu );
	if ( m_hMDIAccel != NULL )
		FreeResource( m_hMDIAccel );
}
//=================================================================================================
void CMainFrame::OnDropFiles(HDROP hDropInfo)
{
	int	num	= DragQueryFile( hDropInfo , -1 , NULL , 0 );
	if( num == 0 )
		return;

	wstring	path;
	{
		int	len	= DragQueryFile( hDropInfo , 0 , NULL , 0 );
		wchar_t*	p = new wchar_t[len+1];
		DragQueryFileW( hDropInfo , 0 , p , len + 1 );
		path	= p;
		delete	[]p;
	}

	if( m_document->IsModify() == true )
	{
		int	id =MessageBox( LoadText( IDS_MSG_4 ) , LoadText( IDS_APPTITLE ) , MB_YESNOCANCEL | MB_ICONQUESTION );
		if( id == IDCANCEL )
			return;
		else if( id == IDYES )
		{
			if( false == Save() )
				return;
		}
	}
	if( false == Load( path ) )
	{
		MessageBox( LoadText( IDS_MSG_5 ) , LoadText( IDS_APPTITLE ) , MB_OK | MB_ICONERROR );
		return;
	}
	m_document->Callback( ICallback::Load , object() , 0 );

//	__super::OnDropFiles(hDropInfo);
}
//=================================================================================================
void CMainFrame::OnUpdateFrameTitle(BOOL bAddToTitle)
{
//	SetWindowText(L"aaa"); 
//	__super::OnUpdateFrameTitle(bAddToTitle);
}
//=================================================================================================
void CMainFrame::OnClose()
{
	if( m_document->IsModify() == true )
	{
		int	id =MessageBox( LoadText( IDS_MSG_4 ) , LoadText( IDS_APPTITLE ) , MB_YESNOCANCEL | MB_ICONQUESTION );
		if( id == IDCANCEL )
			return;
		else if( id == IDYES )
		{
			if( false == Save() )
				return;
		}
	}
	__super::OnClose();
}
//=================================================================================================
void CMainFrame::OnWindowManager()
{
	ShowWindowsDialog();
}
//=================================================================================================
void CMainFrame::OnViewCustomize()
{
	CMFCToolBarsCustomizeDialog* pDlgCust = new CMFCToolBarsCustomizeDialog( this, TRUE );
	pDlgCust->EnableUserDefinedToolbars();
	pDlgCust->Create();
}
//=================================================================================================
LRESULT CMainFrame::OnToolbarReset(WPARAM wp,LPARAM)
{
	UINT uiToolBarId = (UINT) wp;
	if ( uiToolBarId == IDR_PARSEEDIT_256 || uiToolBarId == IDR_PARSEEDIT )
	{
		CMenu menu;
		menu.LoadMenu (IDR_POPUP_ADD_NODE);
		CMenu* submenu = menu.GetSubMenu(0);
		if( submenu != NULL )
		{
			CString desc;
			VERIFY( TRUE == desc.LoadString(ID_ADD_NODE ) );
			m_wndToolBarParseEdit.ReplaceButton
				(
				ID_ADD_NODE,
				CMFCToolBarMenuButton 
					(
					(UINT)-1, 
					submenu->GetSafeHmenu(), 
					GetCmdMgr()->GetCmdImage( ID_ADD_NODE ) , 
					desc
					)
				);
		}
	}
	return 0;
}
//=================================================================================================
LRESULT CMainFrame::OnToolbarCreateNew(WPARAM wp,LPARAM lp)
{
	LRESULT lres = CMDIFrameWndEx::OnToolbarCreateNew(wp,lp);
	if (lres == 0)
	{
		return 0;
	}

	CMFCToolBar* pUserToolbar = (CMFCToolBar*)lres;
	ASSERT_VALID(pUserToolbar);

	BOOL bNameValid;
	CString strCustomize;
	bNameValid = strCustomize.LoadString(IDS_TOOLBAR_CUSTOMIZE);
	ASSERT(bNameValid);

	pUserToolbar->EnableCustomizeButton(TRUE, ID_VIEW_CUSTOMIZE, strCustomize);
	return lres;
}
//=================================================================================================
void CMainFrame::OnApplicationLook(UINT id)
{
	CWaitCursor wait;

	theApp.m_nAppLook = id;

	switch (theApp.m_nAppLook)
	{
	case ID_VIEW_APPLOOK_WIN_2000:
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManager));
		break;

	case ID_VIEW_APPLOOK_OFF_XP:
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerOfficeXP));
		break;

	case ID_VIEW_APPLOOK_WIN_XP:
		CMFCVisualManagerWindows::m_b3DTabsXPTheme = TRUE;
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerWindows));
		break;

	case ID_VIEW_APPLOOK_OFF_2003:
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerOffice2003));
		CDockingManager::SetDockingMode(DT_SMART);
		break;

	case ID_VIEW_APPLOOK_VS_2005:
		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerVS2005));
		CDockingManager::SetDockingMode(DT_SMART);
		break;

	default:
		switch (theApp.m_nAppLook)
		{
		case ID_VIEW_APPLOOK_OFF_2007_BLUE:
			CMFCVisualManagerOffice2007::SetStyle(CMFCVisualManagerOffice2007::Office2007_LunaBlue);
			break;

		case ID_VIEW_APPLOOK_OFF_2007_BLACK:
			CMFCVisualManagerOffice2007::SetStyle(CMFCVisualManagerOffice2007::Office2007_ObsidianBlack);
			break;

		case ID_VIEW_APPLOOK_OFF_2007_SILVER:
			CMFCVisualManagerOffice2007::SetStyle(CMFCVisualManagerOffice2007::Office2007_Silver);
			break;

		case ID_VIEW_APPLOOK_OFF_2007_AQUA:
			CMFCVisualManagerOffice2007::SetStyle(CMFCVisualManagerOffice2007::Office2007_Aqua);
			break;
		}

		CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerOffice2007));
		CDockingManager::SetDockingMode(DT_SMART);
	}

	RedrawWindow(NULL, NULL, RDW_ALLCHILDREN | RDW_INVALIDATE | RDW_UPDATENOW | RDW_FRAME | RDW_ERASE);

	theApp.WriteInt(_T("ApplicationLook"), theApp.m_nAppLook);
}
//=================================================================================================
void CMainFrame::OnUpdateApplicationLook(CCmdUI* pCmdUI)
{
	pCmdUI->SetRadio(theApp.m_nAppLook == pCmdUI->m_nID);
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC command hander
//=================================================================================================
void CMainFrame::OnFileNew()
{
	if( m_document->IsModify() == true )
	{
		int	id =MessageBox( LoadText( IDS_MSG_4 ) , LoadText( IDS_APPTITLE ) , MB_YESNOCANCEL | MB_ICONQUESTION );
		if( id == IDCANCEL )
			return;
		else if( id == IDYES )
		{
			if( false == Save() )
				return;
		}
	}
	m_document->Reset();
	m_document->Callback( ICallback::New , object() , 0 );
}
//=================================================================================================
void CMainFrame::OnUpdateFileNew(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CMainFrame::OnFileOpen()
{
	if( m_document->IsModify() == true )
	{
		int	id =MessageBox( LoadText( IDS_MSG_4 ) , LoadText( IDS_APPTITLE ) , MB_YESNOCANCEL | MB_ICONQUESTION );
		if( id == IDCANCEL )
			return;
		else if( id == IDYES )
		{
			if( false == Save() )
				return;
		}
	}
	CFileDialog		dlg
			(
			TRUE ,
			NULL ,
			NULL ,
			OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_NOCHANGEDIR | OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST ,
			L"Texml Files (*.tml)|*.tml|All Files (*.*)|*.*||"
			);
	if( IDOK != dlg.DoModal() )
		return;
	if( false == Load( (const wchar_t*)dlg.GetPathName() ) )
	{
		MessageBox( LoadText( IDS_MSG_5 ) , LoadText( IDS_MSG_1 ) , MB_OK | MB_ICONERROR );
		return;
	}
	m_document->Callback( ICallback::Load , object() , 0 );
}
//=================================================================================================
void CMainFrame::OnUpdateFileOpen(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CMainFrame::OnFileSave()
{
	if( false == Save() )
		return;
	m_document->Callback( ICallback::Save , object() , 0 );
}
//=================================================================================================
void CMainFrame::OnUpdateFileSave(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( m_document->IsModify() == true ? TRUE : FALSE );
}
//=================================================================================================
void CMainFrame::OnFileSaveAs()
{
	if( false == SaveAs() )
		return;
	m_document->Callback( ICallback::Save , object() , 0 );
}
//=================================================================================================
void CMainFrame::OnUpdateFileSaveAs(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CMainFrame::OnEditUndo()
{
	m_document->Undo();
	m_document->Callback( ICallback::Undo , object() , 0 );
}
//=================================================================================================
void CMainFrame::OnEditRedo()
{
	m_document->Redo();
	m_document->Callback( ICallback::Redo , object() , 0 );
}
//=================================================================================================
void CMainFrame::OnUpdateEditUndo(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( m_document->IsUndo() == true ? TRUE : FALSE );
}
//=================================================================================================
void CMainFrame::OnUpdateEditRedo(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( m_document->IsRedo() == true ? TRUE : FALSE );
}
//=================================================================================================
void CMainFrame::OnEditExecute()
{
	ExecuteParser();
}
//=================================================================================================
void CMainFrame::OnUpdateEditExecute(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( CanExecuteParser() == true ? TRUE : FALSE );
}
//=================================================================================================
void CMainFrame::OnEditTestcode()
{
	OpenTestCodeEditor();
}
//=================================================================================================
void CMainFrame::OnUpdateEditTestcode(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CMainFrame::OnEditSetting()
{
	CSettingDlg		setting( LoadText( IDS_SETTING_TITLE ) );
	setting.Initialize( m_setting );
	if( IDOK != setting.DoModal() )
		return;
	setting.GetData( m_setting );
}
//=================================================================================================
void CMainFrame::OnUpdateEditSetting(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CMainFrame::OnEditOutputtxp()
{
	CFileDialog		dlg
			(
			FALSE ,
			L"txp" ,
			NULL ,
			OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_NOCHANGEDIR | OFN_EXPLORER ,
			L"Texml Parser Files (*.txp)|*.txp|All Files (*.*)|*.*||"
			);
	if( IDOK != dlg.DoModal() )
		return;
	if( false == OutputTxp( (const wchar_t*)dlg.GetPathName() ) )
	{
		MessageBox( LoadText( IDS_MSG_9 ) , LoadText( IDS_MSG_1 ) , MB_OK | MB_ICONERROR );
		return;
	}		
	return;
}
//=================================================================================================
void CMainFrame::OnUpdateEditOutputtxp(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CMainFrame::OnEditProject()
{
	CProjectDlg		dlg( LoadText( IDS_PROPERTYDLG_TITLE ) );
	dlg.SetData( m_document->GetProperty() );
	if( IDOK != dlg.DoModal() )
		return;
	m_document->SetProperty( dlg.GetData() );
}
//=================================================================================================
void CMainFrame::OnUpdateEditProject(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CMainFrame::OnEditHelp()
{
	ShellExecute(NULL , L"open" , ( wstring( L"file:///" ) + GetModuleFolder() + L"Help/index.htm" ).c_str() , NULL , NULL , SW_SHOWNORMAL );
}
//=================================================================================================
void CMainFrame::OnUpdateEditHelp(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
