
// MainFrm.h : CMainFrame NX̃C^[tFCX
//

#pragma once
#include	"ParserView.h"
#include	"OutputWnd.h"
#include	"PropertiesWnd.h"
#include	"OutputXmlWnd.h"
#include	"Document/Document.h"
#include	"ParseEditFrm.h"
#include	"Document/XmlParserProcessGen.h"
#include	<xercesc/parsers/XercesDOMParser.hpp>
#include	<xercesc/dom/DOM.hpp>
#include	<xercesc/dom/DOMNode.hpp>
#include	<xercesc/util/XMLString.hpp>
#include	<xercesc/util/PlatformUtils.hpp>
#include	<xercesc/util/BinInputStream.hpp>
#include	<xercesc/sax/HandlerBase.hpp>
#include	<xercesc/sax/InputSource.hpp>
#include	<xercesc/framework/LocalFileFormatTarget.hpp>

using namespace document;
using namespace icubic;

/**************************************************************************************************
"SettingData" class 
**************************************************************************************************/
class SettingData
{
// variable member
public:
	wstring		m_editor_path;
	wstring		m_editor_args;
	wstring		m_editor_args_row;
	EncodeType	m_editor_encode;
	
// public functions
public:
//=================================================================================================
SettingData() : m_editor_encode( ShiftJis )
{
}
//=================================================================================================
void Load()
{
	m_editor_path		= AfxGetApp()->GetProfileString( L"settingdata" , L"editorpath" , L"notepad.exe" );
	m_editor_args		= AfxGetApp()->GetProfileString( L"settingdata" , L"editorargs" , L"%file" );
	m_editor_args_row	= AfxGetApp()->GetProfileString( L"settingdata" , L"editorargsrow" , L"%file" );
	m_editor_encode		= (EncodeType)AfxGetApp()->GetProfileInt( L"settingdata" , L"editorencode" , ShiftJis );
}
//=================================================================================================
void Save()
{
	AfxGetApp()->WriteProfileString( L"settingdata" , L"editorpath" , m_editor_path.c_str() );
	AfxGetApp()->WriteProfileString( L"settingdata" , L"editorargs" , m_editor_args.c_str() );
	AfxGetApp()->WriteProfileString( L"settingdata" , L"editorargsrow" , m_editor_args_row.c_str() );
	AfxGetApp()->WriteProfileInt( L"settingdata" , L"editorencode" , m_editor_encode );
}
};

/**************************************************************************************************
"CMainFrame" class 
**************************************************************************************************/
class CMainFrame : public CMDIFrameWndEx , public ICallback
{
	DECLARE_DYNAMIC(CMainFrame)

// member variable
private:
	iDocument					m_document;
	instance<CallbackListener>	m_listener;
	SettingData					m_setting;

	HMENU						m_hMDIMenu;
	HACCEL						m_hMDIAccel;
	int							m_accel_suspend_count;
	Array<CWnd*>				m_cmdmsg_callback;
	
	CMFCMenuBar					m_wndMenuBar;
	CMFCToolBar					m_wndToolBarNormal;
	CMFCToolBar					m_wndToolBarParseEdit;
	
	CMFCStatusBar				m_wndStatusBar;
	CMFCToolBarImages			m_UserImages;
	CParserView					m_wndParserView;
	COutputWnd					m_wndOutput;
	CPropertiesWnd				m_wndProperties;
//	CTestCodeView				m_wndTestCode;
	COutputXmlWnd				m_wndOutputXml;

// private functions
private:
//=================================================================================================
void cb_call Callback
		(
		ICallback::Type	type , 
		object&	obj , 
		void*	param
		);
//=================================================================================================
CMDIChildWnd* CMainFrame::SearchParserView
		(
		unsigned int	item_id
		);
//=================================================================================================
bool CMainFrame::Save();
//=================================================================================================
bool CMainFrame::SaveAs();
//=================================================================================================
void CMainFrame::OutputMsg
		(
		const wstring&						msg , 
		ICallback::OutputMsgParam::Type		type	= ICallback::OutputMsgParam::Normal , 
		ICallback::OutputMsgParam::ShowType show	= ICallback::OutputMsgParam::Show , 
		ICallback::OutputMsgParam::Cmd		cmd		= ICallback::OutputMsgParam::Add
		);			
//=================================================================================================
void CMainFrame::OutputMsg
		(
		const wstring&						msg , 
		int									row , 
		int									column , 
		ICallback::OutputMsgParam::Type		type	= ICallback::OutputMsgParam::Normal , 
		ICallback::OutputMsgParam::ShowType show	= ICallback::OutputMsgParam::Show , 
		ICallback::OutputMsgParam::Cmd		cmd		= ICallback::OutputMsgParam::Add
		);
//=================================================================================================
void CMainFrame::OutputMsg
		(
		Array<wstring>&						msg , 
		ICallback::OutputMsgParam::Type		type	= ICallback::OutputMsgParam::Normal , 
		ICallback::OutputMsgParam::ShowType show	= ICallback::OutputMsgParam::Show , 
		ICallback::OutputMsgParam::Cmd		cmd		= ICallback::OutputMsgParam::Add
		);
//=================================================================================================
wstring ReplaceText
		(
		int			resid , 
		int			row , 
		int			column
		);
//=================================================================================================
iXmlParserProcess CMainFrame::CreateXmlParserProcess();
//=================================================================================================
bool CMainFrame::ExecuteXmlParserProcess
		(
		iXmlParserProcess&		pp
		);
//=================================================================================================
void CMainFrame::ClearOutputXml();
//=================================================================================================
bool CMainFrame::OutputXml
		(
		iXmlParserProcess&		pp
		);
//=================================================================================================
bool CMainFrame::OutputTxp
		(
		const wchar_t*		path
		);
//=================================================================================================
void CMainFrame::UpdateCaption();
//=================================================================================================
bool CMainFrame::WriteProfileInt
		(
		const wchar_t*	section , 
		const wchar_t*	entry , 
		int				value
		);
//=================================================================================================
bool CMainFrame::WriteProfileString
		(
		const wchar_t*	section , 
		const wchar_t*	entry , 
		const wchar_t*	value
		);
//=================================================================================================
int CMainFrame::GetProfileInt
		(
		const wchar_t*	section , 
		const wchar_t*	entry , 
		int				def
		);
//=================================================================================================
wstring CMainFrame::GetProfileString
		(
		const wchar_t*	section , 
		const wchar_t*	entry , 
		const wchar_t*	def
		);
//=================================================================================================
wstring CMainFrame::GetModuleFolder();

// public functions
public:
//=================================================================================================
CMainFrame();
//=================================================================================================
virtual 
~CMainFrame();
//=================================================================================================
void CMainFrame::OpenTestCodeEditor
		(
		int		row		= -1 , 
		int		column	= -1
		);
//=================================================================================================
wstring CMainFrame::GetTestCodePath();
//=================================================================================================
wstring CMainFrame::GetEditorArgs
		(
		int		row		= -1 , 
		int		column	= -1
		);
//=================================================================================================
bool CMainFrame::GetTestCode
		(
		wstring&	source
		);
//=================================================================================================
void CMainFrame::CreateParserView
		(
		iItem&		item
		);
//=================================================================================================
int CMainFrame::AccelSuspend();
//=================================================================================================
int CMainFrame::AccelResume();
//=================================================================================================
void CMainFrame::RegistCmdMsgCallback
		(
		CWnd*		tgt
		);
//=================================================================================================
void CMainFrame::RemoveCmdMsgCallback
		(
		CWnd*		tgt
		);
//=================================================================================================
bool CMainFrame::Load
		(
		const wstring&		path
		);
//=================================================================================================
bool CMainFrame::CanExecuteParser();
//=================================================================================================
void CMainFrame::ExecuteParser();
//=================================================================================================
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
//=================================================================================================
BOOL CreateDockingWindows();
//=================================================================================================
void SetDockingWindowIcons(BOOL bHiColorIcons);

// MFC override
public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL LoadFrame(UINT nIDResource, DWORD dwDefaultStyle = WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, CWnd* pParentWnd = NULL, CCreateContext* pContext = NULL);
	virtual BOOL PreTranslateMessage(MSG* pMsg);

// MFC handler
protected:
	DECLARE_MESSAGE_MAP()
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnWindowManager();
	afx_msg void OnViewCustomize();
	afx_msg LRESULT OnToolbarCreateNew(WPARAM wp, LPARAM lp);
	afx_msg void OnApplicationLook(UINT id);
	afx_msg void OnUpdateApplicationLook(CCmdUI* pCmdUI);
	afx_msg void OnEditRedo();
	afx_msg void OnUpdateEditRedo(CCmdUI *pCmdUI);
	afx_msg void OnEditUndo();
	afx_msg void OnUpdateEditUndo(CCmdUI *pCmdUI);
	afx_msg void OnDestroy();
	afx_msg void OnFileNew();
	afx_msg LRESULT OnToolbarReset(WPARAM,LPARAM);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
public:
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	afx_msg void OnFileOpen();
	afx_msg void OnUpdateFileOpen(CCmdUI *pCmdUI);
	afx_msg void OnFileSave();
	afx_msg void OnUpdateFileSave(CCmdUI *pCmdUI);
	afx_msg void OnFileSaveAs();
	afx_msg void OnUpdateFileSaveAs(CCmdUI *pCmdUI);
	afx_msg void OnUpdateFileNew(CCmdUI *pCmdUI);
	afx_msg void OnClose();
protected:
	virtual void OnUpdateFrameTitle(BOOL bAddToTitle);
public:
	afx_msg void OnEditExecute();
	afx_msg void OnUpdateEditExecute(CCmdUI *pCmdUI);
	afx_msg void OnDropFiles(HDROP hDropInfo);
	afx_msg void OnEditTestcode();
	afx_msg void OnUpdateEditTestcode(CCmdUI *pCmdUI);
	afx_msg void OnEditSetting();
	afx_msg void OnUpdateEditSetting(CCmdUI *pCmdUI);
	afx_msg void OnEditOutputtxp();
	afx_msg void OnUpdateEditOutputtxp(CCmdUI *pCmdUI);
	afx_msg void OnEditProject();
	afx_msg void OnUpdateEditProject(CCmdUI *pCmdUI);
	afx_msg void OnEditHelp();
	afx_msg void OnUpdateEditHelp(CCmdUI *pCmdUI);
};


