// NodePropertyWnd.cpp : t@C
//

#include "stdafx.h"
#include "Texml.h"
#include "NodePropertyWnd.h"


/**************************************************************************************************
"CNodePropertyWnd" class 
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC message map
IMPLEMENT_DYNAMIC(CNodePropertyWnd, CMFCPropertyGridCtrl)

BEGIN_MESSAGE_MAP(CNodePropertyWnd, CMFCPropertyGridCtrl)
	ON_WM_CREATE()
	ON_WM_SETTINGCHANGE()
	ON_WM_DESTROY()
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call CNodePropertyWnd::Callback
		(
		ICallback::Type	type , 
		object&	obj , 
		void*	param
		)
{
	if( type == ICallback::SetPropertyItem )
	{
		ICallback::SetPropertyItemParam*	p = (ICallback::SetPropertyItemParam*)param;
		if( m_parser_id != p->m_tree_id
		||  m_item_id	!= p->m_item_id )
		{
			m_parser_id = p->m_tree_id;
			m_item_id	= p->m_item_id;
//			InitProperty();
		}
		UpdateProperty();
		UpdatePropertyShow();
	}
	else if( /*( type == ICallback::ModifyItemProperty && obj == (object)GetNode() )*/
	      ( type == ICallback::MoveItems && obj == (object)GetParser() ) )
	{
		UpdateProperty();
		UpdatePropertyShow();
	}
	else if( type == ICallback::Undo 
	     ||  type == ICallback::Redo )
	{
		UpdateProperty();
		UpdatePropertyShow();
	} 
}
//=================================================================================================
void CNodePropertyWnd::SetPropListFont()
{
	::DeleteObject(m_fntPropList.Detach());

	LOGFONT lf;
	afxGlobalData.fontRegular.GetLogFont(&lf);

	NONCLIENTMETRICS info;
	info.cbSize = sizeof(info);

	afxGlobalData.GetNonClientMetrics(info);

	lf.lfHeight = info.lfMenuFont.lfHeight;
	lf.lfWeight = info.lfMenuFont.lfWeight;
	lf.lfItalic = info.lfMenuFont.lfItalic;

	m_fntPropList.CreateFontIndirect(&lf);

	SetFont(&m_fntPropList);
}
//=================================================================================================
iParserDoc CNodePropertyWnd::GetParser()
{
	return (iParserDoc)m_document->SearchTreeId( m_parser_id );
}
//=================================================================================================
iParserNode CNodePropertyWnd::GetNode()
{
	iParserDoc	doc		= (iParserDoc)m_document->SearchTreeId( m_parser_id );
	if( doc == false )
		return iParserNode();
	return (iParserNode)doc->SearchParserItemId( m_item_id );
}
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_ClearText
		(
		CMFCPropertyGridProperty*				group
		)
{
	//none
}
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_PushTag
		(
		CMFCPropertyGridProperty*			group
		)
{
	m_props[PushTag_name] = new CMFCPropertyGridProperty
					(
					LoadText( IDS_PROP_0 ), 
					_T(""),
					LoadText( IDS_PROP_1 )
					);
	m_props[PushTag_name]->SetData( PushTag_name );
	m_props[PushTag_name]->Show( FALSE );
	group->AddSubItem( m_props[PushTag_name] );
}
//=================================================================================================
void CNodePropertyWnd::UpdateCmdArg
		(
		IParserNode::Property::PushTagProp&	prop	
		)
{
	m_props[PushTag_name]->SetValue( prop.m_tag.c_str() );
}
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_PopTag
		(
		CMFCPropertyGridProperty*			group
		)
{
	// none
}
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_SetAttr
		(
		CMFCPropertyGridProperty*			group
		)
{
	{
		m_props[SetAttr_name] = new CMFCPropertyGridProperty
						(
						LoadText( IDS_PROP_2 ) , 
						_T("") , 
						LoadText( IDS_PROP_3 )
						);
		m_props[SetAttr_name]->Show( FALSE );
		m_props[SetAttr_name]->SetData( SetAttr_name );
		group->AddSubItem( m_props[SetAttr_name] );					
	}
	{
		m_props[SetAttr_value] = new CMFCPropertyGridProperty
						(
						LoadText( IDS_PROP_4 ) , 
						_T(""),
						LoadText( IDS_PROP_5 )
						);
		m_props[SetAttr_value]->Show( FALSE );
		m_props[SetAttr_value]->SetData( SetAttr_value );
		group->AddSubItem( m_props[SetAttr_value] );
	}
}
//=================================================================================================
void CNodePropertyWnd::UpdateCmdArg
		(
		IParserNode::Property::SetAttrProp&	prop	
		)
{
	m_props[SetAttr_name]->SetValue( prop.m_name.c_str() );
	m_props[SetAttr_value]->SetValue( prop.m_value.c_str() );
}

//=================================================================================================
void CNodePropertyWnd::InitCmdArg_SetAttrText
		(
		CMFCPropertyGridProperty*				group
		)
{
	{
		m_props[SetAttrText_name] = new CMFCPropertyGridProperty
						(
						LoadText( IDS_PROP_6 ) , 
						_T(""),
						LoadText( IDS_PROP_7 )
						);
		m_props[SetAttrText_name]->Show( FALSE );
		m_props[SetAttrText_name]->SetData( SetAttrText_name );
		group->AddSubItem( m_props[SetAttrText_name] );					
	}
}
//=================================================================================================
void CNodePropertyWnd::UpdateCmdArg
		(
		IParserNode::Property::SetAttrTextProp&	prop	
		)
{
	m_props[SetAttrText_name]->SetValue( prop.m_name.c_str() );
}
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_SetText
		(
		CMFCPropertyGridProperty*				group
		)
{
	//none
}
//=================================================================================================
void CNodePropertyWnd::InitProperty()
{
	RemoveAll();
	{
		m_props[Group1]	= new CMFCPropertyGridProperty(LoadText( IDS_PROP_8 ) );
		{
			m_props[XPos]	= new CMFCPropertyGridProperty(LoadText(IDS_PROP_9), (_variant_t)(LONG)0, LoadText( IDS_PROP_10));
			m_props[XPos]->SetData( XPos );
			m_props[XPos]->EnableSpinControl( TRUE, -10000000 , 10000000 );
			m_props[XPos]->Show( FALSE );
			m_props[Group1]->AddSubItem(m_props[XPos]);
		}
		{
			m_props[YPos] = new CMFCPropertyGridProperty( LoadText(IDS_PROP_11), (_variant_t)(LONG)0, LoadText(IDS_PROP_12));
			m_props[YPos]->SetData( YPos );
			m_props[YPos]->EnableSpinControl( TRUE , -1000000 , 1000000 );
			m_props[YPos]->Show( FALSE );
			m_props[Group1]->AddSubItem( m_props[YPos] );
		}
		AddProperty( m_props[Group1] );
	}
	{
		m_props[Group2]	= new CMFCPropertyGridProperty(LoadText(IDS_PROP_13));
		{
			m_props[CmdType] = new CMFCPropertyGridProperty
					(
					LoadText(IDS_PROP_14), 
					_T("") , 
					LoadText(IDS_PROP_15)
					);
			int		off , num = m_nodetype_list.GetDatanum();
			for( off = 2 ; off < num ; off++ )
				m_props[CmdType]->AddOption(m_nodetype_list[ off ]);
			m_props[CmdType]->Show( FALSE );
			m_props[CmdType]->SetData( CmdType );
			m_props[CmdType]->AllowEdit( FALSE );
			m_props[Group2]->AddSubItem( m_props[CmdType] );
		}
		InitCmdArg_ClearText( m_props[Group2] );
		InitCmdArg_PushTag( m_props[Group2] );
		InitCmdArg_PopTag( m_props[Group2] );
		InitCmdArg_SetAttr( m_props[Group2] );
		InitCmdArg_SetAttrText( m_props[Group2] );
		InitCmdArg_SetText( m_props[Group2] );
		AddProperty( m_props[Group2] );
	}
}
//=================================================================================================
void CNodePropertyWnd::UpdateProperty()
{
	iParserNode	node	= GetNode();
	if( node == false )
		return;
	IParserNode::Property	prop	= node->GetProperty();
	m_props[XPos]->SetValue( (_variant_t)(LONG)prop.m_pos.x );
	m_props[YPos]->SetValue( (_variant_t)(LONG)prop.m_pos.y );
	m_props[CmdType]->SetValue( m_nodetype_list[ prop.m_type ] );
	if( prop.m_type == IParserNode::Property::Start || prop.m_type == IParserNode::Property::End )
		m_props[CmdType]->Enable( FALSE );
	else
		m_props[CmdType]->Enable( TRUE );
	UpdateCmdArg( prop.m_pushtag_prop );
	UpdateCmdArg( prop.m_setattr_prop );
	UpdateCmdArg( prop.m_setattrtext_prop );
}
//=================================================================================================
void CNodePropertyWnd::UpdatePropertyShow()
{
	iParserNode	node	= GetNode();
	if( node == false )
	{
		m_props[Group1]->Show( FALSE );
		m_props[Group2]->Show( FALSE );
		return;
	}
	IParserNode::Property		prop	= node->GetProperty();
	
	m_props[Group1]->Show( TRUE );
	m_props[Group2]->Show( TRUE );
	m_props[XPos]->Show( TRUE );
	m_props[YPos]->Show( TRUE );
	m_props[CmdType]->Show( TRUE );
	m_props[PushTag_name]->Show( prop.m_type == IParserNode::Property::PushTag ? TRUE : FALSE );
	m_props[SetAttr_name]->Show( prop.m_type == IParserNode::Property::SetAttr ? TRUE : FALSE );
	m_props[SetAttr_value]->Show( prop.m_type == IParserNode::Property::SetAttr ? TRUE : FALSE );
	m_props[SetAttrText_name]->Show( prop.m_type == IParserNode::Property::SetAttrText ? TRUE : FALSE );
}
//=================================================================================================
void CNodePropertyWnd::PropertyChanged
		(
		CMFCPropertyGridProperty* pprop 
		)
{
	iParserNode	node	= GetNode();
	if( node == false )
		return;
		
	IParserNode::Property	prop	= node->GetProperty();
	if( m_props[XPos] == pprop )
	{
		prop.m_pos.x	= (_variant_t)pprop->GetValue();
	}
	else if( m_props[YPos] == pprop )
	{
		prop.m_pos.y	= (_variant_t)pprop->GetValue();
	}
	else if( m_props[CmdType] == pprop )
	{
		CString	name = pprop->GetValue();
		int		off , num = m_nodetype_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( m_nodetype_list[off] == name )
			{
				prop.m_type = (IParserNode::Property::Type)off;
				break;
			}
		}		
	}
	else if( m_props[PushTag_name] == pprop )
	{
		CString	t = pprop->GetValue();
		prop.m_pushtag_prop.m_tag = t;
	}
	else if( m_props[SetAttr_name] == pprop )
	{
		CString	t = pprop->GetValue();
		prop.m_setattr_prop.m_name = t;
	}
	else if( m_props[SetAttr_value] == pprop )
	{
		CString	t = pprop->GetValue();
		prop.m_setattr_prop.m_value = t;
	}
	else if( m_props[SetAttrText_name] == pprop )
	{
		CString	t = pprop->GetValue();
		prop.m_setattrtext_prop.m_name = t;
	}
	else
		return;
	
	IUndoList*	undo = m_document->Recode();
	node->SetProperty( prop , undo );
	m_document->Callback( ICallback::ModifyItemProperty , (object)GetParser() , 0 );
	UpdatePropertyShow();
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CNodePropertyWnd::CNodePropertyWnd() : 
		m_parser_id( 0 ) , 
		m_item_id( 0 )
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );

	int		off , num = _countof( m_props );
	for( off = 0 ; off < num ; off++ )
		m_props[off] = 0;
	{
		int		num = IParserNode::Property::Desc + 1;
		m_nodetype_list.Resize( num );
		m_nodetype_list[IParserNode::Property::Start]		= LoadText(IDS_PROP_16);
		m_nodetype_list[IParserNode::Property::End]			= LoadText(IDS_PROP_17);
		m_nodetype_list[IParserNode::Property::None]		= LoadText(IDS_PROP_18);
		m_nodetype_list[IParserNode::Property::ClearText]	= LoadText(IDS_PROP_19);
		m_nodetype_list[IParserNode::Property::PushTag]		= LoadText(IDS_PROP_20);
		m_nodetype_list[IParserNode::Property::PopTag]		= LoadText(IDS_PROP_21);
		m_nodetype_list[IParserNode::Property::SetAttr]		= LoadText(IDS_PROP_22);
		m_nodetype_list[IParserNode::Property::SetAttrText]	= LoadText(IDS_PROP_23);
		m_nodetype_list[IParserNode::Property::SetText]		= LoadText(IDS_PROP_24);
		m_nodetype_list[IParserNode::Property::PushText]	= LoadText(IDS_PROP_47);
		m_nodetype_list[IParserNode::Property::PopText]		= LoadText(IDS_PROP_48);
		m_nodetype_list[IParserNode::Property::Desc]		= LoadText(IDS_PROP_49);
	}
}
//=================================================================================================
CNodePropertyWnd::~CNodePropertyWnd()
{
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC override functions
//=================================================================================================
void CNodePropertyWnd::OnPropertyChanged
		(
		CMFCPropertyGridProperty* pProp 
		)const
{
	typedef void (CNodePropertyWnd::*FuncType)(CMFCPropertyGridProperty*)const;
	FuncType	func = (FuncType)&CNodePropertyWnd::PropertyChanged;
	(this->*func)( pProp );

	__super::OnPropertyChanged( pProp );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
int CNodePropertyWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMFCPropertyGridCtrl::OnCreate(lpCreateStruct) == -1)
		return -1;

	SetPropListFont();
	EnableHeaderCtrl( FALSE );
	EnableDescriptionArea();
	SetVSDotNetLook();
	MarkModifiedProperties();
	InitProperty();
	UpdatePropertyShow();

	return 0;
}
void CNodePropertyWnd::OnDestroy()
{
	m_parser_id	= 0;
	m_item_id	= 0;
//	RemoveAll();

	__super::OnDestroy();
}
//=================================================================================================
void CNodePropertyWnd::OnSettingChange(UINT uFlags, LPCTSTR lpszSection)
{
//	__super::OnSettingChange(uFlags, lpszSection);

	SetPropListFont();
}

