// OutputXmlCtrlWnd.cpp : t@C
//

#include "stdafx.h"
#include "Texml.h"
#include "OutputXmlCtrlWnd.h"


/**************************************************************************************************
"COutputXmlCtrlWnd" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event map
IMPLEMENT_DYNAMIC(COutputXmlCtrlWnd, CTreeCtrl)
BEGIN_MESSAGE_MAP(COutputXmlCtrlWnd, CTreeCtrl)
	ON_WM_CREATE()
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call COutputXmlCtrlWnd::Callback
		(
		Type	type , 
		object&	obj , 
		void*	param
		)
{
	if( type == ICallback::OutputXml )
	{
		UpdateTree( ((ICallback::OutputXmlParam*)param)->m_doc );
	}
}
//=================================================================================================
HTREEITEM COutputXmlCtrlWnd::InsertItem
		(
		const wchar_t*	str , 
		int				image , 
		bool			expand , 
		HTREEITEM		parent
		)
{
	return CTreeCtrl::InsertItem
			(
			TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_STATE ,
			str , 
			image , 
			image , 
			expand == true ? TVIS_EXPANDED : 0 , 
			TVIS_EXPANDED , 
			0 , 
			parent , 
			TVI_LAST
			);
}
//=================================================================================================
void COutputXmlCtrlWnd::UpdateItem
		(
		HTREEITEM		parent , 
		DOMNode*		node
		)
{
	if( node == 0 )
		return;
	HTREEITEM			hitem	= NULL;
	DOMNode::NodeType	type	= (DOMNode::NodeType)node->getNodeType();
	if( type == DOMNode::ELEMENT_NODE )
	{
		cb_trace( L"ELEMENT_NODE\n" );
		hitem	= InsertItem( node->getNodeName() , 1 , true , parent );
	}
	else if( type == DOMNode::ATTRIBUTE_NODE )
	{
		cb_trace( L"ATTRIBUTE_NODE\n" );
		HTREEITEM	hattr	= InsertItem( node->getNodeName() , 2 , true , parent );
		InsertItem( node->getNodeValue() , 3 , true , hattr );
	}
	else if( type == DOMNode::TEXT_NODE )
	{
		cb_trace( L"TEXT_NODE\n" );
		InsertItem( node->getNodeValue() , 4 , true , parent );
	}
	else if( type == DOMNode::CDATA_SECTION_NODE )
	{
		cb_trace( L"CDATA_SECTION_NODE\n" );
	}
	else if( type == DOMNode::ENTITY_REFERENCE_NODE )
	{
		cb_trace( L"ENTITY_REFERENCE_NODE\n" );
	}
	else if( type == DOMNode::ENTITY_NODE )
	{
		cb_trace( L"ENTITY_NODE\n" );
	}
	else if( type == DOMNode::PROCESSING_INSTRUCTION_NODE )
	{
		cb_trace( L"PROCESSING_INSTUCTION_NODE\n" );
	}
	else if( type == DOMNode::COMMENT_NODE )
	{
		cb_trace( L"COMMENT_NODE\n" );
	}
	else if( type == DOMNode::DOCUMENT_NODE )
	{
		cb_trace( L"DOCUMENT_NODE\n" );
		hitem	= InsertItem( node->getNodeName() , 0 , true , parent );
	}
	else if( type == DOMNode::DOCUMENT_TYPE_NODE )
	{
		cb_trace( L"DOCUMENT_TYPE_NODE\n" );
		DOMDocumentType*	type = (DOMDocumentType*)node;
		HTREEITEM	htype = InsertItem( type->getName() , 5 , true , parent );
		wstring		publicid( type->getPublicId() );
		wstring		systemid( type->getSystemId() );
		if( publicid.empty() == false )
			InsertItem( publicid.c_str() , 6 , true , htype );
		if( systemid.empty() == false )
			InsertItem( systemid.c_str() , 7 , true , htype );
		
//		InsertItem( node->getNodeValue() , 5 , true , htype );
	}
	else if( type == DOMNode::DOCUMENT_FRAGMENT_NODE )
	{
		cb_trace( L"DOCUMENT_FRAGMENT_NODE\n" );
	}
	else if( type == DOMNode::NOTATION_NODE )
	{
		cb_trace( L"NOTATION_NODE\n" );
	}
	if( hitem == NULL )
		return;
		
	DOMNamedNodeMap*	attrs	= node->getAttributes();
	if( attrs != 0 )
	{
		int		off , num = attrs->getLength();
		for( off = 0 ; off < num ; off++ )
		{
			UpdateItem( hitem , attrs->item( off ) );
		}
	}

	DOMNodeList* children = node->getChildNodes();
	if( children != 0 )
	{
		int		off , num = children->getLength();
		for( off = 0 ; off < num ; off++ )
		{
			UpdateItem( hitem , children->item( off ) );
		}
	}
}
//=================================================================================================
void COutputXmlCtrlWnd::UpdateTree
		(
		XERCES_CPP_NAMESPACE::DOMDocument*	doc
		)
{
	DeleteAllItems();
	if( doc == 0 )
		return;
	UpdateItem( NULL , doc );
}
//=================================================================================================
void COutputXmlCtrlWnd::ExpandAll
		(
		HTREEITEM	item , 
		bool		expand
		)
{
	Expand( item , expand == true ? TVE_EXPAND : TVE_COLLAPSE );

	HTREEITEM	child = GetChildItem( item );
	while( child != NULL )
	{
		ExpandAll( child , expand );
		child	= GetNextItem( child , TVGN_NEXT );
	}
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
COutputXmlCtrlWnd::COutputXmlCtrlWnd()
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );
}
//=================================================================================================
COutputXmlCtrlWnd::~COutputXmlCtrlWnd()
{
}
//=================================================================================================
void COutputXmlCtrlWnd::ExpandAll
		(
		bool		expand
		)
{
	ExpandAll( TVI_ROOT , expand );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
int COutputXmlCtrlWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (__super::OnCreate(lpCreateStruct) == -1)
		return -1;

	m_imagelist.DeleteImageList();
	UINT bmpid = theApp.m_bHiColorIcons ? IDB_OUTPUTXMLCTRLWND_ITEM_24 : IDB_OUTPUTXMLCTRLWND_ITEM;
	CBitmap bmp;
	if ( !bmp.LoadBitmap( bmpid ) )
	{
		TRACE(_T("bitmap load error: %x\n"), bmpid);
		ASSERT(FALSE);
		return 0;
	}
	BITMAP bmpobj;
	bmp.GetBitmap( &bmpobj );
	UINT flags = ILC_MASK | ( (theApp.m_bHiColorIcons) ? ILC_COLOR24 : ILC_COLOR4 );

	m_imagelist.Create( 16 , bmpobj.bmHeight , flags , 0 , 0 );
	m_imagelist.Add( &bmp , RGB( 192, 192, 192 ) );
	SetImageList( &m_imagelist, TVSIL_NORMAL );

	return 0;
}
