
// ParseEditCtrlView.cpp : CParseEditCtrlView NX̎
//

#include "stdafx.h"
#include "Texml.h"
#include "ParseEditCtrlView.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

/**************************************************************************************************
"CDescEdit" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event map
IMPLEMENT_DYNAMIC(CDescEdit, CRichEditCtrl)
BEGIN_MESSAGE_MAP(CDescEdit, CRichEditCtrl)
	ON_WM_CREATE()
//	ON_NOTIFY_REFLECT(EN_REQUESTRESIZE, &CDescEdit::OnEnRequestresize)
	ON_WM_CONTEXTMENU()
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CDescEdit::CDescEdit()
{

}
//=================================================================================================
CDescEdit::~CDescEdit()
{
}
//=================================================================================================
void CDescEdit::Initialize
		(
		const wstring&	facename , 
		int				height , 
		const rgb&		c , 
		const rgb&		bkc , 
		const isize&	min
		)
{
	m_color		= c;
	m_bkcolor	= bkc;
	m_facename	= facename;
	m_height	= height;
	m_min		= min;
}
//=================================================================================================
void CDescEdit::SetPos
		(
		const ivector2&		pos
		)
{
	m_pos	= pos;
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC override
//=================================================================================================
BOOL CDescEdit::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style |= ES_MULTILINE | ES_AUTOHSCROLL | ES_AUTOVSCROLL;
	return CRichEditCtrl::PreCreateWindow(cs);
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
int CDescEdit::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CRichEditCtrl::OnCreate(lpCreateStruct) == -1)
		return -1;
	SetEventMask( ENM_REQUESTRESIZE | ENM_CHANGE );

	HDC		hdc	= ::GetDC( NULL );
	float	dpi	= (float)::GetDeviceCaps( hdc , LOGPIXELSY );
	::ReleaseDC( NULL , hdc );

	LPARAM	option = SendMessage( EM_GETLANGOPTIONS , 0 , 0 );
	option &= ~IMF_DUALFONT;
	SendMessage( EM_SETLANGOPTIONS , 0 , option );

	SetBackgroundColor( FALSE , RGB( m_bkcolor.r , m_bkcolor.g , m_bkcolor.b ) );
	{
		PARAFORMAT2	fmt;
		::ZeroMemory( &fmt , sizeof( fmt ) );
		fmt.cbSize				= sizeof( fmt );
		fmt.dwMask				= PFM_LINESPACING;
		fmt.dyLineSpacing		= 0;
		fmt.bLineSpacingRule	= 0;
		cb_verify( 0 != SetParaFormat( fmt ) );
	}
	{
		CHARFORMAT2	fmt;
		::ZeroMemory( &fmt , sizeof( fmt ) );
		fmt.cbSize				= sizeof( fmt );
		fmt.dwMask				= CFM_SIZE | CFM_FACE | CFM_SPACING | CFM_STYLE | CFM_UNDERLINETYPE | CFM_COLOR;
		fmt.yHeight				=  (int)( 1440 * m_height / dpi );
		fmt.crTextColor			= RGB( m_color.r , m_color.g , m_color.b );
		wcscpy_s( fmt.szFaceName , _countof( fmt.szFaceName ) , LoadText( IDS_PARSEEDIT_DESC_FACENAME ) );
		fmt.sSpacing			= 0;
		SendMessage( EM_SETCHARFORMAT , SCF_DEFAULT , (LPARAM)&fmt );
		SendMessage( EM_SETCHARFORMAT , SCF_ALL , (LPARAM)&fmt );
	}
	
	{
		IRichEditOleCallback	*callback = new CDescEditRichEditOleCallback();
		SetOLECallback( callback );
		callback->Release();
	}	
	return 0;
}
//=================================================================================================
void CDescEdit::OnContextMenu(CWnd* /*pWnd*/, CPoint /*point*/)
{
}
/**************************************************************************************************
"CParseEditCtrlView" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC message map
BEGIN_MESSAGE_MAP(CParseEditCtrlView, CWnd)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_WM_MOUSEHWHEEL()
	ON_WM_MOUSEWHEEL()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_CANCELMODE()
	ON_WM_TIMER()
	ON_WM_KEYDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_CREATE()
	ON_WM_CHAR()
	ON_EN_KILLFOCUS( ID_DESC_EDIT , OnKillFocusDescEdit )
	ON_EN_CHANGE( ID_DESC_EDIT , OnChangeDescEdit )
	ON_NOTIFY( EN_REQUESTRESIZE, ID_DESC_EDIT, OnRequestResizeDescEdit )
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// static variable
iTexture	CParseEditCtrlView::m_node_start_img;
iTexture	CParseEditCtrlView::m_node_end_img;
iTexture	CParseEditCtrlView::m_node_none_img;
iTexture	CParseEditCtrlView::m_node_cleartext_img;
iTexture	CParseEditCtrlView::m_node_pushtag_img;
iTexture	CParseEditCtrlView::m_node_poptag_img;
iTexture	CParseEditCtrlView::m_node_setattr_img;
iTexture	CParseEditCtrlView::m_node_setattrtext_img;
iTexture	CParseEditCtrlView::m_node_settext_img;
iTexture	CParseEditCtrlView::m_node_pushtext_img;
iTexture	CParseEditCtrlView::m_node_poptext_img;

///////////////////////////////////////////////////////////////////////////////////////////////////
// trans functions

//=================================================================================================
bool CParseEditCtrlView::ts_0to0_select(void*p)
{
	static
	int		tbl[] = 
	{
		ev_None , 
		ev_Item , 
		ev_InputPin , 
		ev_OutputPin , 
		ev_Item , 
		ev_ReconnectInput , 
		ev_ReconnectOutput , 
		ev_LinkbarCtrl
	};
	TransParam*	tp	= (TransParam*)p;
	m_add_mode		= IsAddMode();
	m_drag_start	= ClientToWorld( tp->m_pos );
	StaticStateTrans::ChangeState( tbl[ HitArea( tp->m_pos , &m_edit_item ) ] , *tp );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_0to0_dblclick(void*p)
{
	TransParam*	tp	= (TransParam*)p;
	AreaType	type	= HitArea( tp->m_pos , &m_edit_item );
	if( type != Node )
		return true;
	iParserNode	node	= SearchNodeId( m_edit_item );
	if( node == false )
		return true;
	if( node->GetProperty().m_type != IParserNode::Property::Desc )
		return true;
	StaticStateTrans::ChangeState( ev_EditDesc , *tp );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_0to0(void*p)
{
	TransParam*	tp	= (TransParam*)p;
	AreaType	type= HitArea( tp->m_pos , 0 );
	if( type == InputPin )
		SetCursor(AfxGetApp()->LoadCursor( IDC_INPUT_PIN ) );
	else if( type == OutputPin )
		SetCursor(AfxGetApp()->LoadCursor( IDC_OUTPUT_PIN ) );
	else if( type == InputReconnectPin )
		SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN ) );
	else if( type == OutputReconnectPin )
		SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN ) );
	else if( type == LinkBarCtrl )
		SetCursor(AfxGetApp()->LoadCursor( IDC_LINKBAR_CTRL ) );
	else
		SetCursor(AfxGetApp()->LoadStandardCursor( IDC_ARROW ) );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_0to1(void*p)
{
	SetCursor(AfxGetApp()->LoadCursor( IDC_LINKBAR_CTRL ) );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_0to3(void*p)
{
	// none
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_0to5(void*p)
{
	// none
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_0to7(void*p)
{
	TransParam*	tp	= (TransParam*)p;
	SetTimer( 1 , m_autoscroll_interval , NULL );
	SetCapture();
	SetCursor(AfxGetApp()->LoadCursor( IDC_INPUT_PIN ) );

	DrawSurface();
	DrawEditLink( m_edit_item , InputPin , tp->m_pos );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_0to8(void*p)
{
	TransParam*	tp	= (TransParam*)p;
	SetTimer( 1 , m_autoscroll_interval , NULL );
	SetCapture();
	SetCursor(AfxGetApp()->LoadCursor( IDC_OUTPUT_PIN ) );

	DrawSurface();
	DrawEditLink( m_edit_item , OutputPin , tp->m_pos );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_0to9(void*p)
{
	SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN ) );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_0to11(void*p)
{
	SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN ) );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_0to13(void*p)
{
	iParserNode				node = SearchNodeId( m_edit_item );
	IParserNode::Property	prop = node->GetProperty();
	cb_assert( prop.m_type == IParserNode::Property::Desc , L"algorithm error." );
	
	ivector2	pos;
	isize		size;
	GetNodePos( node , &pos , &size , 0 );

	m_desc_edit.SetWindowText( prop.m_desc_prop.m_desc.c_str() );	
	m_desc_edit.SetPos( pos + ivector2( m_desc_margin.width - 1 , size.height / 2 ) );
	m_desc_edit.RequestResize();
	m_desc_edit.ShowWindow( SW_NORMAL );
	m_desc_edit.SetFocus();

	( (CMainFrame*)AfxGetMainWnd() )->AccelSuspend();

	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_1to0(void*p)
{
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_1to1(void*p)
{
	SetCursor(AfxGetApp()->LoadCursor( IDC_LINKBAR_CTRL ) );
	TransParam*	tp	= (TransParam*)p;
	ivector2	dp	= tp->m_pos - WorldToClient( m_drag_start );
	if( dp.x * dp.x + dp.y * dp.y < m_drag_len )
		return true;
	StaticStateTrans::ChangeState( ev_Next , *tp );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_1to2(void*p)
{
	iParserLink	link = SearchItemId( m_edit_item );
	if( link == false )
		return false;

	TransParam*	tp	= (TransParam*)p;
	GetLinkInfo( link , ivector2() , 0 , 0 , 0 , 0 , 0 , &m_linkbar_start , 0 );
	m_linkbar_mov	= tp->m_pos.x - WorldToClient( m_drag_start ).x;

	cb_assert( m_undo == 0 , L"algorithm error." );
	m_undo	= m_document->Recode();
	if( true == SetLinkbarWidth( m_edit_item , m_linkbar_start + m_linkbar_mov , true , m_undo ) )
		m_document->Callback( ICallback::ResizeLinkbar , (object)m_document->SearchTreeId( m_item_id ) , 0 );
	
	SetCursor(AfxGetApp()->LoadCursor( IDC_LINKBAR_CTRL ) );
	SetCapture();
	SetTimer( 1 , m_autoscroll_interval , NULL );

	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_2to2(void*p)
{
	SetCursor(AfxGetApp()->LoadCursor( IDC_LINKBAR_CTRL ) );
	TransParam*	tp	= (TransParam*)p;

	m_linkbar_mov	= tp->m_pos.x - WorldToClient( m_drag_start ).x;
	if( false == SetLinkbarWidth( m_edit_item , m_linkbar_start + m_linkbar_mov , true , 0 ) )
	{	
		DrawSurface();
		SurfaceBlt();
	}
	else
	{
		m_document->Callback( ICallback::ResizeLinkbar , (object)m_document->SearchTreeId( m_item_id ) , 0 );
	}
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_2to2_timer(void*p)
{
	SetCursor(AfxGetApp()->LoadCursor( IDC_LINKBAR_CTRL ) );
	ivector2	pos;
	if( false == AutoScroll( &pos ) )
		return true;

	m_linkbar_mov	= pos.x - WorldToClient( m_drag_start ).x;
	if( false == SetLinkbarWidth( m_edit_item , m_linkbar_start + m_linkbar_mov , true , 0 ) )
	{
		DrawSurface();
		SurfaceBlt();
	}
	else
	{
		m_document->Callback( ICallback::ResizeLinkbar , (object)m_document->SearchTreeId( m_item_id ) , 0 );
	}
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_2to0(void*p)
{
	SetCursor(AfxGetApp()->LoadStandardCursor( IDC_ARROW ) );
	ReleaseCapture();
	KillTimer( 1 );

	if( false == SetLinkbarWidth( m_edit_item , m_linkbar_start + m_linkbar_mov , true , m_undo ) )
	{
		m_undo	= 0;
		DrawSurface();
		SurfaceBlt();
	}
	else
	{
		m_undo	= 0; 
		m_document->Callback( ICallback::ResizeLinkbar , (object)m_document->SearchTreeId( m_item_id ) , 0 );
	}
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_2to0_canel(void*p)
{
	SetCursor(AfxGetApp()->LoadStandardCursor( IDC_ARROW ) );
	KillTimer( 1 );

	if( false == SetLinkbarWidth( m_edit_item , m_linkbar_start + m_linkbar_mov , true , m_undo ) )
	{
		m_undo	= 0;
		DrawSurface();
		SurfaceBlt();
	}
	else
	{
		m_undo	= 0;
		m_document->Callback( ICallback::ResizeLinkbar , (object)m_document->SearchTreeId( m_item_id ) , 0 );
	}
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_3to3(void*p)
{
	TransParam*	tp	= (TransParam*)p;
	ivector2	dp	= tp->m_pos - WorldToClient( m_drag_start );
	if( dp.x * dp.x + dp.y * dp.y < m_drag_len )
		return true;
	StaticStateTrans::ChangeState( ev_Next , *tp );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_3to0(void*p)
{
	if( m_add_mode == true )
		ToggleSelect( m_edit_item );
	else
		SetSelect( m_edit_item );

	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_3to4(void*p)
{
	SetCapture();
	SetTimer( 1 , m_autoscroll_interval , NULL );

	TransParam*	tp	= (TransParam*)p;
	if( m_add_mode == true )
		AddSelect( m_edit_item );
	else
	{
		if( -1 == SearchSelect( m_edit_item ) )
			SetSelect( m_edit_item );
	}
	DrawSurface();
	DrawMoveItem( m_edit_item , tp->m_pos - WorldToClient( m_drag_start ) , true );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_4to4(void*p)
{
	TransParam*	tp	= (TransParam*)p;
	DrawSurface();
	DrawMoveItem( m_edit_item , tp->m_pos - WorldToClient( m_drag_start ) , true );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_4to4_timer(void*p)
{
	ivector2	pos;
	if( false == AutoScroll( &pos ) )
		return true;
	DrawSurface();
	DrawMoveItem( m_edit_item , pos - WorldToClient( m_drag_start ) , true );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_4to0(void*p)
{
	TransParam*	tp	= (TransParam*)p;
	ReleaseCapture();
	KillTimer( 1 );
	
	if( false == MoveSelectItem( m_edit_item , tp->m_pos - WorldToClient( m_drag_start ) , true ) )
	{
		DrawSurface();
		SurfaceBlt();
	}
	else
	{
		m_document->Callback( ICallback::MoveItems , (object)m_document->SearchTreeId( m_item_id ) , 0 );
	}
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_4to0_cancel(void*p)
{
	KillTimer( 1 );
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_5to5(void*p)
{
	TransParam*	tp	= (TransParam*)p;
	ivector2	dp	= tp->m_pos - WorldToClient( m_drag_start );
	if( dp.x * dp.x + dp.y * dp.y < m_drag_len )
		return true;
	StaticStateTrans::ChangeState( ev_Next , *tp );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_5to0(void*p)
{
	if( m_add_mode != true )
		ResetSelect();
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_5to6(void*p)
{
	SetCapture();
	SetTimer( 1 , m_autoscroll_interval , NULL );

	TransParam*	tp	= (TransParam*)p;
	if( m_add_mode == true )
		m_select_num	= m_select.GetDatanum();
	else
		ResetSelect();

	DrawSurface();
	DrawRect( irect( WorldToClient( m_drag_start ) , tp->m_pos ) , m_paint_select , m_paint_select_stroke );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_6to6(void*p)
{
	TransParam*	tp	= (TransParam*)p;

	if( m_add_mode == true )
	{
		m_select.ResizeHold( m_select_num );
		AddSelect( irect( WorldToClient( m_drag_start ) , tp->m_pos ).Normalize());
	}
	else
		SetSelect( irect( WorldToClient( m_drag_start ) , tp->m_pos ).Normalize());
	DrawSurface();
	DrawRect( irect( WorldToClient( m_drag_start ) , tp->m_pos ) , m_paint_select , m_paint_select_stroke );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_6to6_timer(void*p)
{
	ivector2	pos;
	if( false == AutoScroll( &pos ) )
		return true;
	SetSelect( irect( WorldToClient( m_drag_start ) , pos ).Normalize());
	DrawSurface();
	DrawRect( irect( WorldToClient( m_drag_start ) , pos ) , m_paint_select , m_paint_select_stroke );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_6to0(void*p)
{
	ReleaseCapture();
	KillTimer( 1 );
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_6to0_cancel(void*p)
{
	KillTimer( 1 );
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_7to7(void*p)
{
	TransParam*		tp	= (TransParam*)p;
	ivector2		tgt	= tp->m_pos;
	unsigned int	t_item;
	AreaType		type= HitArea( tp->m_pos , &t_item );
	if( type == OutputPin && IsEnablePin( t_item , type ) )
	{
		tgt	= WorldToClient( GetPinPos( t_item , type ) );
		SetCursor(AfxGetApp()->LoadCursor( IDC_INPUT_PIN_LINK ) );
	}
	else
		SetCursor(AfxGetApp()->LoadCursor( IDC_INPUT_PIN ) );

	DrawSurface();
	DrawEditLink( m_edit_item , InputPin , tgt );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_7to7_timer(void*p)
{
	ivector2	pos;
	if( false == AutoScroll( &pos ) )
		return true;
		
	DrawSurface();
	DrawEditLink( m_edit_item , InputPin , pos );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_7to0(void*p)
{
	KillTimer( 1 );
	ReleaseCapture();
	
	TransParam*	tp	= (TransParam*)p;
	unsigned int	t_item;
	AreaType		type= HitArea( tp->m_pos , &t_item );
	if( type == OutputPin && IsEnablePin( t_item , type ) )
	{
		AddLink( (iGraphNode)SearchNodeId( t_item ) , (iGraphNode)SearchNodeId( m_edit_item ) , true );
		return true;
	}
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_7to0_cancel(void*p)
{
	KillTimer( 1 );
	SetCursor(AfxGetApp()->LoadStandardCursor( IDC_ARROW ) );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_8to8(void*p)
{
	TransParam*		tp	= (TransParam*)p;
	ivector2		tgt	= tp->m_pos;
	unsigned int	t_item;
	AreaType		type= HitArea( tp->m_pos , &t_item );
	if( type == InputPin && IsEnablePin( t_item , type ) )
	{
		tgt	= WorldToClient( GetPinPos( t_item , type ) );
		SetCursor(AfxGetApp()->LoadCursor( IDC_OUTPUT_PIN_LINK ) );
	}
	else
		SetCursor(AfxGetApp()->LoadCursor( IDC_OUTPUT_PIN ) );

	DrawSurface();
	DrawEditLink( m_edit_item , OutputPin , tgt );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_8to8_timer(void*p)
{
	ivector2	pos;
	if( false == AutoScroll( &pos ) )
		return true;
		
	DrawSurface();
	DrawEditLink( m_edit_item , OutputPin , pos );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_8to0(void*p)
{
	KillTimer( 1 );
	ReleaseCapture();
	
	TransParam*	tp	= (TransParam*)p;
	unsigned int	t_item;
	AreaType		type= HitArea( tp->m_pos , &t_item );
	if( type == InputPin && IsEnablePin( t_item , type ) )
	{
		AddLink( (iGraphNode)SearchNodeId( m_edit_item ) , (iGraphNode)SearchNodeId( t_item ) , true );
		return true;
	}
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_8to0_cancel(void*p)
{
	KillTimer( 1 );
	SetCursor(AfxGetApp()->LoadStandardCursor( IDC_ARROW ) );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_9to0(void*p)
{
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_9to9(void*p)
{
	SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN ) );
	TransParam*	tp	= (TransParam*)p;
	ivector2	dp	= tp->m_pos - WorldToClient( m_drag_start );
	if( dp.x * dp.x + dp.y * dp.y < m_drag_len )
		return true;
	StaticStateTrans::ChangeState( ev_Next , *tp );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_9to10(void*p)
{
	SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN ) );
	SetCapture();
	SetTimer( 1 , m_autoscroll_interval , NULL );

	TransParam*	tp	= (TransParam*)p;
	DrawSurface();
	DrawLink( (iParserLink)SearchItemId( m_edit_item ) , tp->m_pos - WorldToClient( m_drag_start ) , 100 , false , &tp->m_pos , 0 );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_10to10(void*p)
{
	TransParam*	tp	= (TransParam*)p;

	unsigned int	t_item;
	AreaType		type= HitArea( tp->m_pos , &t_item );
	ivector2		tgt	= tp->m_pos;
	if( type == OutputPin && IsEnablePin( t_item , type ) )
	{
		tgt	= WorldToClient( GetPinPos( t_item , type ) );
		SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN_LINK ) );
	}
	else
		SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN ) );

	DrawSurface();
	DrawLink( (iParserLink)SearchItemId( m_edit_item ) , tgt - WorldToClient( m_drag_start ) , 100 , false , &tgt , 0 );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_10to10_timer(void*p)
{
	ivector2	pos;
	if( false == AutoScroll( &pos ) )
		return true;
	DrawSurface();
	DrawLink( (iParserLink)SearchItemId( m_edit_item ) , pos - WorldToClient( m_drag_start ) , 100 , false , &pos , 0 );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_10to0(void*p)
{
	SetCursor(AfxGetApp()->LoadStandardCursor( IDC_ARROW ) );
	ReleaseCapture();
	KillTimer( 1 );

	TransParam*	tp	= (TransParam*)p;
	unsigned int	t_item;
	AreaType		type= HitArea( tp->m_pos , &t_item );
	if( type == OutputPin && IsEnablePin( t_item , type ) )
	{
		iGraphLink		link	= (iGraphLink)SearchItemId( m_edit_item );
		iGraphNode		node	= (iGraphNode)SearchNodeId( t_item );
		if( link == true && node == true )
		{
			IUndoList*	undo	= m_document->Recode();
			link->SetInput( node , node->GetOutputNum() , undo );
			m_document->Callback( ICallback::ReconnectLink , (object)m_document->SearchTreeId( m_item_id ) , 0 );
			return true;
		}		
	}
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_10to0_canel(void*p)
{
	SetCursor(AfxGetApp()->LoadStandardCursor( IDC_ARROW ) );
	KillTimer( 1 );
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_11to0(void*p)
{
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_11to11(void*p)
{
	SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN ) );
	TransParam*	tp	= (TransParam*)p;
	ivector2	dp	= tp->m_pos - WorldToClient( m_drag_start );
	if( dp.x * dp.x + dp.y * dp.y < m_drag_len )
		return true;
	StaticStateTrans::ChangeState( ev_Next , *tp );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_11to12(void*p)
{
	SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN ) );
	SetCapture();
	SetTimer( 1 , m_autoscroll_interval , NULL );

	TransParam*	tp	= (TransParam*)p;
	DrawSurface();
	DrawLink( (iParserLink)SearchItemId( m_edit_item ) , tp->m_pos - WorldToClient( m_drag_start ) , 100 , false , 0 , &tp->m_pos );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_12to12(void*p)
{
	TransParam*	tp	= (TransParam*)p;

	unsigned int	t_item;
	AreaType		type= HitArea( tp->m_pos , &t_item );
	ivector2		tgt	= tp->m_pos;
	if( type == InputPin && IsEnablePin( t_item , type ) )
	{
		tgt	= WorldToClient( GetPinPos( t_item , type ) );
		SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN_LINK ) );
	}
	else
		SetCursor(AfxGetApp()->LoadCursor( IDC_RECONNECT_PIN ) );

	DrawSurface();
	DrawLink( (iParserLink)SearchItemId( m_edit_item ) , ivector2( 0 , 0 ) , 100 , false , 0 , &tgt );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_12to12_timer(void*p)
{
	ivector2	pos;
	if( false == AutoScroll( &pos ) )
		return true;
	DrawSurface();
	DrawLink( (iParserLink)SearchItemId( m_edit_item ) , ivector2( 0 , 0 ) , 100 , false , 0 , &pos  );
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_12to0(void*p)
{
	SetCursor(AfxGetApp()->LoadStandardCursor( IDC_ARROW ) );
	ReleaseCapture();
	KillTimer( 1 );

	TransParam*	tp	= (TransParam*)p;
	unsigned int	t_item;
	AreaType		type= HitArea( tp->m_pos , &t_item );
	if( type == InputPin && IsEnablePin( t_item , type ) )
	{
		iGraphLink		link	= (iGraphLink)SearchItemId( m_edit_item );
		iGraphNode		node	= (iGraphNode)SearchNodeId( t_item );
		if( link == true && node == true )
		{
			IUndoList*	undo	= m_document->Recode();
			link->SetOutput( node , node->GetInputNum() , undo );
			m_document->Callback( ICallback::ReconnectLink , (object)m_document->SearchTreeId( m_item_id ) , 0 );
			return true;
		}		
	}
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_12to0_canel(void*p)
{
	SetCursor(AfxGetApp()->LoadStandardCursor( IDC_ARROW ) );
	KillTimer( 1 );
	DrawSurface();
	SurfaceBlt();
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_13to0(void*p)
{
	( (CMainFrame*)AfxGetMainWnd() )->AccelResume();

	CString		text;
	m_desc_edit.GetWindowText( text );

	iParserNode				node = SearchNodeId( m_edit_item );
	IParserNode::Property	prop = node->GetProperty();
	cb_assert( prop.m_type == IParserNode::Property::Desc , L"algorithm error." );

	IUndoList*	undo	= m_document->Recode();
	prop.m_desc_prop.m_desc = text;	
	node->SetProperty( prop , undo );

	m_desc_edit.ShowWindow( SW_HIDE );
	m_document->Callback
			( 
			ICallback::ModifyItemProperty , 
			(object)m_document->SearchTreeId( m_item_id ) , 
			0
			);
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_13to13_change(void*p)
{
/*
	CString		text;
	m_desc_edit.GetWindowText( text );

	iParserNode				node = SearchNodeId( m_edit_item );
	IParserNode::Property	prop = node->GetProperty();
	cb_assert( prop.m_type == IParserNode::Property::Desc , L"algorithm error." );
	prop.m_desc_prop.m_desc = text;	
	node->SetProperty( prop , 0 );
	
	DrawSurface();
	SurfaceBlt();
	m_desc_edit.UpdateWindow();
*/
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ts_13to13_resize(void*p)
{
	TransParam*	tp	= (TransParam*)p;
	isize		tsize;
	tsize.width		= max( tp->m_resize.width , m_desc_min );
	tsize.height	= max( tp->m_resize.height , m_desc_min );

	iParserNode		node = SearchNodeId( m_edit_item );
	ivector2		pos;
	isize			size;
	GetNodePos( node , &pos , &size , 0 );
	pos	= pos + ivector2( m_desc_margin.width , size.height / 2 ) - ivector2( 0 , tsize.height / 2 );
	
	m_desc_edit.SetWindowPos
			(
			NULL , 
			pos.x , 
			pos.y , 
			tsize.width , 
			tsize.height , 
			SWP_NOOWNERZORDER
			);

	DrawSurface();
	SurfaceBlt();
	m_desc_edit.UpdateWindow();
	return true;
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call CParseEditCtrlView::Callback
		(
		Type	type , 
		object&	obj , 
		void*	param
		)
{
	if( type == ICallback::AddNode
	||  type == ICallback::MoveItems
	||  type == ICallback::AddLink
	||  type == ICallback::ReconnectLink
	||  type == ICallback::ResizeLinkbar
	||  type == ICallback::ModifyItemProperty )
	{
		if( (object)m_document->SearchTreeId( m_item_id ) == obj )
		{
			DrawSurface();
			SurfaceBlt();
		}
	}
	else if( type == ICallback::RemoveParserItem )
	{
		UpdateSelect();
		DrawSurface();
		SurfaceBlt();
	}
	else if( type == ICallback::Undo
	||  type == ICallback::Redo )
	{
		UpdateSelect();
		DrawSurface();
		SurfaceBlt();
	}
}
//=================================================================================================
CParseEditCtrlView::AreaType CParseEditCtrlView::HitArea
		(
		const ivector2&	pos , 
		unsigned int*	id
		)
{
	int		off , num = m_drawed.GetDatanum();
	for( off = num - 1 ; off >= 0 ; off-- )
	{
		int	roff , rnum = m_drawed[off].m_rect_num;
		for( roff = 0 ; roff < rnum ; roff++ )
		{
			if( true == m_drawed[off].m_rect[roff].IsInside( pos ) )
			{
				store( id , m_drawed[off].m_item_id );
				return m_drawed[off].m_type;
			}
		}
	}
	return None;
}
//=================================================================================================
bool CParseEditCtrlView::IsEnablePin
		(
		unsigned int	item , 
		AreaType		type
		)
{
	if( type != InputPin && type != OutputPin )
		return false;
	iParserNode	node		= (iParserNode)SearchNodeId( item );
	if( node == false )
		return false;
	IParserNode::Property	prop		= node->GetProperty();
	if( prop.m_type == IParserNode::Property::Start && type == InputPin )
		return false;
	if( prop.m_type == IParserNode::Property::End && type == OutputPin )
		return false;
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::AutoScroll
		(
		ivector2*	curpos
		)
{
	POINT	pos;
	if( FALSE == ::GetCursorPos( &pos ) )
		return true;
	ScreenToClient( &pos );
	
	bool	scroll = false;
	if( pos.x < 0 )
	{
		m_scroll_pos.x -= m_scroll_line;
		scroll		= true;
	}
	else if( pos.x > m_wndsize.width )
	{
		m_scroll_pos.x += m_scroll_line;
		scroll		= true;
	}
	if( pos.y < 0 )
	{
		m_scroll_pos.y -= m_scroll_line;
		scroll		= true;
	}
	else if( pos.y > m_wndsize.height )
	{
		m_scroll_pos.y += m_scroll_line;
		scroll		= true;
	}
	if( scroll == true )
	{
		UpdateViewArea();
		UpdateScroll( SB_HORZ );
		UpdateScroll( SB_VERT );
		store( curpos , ivector2( pos.x , pos.y ) );
		return true;
	}
	return false;
}
//=================================================================================================
void CParseEditCtrlView::UpdateSelect()
{
	int		off , num = m_select.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( false == SearchItemId( m_select[off] ) )
		{
			m_select.Delete( off );
			off--;
			num--;
		}
	}
}
//=================================================================================================
bool CParseEditCtrlView::IsAddMode()
{
	if( ( ( GetKeyState( VK_SHIFT ) & 0x8000 ) != 0 ) )
		return true;
	return false;
}
//=================================================================================================
iTexture CParseEditCtrlView::LoadImage
		(
		const wchar_t*		name , 
		const wchar_t*		type
		)
{
	instance<Surface>			surface;
	instance< ResourceReader >	resource;
	if( false == resource->Open( AfxGetInstanceHandle() , name , type ) )
		surface->Create( isize( 10 , 10 ) , rgba_pixelformat , DPI() );
	else
	{
		instance< LoaderImagefile >	loader;
		if( false == loader->Load( ( iFileStreamRead )resource ) )
			surface->Create( isize( 10 , 10 ) , rgba_pixelformat , DPI() );
		else
		{
			surface->Create( loader->GetImageSize( 0 ) , rgba_pixelformat , loader->GetImageDPI( 0 ) );
			int		pitchbyte;
			void	*p = surface->GetDestPixelPtr( &pitchbyte );
			loader->GetImage( 0 , surface->GetDestFormat() , p , pitchbyte );
		}
	}
	instance<TextureImageNearest>	texture;
	texture->SetTexture( (iSurfaceSource)surface );
	texture->SetWraptype( Clamp_Wraptype );
	return (iTexture)texture;
}
//=================================================================================================
void CParseEditCtrlView::InitializeImgs()
{
	if( m_node_start_img == false )
		m_node_start_img = LoadImage( L"NODE_START" , L"PSD" );
	if( m_node_end_img == false )
		m_node_end_img = LoadImage( L"NODE_END" , L"PSD" );
	if( m_node_none_img == false )
		m_node_none_img = LoadImage( L"NODE_NONE" , L"PSD" );
	if( m_node_cleartext_img == false )
		m_node_cleartext_img = LoadImage( L"NODE_CLEARTEXT" , L"PSD" );
	if( m_node_pushtag_img == false )
		m_node_pushtag_img = LoadImage( L"NODE_PUSHTAG" , L"PSD" );
	if( m_node_poptag_img == false )
		m_node_poptag_img = LoadImage( L"NODE_POPTAG" , L"PSD" );
	if( m_node_setattr_img == false )
		m_node_setattr_img = LoadImage( L"NODE_SETATTR" , L"PSD" );
	if( m_node_setattrtext_img == false )
		m_node_setattrtext_img = LoadImage( L"NODE_SETATTRTEXT" , L"PSD" );
	if( m_node_settext_img == false )
		m_node_settext_img = LoadImage( L"NODE_SETTEXT" , L"PSD" );
	if( m_node_pushtext_img == false )
		m_node_pushtext_img = LoadImage( L"NODE_PUSHTEXT" , L"PSD" );
	if( m_node_poptext_img == false )
		m_node_poptext_img = LoadImage( L"NODE_POPTEXT" , L"PSD" );
}
//=================================================================================================
iTexture CParseEditCtrlView::GetNodeImg
		(
		IParserNode::Property::Type	type
		)
{
	if( type == IParserNode::Property::Start )
		return m_node_start_img;
	else if( type == IParserNode::Property::End )
		return m_node_end_img;
	else if( type == IParserNode::Property::None )
		return m_node_none_img;
	else if( type == IParserNode::Property::ClearText )
		return m_node_cleartext_img;
	else if( type == IParserNode::Property::PushTag )
		return m_node_pushtag_img;
	else if( type == IParserNode::Property::PopTag )
		return m_node_poptag_img;
	else if( type == IParserNode::Property::SetAttr )
		return m_node_setattr_img;
	else if( type == IParserNode::Property::SetAttrText )
		return m_node_setattrtext_img;
	else if( type == IParserNode::Property::SetText )
		return m_node_settext_img;
	else if( type == IParserNode::Property::PushText )
		return m_node_pushtext_img;
	else if( type == IParserNode::Property::PopText )
		return m_node_poptext_img;
	else
		return m_node_none_img;
}
//=================================================================================================
isize CParseEditCtrlView::GetNodeSize
		(
		const IParserNode::Property&	prop
		)
{
	if( prop.m_type == IParserNode::Property::Start )
		return m_node_start_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::End )
		return m_node_end_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::None )
		return m_node_none_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::ClearText )
		return m_node_cleartext_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::PushTag )
		return m_node_pushtag_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::PopTag )
		return m_node_poptag_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::SetAttr )
		return m_node_setattr_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::SetAttrText )
		return m_node_setattrtext_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::SetText )
		return m_node_settext_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::PushText )
		return m_node_pushtext_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::PopText )
		return m_node_poptext_img->TextureSize();
	else if( prop.m_type == IParserNode::Property::Desc )
	{
		m_graphics->SetTextAlign( Left_TextAlignHorz_gp , Top_TextAlignVert_gp );
		m_graphics->SetFont( m_font_desc );
		isize	size = m_graphics->GetTextRect( prop.m_desc_prop.m_desc.c_str() , prop.m_desc_prop.m_desc.length() , fvector2() ).Size();
		size.width	= max( size.width , m_desc_min );
		size.height	= max( size.height , m_desc_min );
		size.width	+= m_desc_margin.width * 2;
		size.height	+= m_desc_margin.height * 2;
		
		return size;
	}
	else
		return m_node_none_img->TextureSize();
}
//=================================================================================================
irect CParseEditCtrlView::GetLinkBoundbox
		(
		iParserLink&		link
		)
{
	irect	r;
	GetLinkInfo( link , ivector2(0,0) , 0 , 0 , &r , 0 , 0 , 0 , 0 );
	return irect( ClientToWorld( r.Min() ) , ClientToWorld( r.Max() ) ).Normalize();
}
//=================================================================================================
irect CParseEditCtrlView::GetNodeBoundbox
		(
		iParserNode&		node
		)
{
	IParserNode::Property	prop	= node->GetProperty();
	ivector2				pos		= prop.m_pos;
	isize					size	= GetNodeSize( prop );
	pos.y -= size.height / 2;
	return irect( pos , size );
}
//=================================================================================================
irect CParseEditCtrlView::GetItemsBoundbox
		(
		iGraph&	graph
		)
{
	if( graph == false )
		return irect();

	bool	init_f = false;
	irect	boundbox;
	int		nodeoff , nodenum = graph->GetNodeNum();
	for( nodeoff = 0 ; nodeoff < nodenum ; nodeoff++ )
	{
		iGraphNode	node = graph->GetNode( nodeoff );
		if( nodeoff == 0 )
			boundbox = GetNodeBoundbox( (iParserNode)node );
		else
			boundbox |= GetNodeBoundbox( (iParserNode)node );
		int		linkoff , linknum = node->GetOutputNum();
		for( linkoff = 0 ; linkoff < linknum ; linkoff++ )
			boundbox |= GetLinkBoundbox( (iParserLink)node->GetOutput( linkoff ) );
	}
	return boundbox;
}
//=================================================================================================
bool CParseEditCtrlView::GetSelectItemsBoundbox
		(
		irect*	bbx
		)
{
	bool	init_f = false;
	irect	boundbox;
	int		off , num = m_select.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		iParserItem		item = SearchItemId( m_select[ off ] );
		irect	r;
		if( item->m_itemtype == IParserItem::Node )
		{
			if( init_f == false )
			{
				boundbox	= GetNodeBoundbox( (iParserNode)item );
				init_f		= true;
			}
			else
				boundbox	|= GetNodeBoundbox( (iParserNode)item );
		}
		else if( item->m_itemtype == IParserItem::Link )
		{
			if( init_f == false )
			{
				boundbox	= GetLinkBoundbox( (iParserLink)item );
				init_f		= true;
			}
			else
				boundbox	|= GetLinkBoundbox( (iParserLink)item );
		}
	}
	if( init_f == false )
		return false;
	store( bbx , boundbox );
	return true;
}
//=================================================================================================
void CParseEditCtrlView::MoveItemsCenter
		(
		iGraph&		graph , 
		IUndoList*	undo
		)
{
	if( graph == false )
		return;
	irect		bbx = GetItemsBoundbox( graph );
	ivector2	bbx_center( ( bbx.xmin + bbx.xmax ) / 2 , ( bbx.ymin + bbx.ymax ) / 2 );
	ivector2	scrn_center	= ClientToWorld( ivector2( m_wndsize.width / 2 , m_wndsize.height / 2 ) );
	ivector2	mov	= scrn_center - bbx_center;
	if( mov.x == 0 && mov.y == 0 )
		return;
	int		nodeoff , nodenum = graph->GetNodeNum();
	for( nodeoff = 0 ; nodeoff < nodenum ; nodeoff++ )
	{
		iParserNode				node = graph->GetNode( nodeoff );
		IParserNode::Property	prop = node->GetProperty();
		prop.m_pos += mov;
		node->SetProperty( prop , undo );
	}
}
//=================================================================================================
void CParseEditCtrlView::InitializeViewArea
		(
		const isize&	wndsize
		)
{
	irect	bbx	= GetItemsBoundbox( (iGraph)m_document->SearchTreeId( m_item_id ) );
	bbx.xmin -= m_page_margin;
	bbx.ymin -= m_page_margin;
	bbx.xmax += m_page_margin;
	bbx.ymax += m_page_margin;
	
	ivector2	pos;
	if( wndsize.width < bbx.Width() )
		pos.x = ( bbx.Width() - wndsize.width ) / 2;
	else
	{
		int		sp = ( wndsize.width - bbx.Width() ) / 2;
		bbx.xmin -= sp;
		bbx.xmax += sp;
		pos.x	= 0;
	}
	if( wndsize.height < bbx.Height() )
		pos.y = ( bbx.Height() - wndsize.height ) / 2;
	else
	{
		int		sp = ( wndsize.height - bbx.Height() ) / 2;
		bbx.ymin -= sp;
		bbx.ymax += sp;
		pos.y	= 0;
	}
	m_wndsize	= wndsize;
	m_scroll_pos	= pos;
	m_view_area		= bbx;
}
//=================================================================================================
void CParseEditCtrlView::UpdateViewArea
		(
		const isize&	wndsize
		)
{
	ivector2	pos	= m_scroll_pos;
	pos.x += ( m_wndsize.width - wndsize.width ) / 2;
	pos.y += ( m_wndsize.height - wndsize.height ) / 2;
	irect	wndrect( pos + m_view_area.Min() , wndsize );

	m_view_area	|= wndrect;
	m_wndsize	= wndsize;
	m_scroll_pos	= wndrect.Min() - m_view_area.Min();
}
//=================================================================================================
void CParseEditCtrlView::UpdateViewArea()
{
	ivector2	pos	= m_scroll_pos;
	irect	wndrect( pos + m_view_area.Min() , m_wndsize );
	m_view_area		|= wndrect;
	m_scroll_pos	= wndrect.Min() - m_view_area.Min();
}
//=================================================================================================
bool CParseEditCtrlView::UpdateViewAreaInKey
		(
		KeyDir	dir
		)
{
	irect	bbx;
	if( false == GetSelectItemsBoundbox( &bbx ) )
		return false;
	
	irect	wnd_r( ClientToWorld( ivector2(0,0) ) , ClientToWorld( ivector2(m_wndsize.width , m_wndsize.height ) ) );
	wnd_r	= wnd_r.Normalize();
	if( dir == Left && bbx.xmin < wnd_r.xmin )
		m_scroll_pos.x -= ( wnd_r.xmin - bbx.xmin ) + m_key_scroll_margin;
	else if( dir == Right && bbx.xmax > wnd_r.xmax )
		m_scroll_pos.x += ( bbx.xmax - wnd_r.xmax ) + m_key_scroll_margin;
	else if( dir == Up && bbx.ymin < wnd_r.ymin )
		m_scroll_pos.y -= ( wnd_r.ymin - bbx.ymin ) + m_key_scroll_margin;
	else if( dir == Down && bbx.ymax > wnd_r.ymax )
		m_scroll_pos.y += ( bbx.ymax - wnd_r.ymax ) + m_key_scroll_margin;
	else
		return false;
	UpdateViewArea();
	UpdateScroll( SB_HORZ );
	UpdateScroll( SB_VERT );
	return true;
}
//=================================================================================================
void CParseEditCtrlView::UpdateScroll
		(
		int		dir		//!< [in] SB_HORZ / SB_VERT
		)
{
	SCROLLINFO	info;
	info.cbSize	= sizeof( info );
	info.fMask	= SIF_DISABLENOSCROLL | SIF_PAGE | SIF_POS | SIF_RANGE;
	info.nMin	= ( dir == SB_HORZ ) ? m_view_area.xmin : m_view_area.ymin;
	info.nMax	= ( dir == SB_HORZ ) ? m_view_area.xmax : m_view_area.ymax;
	info.nPage	= ( dir == SB_HORZ ) ? m_wndsize.width : m_wndsize.height;
	info.nPos	= ( dir == SB_HORZ ) ? ( m_scroll_pos.x + m_view_area.xmin ) : ( m_scroll_pos.y + m_view_area.ymin );
	cb_verify( TRUE == SetScrollInfo( dir , &info , TRUE ) );
	EnableScrollBar( dir , ESB_ENABLE_BOTH );
}
//=================================================================================================
irect CParseEditCtrlView::GetWindowArea()
{
	return irect( m_view_area.Min() + m_scroll_pos , m_wndsize );
}
//=================================================================================================
iParserNode CParseEditCtrlView::SearchNodeId
		(
		unsigned int	item
		)
{
	iGraph	graph = (iGraph)m_document->SearchTreeId( m_item_id );
	if( graph == false )
		return iParserNode();
	
	int		off ,num = graph->GetNodeNum();
	for( off = 0 ; off < num ; off++ )
	{
		iParserNode	node = (iParserNode)graph->GetNode( off );
		if( node->m_item_id == item )
			return node;
	}
	return iParserNode();
}
//=================================================================================================
iParserItem CParseEditCtrlView::SearchItemId
		(
		unsigned int	item
		)
{
	iGraph	graph = (iGraph)m_document->SearchTreeId( m_item_id );
	if( graph == false )
		return iParserItem();
	
	int		off ,num = graph->GetNodeNum();
	for( off = 0 ; off < num ; off++ )
	{
		iParserItem		node	= (iParserItem)graph->GetNode( off );
		if( node->m_item_id == item )
			return node;
		iGraphNode	gnode	= (iGraphNode)node;
		int		poff , pnum = gnode->GetOutputNum();
		for( poff = 0 ; poff < pnum ; poff++ )
		{
			iParserItem		pi = (iParserItem)gnode->GetOutput( poff );
			if( pi->m_item_id == item )
				return pi;
		}
	}
	return iParserItem();
}
//=================================================================================================
int CParseEditCtrlView::SearchSelect
		(
		unsigned int	item
		)
{
	int	off , num = m_select.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( m_select[off] == item )
			return off;
	}
	return -1;
}
//=================================================================================================
bool CParseEditCtrlView::ResetSelect()
{
	if( m_select.GetDatanum() == 0 )
		return false;
	m_select.Resize( 0 );
	m_document->Callback( ICallback::SetPropertyItem , (object)object() , (void*)&ICallback::SetPropertyItemParam( 0 , 0 ) );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::ToggleSelect
		(
		unsigned int	item
		)
{
	int	off = SearchSelect( item );
	if( off == -1 )
	{
		m_select[ m_select.Add() ]	= item;
		return true;
	}
	else
	{
		m_select.Delete( off );
		return false;
	}
	if( m_select.GetDatanum() == 1 )
		m_document->Callback
				( 
				ICallback::SetPropertyItem , 
				(object)SearchItemId( m_select[0] ) , 
				(void*)&ICallback::SetPropertyItemParam( m_item_id , m_select[0] ) 
				);
}
//=================================================================================================
bool CParseEditCtrlView::SetSelect
		(
		unsigned int	item
		)
{
	if( m_select.GetDatanum() == 1 && m_select[0] == item )
		return false;
	m_select.Resize( 1 );
	m_select[0]	= item;
	m_document->Callback
			( 
			ICallback::SetPropertyItem , 
			(object)SearchItemId( m_select[0] ) , 
			(void*)&ICallback::SetPropertyItemParam( m_item_id , m_select[0] ) 
			);
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::AddSelect
		(
		unsigned int	item
		)
{
	int	off = SearchSelect( item );
	if( off != -1 )
		return false;
	m_select[ m_select.Add() ]	= item;
	if( m_select.GetDatanum() == 1 )
		m_document->Callback
				( 
				ICallback::SetPropertyItem , 
				(object)SearchItemId( m_select[0] ) , 
				(void*)&ICallback::SetPropertyItemParam( m_item_id , m_select[0] ) 
				);
	return true;
}
//=================================================================================================
void CParseEditCtrlView::SetSelect
		(
		const irect&	r
		)
{
	m_select.Resize( 0 );
	int		off , num = m_drawed.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		int		roff , rnum = m_drawed[off].m_rect_num;
		for( roff = 0 ; roff < rnum ; roff++ )
		{
			if( ( m_drawed[off].m_rect[roff] & r ).IsExist() == true 
			   && ( m_drawed[off].m_type == Node
			   ||   m_drawed[off].m_type == Link ) )
			{
				m_select[ m_select.Add() ]	= m_drawed[off].m_item_id;
				break;
			}
		}
	}
	if( m_select.GetDatanum() >= 1 )
		m_document->Callback
				( 
				ICallback::SetPropertyItem , 
				(object)SearchItemId( m_select[0] ) , 
				(void*)&ICallback::SetPropertyItemParam( m_item_id , m_select[0] ) 
				);
}
//=================================================================================================
void CParseEditCtrlView::AddSelect
		(
		const irect&	r
		)
{
	int		off , num = m_drawed.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		int		roff , rnum = m_drawed[off].m_rect_num;
		for( roff = 0 ; roff < rnum ; roff++ )
		{
			if( true == ( m_drawed[off].m_rect[roff] & r ).IsExist() 
			   && -1 == SearchSelect( m_drawed[off].m_item_id )
			   && m_drawed[off].m_type != InputPin 
			   && m_drawed[off].m_type != OutputPin )
			{
				m_select[ m_select.Add() ]	= m_drawed[off].m_item_id;
				break;
			}
		}
	}
	if( m_select.GetDatanum() >= 1 )
		m_document->Callback
				( 
				ICallback::SetPropertyItem , 
				(object)SearchItemId( m_select[0] ) , 
				(void*)&ICallback::SetPropertyItemParam( m_item_id , m_select[0] ) 
				);
}
//=================================================================================================
unsigned int CParseEditCtrlView::SearchDrawed
		(
		const ivector2&		pt
		)
{
	int		off , num = m_drawed.GetDatanum();
	for( off = num - 1 ; off >= 0 ; off-- )
	{
		int	roff , rnum = m_drawed[off].m_rect_num;
		for( roff = 0 ; roff < rnum ; roff++ )
		{
			if( true == m_drawed[off].m_rect[roff].IsInside( pt ) )
				return m_drawed[off].m_item_id;
		}
	}
	return 0;
}
//=================================================================================================
bool CParseEditCtrlView::AddLink
		(
		iGraphNode&	snode , 
		iGraphNode&	tnode , 
		bool		grid
		)
{
	if( snode == false || tnode == false )
		return false;
	IUndoList*				undo		= m_document->Recode();
	iParserLink				link		= snode->AddLink( snode->GetOutputNum() , tnode , tnode->GetInputNum() , undo );
	IParserNode::Property	node_prop	= ( (iParserNode)tnode )->GetProperty();
	ivector2				pos			= node_prop.m_pos + ivector2( GetNodeSize( node_prop ).width , 0 ) + ivector2( 5 , 0 );
	if( grid == true )
		pos	= ToGrid( pos );
	IParserLink::Property	prop		= link->GetProperty();
	prop.m_pos	= pos - node_prop.m_pos;
	link->SetProperty( prop , undo );
	m_document->Callback( ICallback::AddLink , (object)m_document->SearchTreeId( m_item_id ) , 0 );
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::SetLinkbarWidth
		(
		unsigned int	edit_id , 
		int				w , 
		bool			grid , 
		IUndoList*		undo
		)
{
	if( w <= 0 )
		w = 0;
	if( grid == true )
	{
		iParserLink	link = (iParserLink)SearchItemId( edit_id );
		if( link == false )
			return false;
		w	= LinkbarToGrid( link , w );
	}
	int	off , num = m_select.GetDatanum();
	if( num == 0 )
		return false;

	for( off = 0 ; off < num ; off++ )
	{
		iParserLink		link = SearchItemId( m_select[off] );
		if( link == true )
		{
			IParserLink::Property	prop = link->GetProperty();
			prop.m_bar_width	= w;
			link->SetProperty( prop , undo );
		}
	}
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::MoveSelectItem
		(
		unsigned int	edit_id , 
		ivector2		move , 
		bool			grid
		)
{
	if( move.x == 0 && move.y == 0 )
		return false;
	int	off , num = m_select.GetDatanum();
	if( num == 0 )
		return false;
	iParserItem	item	= SearchItemId( edit_id );
	if( item == false )
		return false;

	if( item->m_itemtype == IParserItem::Node && grid == true )
		move	= MoveNodeToGrid( (iParserNode)item , move );
	else if( item->m_itemtype == IParserItem::Link && grid == true )
		move	= MoveLinkToGrid( (iParserLink)item , move );
		
	IUndoList*	undo	= m_document->Recode();
	for( off = 0 ; off < num ; off++ )
	{
		iParserItem		tgt = SearchItemId( m_select[off] );
		if( tgt == true && item->m_itemtype == tgt->m_itemtype )
		{
			if( item->m_itemtype == IParserItem::Node )
			{
				iParserNode		node = (iParserNode)tgt;
				IParserNode::Property	prop = node->GetProperty();
				prop.m_pos += move;
				node->SetProperty( prop , undo );
			}
			else if( item->m_itemtype == IParserItem::Link )
			{
				iParserLink		link = (iParserLink)tgt;
				IParserLink::Property	prop = link->GetProperty();
				prop.m_pos += move;
				link->SetProperty( prop , undo );
			}
		}
	}
	return true;
}
//=================================================================================================
void CParseEditCtrlView::DrawBack()
{
	m_graphics->SetAlpha( 255 );
	m_graphics->SetPaint( m_paint_back );
	m_graphics->PaintRect( 0 , faffine() );

/*
	m_graphics->SetStrokePaint( m_paint_link );
	m_graphics->SetStrokeWidth( 1.0f );
	m_graphics->SetStrokeClose( false );
	m_graphics->SetAntialias( none_antialias );
	fvector2	p[2]	= 
	{
		fvector2( 9.8f , 0.0f ) , 
		fvector2( 9.8f , 10.0f ) , 
	};
	m_graphics->StrokeLine( 2 , p , faffine() , faffine() );
*/
}
//=================================================================================================
void CParseEditCtrlView::DrawGrid()
{
	m_graphics->SetAlpha( 255 );
	m_graphics->SetPaint( m_paint_grid );
	
	int			interval = m_grid_size * m_grid_draw_num;
	irect		wnd_area = GetWindowArea();
	ivector2	offset
			( 
			wnd_area.xmin < 0 ? -( wnd_area.xmin % interval ) : ( interval - ( wnd_area.xmin % interval ) ) , 
			wnd_area.ymin < 0 ? -( wnd_area.ymin % interval ) : ( interval - ( wnd_area.ymin % interval ) )
			);
	offset.x = offset.x == interval ? 0 : offset.x;
	offset.y = offset.y == interval ? 0 : offset.y;
	
	// x dir
	while( offset.x < m_wndsize.width )
	{
		frect		r( (float)offset.x , 0.0f , (float)offset.x + 1.0f , (float)m_wndsize.height );
		m_graphics->PaintRect( &r , faffine() );
		offset.x += interval;
	}
	// y dir
	while( offset.y < m_wndsize.height )
	{
		frect		r( 0.0f , (float)offset.y , (float)m_wndsize.width , (float)offset.y + 1.0f );
		m_graphics->PaintRect( &r , faffine() );
		offset.y += interval;
	}
}
//=================================================================================================
ivector2 CParseEditCtrlView::GetPinPos
		(
		unsigned int	item , 
		AreaType		type
		)
{
	return GetPinPos( SearchNodeId( item ) , type );
}
//=================================================================================================
ivector2 CParseEditCtrlView::GetPinPos
		(
		iParserNode&	node , 
		AreaType		type
		)
{
	if( node == false )
		return ivector2();
	IParserNode::Property	prop	= node->GetProperty();
	ivector2				pos		= prop.m_pos;
	isize					size	= GetNodeSize( prop );
	if( type == InputPin )
		return pos;
	else
		return ivector2( pos.x + size.width , pos.y );
}
//=================================================================================================
void CParseEditCtrlView::DrawEditLink
		(
		unsigned int	item , 
		AreaType		type , 
		ivector2		tgt
		)
{
	ivector2	src = WorldToClient( GetPinPos( item , type ) );
	if( type == InputPin )
		swap( &src , &tgt );
	
	int		p[13];
	GetPinConnectLine( p , src - tgt , m_link_r , m_link_ih , -1 , -1 );
	DrawConnectLine( tgt , p , m_paint_edit_link , 255 );
}
//=================================================================================================
fvector2 CParseEditCtrlView::SetPathArcXY
		(
		const fvector2&	sp , 
		int				p[2] , 
		iPath&			path
		)
{
	if( p[0] == 0 && p[1] == 0 )
		return sp;
	if( p[0] == 0 )
	{
		fvector2	tp( sp.x , sp.y + p[1] );
		path->Line( tp );
		return tp;
	}
	if( p[1] == 0 )
	{
		fvector2	tp( sp.x + p[0] , sp.y );
		path->Line( tp );
		return tp;
	}
	float	angle;
	if( 0 <= p[0] )
	{
		if( 0 <= p[1] )
			angle	= PI_R2_f;
		else
			angle	= -PI_R2_f;
	}
	else
	{
		if( 0 <= p[1] )
			angle	= -PI_R2_f;
		else
			angle	= PI_R2_f;
	}
	path->Arc( fvector2( sp.x , sp.y + p[1] ) , fabs( (float)p[1] / (float)p[0] ) , angle );
	return fvector2( sp.x + p[0] , sp.y + p[1] );
}
//=================================================================================================
fvector2 CParseEditCtrlView::SetPathArcYX
		(
		const fvector2&	sp , 
		int				p[2] , 
		iPath&			path
		)
{
	if( p[0] == 0 && p[1] == 0 )
		return sp;
	if( p[0] == 0 )
	{
		fvector2	tp( sp.x + p[1] , sp.y );
		path->Line( tp );
		return tp;
	}
	if( p[1] == 0 )
	{
		fvector2	tp( sp.x , sp.y + p[0] );
		path->Line( tp );
		return tp;
	}
	float	angle;
	if( 0 <= p[0] )
	{
		if( 0 <= p[1] )
			angle	= -PI_R2_f;
		else
			angle	= PI_R2_f;
	}
	else
	{
		if( 0 <= p[1] )
			angle	= PI_R2_f;
		else
			angle	= -PI_R2_f;
	}
	path->Arc( fvector2( sp.x + p[1] , sp.y ) , fabs( (float)p[0] / (float)p[1] ) , angle );
	return fvector2( sp.x + p[1] , sp.y + p[0] );
}
//=================================================================================================
void CParseEditCtrlView::StrokePath
		(
		iPath&			path , 
		float			width , 
		iPaint_gp&		paint , 
		uint8			alpha
		)
{
//	m_gen->SetSampleScale( 0.0f );
	m_gen->SetStrokeWidth( width );
	m_outline->Reset();
	m_pathto->ToOutline( (iOutline)m_outline , *path->GetPathInfo() , (iOutlineGen)m_gen , faffine() );
	m_edgemap->BeginOutline( irect( ivector2() , m_surface->GetDestSize() ) );
	m_edgemap->SetOutline( (iOutline)m_outline , faffine() );
	m_edgemap->EndOutline();
	m_render->SetBlender( (iBlender)m_blender );
	m_render->SetPaint( (iPaint)paint );
	m_render->Render( (iSurfaceDest)m_surface , (iEdgemapCellInfo)m_edgemap , 0 , alpha );
/*
	m_graphics->SetAntialias( x4_antialias );
	m_graphics->SetAlpha( alpha );	
	m_graphics->SetStrokePaint( paint );
	m_graphics->SetStrokeWidth( width );
	m_graphics->SetStrokeClose( false );
	m_graphics->StrokePath( (iPathLogicInfo)m_path_link , faffine() , faffine() );
	m_graphics->SetAntialias( none_antialias );
*/
}
//=================================================================================================
void CParseEditCtrlView::DrawConnectLine
		(
		fvector2		sp , 
		int				p[13] , 
		iPaint_gp&		paint , 
		uint8			alpha
		)
{
	sp = sp + fvector2( 0.5f , 0.5f );
	m_path_link->Reset();
	m_path_link->Move( sp , faffine() , false );
	fvector2	tp( sp.x + p[0] , sp.y );
	m_path_link->Line( tp );
	tp	= SetPathArcXY( tp , &p[1] , (iPath)m_path_link );
	tp.y += p[3];
	m_path_link->Line( tp );
	tp	= SetPathArcYX( tp , &p[4] , (iPath)m_path_link );
	tp.x += p[6];
	m_path_link->Line( tp );	
	tp	= SetPathArcXY( tp , &p[7] , (iPath)m_path_link );
	tp.y += p[9];
	m_path_link->Line( tp );	
	tp	= SetPathArcYX( tp , &p[10] , (iPath)m_path_link );
	tp.x += p[12];
	m_path_link->Line( tp );	
	StrokePath( (iPath)m_path_link , m_link_w , paint , alpha );
/*
	m_graphics->SetAntialias( x4_antialias );
	m_graphics->SetAlpha( alpha );	
	m_graphics->SetStrokePaint( m_paint_link );
	m_graphics->SetStrokeWidth( m_link_w );
	m_graphics->SetStrokeClose( false );
	m_graphics->StrokePath( (iPathLogicInfo)m_path_link , faffine() , faffine() );
	m_graphics->SetAntialias( none_antialias );
*/
}
//=================================================================================================
void CParseEditCtrlView::AddObjectAreaX
		(
		const fvector2&		sp , 
		int					l , 
		ObjectArea*			area
		)
{
	if( l == 0 )
		return;
	if( area == 0 )
		return;
	if( area->m_rect_num >= _countof( area->m_rect ) )
		return;
	area->m_rect[ area->m_rect_num ]	= irect( (int)sp.x , (int)sp.y - m_link_area_w , (int)sp.x+l , (int)sp.y + m_link_area_w ).Normalize();
	area->m_rect_num++;
}
//=================================================================================================
void CParseEditCtrlView::AddObjectAreaY
		(
		const fvector2&		sp , 
		int					l , 
		ObjectArea*			area
		)
{
	if( l == 0 )
		return;
	if( area == 0 )
		return;
	if( area->m_rect_num >= _countof( area->m_rect ) )
		return;
	area->m_rect[ area->m_rect_num ]	= irect( (int)sp.x - m_link_area_w , (int)sp.y , (int)sp.x + m_link_area_w , (int)sp.y+l ).Normalize();
	area->m_rect_num++;
}
//=================================================================================================
void CParseEditCtrlView::DrawConnectLine
		(
		fvector2		sp , 
		int				p1[13] , 
		fvector2		cp , 
		int				p2[13] , 
		uint8			alpha , 
		ObjectArea*		area
		)
{
	if( area != 0 )
		area->m_rect_num = 0;
	sp = sp + fvector2( 0.5f , 0.5f );
	cp = cp + fvector2( 0.5f , 0.5f );
	m_path_link->Reset();
	m_path_link->Move( sp , faffine() , false );
	AddObjectAreaX( sp , p1[0] , area );
	fvector2	tp( sp.x + p1[0] , sp.y );
	m_path_link->Line( tp );
	tp	= SetPathArcXY( tp , &p1[1] , (iPath)m_path_link );
	AddObjectAreaY( tp , p1[3] , area );
	tp.y += p1[3];
	m_path_link->Line( tp );
	tp	= SetPathArcYX( tp , &p1[4] , (iPath)m_path_link );
	AddObjectAreaX( tp , p1[6] , area );
	tp.x += p1[6];
	m_path_link->Line( tp );	
	tp	= SetPathArcXY( tp , &p1[7] , (iPath)m_path_link );
	AddObjectAreaY( tp , p1[9] , area );
	tp.y += p1[9];
	m_path_link->Line( tp );	
	tp	= SetPathArcYX( tp , &p1[10] , (iPath)m_path_link );
	AddObjectAreaX( tp , p1[12] , area );
	tp.x += p1[12];
	m_path_link->Line( tp );	

	AddObjectAreaX( cp , p2[0] , area );
	tp	= fvector2( cp.x + p2[0] , cp.y );
	m_path_link->Line( tp );
	tp	= SetPathArcXY( tp , &p2[1] , (iPath)m_path_link );
	AddObjectAreaY( tp , p2[3] , area );
	tp.y += p2[3];
	m_path_link->Line( tp );
	tp	= SetPathArcYX( tp , &p2[4] , (iPath)m_path_link );
	AddObjectAreaX( tp , p2[6] , area );
	tp.x += p2[6];
	m_path_link->Line( tp );	
	tp	= SetPathArcXY( tp , &p2[7] , (iPath)m_path_link );
	AddObjectAreaY( tp , p2[9] , area );
	tp.y += p2[9];
	m_path_link->Line( tp );	
	tp	= SetPathArcYX( tp , &p2[10] , (iPath)m_path_link );
	AddObjectAreaX( tp , p2[12] , area );
	tp.x += p2[12];
	m_path_link->Line( tp );	

	StrokePath( (iPath)m_path_link , m_link_w , m_paint_link , alpha );
}
//=================================================================================================
void CParseEditCtrlView::DrawLinkInfo
		(
		const irect&					bbx , 
		const wstring&					info , 
		IParserLink::Property::Type		type , 
		IParserLink::Property::Align	align , 
		uint8							alpha , 
		ObjectArea*						area
		)
{
	frect		clip	= bbx;
			( 
			bbx.xmin + m_link_info_margin.width , 
			bbx.ymin , 
			bbx.xmax , 
			bbx.ymax - m_link_info_margin.width
			);
	fvector2			pos;
	TextAlignHorz_gp	textalign;
	if( align == IParserLink::Property::Left )
	{
		pos			= fvector2( bbx.xmin + m_link_info_margin.width , bbx.ymax - m_link_info_margin.height );
		textalign	= Left_TextAlignHorz_gp;
	}
	else if( align == IParserLink::Property::Center )
	{
		pos			= fvector2( ( bbx.xmin + bbx.xmax ) / 2 , bbx.ymax - m_link_info_margin.height );
		textalign	= Center_TextAlignHorz_gp;
	}
	else
	{
		pos			= fvector2( bbx.xmax - m_link_info_margin.width , bbx.ymax - m_link_info_margin.height );
		textalign	= Right_TextAlignHorz_gp;
	}
	m_graphics->SetAlpha( alpha );	
	m_graphics->SetTextAlign( textalign , Bottom_TextAlignVert_gp );
	m_graphics->SetFont( type == IParserLink::Property::Function ? m_font_function : m_font_regular );
	m_graphics->DrawText
			( 
			info.c_str() , 
			info.length() , 
			pos , 
			type == IParserLink::Property::Function ? m_color_function : m_color_regular , 
			0 //&clip
			);
	if( area != 0 )
	{
		area->m_rect[ area->m_rect_num ]	= bbx;
		area->m_rect_num++;
	}
}
//=================================================================================================
void CParseEditCtrlView::GetLinkInfo
		(
		iParserLink&			link , 
		const ivector2&			move , 
		ivector2*				sp , 
		ivector2*				tp , 
		irect*					bbx , 
		ivector2*				linkpos , 
		wstring*				str , 
		int*					linkbar , 
		IParserLink::Property*	rprop
		)
{
	iGraphNode	in_node			= ((iGraphLink)link)->GetInput();
	iGraphNode	out_node		= ((iGraphLink)link)->GetOutput();
	ivector2	in_outpinpos	= WorldToClient( GetPinPos( (iParserNode)in_node , OutputPin ) );
	ivector2	in_inpinpos		= WorldToClient( GetPinPos( (iParserNode)in_node , InputPin ) );
	ivector2	out_pinpos		= WorldToClient( GetPinPos( (iParserNode)out_node , InputPin ) );
	
	// search link
	int		linkoff , linknum = in_node->GetOutputNum();
	for( linkoff = 0 ; linkoff < linknum ; linkoff++ )
	{
		if( in_node->GetOutput( linkoff ) == link )
			break;
	}
	// get disp string
	IParserLink::Property	prop = link->GetProperty();
	wstring					info;
	{
		wostringstream	os;
		if( linknum != 1 )
		{
			os << ( linkoff + 1 );
			os << L": ";
		}
		if( prop.m_type == IParserLink::Property::None )
			os	<< (const wchar_t*)LoadText( IDS_LINK_NONE );
		else if( prop.m_type == IParserLink::Property::RegularExp )
			os	<< prop.m_regular_prop.m_exp;
		else if( prop.m_type == IParserLink::Property::Function )
			os	<< prop.m_function_prop.m_parser_name;
		info	= os.str();
	}
	// get link rect
	iFont_gp	font		= ( prop.m_type == IParserLink::Property::Function ) ? m_font_function : m_font_regular;
	isize		link_size	= font->GetStringSize( (iSurfaceDest)m_surface , info.c_str() , info.length() );
	link_size.width		+= m_link_info_margin.width * 2;
	link_size.height	+= m_link_info_margin.height * 2;
	int		bar_w;
	if( prop.m_bar_width == 0 )
		bar_w	= link_size.width;
	else
	{
		bar_w	= prop.m_bar_width;
		link_size.width	= max( link_size.width , prop.m_bar_width );
	}
	// boundbox
	irect	boundbox;
	if( prop.m_align == IParserLink::Property::Left )
		boundbox	= irect( ivector2( 0 , 0 ) , link_size );
	else if( prop.m_align == IParserLink::Property::Center )
		boundbox	= irect( ivector2( ( bar_w - link_size.width ) / 2 , 0 ) , link_size );
	else
		boundbox	= irect( ivector2( bar_w - link_size.width , 0 ) , link_size );
	store( linkpos , in_inpinpos + prop.m_pos + move );
	store( bbx , boundbox.Move( in_inpinpos + prop.m_pos + move + ivector2( 0 , -boundbox.Height() ) ) );
	store( str , info );
	store( rprop , prop );
	store( sp , in_outpinpos );
	store( tp , out_pinpos );
	store( linkbar , bar_w );
}
//=================================================================================================
void CParseEditCtrlView::InverseP
		(
		int			p[13]
		)
{
	int		i;
	for( i = 0 ; i < 13 ; i++ )
		p[i]	= -p[i];
	for( i = 0 ; i < 6 ; i++ )
		swap( &p[i] , &p[12-i] );
}
//=================================================================================================
void CParseEditCtrlView::DrawLink
		(
		iParserLink&		link , 
		const ivector2		move , 
		uint8				alpha , 
		bool				drawed , 
		const ivector2*		spp , 
		const ivector2*		tpp
		)
{
	if( link == false )
		return;

	wstring					info;
	irect					bbx;
	IParserLink::Property	prop;
	ivector2				sp , tp;
	int						bar_w;
	ivector2				linkpos;
	GetLinkInfo( link , move , &sp , &tp , &bbx , &linkpos , &info , &bar_w , &prop );
	if( spp != 0 )
		sp = *spp;
	if( tpp != 0 )
		tp = *tpp;
		
	// lsp , ltp
	ivector2	barl	= linkpos;
	ivector2	barr	= barl + ivector2( bar_w , 0 );
	
	// connect
	int			p0[13] , p1[13];
	ivector2	cp;
	if( prop.m_knottype == IParserLink::Property::Direct )
	{
		GetPinConnectLine( p0 , sp - barl  , m_link_r , m_link_ih , -1 , -1 );
		GetPinConnectLine( p1 , tp - barr , m_link_r , m_link_ih , 1 , 1 );
		cp	= barr;
	}
	else if( prop.m_knottype == IParserLink::Property::Twist )
	{
		GetPinConnectLine( p0 , sp - barr , m_link_r , m_link_ih , 1 , -1 );
		GetPinConnectLine( p1 , tp - barl , m_link_r , m_link_ih , -1 , 1 );
		cp	= barl;
	}
	ObjectArea	area;
	area.m_item_id	= link->m_item_id;
	area.m_type		= Link;
	InverseP( p0 );
	DrawConnectLine( sp , p0 , cp , p1 , alpha , drawed == false ? 0 : &area );
	DrawLinkInfo( bbx , info , prop.m_type , prop.m_align , alpha , drawed == false ? 0 : &area );
	if( drawed == true )
		m_drawed[m_drawed.Add()]	= area;
}
//=================================================================================================
void CParseEditCtrlView::DrawNodeLink
		(
		iParserNode&	node , 
		bool			drawed
		)
{
	iGraphNode	gnode	= (iGraphNode)node;
	if( gnode == false )
		return;
	int		off , num = gnode->GetOutputNum();
	for( off = 0 ; off < num ; off++ )
	{
		iGraphLink	link = gnode->GetOutput( off );
		DrawLink
				( 
				(iParserLink)link , 
				ivector2(0 , 0) , 
				255 ,
				drawed
				);
	}
}
//=================================================================================================
void CParseEditCtrlView::GetNodePos
		(
		iParserNode&			node , 
		ivector2*				ppos , 
		isize*					psize , 
		IParserNode::Property*	pprop 
		)
{
	IParserNode::Property	prop	= node->GetProperty();
	ivector2				pos		= WorldToClient( prop.m_pos );
	isize					size	= GetNodeSize( prop );
	pos.y -= size.height / 2;
	
	store( ppos , pos );
	store( psize , size );
	store( pprop , prop );
}
//=================================================================================================
void CParseEditCtrlView::DrawNode
		(
		iParserNode&	node , 
		const ivector2&	move , 
		uint8			alpha , 
		bool			drawed
		)
{
	if( node == false )
		return;
	IParserNode::Property	prop;
	ivector2				pos;
	isize					size;
	GetNodePos( node , &pos , &size , &prop );
	pos += move;
	
	if( prop.m_type == IParserNode::Property::Desc )
	{
		if( m_desc_edit.IsWindowVisible() == TRUE 
		&&  m_edit_item == node->m_item_id )
		{
			CRect	r;
			m_desc_edit.GetWindowRect( &r );
			isize		tsize( r.right - r.left + m_desc_margin.width * 2 , r.bottom - r.top + m_desc_margin.height * 2 );
			ivector2	tpos	= pos + ivector2( 0 , size.height / 2 ) + ivector2( 0 , -tsize.height / 2 );
			m_graphics->SetAlpha( alpha );
			DrawRect( irect( tpos , tsize ) , m_paint_desc_node , m_paint_desc_node_stroke );
		}
		else
		{
			m_graphics->SetAlpha( alpha );
			DrawRect( irect( pos , size ) , m_paint_desc_node , m_paint_desc_node_stroke );
			m_graphics->SetFont( m_font_desc );
			m_graphics->DrawText
					( 
					prop.m_desc_prop.m_desc.c_str() , 
					prop.m_desc_prop.m_desc.length() , 
					pos + ivector2( m_desc_margin.width , m_desc_margin.height ) , 
					m_color_desc , 
					0
					);
		}
	}
	else
	{
		iTexture	texture	= GetNodeImg( prop.m_type );
		m_graphics->SetAlpha( alpha );
		m_graphics->BitBlt
				( 
				fvector2( pos.x , pos.y ) , 
				texture , 
				fvector2( 0.0f , 0.0f ) 
				);
	}
	if( drawed == true )
	{
		int		off = m_drawed.Add();
		m_drawed[off].m_type		= Node;
		m_drawed[off].m_item_id		= node->m_item_id;
		m_drawed[off].m_rect_num	= 1;
		m_drawed[off].m_rect[0]		= irect( pos , size );

		if( prop.m_type != IParserNode::Property::Start )
		{
			off = m_drawed.Add();
			m_drawed[off].m_type		= InputPin;
			m_drawed[off].m_item_id		= node->m_item_id;
			m_drawed[off].m_rect_num	= 1;
			m_drawed[off].m_rect[0]		= irect( ivector2( pos.x , pos.y + ( size.height - m_pin_size.height ) / 2 ) , m_pin_size );
		}
		if( prop.m_type != IParserNode::Property::End )
		{
			off = m_drawed.Add();
			m_drawed[off].m_type		= OutputPin;
			m_drawed[off].m_item_id		= node->m_item_id;
			m_drawed[off].m_rect_num	= 1;
			m_drawed[off].m_rect[0]		= irect( ivector2( pos.x + size.width - m_pin_size.width , pos.y + ( size.height - m_pin_size.height ) / 2 ) , m_pin_size );
		}
	}
}
//=================================================================================================
void CParseEditCtrlView::DrawNodeFrame
		(
		iParserNode&	node , 
		const ivector2&	move , 
		uint8			alpha
		)
{
	if( node == false )
		return;
	IParserNode::Property	prop	= node->GetProperty();
	ivector2				pos		= WorldToClient( prop.m_pos );
	isize					size	= GetNodeSize( prop );
	pos.y -= size.height / 2;
	pos += move;
	
	if( prop.m_type == IParserNode::Property::Desc 
	&& m_desc_edit.IsWindowVisible() == TRUE 
	&& m_edit_item == node->m_item_id )
	{
		CRect	r;
		m_desc_edit.GetWindowRect( &r );
		isize		tsize( r.right - r.left + m_desc_margin.width * 2 , r.bottom - r.top + m_desc_margin.height * 2 );
		ivector2	tpos	= pos + ivector2( 0 , size.height / 2 ) + ivector2( 0 , -tsize.height / 2 );
		DrawFrame( irect( tpos , tsize ) , m_paint_frame_node , m_paint_frame_node_stroke );
	}
	else
	{
		irect	r = irect( size ).Move( pos );
		m_graphics->SetAlpha( alpha );
		DrawFrame( r , m_paint_frame_node , m_paint_frame_node_stroke );
	}
}
//=================================================================================================
void CParseEditCtrlView::DrawSelectPin
		(
		const ivector2&		in , 
		const ivector2&		out , 
		unsigned int		item_id , 
		bool				drawed
		)
{
	frect	in_r( in.x - m_pin_size.width / 2.0f , in.y - m_pin_size.height / 2.0f , in.x + m_pin_size.width / 2.0f , in.y + m_pin_size.height / 2.0f );
	frect	out_r( out.x - m_pin_size.width / 2.0f , out.y - m_pin_size.height / 2.0f , out.x + m_pin_size.width / 2.0f , out.y + m_pin_size.height / 2.0f );
	DrawRect( in_r , m_paint_pin , m_paint_pin_stroke );
	DrawRect( out_r , m_paint_pin , m_paint_pin_stroke );
	if( drawed == true )
	{
		int		off = m_drawed.Add();
		m_drawed[off].m_item_id	= item_id;
		m_drawed[off].m_type	= InputReconnectPin;
		m_drawed[off].m_rect_num= 1;
		m_drawed[off].m_rect[0]	= in_r;

		off = m_drawed.Add();
		m_drawed[off].m_item_id	= item_id;
		m_drawed[off].m_type	= OutputReconnectPin;
		m_drawed[off].m_rect_num= 1;
		m_drawed[off].m_rect[0]	= out_r;
	}
}
//=================================================================================================
void CParseEditCtrlView::DrawSelectLinkbar
		(
		const ivector2&		pos , 
		unsigned int		item_id , 
		bool				drawed
		)
{
	irect	r
			( 
			pos.x - m_linkbar_ctrl_size.width / 2 , 
			pos.y - m_linkbar_ctrl_size.height / 2 , 
			pos.x + m_linkbar_ctrl_size.width / 2 , 
			pos.y + m_linkbar_ctrl_size.height / 2 
			);
	
	// draw
	m_graphics->SetAlpha( 255 );
	DrawRect( r , m_paint_linkbar , m_paint_linkbar_stroke );

	// drawed
	if( drawed == true )
	{
		int		off = m_drawed.Add();
		m_drawed[off].m_item_id	= item_id;
		m_drawed[off].m_type	= LinkBarCtrl;
		m_drawed[off].m_rect_num= 1;
		m_drawed[off].m_rect[0]	= r;
	}
}
//=================================================================================================
void CParseEditCtrlView::DrawLinkFrame
		(
		iParserLink&	link , 
		const ivector2&	move , 
		uint8			alpha , 
		bool			drawed
		)
{
	if( link == false )
		return;
	irect					bbx;
	ivector2				sp , tp , linkpos;
	IParserLink::Property	prop;
	GetLinkInfo( link , ivector2(0,0) , &sp , &tp , &bbx , &linkpos , 0 , 0 , &prop );
	bbx	= bbx.Move( move );

	// draw
	m_graphics->SetAlpha( alpha );
	DrawFrame( bbx , m_paint_frame_link , m_paint_frame_link_stroke );
	
	// drawed
	if( drawed == true )
	{
		DrawSelectPin( sp , tp , link->m_item_id , true );
		int	w;
		if( prop.m_bar_width == 0 )
			w	= bbx.Width();
		else
			w	= prop.m_bar_width;
		DrawSelectLinkbar( ivector2( linkpos.x + w , linkpos.y ) , link->m_item_id , true );
	}
}
//=================================================================================================
void CParseEditCtrlView::DrawItemFrame
		(
		unsigned int	item_id , 
		const ivector2&	move , 
		uint8			alpha
		)
{
	iParserItem		item = SearchItemId( item_id );
	if( item == false )
		return;
	if( IParserItem::Node == item->m_itemtype )
		DrawNodeFrame( (iParserNode)item , move , alpha );
	else if( IParserItem::Link == item->m_itemtype )
		DrawLinkFrame( (iParserLink)item , move , alpha , true );
}
//=================================================================================================
void CParseEditCtrlView::DrawAllNode()
{
	m_drawed.Resize( 0 );

	iGraph	graph = (iGraph)m_document->SearchTreeId( m_item_id );
	if( graph == false )
		return;
	int		nodeoff , nodenum = graph->GetNodeNum();
	for( nodeoff = 0 ; nodeoff < nodenum ; nodeoff++ )
	{
		iParserNode	node = (iParserNode)graph->GetNode( nodeoff );
		DrawNode( node , ivector2() , 255 , true );
		DrawNodeLink( node , true );
	}
}
//=================================================================================================
void CParseEditCtrlView::DrawSelectFrame()
{
	iGraph	graph = (iGraph)m_document->SearchTreeId( m_item_id );
	if( graph == false )
		return;
	
	int		off , num = m_select.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		DrawItemFrame( m_select[off] , ivector2() , 255 );
	}
}
//=================================================================================================
ivector2 CParseEditCtrlView::MoveNodeToGrid
		(
		iParserNode&		node , 
		const ivector2&		move
		)
{
	IParserNode::Property	prop = node->GetProperty();
	return ToGrid( prop.m_pos + move ) - prop.m_pos;
}
//=================================================================================================
ivector2 CParseEditCtrlView::MoveLinkToGrid
		(
		iParserLink&		link , 
		const ivector2&		move
		)
{
	iGraphLink	glink	= (iGraphLink)link;
	iParserNode	node	= (iParserNode)glink->GetInput();
	
	IParserNode::Property	node_prop	= node->GetProperty();
	IParserLink::Property	link_prop	= link->GetProperty();
	ivector2	pos = ToGrid( node_prop.m_pos + link_prop.m_pos + move );
	return pos - node_prop.m_pos - link_prop.m_pos;
}
//=================================================================================================
int CParseEditCtrlView::LinkbarToGrid
		(
		iParserLink&		link , 
		int					w
		)
{
	if( w <= 0 )
		return w;
	iGraphLink	glink	= (iGraphLink)link;
	iParserNode	node	= (iParserNode)glink->GetInput();
	
	IParserNode::Property	node_prop	= node->GetProperty();
	IParserLink::Property	link_prop	= link->GetProperty();
	ivector2	pos = ToGrid( node_prop.m_pos + link_prop.m_pos + ivector2( w , 0 ) );
	return pos.x - node_prop.m_pos.x - link_prop.m_pos.x;
}
//=================================================================================================
void CParseEditCtrlView::DrawMoveItem
		(
		unsigned int	edit_id , 
		ivector2		move , 
		bool			grid
		)
{
	iParserItem	item	= SearchItemId( edit_id );
	if( item == false )
		return;
	if( item->m_itemtype == IParserItem::Node )
	{
		if( grid == true )
			move= MoveNodeToGrid( (iParserNode)item , move );
		int		off , num = m_select.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			DrawNode( SearchNodeId( m_select[off] ) , move , 100 , false );
		}
	}
	else if( item->m_itemtype == IParserItem::Link )
	{
		if( grid == true )
			move	= MoveLinkToGrid( (iParserLink)item , move );
		int		off , num = m_select.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			iGraphLink		link = (iParserLink)SearchItemId( m_select[off] );
			if( link == true )
			{
				DrawLink( (iParserLink)SearchItemId( m_select[off] ) , move , 100 , false );
			}
		}
	}
}
//=================================================================================================
void CParseEditCtrlView::PaintRect
		(
		const irect&		r , 
		iPaint_gp&			paint
		)
{
//	m_graphics->SetAlpha( 255 );
	m_graphics->SetPaint( paint );
	{
		frect	fr( (float)(r.xmin) , (float)(r.ymin) , (float)(r.xmax) , (float)(r.ymax) );
		m_graphics->PaintRect( &fr , faffine() );
	}
}
//=================================================================================================
void CParseEditCtrlView::StrokeRect
		(
		const irect&		r , 
		iPaint_gp&			stroke , 
		int					size
		)
{
//	m_graphics->SetAlpha( 255 );
	m_graphics->SetPaint( stroke );
	{
		frect	fr( (float)(r.xmin-size) , (float)(r.ymin-size) , (float)(r.xmax+size) , (float)(r.ymin) );
		m_graphics->PaintRect( &fr , faffine() );
	}
	{
		frect	fr( (float)(r.xmin-size) , (float)(r.ymax) , (float)(r.xmax+size) , (float)(r.ymax+size) );
		m_graphics->PaintRect( &fr , faffine() );
	}
	{
		frect	fr( (float)(r.xmin-size) , (float)(r.ymin) , (float)(r.xmin) , (float)(r.ymax) );
		m_graphics->PaintRect( &fr , faffine() );
	}
	{
		frect	fr( (float)(r.xmax) , (float)(r.ymin) , (float)(r.xmax+size) , (float)(r.ymax) );
		m_graphics->PaintRect( &fr , faffine() );
	}
}
//=================================================================================================
void CParseEditCtrlView::DrawRect
		(
		const irect&		r , 
		iPaint_gp&			paint , 
		iPaint_gp&			stroke
		)
{
	irect	tr( r.xmin+1 , r.ymin+1 , r.xmax-1 , r.ymax-1 );
	PaintRect( tr , paint );
	StrokeRect( tr , stroke , 1 );
}
//=================================================================================================
void CParseEditCtrlView::DrawFrame
		(
		const irect&		r , 
		iPaint_gp&			paint , 
		iPaint_gp&			stroke
		)
{
	StrokeRect( r , paint , m_select_frame_width );
	StrokeRect( r , stroke , 1 );
	StrokeRect( irect( r.xmin - m_select_frame_width , r.ymin - m_select_frame_width , r.xmax + m_select_frame_width , r.ymax + m_select_frame_width ) , stroke , 1 );
}
//=================================================================================================
void CParseEditCtrlView::DrawSurface()
{
	cb_trace( L"DrawSurface\n" );
	DrawBack();
	DrawGrid();
	DrawAllNode();
	DrawSelectFrame();
}
//=================================================================================================
void CParseEditCtrlView::SurfaceBlt
		(
		HDC		hdc
		) 
{
	if( hdc == NULL )
		return;
	irect	v , a;
	HDC		shdc	= m_surface->GetSourceHDC( &v , &a );
	BitBlt( hdc , v.xmin + a.xmin , v.ymin + a.ymin , a.Width() , a.Height() , shdc , v.xmin + a.xmin , v.ymin + a.ymin , SRCCOPY );
}
//=================================================================================================
void CParseEditCtrlView::SurfaceBlt()
{
	CDC*	dc = GetDC();
	if( dc == 0 )
		return;
	SurfaceBlt( dc->m_hDC );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// protected functions
//=================================================================================================
int CParseEditCtrlView::ToGrid
		(
		int		v
		)
{
	v	= (int)floorf( ( (float)v + (float)m_grid_size / 2.0f ) / (float)m_grid_size );
	v	= v * m_grid_size;
	return v;
}
//=================================================================================================
ivector2 CParseEditCtrlView::ToGrid
		(
		const ivector2&		v
		)
{
	return ivector2( ToGrid( v.x ) , ToGrid( v.y ) );
}
//=================================================================================================
ivector2 CParseEditCtrlView::WorldToClient
		(
		const ivector2&	pos
		)
{
	return pos - m_view_area.Min() - m_scroll_pos;
}
//=================================================================================================
ivector2 CParseEditCtrlView::ClientToWorld
		(
		const ivector2&	pos
		)
{
	return pos + m_view_area.Min() + m_scroll_pos;
}
//=================================================================================================
irect CParseEditCtrlView::WorldToClient
		(
		const irect&	r
		)
{
	return r.Move( - m_view_area.Min() - m_scroll_pos );
}
//=================================================================================================
irect CParseEditCtrlView::ClientToWorld
		(
		const irect&	r
		)
{
	return r.Move( m_view_area.Min() + m_scroll_pos );
}
//=================================================================================================
bool CParseEditCtrlView::CanDelete()
{
	int		off , num = m_select.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		iParserItem	item = (iParserItem)SearchItemId( m_select[off] );
		if( item == true && item->m_itemtype == IParserItem::Node )
		{
			IParserNode::Property	prop	= ((iParserNode)item)->GetProperty();
			if( prop.m_type != IParserNode::Property::Start 
			&&  prop.m_type != IParserNode::Property::End )
				return true;
		}
		else if( item == true && item->m_itemtype == IParserItem::Link )
		{
			return true;
		}
	}
	return false;
}
//=================================================================================================
void CParseEditCtrlView::Delete()
{
	if( CanDelete() == false )
		return;
	IUndoList*	undo = m_document->Recode();
	int		off , num = m_select.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		iParserItem	item = (iParserItem)SearchItemId( m_select[off] );
		if( item == true && item->m_itemtype == IParserItem::Node )
		{
			iParserNode	node = (iParserNode)item;
			IParserNode::Property	prop	= node->GetProperty();
			if( prop.m_type != IParserNode::Property::Start 
			&&  prop.m_type != IParserNode::Property::End )
			{
				((iGraphNode)node)->Remove( undo );
			}
		}
		else if( item == true && item->m_itemtype == IParserItem::Link )
		{
			((iGraphLink)item)->Remove( undo );
		}
	}
	m_document->Callback( ICallback::RemoveParserItem , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
bool CParseEditCtrlView::CanCopy()
{
	int	off , num = m_select.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		iParserNode	node = SearchNodeId( m_select[off] );
		if( node == true )
		{
			if( node->GetProperty().m_type != IParserNode::Property::Start
			&&  node->GetProperty().m_type != IParserNode::Property::End )
				return true;
		}
	}
	return false;
}
//=================================================================================================
bool CParseEditCtrlView::Copy()
{
	if( false == CanCopy() )
		return false;

	// items
	Array<iParserItem>	items;
	{
		int					off , num = m_select.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			iParserItem		item	= SearchItemId( m_select[off] );
			if( item == true )
				items[ items.Add() ]	= item;
		}
	}
	if( items.GetDatanum() == 0 )
		return false;
		
	// save
	iParserDoc	doc = (iParserDoc)m_document->SearchTreeId( m_item_id );
	if( doc == false )
		return false;
	instance<MemStreamWrite>	file;
	if( false == file->Open() )
		return false;
	if( false == doc->Save( (iStreamWrite)file , items.GetDatanum() , items.GetPtr() ) )
		return false;
	
	// get data
	int		size;
	const void*	src = file->GetData( &size );
	if( size == 0 )
		return true;

	// copy
	if( false == CopyClipboard( this , GetClipboardFormatParser() , src , size ) )
		return false;
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::CanPaste()
{
	if( false == CheckClipboardId( this , GetClipboardFormatParser() ) )
		return false;
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::Paste()
{
	if( false == CanPaste() )
		return false;
	
	iParserDoc	src;
	{	
		PasteClipboad	clip;
		int				size;
		const void*		p	= clip.Open( this , GetClipboardFormatParser() , &size );
		if( p == 0 )
			return false;

		instance<MemStreamRead>			file;
		instance<document::ParserItem>	parser;

		if( false == file->Open( p , size )
		||  false == parser->Load( (iStreamRead)file ) )
			return false;
		src	= (iParserDoc)parser;
		MoveItemsCenter( (iGraph)src , 0 );
	}
	
	iParserDoc	doc = (iParserDoc)m_document->SearchTreeId( m_item_id );
	if( doc == false )
		return false;
	
	IUndoList*	undo = m_document->Recode();
	PasteItems	paste_items;
	cb_verify( true == doc->Paste( src , false , &paste_items , undo ) );

	// select
	m_select.Resize( 0 );
	int		itemoff , itemnum = paste_items.m_items.GetDatanum();
	for( itemoff = 0 ; itemoff < itemnum ; itemoff++ )
		m_select[ m_select.Add() ]	= paste_items.m_items[itemoff]->m_item_id;

	// callback
	m_document->Callback( ICallback::AddNode , (object)doc , 0 );
	if( m_select.GetDatanum() > 0 )
		m_document->Callback
				( 
				ICallback::SetPropertyItem , 
				(object)SearchItemId( m_select[0] ) , 
				(void*)&ICallback::SetPropertyItemParam( m_item_id , m_select[0] ) 
				);
	else
		m_document->Callback
				( 
				ICallback::SetPropertyItem , 
				object() , 
				(void*)&ICallback::SetPropertyItemParam( 0 , 0 ) 
				);
	return true;
}
//=================================================================================================
bool CParseEditCtrlView::CanSelectAll()
{
	return true;
}
//=================================================================================================
void CParseEditCtrlView::SelectAll()
{
	iGraph	graph = (iGraph)m_document->SearchTreeId( m_item_id );
	if( graph == false )
		return;
	
	int		off ,num = graph->GetNodeNum();
	for( off = 0 ; off < num ; off++ )
	{
		iParserItem		node	= (iParserItem)graph->GetNode( off );
		AddSelect( node->m_item_id );

		iGraphNode	gnode	= (iGraphNode)node;
		int		poff , pnum = gnode->GetOutputNum();
		for( poff = 0 ; poff < pnum ; poff++ )
		{
			iParserItem		pi = (iParserItem)gnode->GetOutput( poff );
			AddSelect( pi->m_item_id );
		}
	}
	DrawSurface();
	SurfaceBlt();
}
//=================================================================================================
void CParseEditCtrlView::MoveSelectItem
		(
		KeyDir				key , 
		int					len
		)
{
	if( m_select.GetDatanum() == 0 )
		return;
	ivector2	mov;
	if( key == Left )
		mov	= ivector2( -len , 0 );
	else if( key == Right )
		mov	= ivector2( len , 0 );
	else if( key == Up )
		mov	= ivector2( 0 , -len );
	else
		mov	= ivector2( 0 , len );
	if( true == MoveSelectItem( m_select[ m_select.GetDatanum() - 1 ] , mov , true ) )
	{
		UpdateViewAreaInKey( key );
		m_document->Callback( ICallback::MoveItems , (object)m_document->SearchTreeId( m_item_id ) , 0 );
	}
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CParseEditCtrlView::CParseEditCtrlView() : 
		m_item_id( 0 ) , 
		m_page_margin( 20 ) , 
		m_scroll_line( 20 ) , 
		m_grid_size( 5 ) , 
		m_grid_draw_num( 5 ) , 
		m_drawed( Expand_ArrayCashType , 32 ) , 
		m_select( Expand_ArrayCashType , 32 ) , 
		m_select_frame_width( 3 ) , 
		m_drag_len( 3 * 3 ) , 
		m_autoscroll_interval( 100 ) , 
		m_pin_size( 10 , 10 ) , 
		m_linkbar_ctrl_size( 8 , 8 ) , 
		m_pin_margin( 10 ) , 
		m_link_info_margin( 5 , 0 ) , 
		m_link_r( 10 ) , 
		m_link_w( 1.0f ) , 
		m_link_ih( 10 ) , 
		m_linkbar_w( 1.0f ) , 
		m_link_area_w( 4 ) , 
		m_color_function( 0 , 0 , 100 , 255 ) , 
		m_color_regular( 0 , 0 , 0 , 255 ) , 
		m_key_scroll_margin( 50 ) , 
		m_desc_margin( 5 , 5 ) , 
		m_color_desc( 110 , 0 , 0 ) , 
		m_undo( 0 ) , 
		m_desc_min( 20 ) , 
		m_font_desc_h( 12 ) , 
		m_font_function_h( 12 ) , 
		m_font_regular_h( 12 )
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );

	// initialize graphics
	m_graphics->SetSurface( (iSurface)m_surface );
	m_graphics->SetAntialias( none_antialias );
	
	// initialize draw element
	m_paint_back					= CreatePaintSolid( rgba( 255 , 255 , 243 ) );
	m_paint_grid					= CreatePaintSolid( rgba( 220 , 230 , 220 ) );
	m_paint_frame_node				= CreatePaintSolid( rgba( 143 , 143 , 248 , 120 ) );
	m_paint_frame_node_stroke		= CreatePaintSolid( rgba( 143 , 143 , 248 , 255 ) );
	m_paint_frame_link				= CreatePaintSolid( rgba( 149 , 234 , 191 , 120 ) );
	m_paint_frame_link_stroke		= CreatePaintSolid( rgba( 86 , 164 , 124 , 255 ) );
	m_paint_select					= CreatePaintSolid( rgba( 0 , 84 , 227 , 20 ) );
	m_paint_select_stroke			= CreatePaintSolid( rgba( 0 , 84 , 227 , 255 ) );
	m_paint_edit_link				= CreatePaintSolid( rgba( 255 , 0 , 0 , 150 ) );
	m_paint_link					= CreatePaintSolid( rgba( 120 , 120 , 120 , 255 ) );
	m_paint_link_info				= CreatePaintSolid( rgba( 120 , 120 , 120 , 255 ) );
	m_paint_pin_stroke				= CreatePaintSolid( rgba( 150 , 50 , 50 , 255 ) );
	m_paint_pin						= CreatePaintSolid( rgba( 255 , 100 , 100 , 150 ) );
	m_paint_linkbar_stroke			= CreatePaintSolid( rgba( 228 , 100 , 50 , 255 ) );
	m_paint_linkbar					= CreatePaintSolid( rgba( 254 , 205 , 139 , 150 ) );
	m_paint_desc_node				= CreatePaintSolid( rgba( 240 , 230 , 230 , 150 ) );
	m_paint_desc_node_stroke		= CreatePaintSolid( rgba( 110 , 0 , 0 , 255 ) );

	CString		facename;
	m_font_desc						= CreateFont( isize( 0 , m_font_desc_h ) , LoadText( IDS_PARSEEDIT_DESC_FACENAME ) );
	m_font_function					= CreateFont( isize( 0 , m_font_function_h ) , LoadText( IDS_PARSEEDIT_FUNCTION_FACENAME ) , Roman_FontCharsetType , 400 , true );
	m_font_regular					= CreateFont( isize( 0 , m_font_regular_h ) , LoadText( IDS_PARSEEDIT_REGULAR_FACENAME ) );

	m_desc_edit.Initialize
			( 
			wstring( LoadText( IDS_PARSEEDIT_DESC_FACENAME ) ) , 
			m_font_desc_h , 
			m_color_desc , 
			rgb( 246 , 240 , 234 ) , 
			isize( m_desc_min , m_desc_min ) 
			);
	
	// load images
	InitializeImgs();
}
//=================================================================================================
CParseEditCtrlView::~CParseEditCtrlView()
{
}
//=================================================================================================
unsigned int CParseEditCtrlView::GetTargetItemId()
{
	return m_item_id;
}
//=================================================================================================
void CParseEditCtrlView::Initialize
		(
		unsigned int	item_id
		)
{
	cb_assert( m_hWnd != NULL , L"initialize called prev create." );	
	cb_assert( m_item_id == 0 , L"initialize called twice." );	

	m_item_id	= item_id;
	StaticStateTrans::Reset();
	
	isize	size;
	{
		CRect	r;
		GetClientRect( &r );
		size	= isize( r.right - r.left , r.bottom - r.top ); 
	}
	InitializeViewArea( size );
	UpdateScroll( SB_HORZ );
	UpdateScroll( SB_VERT );
	
	m_surface->Create_rgb( size , DPI() );
	DrawSurface();
	SurfaceBlt();
	ShowWindow( SW_SHOW );
	SetFocus();
}
//=================================================================================================
object CParseEditCtrlView::GetPropertyItem()
{
	int	num = m_select.GetDatanum();
	if( num == 0 )
		return object();
	return SearchItemId( m_select[0] );
}
//=================================================================================================
unsigned int CParseEditCtrlView::GetParserId()
{
	return m_item_id;
}
//=================================================================================================
unsigned int CParseEditCtrlView::GetPropertyId()
{
	int	num = m_select.GetDatanum();
	if( num == 0 )
		return 0;
	return m_select[0];
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC override
//=================================================================================================
BOOL CParseEditCtrlView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style |= WS_VSCROLL | WS_HSCROLL;
	cs.style &= ~WS_BORDER;
	cs.style &= ~WS_VISIBLE;
	cs.lpszClass = AfxRegisterWndClass
			(
			CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
			::LoadCursor(NULL, IDC_ARROW), 
			NULL , //reinterpret_cast<HBRUSH>(COLOR_WINDOW+1), 
			NULL
			);
	return TRUE;
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
int CParseEditCtrlView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (__super::OnCreate(lpCreateStruct) == -1)
		return -1;

	m_desc_edit.Create( WS_CHILD , CRect( 0 , 0 , 0 , 0 ) , this , ID_DESC_EDIT );

	return 0;
}
//=================================================================================================
void CParseEditCtrlView::OnSize(UINT nType, int cx, int cy)
{
	__super::OnSize(nType, cx, cy);

	if( m_item_id == 0 )
		return;
	UpdateViewArea( isize( cx , cy ) );
	UpdateScroll( SB_HORZ );
	UpdateScroll( SB_VERT );

	m_surface->Create_rgb( isize( cx , cy ) , DPI() );
	DrawSurface();
	SurfaceBlt();
}
//=================================================================================================
void CParseEditCtrlView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	StaticStateTrans::ChangeState( ev_EditDescEnd , TransParam() );
	if( nSBCode == SB_ENDSCROLL )
		return;
	switch( nSBCode )
	{
	case SB_LEFT:
		m_scroll_pos.x	= 0;
		break;
	case SB_RIGHT:
		m_scroll_pos.x	= m_view_area.Width() - m_wndsize.width;
		break;
	case SB_LINELEFT:
		m_scroll_pos.x -= m_scroll_line;
		UpdateViewArea();
		break;
	case SB_LINERIGHT:
		m_scroll_pos.x += m_scroll_line;
		UpdateViewArea();
		break; 
	case SB_PAGELEFT:
		m_scroll_pos.x -= m_wndsize.width;
		break;
	case SB_PAGERIGHT:
		m_scroll_pos.x += m_wndsize.width;
		break;
	case SB_THUMBPOSITION:
		m_scroll_pos.x = nPos - m_view_area.xmin;
		break;
	case SB_THUMBTRACK:
		m_scroll_pos.x = nPos - m_view_area.xmin;
		break;
	}
	UpdateScroll( SB_HORZ );
	DrawSurface();
	SurfaceBlt();
}
//=================================================================================================
void CParseEditCtrlView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	StaticStateTrans::ChangeState( ev_EditDescEnd , TransParam() );
	if( nSBCode == SB_ENDSCROLL )
		return;
	switch( nSBCode )
	{
	case SB_LEFT:
		m_scroll_pos.y	= 0;
		break;
	case SB_RIGHT:
		m_scroll_pos.y	= m_view_area.Height() - m_wndsize.height;
		break;
	case SB_LINELEFT:
		m_scroll_pos.y -= m_scroll_line;
		UpdateViewArea();
		break;
	case SB_LINERIGHT:
		m_scroll_pos.y += m_scroll_line;
		UpdateViewArea();
		break; 
	case SB_PAGELEFT:
		m_scroll_pos.y -= m_wndsize.height;
		break;
	case SB_PAGERIGHT:
		m_scroll_pos.y += m_wndsize.height;
		break;
	case SB_THUMBPOSITION:
		m_scroll_pos.y = nPos - m_view_area.ymin;
		break;
	case SB_THUMBTRACK:
		m_scroll_pos.y = nPos - m_view_area.ymin;
		break;
	}
	UpdateScroll( SB_VERT );
	DrawSurface();
	SurfaceBlt();
}
//=================================================================================================
void CParseEditCtrlView::OnLButtonDown(UINT nFlags, CPoint point)
{
	SetFocus();
	StaticStateTrans::ChangeState( ev_EditDescEnd , TransParam(ivector2( point.x , point.y )) );
	StaticStateTrans::ChangeState( ev_LButtonDown , TransParam(ivector2( point.x , point.y )) );
	__super::OnLButtonDown(nFlags, point);
}
//=================================================================================================
void CParseEditCtrlView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	StaticStateTrans::ChangeState( ev_LDblClick , TransParam(ivector2( point.x , point.y )) );
	__super::OnLButtonDblClk(nFlags, point);
}
//=================================================================================================
void CParseEditCtrlView::OnMouseMove(UINT nFlags, CPoint point)
{
	StaticStateTrans::ChangeState( ev_MouseMove , TransParam(ivector2( point.x , point.y )) );
	__super::OnMouseMove(nFlags, point);
}
//=================================================================================================
void CParseEditCtrlView::OnLButtonUp(UINT nFlags, CPoint point)
{
	StaticStateTrans::ChangeState( ev_LButtonUp , TransParam(ivector2( point.x , point.y )) );
	__super::OnLButtonUp(nFlags, point);
}
//=================================================================================================
void CParseEditCtrlView::OnCancelMode()
{
	__super::OnCancelMode();
	StaticStateTrans::ChangeState( ev_CancelMode , TransParam() );
}
//=================================================================================================
void CParseEditCtrlView::OnTimer(UINT_PTR nIDEvent)
{
	if( nIDEvent == 1 )
		StaticStateTrans::ChangeState( ev_Timer , TransParam() );
	__super::OnTimer(nIDEvent);
}
//=================================================================================================
BOOL CParseEditCtrlView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	int	line = zDelta / WHEEL_DELTA;
	m_scroll_pos.y -= m_scroll_line * line;
	UpdateViewArea();
	UpdateScroll( SB_VERT );
	DrawSurface();
	SurfaceBlt();
	return __super::OnMouseWheel(nFlags, zDelta, pt);
}
//=================================================================================================
void CParseEditCtrlView::OnMouseHWheel(UINT nFlags, short zDelta, CPoint pt)
{
	int	line = zDelta / WHEEL_DELTA;
	m_scroll_pos.x += m_scroll_line * line;
	UpdateViewArea();
	UpdateScroll( SB_HORZ );
	DrawSurface();
	SurfaceBlt();
	__super::OnMouseHWheel(nFlags, zDelta, pt);
}
//=================================================================================================
BOOL CParseEditCtrlView::OnEraseBkgnd(CDC* pDC)
{
	return TRUE;
}
//=================================================================================================
void CParseEditCtrlView::OnPaint() 
{
	CPaintDC dc( this );
	SurfaceBlt( dc.m_hDC );
}
//=================================================================================================
void CParseEditCtrlView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	if( nChar==VK_DELETE )
		Delete();

	__super::OnKeyDown(nChar, nRepCnt, nFlags);
}
//=================================================================================================
void CParseEditCtrlView::OnKillFocusDescEdit()
{
	StaticStateTrans::ChangeState( ev_EditDescEnd , TransParam() );
}
//=================================================================================================
void CParseEditCtrlView::OnChangeDescEdit()
{
	StaticStateTrans::ChangeState( ev_EditDescChange , TransParam() );
}
//=================================================================================================
void CParseEditCtrlView::OnRequestResizeDescEdit(NMHDR *pNMHDR, LRESULT *pResult)
{
	REQRESIZE *pReqResize = reinterpret_cast<REQRESIZE *>(pNMHDR);
	StaticStateTrans::ChangeState( ev_EditDescResize , TransParam( isize( pReqResize->rc.right - pReqResize->rc.left , pReqResize->rc.bottom - pReqResize->rc.top ) ) );
	*pResult = 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC command handler


