
#include "stdafx.h"
#include "Resource.h"
#include "Texml.h"
#include "ParserCtrlView.h"
#include "MainFrm.h"
#include "ParseEditFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/**************************************************************************************************
"CParserCtrlView" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// message map
BEGIN_MESSAGE_MAP(CParserCtrlView, CTreeCtrl)
	ON_WM_CREATE()
	ON_WM_CONTEXTMENU()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_CANCELMODE()
	ON_WM_DESTROY()
	ON_NOTIFY_REFLECT(TVN_ITEMEXPANDED, &CParserCtrlView::OnTvnItemexpanded)
	ON_NOTIFY_REFLECT(TVN_ENDLABELEDIT, &CParserCtrlView::OnTvnEndlabeledit)
	ON_NOTIFY_REFLECT(TVN_BEGINLABELEDIT, &CParserCtrlView::OnTvnBeginlabeledit)
	ON_NOTIFY_REFLECT(TVN_BEGINDRAG, &CParserCtrlView::OnTvnBegindrag)
	ON_NOTIFY_REFLECT(NM_RCLICK, &CParserCtrlView::OnNMRClick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, &CParserCtrlView::OnNMDblclk)

	ON_COMMAND(ID_NEW_FOLDER, OnNewFolder)
	ON_UPDATE_COMMAND_UI(ID_NEW_FOLDER , OnNewFolderUpdate )
	ON_COMMAND(ID_NEW_PARSER, OnNewParser)
	ON_UPDATE_COMMAND_UI(ID_NEW_PARSER , OnNewParserUpdate )
	ON_COMMAND(ID_PARSERVIEW_RENAME, OnRename )
	ON_UPDATE_COMMAND_UI(ID_PARSERVIEW_RENAME , OnRenameUpdate )
	ON_COMMAND(ID_PARSERVIEW_DELETE, OnDelete )
	ON_UPDATE_COMMAND_UI(ID_PARSERVIEW_DELETE , OnDeleteUpdate )
	ON_COMMAND(ID_PARSERVIEW_SETSTART, OnSetStart)
	ON_UPDATE_COMMAND_UI(ID_PARSERVIEW_SETSTART , OnSetStartUpdate )

	ON_COMMAND_EX(ID_EDIT_DELETE, &CParserCtrlView::OnEditDeleteEx)
	ON_UPDATE_COMMAND_UI(ID_EDIT_DELETE, &CParserCtrlView::OnUpdateEditDelete)
	ON_COMMAND_EX(ID_EDIT_CUT, &CParserCtrlView::OnEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, &CParserCtrlView::OnUpdateEditCut)
	ON_COMMAND_EX(ID_EDIT_COPY, &CParserCtrlView::OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, &CParserCtrlView::OnUpdateEditCopy)
	ON_COMMAND_EX(ID_EDIT_PASTE, &CParserCtrlView::OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, &CParserCtrlView::OnUpdateEditPaste)

	ON_WM_KEYDOWN()
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call CParserCtrlView::Callback
		(
		Type	type , 
		object&	obj , 
		void*	param
		)
{
	if( type == ICallback::NewTreeItem )
	{
		UpdateItems();
		iItem	item = (iItem)obj;
		if( item == true )
		{
			HTREEITEM	hitem = SearchItem( GetRootItem() , item->m_item_id );
			if( hitem != NULL )
			{
				SelectItem( hitem );
				EditLabel( hitem );
			}
		}
	}
	else if( type == ICallback::New
	     ||  type == ICallback::Load )
	{
		UpdateItems();
	}  
	else if( type == ICallback::ModifyTreeItem
		  || type == ICallback::DeleteTreeItem
		  || type == ICallback::SetStartParser )
	{
		UpdateItems();
	}
	else if( type == ICallback::MoveTreeItem )
	{
		UpdateItems();
		iItem	item = (iItem)obj;
		if( item == true )
		{
			HTREEITEM	hitem = SearchItem( GetRootItem() , item->m_item_id );
			if( hitem != NULL )
			{
				SelectItem( hitem );
			}
		}
	}
	else if( type == ICallback::Undo || type == ICallback::Redo )
	{
		UpdateItems();
	}
}
//=================================================================================================
HTREEITEM CParserCtrlView::SearchItem
		(
		HTREEITEM		hitem , 
		unsigned int	lparam
		)
{
	if( GetItemData( hitem ) == lparam )
		return hitem;
	HTREEITEM	hchild = GetNextItem( hitem , TVGN_CHILD );
	while( hchild != NULL )
	{
		HTREEITEM	t = SearchItem( hchild , lparam );
		if( t != NULL )
			return t;
		hchild = GetNextItem( hchild , TVGN_NEXT );
	}
	return NULL;
}
//=================================================================================================
void CParserCtrlView::UpdateItem
		(
		HTREEITEM				hitem , 
		treedata::iTreeNode&	node
		)
{
	int	coff , cnum = node->GetChildnum();
	HTREEITEM		hchild = NULL;
	for( coff = 0 ; coff < cnum ; coff++ )
	{
		if( coff == 0 )
			hchild	= GetNextItem( hitem , TVGN_CHILD );
		else
			hchild	= GetNextItem( hchild , TVGN_NEXT );
		if( hchild == NULL )
			hchild	= InsertItem( L"" , hitem , TVI_LAST );

		iItem	child = (iItem )node->GetChild( coff );
		
		if( child->m_type == IItem::Folder )
		{
			iFolderItem	n = (iFolderItem)child;
			SetItem
					(
					hchild ,
					TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM | TVIF_STATE , 
					n->GetName().c_str() , 
					child->m_expand == true ? 2 : 3 , 
					child->m_expand == true ? 2 : 3 , 
					child->m_expand == true ? TVIS_EXPANDED : 0 , 
					TVIS_EXPANDED , 
					child->m_item_id
					);
		}
		else if( child->m_type == IItem::Parser )
		{
			iParserDoc		n = (iParserDoc)child;
			SetItem
					(
					hchild ,
					TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM | TVIF_STATE , 
					n->GetName().c_str() , 
					n->GetStart() == false ? 1 : 4 , 
					n->GetStart() == false ? 1 : 4 , 
					child->m_expand == true ? TVIS_EXPANDED : 0 , 
					TVIS_EXPANDED , 
					child->m_item_id
					);
		}
		UpdateItem( hchild , (treedata::iTreeNode)child );
	}

	// remove
	if( hchild == NULL )
		hchild	= GetNextItem( hitem , TVGN_CHILD );
	else
		hchild	= GetNextItem( hchild , TVGN_NEXT );
	while( NULL != hchild )
	{
		HTREEITEM	t = hchild;
		hchild	= GetNextItem( hchild , TVGN_NEXT );
		CTreeCtrl::DeleteItem( t );
	}
}
//=================================================================================================
void CParserCtrlView::UpdateItems()
{
	
	treedata::iTreeNode	root	= m_document->GetRoot();
	HTREEITEM hroot				= GetRootItem();
	{
		CString	name;
		name.LoadString( IDS_PARSERVIEW_ITEM_0 );

		iItem	item	= (iItem)root;
		if( hroot == NULL )
			hroot	= InsertItem( name );
		SetItem
				(
				hroot ,
				TVIF_TEXT | TVIF_IMAGE | TVIF_PARAM | TVIF_STATE , 
				name , 
				0 , 0 , 
				item->m_expand == true ? TVIS_EXPANDED : 0 , 
				TVIS_EXPANDED , 
				item->m_item_id
				);
	}	
	UpdateItem( hroot , root );
}
//=================================================================================================
treedata::iTreeNode CParserCtrlView::CanNewGroup
		(
		HTREEITEM	hitem
		)
{
	if( hitem == NULL )
		return treedata::iTreeNode();
	treedata::iTreeNode	item = m_document->SearchTreeId( GetItemData( hitem ) );
	if( item == false )
		return treedata::iTreeNode();
	iItem	n = (iItem)item;
	if( n->m_type != IItem::Folder )
		return treedata::iTreeNode();
	return item;
}
//=================================================================================================
treedata::iTreeNode CParserCtrlView::CanNewParser
		(
		HTREEITEM	hitem
		)
{
	if( hitem == NULL )
		return treedata::iTreeNode();
	treedata::iTreeNode	item = m_document->SearchTreeId( GetItemData( hitem ) );
	if( item == false )
		return treedata::iTreeNode();
	iItem	n = (iItem)item;
	if( n->m_type != IItem::Folder )
		return treedata::iTreeNode();
	return item;
}
//=================================================================================================
treedata::iTreeNode CParserCtrlView::CanRename
		(
		HTREEITEM	hitem
		)
{
	if( hitem == NULL )
		return treedata::iTreeNode();
	treedata::iTreeNode	item = m_document->SearchTreeId( GetItemData( hitem ) );
	if( item == false || item->GetParent() == false )
		return treedata::iTreeNode();
	return item;
}
//=================================================================================================
treedata::iTreeNode CParserCtrlView::CanDeleteItem
		(
		HTREEITEM	hitem
		)
{
	if( hitem == NULL )
		return treedata::iTreeNode();
	treedata::iTreeNode	item = m_document->SearchTreeId( GetItemData( hitem ) );
	if( item == false || item->GetParent() == false )
		return treedata::iTreeNode();
	return item;
}
//=================================================================================================
iParserDoc CParserCtrlView::CanSetStart
		(
		HTREEITEM	hitem
		)
{
	if( hitem == NULL )
		return iParserDoc();
	iParserDoc	item = (iParserDoc)m_document->SearchTreeId( GetItemData( hitem ) );
	if( item == false )
		return iParserDoc();
	if( item->GetStart() == true )
		return iParserDoc();
	return item;
}
//=================================================================================================
bool CParserCtrlView::CanInsert
		(
		HTREEITEM				htgt , 
		HTREEITEM				hsrc , 
		int						flag ,		//!< [in] 0 : child , 1:up , 2: down
		treedata::iTreeNode*	p , 
		treedata::iTreeNode*	c , 
		int*					insertpos
		)
{
	if( flag < 0 || flag > 2 )
		return false;
	if( htgt == NULL )
		return false;
	if( hsrc == NULL )
		return false;
	treedata::iTreeNode	tgt	= m_document->SearchTreeId( GetItemData( htgt ) );
	treedata::iTreeNode	src	= m_document->SearchTreeId( GetItemData( hsrc ) );
	if( tgt == false || src == false )
		return false;
	if( true == src->SearchItem( tgt ) )
		return false;
	if( src->GetParent() == false )
		return false;
//	if( src == tgt )
//		return false;
	
	if( tgt->GetParent() == false )
	{
		if( flag != 0 )
			return false;
		store( p , tgt );
		store( c , src );
		store( insertpos , tgt->GetChildnum() );
		return true;
	}
	iItem	n = (iItem)tgt;
	if( n->m_type == IItem::Parser || src == tgt )
	{
		if( flag == 0 )
			return false;
		treedata::iTreeNode		parent = tgt->GetParent();
		int		off	= parent->SearchChild( tgt );
		cb_assert( off >= 0 , L"algorithm error." );
		store( p , parent );
		store( c , src );
		store( insertpos , off + ( flag == 1 ? 0 : 1 ) );
		return true;
	}
	
	if( flag == 0 )
	{
		store( p , tgt );
		store( c , src );
		store( insertpos , tgt->GetChildnum() );
		return true;
	}
	else
	{
		treedata::iTreeNode		parent = tgt->GetParent();
		int		off	= parent->SearchChild( tgt );
		cb_assert( off >= 0 , L"algorithm error." );
		store( p , parent );
		store( c , src );
		store( insertpos , off + ( flag == 1 ? 0 : 1 ) );
		return true;
	}
}
//=================================================================================================
void CParserCtrlView::Insert
		(
		HTREEITEM	hparent , 
		HTREEITEM	hitem , 
		int			flag
		)
{
	treedata::iTreeNode	parent , item;
	int					insrtpos;
	if( false == CanInsert( hparent , hitem , flag , &parent , &item , &insrtpos ) )
		return;
	
	IUndoList*	undo = m_document->Recode();
	parent->AddChild( item , insrtpos , undo );
	m_document->Callback( ICallback::MoveTreeItem , (object)item , 0 );	
}
//=================================================================================================
treedata::iTreeNode CParserCtrlView::IsParser
		(
		HTREEITEM	hitem
		)
{
	if( hitem == NULL )
		return treedata::iTreeNode();
	iItem	n	= (iItem)m_document->SearchTreeId( GetItemData( hitem ) );
	if( n->m_type != IItem::Parser )
		return treedata::iTreeNode();
	return (treedata::iTreeNode)n;
}
//=================================================================================================
void CParserCtrlView::OpenParserEdit()
{
	CMainFrame*		mainframe = DYNAMIC_DOWNCAST( CMainFrame, AfxGetMainWnd() );
	if( mainframe == 0 )
		return;
	mainframe->CreateParserView( (iItem)m_document->SearchTreeId( GetItemData( GetSelectedItem() ) ) );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CParserCtrlView::CParserCtrlView() : 
		m_dragitem( NULL ) , 
		m_dragimage( 0 ) , 
		m_insertflag( -1 )
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );
}
//=================================================================================================
CParserCtrlView::~CParserCtrlView()
{
}
//=================================================================================================
bool CParserCtrlView::CanNewGroup()
{
	if( true == CanNewGroup( GetSelectedItem() ) )
		return true;
	return false;
}
//=================================================================================================
bool CParserCtrlView::CanNewParser()
{
	if( true == CanNewParser( GetSelectedItem() ) )
		return true;
	return false;
}
//=================================================================================================
bool CParserCtrlView::CanRename()
{
	if( true == CanRename( GetSelectedItem() ) )
		return true;
	return false;
}
//=================================================================================================
bool CParserCtrlView::CanDeleteItem()
{
	if( true == CanDeleteItem( GetSelectedItem() ) )
		return true;
	return false;
}
//=================================================================================================
bool CParserCtrlView::CanSetStart()
{
	if( true == CanSetStart( GetSelectedItem() ) )
		return true;
	return false;
}
//=================================================================================================
void CParserCtrlView::NewGroup()
{
	HTREEITEM			hitem	= GetSelectedItem();
	treedata::iTreeNode item	= CanNewGroup( hitem );
	if( item == false )
		return;

	iItem	n = (iItem)item;
	IUndoList*	undo = m_document->Recode();
	instance<document::FolderItem>	folder;
	{
		CString	str;
		str.LoadString(IDS_NEW_GROUP_NAME);
		folder->SetName( (LPCTSTR)str , 0 );
	}
	n->m_expand = true;
	item->AddChild( (treedata::iTreeNode)folder , item->GetChildnum() , undo );
	
	m_document->Callback( ICallback::NewTreeItem , (object)folder , 0 );
}
//=================================================================================================
void CParserCtrlView::NewParser()
{
	HTREEITEM			hitem	= GetSelectedItem();
	treedata::iTreeNode item	= CanNewParser( hitem );
	if( item == false )
		return;

	iItem	n = (iItem)item;
	IUndoList*	undo = m_document->Recode();
	instance<document::ParserItem>	parser;
	{
		CString	str;
		str.LoadString(IDS_NEW_PARSER_NAME);
		parser->SetName( (LPCTSTR)str , 0 );
	}
	n->m_expand = true;
	item->AddChild( (treedata::iTreeNode)parser , item->GetChildnum() , undo );
	
	m_document->Callback( ICallback::NewTreeItem , (object)parser , 0 );
}
//=================================================================================================
void CParserCtrlView::Rename()
{
	HTREEITEM	hitem = GetSelectedItem();
	if( true == CanRename( hitem ) )
		EditLabel( hitem );
}
//=================================================================================================
void CParserCtrlView::DeleteItem()
{
	HTREEITEM			hitem	= GetSelectedItem();
	treedata::iTreeNode item	= CanDeleteItem( hitem );
	if( item == false )
		return;

	IUndoList*	undo = m_document->Recode();
	item->Remove( undo );

	m_document->Callback( ICallback::DeleteTreeItem , (object)item , 0 );
}
//=================================================================================================
void CParserCtrlView::SetStart()
{
	iParserDoc	item= CanSetStart( GetSelectedItem() );
	if( item == false )
		return;

	IUndoList*	undo = m_document->Recode();
	m_document->SetStartParser( item , undo );
	m_document->Callback( ICallback::SetStartParser , (object)item , 0 );
}
//=================================================================================================
iItem CParserCtrlView::CanCopy()
{
	iItem	item = (iItem)m_document->SearchTreeId( GetItemData( GetSelectedItem() ) );
	if( item == false )
		return iItem();
	if( m_document->GetRoot() == item )
		return iItem();
	return item;
}
//=================================================================================================
bool CParserCtrlView::Copy()
{
	iItem	item = CanCopy();
	if( item == false )
		return false;
	
	// save
	UINT	id;
	instance<MemStreamWrite>	file;
	if( false == file->Open() )
		return false;
	if( item->m_type == IItem::Folder )
	{
		if( false == ((iFolderItem)item)->Save( (iStreamWrite)file ) )
			return false;
		id = GetClipboardFormatFolder();
	}
	else if( item->m_type == IItem::Parser )
	{
		if( false == ((iParserDoc)item)->Save( (iStreamWrite)file ) )
			return false;
		id = GetClipboardFormatParser();
	}
	else
		return false;
	
	// get data
	int		size;
	const void*	src = file->GetData( &size );
	if( size == 0 )
		return true;

	// copy
	if( false == CopyClipboard( this , id , src , size ) )
		return false;
	return true;
}
//=================================================================================================
iItem CParserCtrlView::CanPaste()
{
	// check item
	iItem	item = (iItem)m_document->SearchTreeId( GetItemData( GetSelectedItem() ) );
	if( item == false )
		return iItem();
	if( item->m_type != IItem::Folder )
		return iItem();

	// check clipboad data
	if( false == CheckClipboardId( this , GetClipboardFormatFolder() )
	&&  false == CheckClipboardId( this , GetClipboardFormatParser() ) )
		return iItem();
	return item;
}
//=================================================================================================
bool CParserCtrlView::Paste()
{
	iItem	item = CanPaste();
	if( item == false )
		return false;
	
	iItem	src;
	{	
		PasteClipboad	clip;
		const void*		p;
		int				size;
		if( 0 != ( p = clip.Open( this , GetClipboardFormatFolder() , &size ) ) )
		{
			instance<MemStreamRead>			file;
			instance<document::FolderItem>	folder;

			if( true == file->Open( p , size )
			&&  true == folder->Load( (iStreamRead)file ) )
				src	= (iItem)folder;
			file->Close();
		}
		else if( 0 != ( p = clip.Open( this , GetClipboardFormatParser() , &size ) ) )
		{
			instance<MemStreamRead>			file;
			instance<document::ParserItem>	parser;

			if( true == file->Open( p , size )
			&&  true == parser->Load( (iStreamRead)file ) )
			{
				// clear start
				parser->SetStart( false , 0 );
				src	= (iItem)parser;
			}
			file->Close();
		}
	}
	if( src == false )
	{
	    CloseClipboard();
	    return false;
	}
	CloseClipboard();
	
	{
		treedata::iTreeNode	node = (treedata::iTreeNode)item;
		IUndoList*	undo = m_document->Recode();
		node->AddChild( (treedata::iTreeNode)src , node->GetChildnum() , undo );
	}
	m_document->Callback( ICallback::NewTreeItem , (object)src , 0 );
	return true;
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC override functions
//=================================================================================================
BOOL CParserCtrlView::PreTranslateMessage(MSG* pMsg)
{
	if ( pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_RETURN )
	{
		CEdit*	edit = GetEditControl();
		if( edit != 0 )
		{
			EndEditLabelNow( FALSE );
			return 1;
		}
		if( GetFocus() == this )
		{
			OpenParserEdit();
		}
	}
	else if( pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_ESCAPE )
	{
		CEdit*	edit = GetEditControl();
		if( edit != 0 )
		{
			EndEditLabelNow( TRUE );
			return 1;
		}
	}
	return __super::PreTranslateMessage(pMsg);
}
//=================================================================================================
BOOL CParserCtrlView::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style |= TVS_EDITLABELS | TVS_SHOWSELALWAYS;
	return __super::PreCreateWindow(cs);
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event functions
//=================================================================================================
int CParserCtrlView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (__super::OnCreate(lpCreateStruct) == -1)
		return -1;

	// initialize imagelist
	m_imagelist.DeleteImageList();
	UINT bmpid = theApp.m_bHiColorIcons ? IDB_PARSER_VIEW_ITEM_24 : IDB_PARSER_VIEW_ITEM;
	CBitmap bmp;
	if ( !bmp.LoadBitmap( bmpid ) )
	{
		TRACE(_T("bitmap load error: %x\n"), bmpid);
		ASSERT(FALSE);
		return 0;
	}
	BITMAP bmpobj;
	bmp.GetBitmap( &bmpobj );
	UINT flags = ILC_MASK | ( (theApp.m_bHiColorIcons) ? ILC_COLOR24 : ILC_COLOR4 );

	m_imagelist.Create( 16 , bmpobj.bmHeight , flags , 0 , 0 );
	m_imagelist.Add( &bmp , RGB( 192, 192, 192 ) );
	SetImageList( &m_imagelist, TVSIL_NORMAL );
	UpdateItems();
	
	// regist on_cmdmsg fook
	CMainFrame*	main = (CMainFrame*)AfxGetMainWnd();
	if( main != 0 )
		main->RegistCmdMsgCallback( this );
	return 0;
}
//=================================================================================================
void CParserCtrlView::OnDestroy()
{
	CMainFrame*	main = (CMainFrame*)AfxGetMainWnd();
	if( main != 0 )
		main->RemoveCmdMsgCallback( this );
	__super::OnDestroy();
}
//=================================================================================================
BOOL CParserCtrlView::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	BOOL bRes = CTreeCtrl::OnNotify(wParam, lParam, pResult);

	NMHDR* pNMHDR = (NMHDR*)lParam;
	ASSERT(pNMHDR != NULL);

	if (pNMHDR && pNMHDR->code == TTN_SHOW && GetToolTips() != NULL)
	{
		GetToolTips()->SetWindowPos(&wndTop, -1, -1, -1, -1, SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOSIZE);
	}
	return bRes;
}
//=================================================================================================
void CParserCtrlView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	if( nChar == VK_DELETE )
	{
		DeleteItem();
	}
//	else if( nChar == VK_RETURN )
//	{
//		OpenParserEdit();
//	}
	__super::OnKeyDown(nChar, nRepCnt, nFlags);
}
//=================================================================================================
void CParserCtrlView::OnContextMenu(CWnd* /*pWnd*/, CPoint point )
{
	if( m_dragitem != NULL )
		return;

	if ( point != CPoint( -1, -1 ) )
	{
		CPoint pt_tree = point;
		ScreenToClient( &pt_tree );
		HTREEITEM hitem = HitTest( pt_tree, NULL );
		if ( hitem != NULL )
			SelectItem( hitem );
	}
	SetFocus();
	CMenu menu;
	menu.LoadMenu( IDR_PARSER_VIEW_CONTEXT );
	CMenu* psubmenu = menu.GetSubMenu( 0 );
	if ( AfxGetMainWnd()->IsKindOf( RUNTIME_CLASS( CMDIFrameWndEx ) ) )
	{
		CMFCPopupMenu* popup = new CMFCPopupMenu;
		if ( !popup->Create( this , point.x, point.y, (HMENU)psubmenu->m_hMenu, FALSE, TRUE ) )
			return;
		( ( CMDIFrameWndEx* )AfxGetMainWnd() )->OnShowPopupMenu( popup );
		UpdateDialogControls( this , FALSE );
	}
}
//=================================================================================================
void CParserCtrlView::OnTvnItemexpanded(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW ptreeitem = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	
	if( ptreeitem->action == TVE_EXPAND || ptreeitem->action == TVE_COLLAPSE )
	{
		treedata::iTreeNode	item = m_document->SearchTreeId( GetItemData( ptreeitem->itemNew.hItem ) );
		if( item == true )
		{
			iItem	n = (iItem)item;
			n->m_expand	= ( ptreeitem->itemNew.state & TVIS_EXPANDED ) != 0 ? true : false;
			if( n->m_type == IItem::Folder )
			{
				ptreeitem->itemNew.iImage			= n->m_expand==true ? 2 : 3;
				ptreeitem->itemNew.iSelectedImage	= n->m_expand==true ? 2 : 3;
				SetItem( &ptreeitem->itemNew );
			}
		}
	}
	*pResult = 0;
}
//=================================================================================================
void CParserCtrlView::OnTvnBeginlabeledit(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTVDISPINFO pinfo = reinterpret_cast<LPNMTVDISPINFO>(pNMHDR);
	treedata::iTreeNode	item = m_document->SearchTreeId( GetItemData( pinfo->item.hItem ) );

	if( item == false || item->GetParent() == false )
		*pResult = 1;
	else
	{
		( (CMainFrame*)AfxGetMainWnd() )->AccelSuspend();
		*pResult = 0;
	}
}
//=================================================================================================
void CParserCtrlView::OnTvnEndlabeledit(NMHDR *pNMHDR, LRESULT *pResult)
{
	*pResult = 0;
	( (CMainFrame*)AfxGetMainWnd() )->AccelResume();
	
	LPNMTVDISPINFO pinfo = reinterpret_cast<LPNMTVDISPINFO>(pNMHDR);
	if( pinfo->item.pszText == 0 )
		return;

	iItem	item = m_document->SearchTreeId( GetItemData( pinfo->item.hItem ) );
	if( item == false )
		return;

	wstring	name = pinfo->item.pszText;
	if( true == name.empty() )
	{
		CString	str;
		str.LoadString( IDS_MESSAGE_0 );
		AfxMessageBox( str );
		EditLabel( pinfo->item.hItem );
		return;
	}
	
	if( item->m_type == IItem::Folder )
	{
		IUndoList*	undo = m_document->Recode();
		iFolderItem	n = (iFolderItem)item;
		n->SetName( name , undo );
		m_document->Callback( ICallback::ModifyTreeItem , (object)n , 0 );
	}
	else if( item->m_type == IItem::Parser )
	{
		IUndoList*	undo = m_document->Recode();
		iParserDoc	n = (iParserDoc)item;
		n->SetName( name , undo );
		m_document->Callback( ICallback::ModifyTreeItem , (object)n , 0 );
	}
}
//=================================================================================================
void CParserCtrlView::OnTvnBegindrag(NMHDR *pNMHDR, LRESULT *pResult)
{
	*pResult = 0;
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);

	HTREEITEM	hitem = HitTest( pNMTreeView->ptDrag, NULL );
	if( hitem == NULL )
		return;
	cb_assert( m_dragimage == 0 , L"dragimage is not free." );
	if( !( m_dragimage = CreateDragImage( hitem ) ) )
		return;

	m_insertflag	= -1;
	m_dragitem	= hitem;
	POINT pt	= pNMTreeView->ptDrag;
	CRect	r;
	GetItemRect( hitem , &r , TRUE );
	m_dragimage->BeginDrag( 0 , CPoint( pt.x - r.left + 22 , pt.y - r.top ) );

	ClientToScreen( &pt );
	m_dragimage->DragEnter( NULL , pt );
	SetCapture();
}
//=================================================================================================
void CParserCtrlView::OnMouseMove(UINT nFlags, CPoint point)
{
	if( m_dragitem != NULL )
	{
		HTREEITEM hitem = HitTest( point , NULL );

		POINT screen_pt = point;
		ClientToScreen( &screen_pt );
		CImageList::DragMove( screen_pt );
		CImageList::DragShowNolock( FALSE );
		SelectDropTarget( hitem );
		CImageList::DragShowNolock( TRUE );

		m_insertflag = -1;
		CRect		r;
		if( FALSE == GetItemRect( hitem , &r , FALSE ) )
			SetCursor(AfxGetApp()->LoadCursor(IDC_NODROP) );
		else
		{
			if( point.y < r.top + 5 )
			{
				m_insertflag = 1;
				if( true == CanInsert( hitem , m_dragitem , 1 ) )
					SetCursor(AfxGetApp()->LoadCursor(IDC_DROP_INSERT_UP ) );
				else
					SetCursor(AfxGetApp()->LoadCursor(IDC_NO_DROP_INSERT_UP) );
			}
			else if( point.y > r.bottom - 5 )
			{
				m_insertflag = 2;
				if( true == CanInsert( hitem , m_dragitem , 2 ) )
					SetCursor(AfxGetApp()->LoadCursor(IDC_DROP_INSERT_DOWN ) );
				else
					SetCursor(AfxGetApp()->LoadCursor(IDC_NO_DROP_INSERT_DOWN) );
			}
			else
			{
				m_insertflag = 0;
				if( true == CanInsert( hitem , m_dragitem , 0 ) )
					SetCursor(AfxGetApp()->LoadCursor(IDC_DROP_INSERT ) );
				else
					SetCursor(AfxGetApp()->LoadCursor(IDC_NO_DROP_INSERT) );
			}
		}		
	}
	__super::OnMouseMove(nFlags, point);
}
//=================================================================================================
void CParserCtrlView::OnLButtonUp(UINT nFlags, CPoint point)
{
	if( m_dragitem != NULL )
	{
		ReleaseCapture();
		CImageList::DragLeave( this );
		CImageList::EndDrag();
		SelectDropTarget( NULL );
		if( m_dragimage != 0 )
		{
			delete m_dragimage;
			m_dragimage = 0;
		}
		Insert( HitTest( point , NULL ) , m_dragitem , m_insertflag );
		m_dragitem	= NULL;
	}
	__super::OnLButtonUp(nFlags, point);
}
//=================================================================================================
void CParserCtrlView::OnCancelMode()
{
	__super::OnCancelMode();

	if( m_dragitem != NULL )
	{
		m_dragitem	= NULL;
		CImageList::DragLeave(this);
		CImageList::EndDrag();
		SelectDropTarget( NULL );
		if( m_dragimage != 0 )
		{
			delete m_dragimage;
			m_dragimage = 0;
		}
	}
}
//=================================================================================================
void CParserCtrlView::OnNMRClick(NMHDR *pNMHDR, LRESULT *pResult)
{
	SendMessage(WM_CONTEXTMENU, (WPARAM) m_hWnd, GetMessagePos());
	*pResult = 0;
}
//=================================================================================================
void CParserCtrlView::OnNMDblclk(NMHDR *pNMHDR, LRESULT *pResult)
{
	*pResult = 0;

	OpenParserEdit();
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC command functions
//=================================================================================================
void CParserCtrlView::OnNewFolder()
{
	NewGroup();
}
//=================================================================================================
void CParserCtrlView::OnNewParser()
{
	NewParser();
}
//=================================================================================================
void CParserCtrlView::OnRename()
{
	Rename();
}
//=================================================================================================
void CParserCtrlView::OnNewFolderUpdate(CCmdUI* pCmdUI)
{
	if( CanNewGroup() == true )
		pCmdUI->Enable( TRUE );
	else
		pCmdUI->Enable( FALSE );
}
//=================================================================================================
void CParserCtrlView::OnNewParserUpdate(CCmdUI* pCmdUI)
{
	if( CanNewParser() == true )
		pCmdUI->Enable( TRUE );
	else
		pCmdUI->Enable( FALSE );
}
//=================================================================================================
void CParserCtrlView::OnRenameUpdate(CCmdUI* pCmdUI)
{
	if( CanRename() == true )
		pCmdUI->Enable( TRUE );
	else
		pCmdUI->Enable( FALSE );
}
//=================================================================================================
void CParserCtrlView::OnSetStart()
{
	SetStart();
}
//=================================================================================================
void CParserCtrlView::OnSetStartUpdate(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( CanSetStart() == true ? TRUE : FALSE );
}
//=================================================================================================
void CParserCtrlView::OnDelete()
{
	DeleteItem();
}
//=================================================================================================
void CParserCtrlView::OnDeleteUpdate(CCmdUI* pCmdUI)
{
	if( CanDeleteItem() == true )
		pCmdUI->Enable( TRUE );
	else
		pCmdUI->Enable( FALSE );
}
//=================================================================================================
BOOL CParserCtrlView::OnEditDeleteEx(UINT nID)
{
	if( GetFocus() != this && GetEditControl() == 0 )
		return FALSE;

	DeleteItem();
	return TRUE;
}
//=================================================================================================
void CParserCtrlView::OnUpdateEditDelete(CCmdUI *pCmdUI)
{
	if( GetFocus() != this && GetEditControl() == 0 )
	{
		pCmdUI->ContinueRouting();
		return;
	}
	pCmdUI->Enable( CanDeleteItem() == true ? TRUE : FALSE );
}
//=================================================================================================
BOOL CParserCtrlView::OnEditCut(UINT nID)
{
	if( GetFocus() != this && GetEditControl() == 0 )
		return FALSE;
	if ( false == Copy() )
	{
		MessageBox( LoadText( IDS_MSG_6 ) , LoadText( IDS_APPTITLE ) , MB_OK | MB_ICONERROR );
		return TRUE;
	}
	DeleteItem();
	return TRUE;
}
//=================================================================================================
void CParserCtrlView::OnUpdateEditCut(CCmdUI *pCmdUI)
{
	if( GetFocus() != this && GetEditControl() == 0 )
	{
		pCmdUI->ContinueRouting();
		return;
	}
	pCmdUI->Enable( CanCopy() == true ? TRUE : FALSE );
}
//=================================================================================================
BOOL CParserCtrlView::OnEditCopy(UINT nID)
{
	if( GetFocus() != this && GetEditControl() == 0 )
		return FALSE;
	if ( false == Copy() )
	{
		MessageBox( LoadText( IDS_MSG_6 ) , LoadText( IDS_APPTITLE ) , MB_OK | MB_ICONERROR );
		return TRUE;
	}
	return TRUE;
}
//=================================================================================================
void CParserCtrlView::OnUpdateEditCopy(CCmdUI *pCmdUI)
{
	if( GetFocus() != this && GetEditControl() == 0 )
	{
		pCmdUI->ContinueRouting();
		return;
	}
	pCmdUI->Enable( CanCopy() == true ? TRUE : FALSE );
}
//=================================================================================================
BOOL CParserCtrlView::OnEditPaste(UINT nID)
{
	if( GetFocus() != this && GetEditControl() == 0 )
		return FALSE;
	if ( false == Paste() )
	{
		MessageBox( LoadText( IDS_MSG_7 ) , LoadText( IDS_APPTITLE ) , MB_OK | MB_ICONERROR );
		return TRUE;
	}
	return TRUE;
}
//=================================================================================================
void CParserCtrlView::OnUpdateEditPaste(CCmdUI *pCmdUI)
{
	if( GetFocus() != this && GetEditControl() == 0 )
	{
		pCmdUI->ContinueRouting();
		return;
	}
	pCmdUI->Enable( CanPaste() == true ? TRUE : FALSE );
}


