/*
 * Decompiled with CFR 0.152.
 */
package org.banana;

import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.banana.RecursiveSearch;
import org.banana.StringParser;
import org.banana.VitalException;

public class MainForm
implements ActionListener {
    final Font FONT_NAME = new Font("SansSerif", 0, 14);
    final String CHAR_SET_UTF8 = "UTF-8";
    final String CHAR_SET_EUCJP = "EUC_JP";
    final String CHAR_SET_SHIFTJIS = "Shift-JIS";
    JFrame frame = new JFrame("\u30c6\u30ad\u30b9\u30c8\u629c\u304d\u53d6\u308a\u30c4\u30fc\u30eb ver.1.0.0");
    JPanel line1 = new JPanel();
    JPanel line2 = new JPanel();
    JPanel line3 = new JPanel();
    JPanel line4 = new JPanel();
    JPanel line5 = new JPanel();
    JPanel line6 = new JPanel();
    JLabel lblTarget = new JLabel("\u7bc4\u56f2\u59cb\u70b9\u6587\u5b57\uff1a");
    JTextField txtTarget = new JTextField(40);
    JLabel lblTargetEnd = new JLabel("\u7bc4\u56f2\u7d42\u70b9\u6587\u5b57\uff1a");
    JTextField txtTargetEnd = new JTextField(40);
    JLabel lblExtention = new JLabel("\u62e1\u5f35\u5b50\uff1a");
    JTextField txtExtention = new JTextField(3);
    JLabel lblOutCharset = new JLabel("\u51fa\u529b\u6587\u5b57\u30b3\u30fc\u30c9\uff1a");
    JTextField txtOutCharset = new JTextField(8);
    JLabel lblInCharset = new JLabel("\u5165\u529b\u6587\u5b57\u30b3\u30fc\u30c9\uff1a");
    JTextField txtInCharset = new JTextField(8);
    JLabel lblInDir = new JLabel("\u8aad\u307f\u8fbc\u307f\u30d5\u30a9\u30eb\u30c0");
    JTextField txtInDir = new JTextField(37);
    JFileChooser fcInDir = new JFileChooser(System.getProperty("user.dir"));
    JButton btnIn = new JButton("\u8aad\u8fbc\u5143\u30d5\u30a9\u30eb\u30c0");
    JLabel lblOutDir = new JLabel("\u5165\u529b\u5143\u30d5\u30a9\u30eb\u30c0");
    JTextField txtOutDir = new JTextField(37);
    JFileChooser fcOutDir = new JFileChooser(System.getProperty("user.dir"));
    JButton btnOut = new JButton("\u51fa\u529b\u5148\u30d5\u30a9\u30eb\u30c0");
    JButton btnExcec = new JButton("\u5b9f\u884c");

    public void initialize() {
        Insets marg = this.btnExcec.getMargin();
        marg.left += 150;
        marg.right += 150;
        this.btnExcec.setMargin(marg);
        this.lblTarget.setFont(this.FONT_NAME);
        this.lblTarget.setFont(this.FONT_NAME);
        this.lblTargetEnd.setFont(this.FONT_NAME);
        this.lblExtention.setFont(this.FONT_NAME);
        this.lblOutCharset.setFont(this.FONT_NAME);
        this.lblInCharset.setFont(this.FONT_NAME);
        this.btnIn.setFont(this.FONT_NAME);
        this.btnOut.setFont(this.FONT_NAME);
        this.btnExcec.setFont(this.FONT_NAME);
        ImageIcon icon = new ImageIcon("images/logo32.png");
        this.frame.setIconImage(icon.getImage());
        this.btnExcec.addActionListener(this);
        this.line1.setLayout(new FlowLayout(0, 5, 5));
        this.line1.add(this.lblTarget);
        this.line1.add(this.txtTarget);
        this.line5.setLayout(new FlowLayout(0, 5, 5));
        this.line5.add(this.lblTargetEnd);
        this.line5.add(this.txtTargetEnd);
        this.line3.setLayout(new FlowLayout(0, 5, 5));
        this.fcInDir.setFileSelectionMode(1);
        this.txtInDir.setEditable(false);
        this.line3.add(this.txtInDir);
        this.btnIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0 == MainForm.this.fcInDir.showOpenDialog(MainForm.this.frame)) {
                    File fl = MainForm.this.fcInDir.getSelectedFile();
                    MainForm.this.txtInDir.setText(fl.getAbsolutePath());
                }
            }
        });
        this.line3.add(this.btnIn);
        this.line4.setLayout(new FlowLayout(0, 5, 5));
        this.fcOutDir.setFileSelectionMode(1);
        this.txtOutDir.setEditable(false);
        this.line4.add(this.txtOutDir);
        this.line4.add(this.btnOut);
        this.btnOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0 == MainForm.this.fcOutDir.showOpenDialog(MainForm.this.frame)) {
                    File fl = MainForm.this.fcOutDir.getSelectedFile();
                    MainForm.this.txtOutDir.setText(fl.getAbsolutePath());
                }
            }
        });
        this.line2.setLayout(new FlowLayout(0, 5, 5));
        this.line2.add(this.lblExtention);
        this.line2.add(this.txtExtention);
        this.line2.add(this.lblInCharset);
        this.line2.add(this.txtInCharset);
        this.line2.add(this.lblOutCharset);
        this.line2.add(this.txtOutCharset);
        this.line6.setLayout(new FlowLayout(1, 5, 5));
        this.line6.add(this.btnExcec);
        this.frame.add(this.line1);
        this.frame.add(this.line5);
        this.frame.add(this.line3);
        this.frame.add(this.line4);
        this.frame.add(this.line2);
        this.frame.add(this.line6);
        this.frame.setLayout(new GridLayout(6, 1));
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.frame.setResizable(false);
        this.frame.pack();
    }

    public MainForm() {
        this.initialize();
    }

    public void run() {
    }

    public boolean inputChek() {
        File checkOut;
        File checkIn;
        String inPath = this.txtInDir.getText();
        String outPath = this.txtOutDir.getText();
        String target = this.txtTarget.getText();
        String targetEnd = this.txtTargetEnd.getText();
        String inCharset = this.txtInCharset.getText();
        String outCharset = this.txtOutCharset.getText();
        boolean isError = false;
        if (target.equals("")) {
            JOptionPane.showMessageDialog(this.frame, "\u7bc4\u56f2\u59cb\u70b9\u6587\u5b57\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", "\u30a8\u30e9\u30fc", 1);
            isError = true;
        }
        if (targetEnd.equals("")) {
            JOptionPane.showMessageDialog(this.frame, "\u7bc4\u56f2\u7d42\u70b9\u6587\u5b57\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", "\u30a8\u30e9\u30fc", 1);
            isError = true;
        }
        if (!(checkIn = new File(inPath)).isDirectory()) {
            JOptionPane.showMessageDialog(this.frame, "\u8aad\u307f\u8fbc\u307f\u30d5\u30a9\u30eb\u30c0\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", "\u30a8\u30e9\u30fc", 1);
            isError = true;
        }
        if (!(checkOut = new File(outPath)).isDirectory()) {
            JOptionPane.showMessageDialog(this.frame, "\u51fa\u529b\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", "\u30a8\u30e9\u30fc", 1);
            isError = true;
        }
        if (checkIn.equals(checkOut)) {
            JOptionPane.showMessageDialog(this.frame, "\u8aad\u307f\u8fbc\u307f\u30d5\u30a9\u30eb\u30c0\u3068\u51fa\u529b\u5148\u30d5\u30a9\u30eb\u30c0\u306f\u540c\u3058\u306b\u3067\u304d\u307e\u305b\u3093", "\u30a8\u30e9\u30fc", 1);
            isError = true;
        }
        if (!(inCharset.equals("UTF-8") || inCharset.equals("Shift-JIS") || inCharset.equals("EUC_JP") || inCharset.equals(""))) {
            JOptionPane.showMessageDialog(this.frame, "\u5165\u529b\u6587\u5b57\u30b3\u30fc\u30c9\u306b\u6307\u5b9a\u51fa\u6765\u308b\u306e\u306f\u300c\u7a7a\u767d\u300d\u300cUTF-8\u300d\u300cShift-JIS\u300d\u300cEUC_JP\u300d\u306b\u306a\u308a\u307e\u3059\u3002", "\u30a8\u30e9\u30fc", 1);
            isError = true;
        }
        if (!(outCharset.equals("UTF-8") || outCharset.equals("Shift-JIS") || outCharset.equals("EUC_JP") || outCharset.equals(""))) {
            JOptionPane.showMessageDialog(this.frame, "\u51fa\u529b\u6587\u5b57\u30b3\u30fc\u30c9\u306b\u6307\u5b9a\u51fa\u6765\u308b\u306e\u306f\u300c\u7a7a\u767d\u300d\u300cUTF-8\u300d\u300cShift-JIS\u300d\u300cEUC_JP\u300d\u306b\u306a\u308a\u307e\u3059\u3002", "\u30a8\u30e9\u30fc", 1);
            isError = true;
        }
        return !isError;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String inPath = this.txtInDir.getText();
        String outPath = this.txtOutDir.getText();
        int compCount = 0;
        if (!this.inputChek()) {
            return;
        }
        String curCode = "UTF-8";
        if (!this.txtInCharset.getText().equals("")) {
            curCode = this.txtInCharset.getText();
        }
        String newCode = "UTF-8";
        if (!this.txtOutCharset.getText().equals("")) {
            newCode = this.txtOutCharset.getText();
        }
        try {
            RecursiveSearch rs = new RecursiveSearch(inPath);
            rs.setExtension(this.txtExtention.getText());
            rs.Search();
            List<File> files = rs.getFiles();
            for (int i = 0; i < files.size(); ++i) {
                File file = files.get(i);
                StringParser IParser = new StringParser(this.txtTarget.getText(), this.txtTargetEnd.getText(), file);
                IParser.setInCharset(curCode);
                IParser.Parse();
                String areaText = IParser.getArea();
                if (areaText == null || areaText.equals("")) continue;
                String outFilePath = file.getAbsolutePath();
                outFilePath = outFilePath.replace(inPath, outPath);
                File outFile = new File(outFilePath);
                String outFileFolderPath = outFilePath.replaceAll("\\\\[^\\\\]*$", "\\\\");
                File outFolderFile = new File(outFileFolderPath);
                if (!outFolderFile.exists()) {
                    outFolderFile.mkdirs();
                }
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile, false), newCode));
                bw.write(areaText);
                bw.close();
                ++compCount;
            }
            JOptionPane.showMessageDialog(this.frame, "\u51e6\u7406\u7d50\u679c" + String.valueOf(compCount) + "\u4ef6\u3002", "\u51e6\u7406\u7d50\u679c", 1);
        }
        catch (VitalException ex) {
            JOptionPane.showMessageDialog(this.frame, ex.getMessage(), "\u30a8\u30e9\u30fc", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.frame, "\u91cd\u5ea6\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", "\u91cd\u5ea6\u30a8\u30e9\u30fc", 0);
        }
    }
}

