/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.banana;

import java.awt.event.ActionEvent;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.io.*;
import java.util.List;

/**
 *
 * @author t-nishioka
 */
public class MainForm implements ActionListener {

	final Font FONT_NAME=new Font("SansSerif" , Font.PLAIN , 14);

	//文字コード
	final String  CHAR_SET_UTF8="UTF-8" ;
	final String  CHAR_SET_EUCJP="EUC_JP" ;
	final String  CHAR_SET_SHIFTJIS="Shift-JIS" ;

	JFrame frame = new JFrame("テキスト抜き取りツール ver.1.0.0");
	JPanel line1 = new JPanel();
	JPanel line2 = new JPanel();
	JPanel line3 = new JPanel();
	JPanel line4 = new JPanel();
	JPanel line5 = new JPanel();
	JPanel line6 = new JPanel();
	JLabel lblTarget = new JLabel("範囲始点文字：");
	JTextField txtTarget = new JTextField(40);
	JLabel lblTargetEnd = new JLabel("範囲終点文字：");
	JTextField txtTargetEnd = new JTextField(40);
	JLabel lblExtention = new JLabel("拡張子：");
	JTextField txtExtention = new JTextField(3);
	JLabel lblOutCharset = new JLabel("出力文字コード：");
	JTextField txtOutCharset = new JTextField(8);
	JLabel lblInCharset = new JLabel("入力文字コード：");
	JTextField txtInCharset = new JTextField(8);

	JLabel lblInDir = new JLabel("読み込みフォルダ");
	JTextField txtInDir = new JTextField(37);
	JFileChooser fcInDir = new JFileChooser(System.getProperty("user.dir"));
	JButton btnIn = new JButton("読込元フォルダ");
	JLabel lblOutDir = new JLabel("入力元フォルダ");
	JTextField txtOutDir = new JTextField(37);
	JFileChooser fcOutDir = new JFileChooser(System.getProperty("user.dir"));
	JButton btnOut = new JButton("出力先フォルダ");
	JButton btnExcec = new JButton("実行");

	public void initialize() {


		//サイズ変更
		Insets marg = btnExcec.getMargin();
		marg.left += 150;
		marg.right += 150;
		btnExcec.setMargin(marg);

		//フォント変更
		lblTarget.setFont(FONT_NAME);
		lblTarget.setFont(FONT_NAME);
		lblTargetEnd.setFont(FONT_NAME);

		lblExtention.setFont(FONT_NAME);
		lblOutCharset.setFont(FONT_NAME);

		lblInCharset.setFont(FONT_NAME);

		btnIn.setFont(FONT_NAME);
		btnOut.setFont(FONT_NAME);
		btnExcec.setFont(FONT_NAME);

		//アイコン
		ImageIcon icon = new ImageIcon("images/logo32.png");
		frame.setIconImage(icon.getImage());

		btnExcec.addActionListener(this);

		//line1.setLayout(new GridLayout(2, 2));
		//line1.add(lblTarget);
		//line1.add(txtTarget);
		//line1.add(lblTargetEnd);
		//line1.add(txtTargetEnd);

		line1.setLayout(new FlowLayout(FlowLayout.LEFT, 5,5 ));
		line1.add(lblTarget);
		line1.add(txtTarget);

		line5.setLayout(new FlowLayout(FlowLayout.LEFT, 5,5 ));
		line5.add(lblTargetEnd);
		line5.add(txtTargetEnd);


		line3.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 5));
		//line3.add(lblInDir);
		fcInDir.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		txtInDir.setEditable(false);
		line3.add(txtInDir);
		btnIn.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {

				if (JFileChooser.APPROVE_OPTION == fcInDir.showOpenDialog(frame)) {

					File fl = fcInDir.getSelectedFile();
					txtInDir.setText(fl.getAbsolutePath());
				}
			}
		});

		line3.add(btnIn);

		line4.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 5));
		//line4.add(lblOutDir);
		fcOutDir.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		txtOutDir.setEditable(false);
		line4.add(txtOutDir);
		line4.add(btnOut);
		btnOut.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				if (JFileChooser.APPROVE_OPTION == fcOutDir.showOpenDialog(frame)) {

					File fl = fcOutDir.getSelectedFile();
					txtOutDir.setText(fl.getAbsolutePath());
				}
			}
		});

		line2.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 5));
		line2.add(lblExtention);
		line2.add(txtExtention);
		line2.add(lblInCharset);
		line2.add(txtInCharset);
		line2.add(lblOutCharset);
		line2.add(txtOutCharset);

		line6.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));
		line6.add(btnExcec);


		//Container cont = frame.getContentPane();
		//cont.add(line1) ;
		//cont.add(line2) ;
		frame.add(line1);
		frame.add(line5);
		frame.add(line3);
		frame.add(line4);
		frame.add(line2);
		frame.add(line6);

		frame.setLayout(new GridLayout(6, 1));
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
		frame.setResizable(false);
		frame.pack();
	}

	public MainForm() {

		initialize();

	}

	public void run() {
	}

	//フレーム内容のチェック
	public boolean inputChek() {

		String inPath = txtInDir.getText();
		String outPath = txtOutDir.getText();
		String target= txtTarget.getText();
		String targetEnd= txtTargetEnd.getText();
		String inCharset = txtInCharset.getText();
		String outCharset = txtOutCharset.getText();

		boolean isError = false;
		if( target.equals("")){
			JOptionPane.showMessageDialog(frame, "範囲始点文字が入力されていません。", "エラー", JOptionPane.INFORMATION_MESSAGE);
			isError = true;
		}
		if( targetEnd.equals("")){
			JOptionPane.showMessageDialog(frame, "範囲終点文字が入力されていません。", "エラー", JOptionPane.INFORMATION_MESSAGE);
			isError = true;
		}

		// フォルダ選択していない場合
		File checkIn = new File(inPath);
		if (checkIn.isDirectory() == false) {
			//終了ダイアログ
			JOptionPane.showMessageDialog(frame, "読み込みフォルダが選択されていません。", "エラー", JOptionPane.INFORMATION_MESSAGE);
			isError = true;
		}
		File checkOut = new File(outPath);
		if (checkOut.isDirectory() == false) {
			//終了ダイアログ
			JOptionPane.showMessageDialog(frame, "出力先フォルダが選択されていません。", "エラー", JOptionPane.INFORMATION_MESSAGE);
			isError = true;
		}
		if( checkIn.equals(checkOut)){
			JOptionPane.showMessageDialog(frame, "読み込みフォルダと出力先フォルダは同じにできません", "エラー", JOptionPane.INFORMATION_MESSAGE);
			isError = true;
		}


		//入力文字コードが指定のではない場合
		if(inCharset.equals(CHAR_SET_UTF8) == false
				&&  inCharset.equals(CHAR_SET_SHIFTJIS) == false
				&&  inCharset.equals(CHAR_SET_EUCJP) == false
				&&  inCharset.equals("") == false){

			JOptionPane.showMessageDialog(frame, "入力文字コードに指定出来るのは「空白」「UTF-8」「Shift-JIS」「EUC_JP」になります。", "エラー", JOptionPane.INFORMATION_MESSAGE);
			isError = true;

		}

		//出力文字コードが指定のではない場合
		if(outCharset.equals(CHAR_SET_UTF8) == false
				&&  outCharset.equals(CHAR_SET_SHIFTJIS) == false
				&&  outCharset.equals(CHAR_SET_EUCJP) == false
				&&  outCharset.equals("") == false){

			JOptionPane.showMessageDialog(frame, "出力文字コードに指定出来るのは「空白」「UTF-8」「Shift-JIS」「EUC_JP」になります。", "エラー", JOptionPane.INFORMATION_MESSAGE);
			isError = true;
		}

		if (isError) {
			return false;
		} else {
			return true;
		}
	}

	@Override
	public void actionPerformed(ActionEvent e) {

		String inPath = txtInDir.getText();
		String outPath = txtOutDir.getText();
		int compCount  =0;

		//エラーがある場合は処理終了
		if (inputChek() == false) {
			return;
		}

		//入力文字コードを取得（デフォルトUTF-8）
		String curCode = CHAR_SET_UTF8;
		if( txtInCharset.getText().equals("")==false){
			curCode=txtInCharset.getText();
		}

		//出力文字コードを取得（デフォルトUTF-8）
		String newCode = CHAR_SET_UTF8 ;
		if( txtOutCharset.getText().equals("")==false){
			newCode = txtOutCharset.getText();
		}


		//////////ここからテスト <!--i-Infomation[-->((.|\n|\r\n)*)<!--]i-Infomation-->////////

		//全ファイルパス取得
		try {
			RecursiveSearch rs = new RecursiveSearch(inPath);

			rs.setExtension(txtExtention.getText());		//拡張子を指定
			rs.Search();

			List<File> files = rs.getFiles();

			//ファイルループ
			for (int i = 0; i < files.size(); i++) {

				File file = files.get(i);

				//ほんとはこのへんで処理タイプによってインターフェースを変える
				IAreaParser IParser = new StringParser(txtTarget.getText(),txtTargetEnd.getText(),file);

				IParser.setInCharset(curCode);

				//解析（インターフェース）
				IParser.Parse();

				//抜き出す（インターフェース）
				String areaText = IParser.getArea();

				//内容がなければ次の処理
				if (areaText == null || areaText.equals("")) {
					continue;
				}

				//出力
				//書き出しパスを作成
				String outFilePath = file.getAbsolutePath();
				outFilePath = outFilePath.replace(inPath, outPath);
				File outFile = new File(outFilePath);

				//フォルダ判定用
				String outFileFolderPath = outFilePath.replaceAll("\\\\[^\\\\]*$", "\\\\");
				File outFolderFile = new File(outFileFolderPath);

				//フォルダがなければ書き出し
				if (!outFolderFile.exists()) {
					//なければ作成
					outFolderFile.mkdirs();
				}

				//書き出し
				BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile,false),newCode));
				bw.write(areaText);
				bw.close();

				//処理件数のカウントアップ
				++compCount;
			}

			//終了ダイアログ
			JOptionPane.showMessageDialog(frame, "処理結果"+String.valueOf(compCount)+"件。", "処理結果", JOptionPane.INFORMATION_MESSAGE);

		} catch (VitalException ex) {

			JOptionPane.showMessageDialog(
					frame, ex.getMessage(), "エラー",
					JOptionPane.ERROR_MESSAGE);

		} catch (Exception ex) {
			JOptionPane.showMessageDialog(
					frame, "重度エラーが発生しました。", "重度エラー",
					JOptionPane.ERROR_MESSAGE);
		}
	}
}
