/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import org.mafait.thinknowlogy.ContextItem;
import org.mafait.thinknowlogy.GeneralizationItem;
import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.InputOutput;
import org.mafait.thinknowlogy.List;
import org.mafait.thinknowlogy.WordItem;

class ContextList
extends List {
    private boolean isMarkedAsContextWord_ = false;

    private boolean hasRelationContextInSpecificationsOfGeneralizationWords(int relationContextNr) {
        GeneralizationItem currentGeneralizationItem = this.myWordItem().firstGeneralizationItem();
        if (currentGeneralizationItem != null) {
            do {
                WordItem currentGeneralizationWordItem;
                if ((currentGeneralizationWordItem = currentGeneralizationItem.generalizationWordItem()) == null || !currentGeneralizationWordItem.hasRelationContextInSpecificationsInWord(relationContextNr)) continue;
                return true;
            } while ((currentGeneralizationItem = currentGeneralizationItem.nextGeneralizationItem()) != null);
        }
        return false;
    }

    protected ContextList(WordItem myWordItem) {
        this.initializeListVariables('x', "ContextList", myWordItem);
    }

    protected void addToContextWordQuickAccessList() {
        WordItem lastContextWordItem = GlobalVariables.lastContextWordItem;
        if (lastContextWordItem == null) {
            GlobalVariables.firstContextWordItem = this.myWordItem();
        } else {
            lastContextWordItem.nextContextWordItem = this.myWordItem();
        }
        GlobalVariables.lastContextWordItem = this.myWordItem();
    }

    protected boolean hasContext(int contextNr) {
        ContextItem searchContextItem = this.firstActiveContextItem();
        while (searchContextItem != null) {
            if (searchContextItem.contextNr() == contextNr) {
                return true;
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return false;
    }

    protected boolean hasContext(int contextNr, WordItem specificationWordItem) {
        ContextItem searchContextItem = this.firstActiveContextItem();
        while (searchContextItem != null) {
            if (searchContextItem.contextNr() == contextNr && searchContextItem.specificationWordItem() == specificationWordItem) {
                return true;
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return false;
    }

    protected boolean hasContext(int contextNr, int spanishAmbiguousCollectionNr, WordItem specificationWordItem) {
        ContextItem searchContextItem = this.firstActiveContextItem();
        while (searchContextItem != null) {
            if (searchContextItem.contextNr() == contextNr && searchContextItem.spanishAmbiguousCollectionNr() == spanishAmbiguousCollectionNr && searchContextItem.specificationWordItem() == specificationWordItem) {
                return true;
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return false;
    }

    protected boolean hasContextCurrentlyBeenUpdated(int contextNr) {
        ContextItem searchContextItem = this.firstActiveContextItem();
        while (searchContextItem != null) {
            if (searchContextItem.hasCurrentCreationSentenceNr() && searchContextItem.contextNr() == contextNr) {
                return true;
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return false;
    }

    protected boolean isContextSubset(int subsetContextNr, int fullSetContextNr) {
        ContextItem searchContextItem = this.firstActiveContextItem();
        while (searchContextItem != null) {
            WordItem specificationWordItem;
            if (searchContextItem.contextNr() == subsetContextNr && (specificationWordItem = searchContextItem.specificationWordItem()) != null && this.hasContext(fullSetContextNr, specificationWordItem)) {
                return true;
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return false;
    }

    protected int contextNr(WordItem specificationWordItem) {
        ContextItem searchContextItem = this.firstActiveContextItem();
        while (searchContextItem != null) {
            if (searchContextItem.specificationWordItem() == specificationWordItem) {
                return searchContextItem.contextNr();
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return 0;
    }

    protected int contextNr(int spanishAmbiguousCollectionNr, WordItem specificationWordItem) {
        ContextItem searchContextItem = this.firstActiveContextItem();
        while (searchContextItem != null) {
            if (searchContextItem.spanishAmbiguousCollectionNr() == spanishAmbiguousCollectionNr && searchContextItem.specificationWordItem() == specificationWordItem) {
                return searchContextItem.contextNr();
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return 0;
    }

    protected int highestContextNr() {
        int highestContextNr = 0;
        ContextItem searchContextItem = this.firstActiveContextItem();
        while (searchContextItem != null) {
            if (searchContextItem.contextNr() > highestContextNr) {
                highestContextNr = searchContextItem.contextNr();
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return highestContextNr;
    }

    protected byte addContext(short contextWordTypeNr, short specificationWordTypeNr, int contextNr, int spanishAmbiguousCollectionNr, WordItem specificationWordItem) {
        if (contextNr <= 0) {
            return this.startError(1, "The given context number is undefined");
        }
        ContextItem foundContextItem = this.contextItem(contextNr);
        if (foundContextItem == null) {
            if (contextWordTypeNr <= 0 || contextWordTypeNr >= 26) {
                return this.startError(1, "The given context word type is undefined or out of bounds: " + contextWordTypeNr);
            }
            if (specificationWordItem != null && (specificationWordTypeNr <= 0 || specificationWordTypeNr >= 26)) {
                return this.startError(1, "The given specification word type is undefined or out of bounds: " + specificationWordTypeNr);
            }
            if (!this.isMarkedAsContextWord_) {
                this.isMarkedAsContextWord_ = true;
                this.addToContextWordQuickAccessList();
            }
            if (this.addItemToList('+', new ContextItem(contextWordTypeNr, specificationWordTypeNr == 12 ? (short)11 : (short)specificationWordTypeNr, contextNr, spanishAmbiguousCollectionNr, specificationWordItem, this, this.myWordItem())) != 1) {
                return this.addError(1, "I failed to add a context item");
            }
        } else if (foundContextItem.specificationWordItem() != specificationWordItem) {
            if (foundContextItem.specificationWordItem() == null) {
                return this.startError(1, "The given context number is assigned to a pronoun context");
            }
            return this.startError(1, "The given context number is already assigned to another specification word: \"" + foundContextItem.specificationWordItem().anyWordTypeString() + "\"");
        }
        return 1;
    }

    protected byte checkForUnusedRelationContext() {
        ContextItem searchContextItem = this.firstActiveContextItem();
        while (searchContextItem != null && !GlobalVariables.hasDisplayedIntegrityWarning) {
            if (!this.hasRelationContextInSpecificationsOfGeneralizationWords(searchContextItem.contextNr()) && InputOutput.writeDiacriticalText((short)7, "\nI found unused relation context number: " + searchContextItem.contextNr() + ";\n\tContextItem: " + searchContextItem.itemToStringBuffer((short)0) + ".\n") != 1) {
                return this.startError(1, "I failed to write an interface warning");
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    protected byte checkWordItemForUsage(WordItem unusedWordItem) {
        searchContextItem = this.firstActiveContextItem();
        if (unusedWordItem != null) ** GOTO lbl7
        return this.startError(1, "The given unused word item is undefined");
lbl-1000:
        // 1 sources

        {
            if (searchContextItem.specificationWordItem() == unusedWordItem) {
                return this.startError(1, "The specification word item is still in use");
            }
            searchContextItem = searchContextItem.nextContextItem();
lbl7:
            // 2 sources

            ** while (searchContextItem != null)
        }
lbl8:
        // 1 sources

        return 1;
    }

    protected ContextItem firstActiveContextItem() {
        return (ContextItem)this.firstActiveItem();
    }

    protected ContextItem contextItem(int contextNr) {
        ContextItem searchContextItem = this.firstActiveContextItem();
        while (searchContextItem != null) {
            if (searchContextItem.contextNr() == contextNr) {
                return searchContextItem;
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return null;
    }

    protected ContextItem contextItem(boolean isCompoundCollectionSpanishAmbiguous, int nContextWords, int spanishAmbiguousCollectionNr, WordItem specificationWordItem) {
        ContextItem searchContextItem = this.firstActiveContextItem();
        WordItem anyWordItem = this.myWordItem();
        while (searchContextItem != null) {
            if (searchContextItem.specificationWordItem() == specificationWordItem) {
                int searchSpanishAmbiguousCollectionNr = searchContextItem.spanishAmbiguousCollectionNr();
                if (!isCompoundCollectionSpanishAmbiguous && (searchSpanishAmbiguousCollectionNr == 0 || searchSpanishAmbiguousCollectionNr == spanishAmbiguousCollectionNr) && anyWordItem.nContextWords(searchContextItem.contextNr(), specificationWordItem) == nContextWords || isCompoundCollectionSpanishAmbiguous && searchSpanishAmbiguousCollectionNr == spanishAmbiguousCollectionNr) {
                    return searchContextItem;
                }
            }
            searchContextItem = searchContextItem.nextContextItem();
        }
        return null;
    }
}

