/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.GrammarItem;
import org.mafait.thinknowlogy.GrammarResultType;
import org.mafait.thinknowlogy.InputOutput;
import org.mafait.thinknowlogy.List;
import org.mafait.thinknowlogy.WordEndingResultType;
import org.mafait.thinknowlogy.WordItem;

class GrammarList
extends List {
    private boolean isCheckingGrammarNeeded_ = false;
    private GrammarItem firstFeminineProperNounEndingGrammarItem_ = null;
    private GrammarItem firstMasculineProperNounEndingGrammarItem_ = null;
    private GrammarItem firstFeminineSingularNounEndingGrammarItem_ = null;
    private GrammarItem firstMasculineSingularNounEndingGrammarItem_ = null;
    private GrammarItem firstPluralNounEndingGrammarItem_ = null;
    private GrammarItem firstMergedWordGrammarItem_ = null;
    private GrammarItem firstChineseExclusiveNounGrammarItem_ = null;
    private GrammarItem firstSentenceGrammarItem_ = null;
    private GrammarItem firstStatementGrammarItem_ = null;
    private GrammarItem firstQuestionGrammarItem_ = null;

    private static boolean isText(int endPosition, String sentenceString) {
        boolean isText = false;
        int currentPosition = 0;
        if (sentenceString != null) {
            while (++currentPosition < endPosition) {
                if (sentenceString.charAt(currentPosition) != '\"' || sentenceString.charAt(currentPosition - 1) == '\\') continue;
                boolean bl = isText = !isText;
            }
        }
        return isText;
    }

    private static boolean isWordEnding(short grammarParameter) {
        return grammarParameter == 3000 || grammarParameter == 3001 || grammarParameter == 3002 || grammarParameter == 3003 || grammarParameter == 3004 || grammarParameter == 3005 || grammarParameter == 3006;
    }

    private GrammarItem firstActiveGrammarItem() {
        return (GrammarItem)this.firstActiveItem();
    }

    private GrammarItem firstWordEndingGrammarItem(short grammarParameter) {
        switch (grammarParameter) {
            case 3000: {
                return this.firstFeminineProperNounEndingGrammarItem_;
            }
            case 3001: {
                return this.firstMasculineProperNounEndingGrammarItem_;
            }
            case 3002: {
                return this.firstFeminineSingularNounEndingGrammarItem_;
            }
            case 3003: {
                return this.firstMasculineSingularNounEndingGrammarItem_;
            }
            case 3004: {
                return this.firstPluralNounEndingGrammarItem_;
            }
            case 3005: {
                return this.firstMergedWordGrammarItem_;
            }
            case 3006: {
                return this.firstChineseExclusiveNounGrammarItem_;
            }
        }
        return null;
    }

    protected GrammarList(WordItem myWordItem) {
        this.initializeListVariables('l', "GrammarList", myWordItem);
    }

    protected void markAsChoiceEnd() {
        boolean hasFound = false;
        int currentSentenceItemNr = GlobalVariables.currentSentenceItemNr;
        GrammarItem searchGrammarItem = this.firstActiveGrammarItem();
        while (!hasFound && searchGrammarItem != null) {
            if (searchGrammarItem.itemNr() == currentSentenceItemNr) {
                hasFound = true;
                searchGrammarItem.isChoiceEnd = true;
            }
            searchGrammarItem = searchGrammarItem.nextGrammarItem();
        }
    }

    protected void markAsOptionEnd() {
        boolean hasFound = false;
        int currentSentenceItemNr = GlobalVariables.currentSentenceItemNr;
        GrammarItem searchGrammarItem = this.firstActiveGrammarItem();
        while (!hasFound && searchGrammarItem != null) {
            if (searchGrammarItem.itemNr() == currentSentenceItemNr) {
                hasFound = true;
                searchGrammarItem.isOptionEnd = true;
            }
            searchGrammarItem = searchGrammarItem.nextGrammarItem();
        }
    }

    protected boolean hasMergedWords() {
        return this.firstMergedWordGrammarItem_ != null;
    }

    protected boolean isCheckingGrammarNeeded() {
        return this.isCheckingGrammarNeeded_;
    }

    protected byte checkForDuplicateGrammarDefinition() {
        GrammarItem definitionGrammarItem = null;
        GrammarItem duplicateDefinitionGrammarItem = null;
        GrammarItem searchGrammarItem = this.firstActiveGrammarItem();
        while (searchGrammarItem != null && duplicateDefinitionGrammarItem == null) {
            if (searchGrammarItem.isDefinitionStart()) {
                if (searchGrammarItem.hasCurrentCreationSentenceNr()) {
                    definitionGrammarItem = searchGrammarItem;
                } else if (definitionGrammarItem != null) {
                    String grammarString = searchGrammarItem.grammarString();
                    String definitionGrammarString = definitionGrammarItem.grammarString();
                    if (grammarString != null && definitionGrammarString != null && definitionGrammarString.equals(grammarString)) {
                        searchGrammarItem.isGrammarItemInUse = true;
                        duplicateDefinitionGrammarItem = searchGrammarItem;
                        definitionGrammarItem.nextDefinitionGrammarItem = searchGrammarItem;
                    }
                }
            }
            searchGrammarItem = searchGrammarItem.nextGrammarItem();
        }
        if (definitionGrammarItem == null) {
            return this.startError(1, "I couldn't find the last grammar definition word");
        }
        if (duplicateDefinitionGrammarItem != null) {
            do {
                boolean isIdentical = true;
                GrammarItem currentGrammarItem = definitionGrammarItem;
                GrammarItem duplicateGrammarItem = duplicateDefinitionGrammarItem;
                do {
                    if (currentGrammarItem.isIdentical(duplicateGrammarItem)) {
                        GrammarItem nextGrammarItem;
                        currentGrammarItem = nextGrammarItem = currentGrammarItem.nextGrammarItem();
                        duplicateGrammarItem = nextGrammarItem = duplicateGrammarItem.nextGrammarItem();
                        continue;
                    }
                    isIdentical = false;
                } while (isIdentical && currentGrammarItem != null && duplicateGrammarItem != null);
                if (!isIdentical || currentGrammarItem != null || duplicateGrammarItem != null) continue;
                return this.startError(1, "I found a duplicate grammar definition");
            } while ((duplicateDefinitionGrammarItem = duplicateDefinitionGrammarItem.nextDefinitionGrammarItem) != null);
        }
        return 1;
    }

    protected byte checkGrammar() {
        short currentWordTypeNr = 25;
        WordItem currentLangugeWordItem = this.myWordItem();
        GrammarItem currentGrammarItem = this.firstActiveGrammarItem();
        if (currentGrammarItem == null) {
            return this.startError(1, "I couldn't find any grammar item");
        }
        this.isCheckingGrammarNeeded_ = false;
        do {
            if (currentGrammarItem.isDefinitionStart()) {
                short grammarWordTypeNr;
                if (currentGrammarItem.isNewStart() && currentGrammarItem.isUserDefinedWord() && (grammarWordTypeNr = currentGrammarItem.grammarWordTypeNr()) <= currentWordTypeNr) {
                    if (grammarWordTypeNr < currentWordTypeNr) {
                        if (grammarWordTypeNr + 1 == currentWordTypeNr) {
                            if (InputOutput.writeInterfaceText((short)4, (short)1106, currentWordTypeNr, (short)1107, currentLangugeWordItem.anyWordTypeString(), (short)1111) != 1) {
                                return this.addError(1, "I failed to write the 'grammar word type definition missing' interface notification");
                            }
                            currentWordTypeNr = grammarWordTypeNr;
                        } else {
                            if (InputOutput.writeInterfaceText((short)4, (short)1108, grammarWordTypeNr + 1, (short)1109, currentWordTypeNr, (short)1110, currentLangugeWordItem.anyWordTypeString(), (short)1111) != 1) {
                                return this.addError(1, "I failed to write the 'grammar word type definitions missing' interface notification");
                            }
                            currentWordTypeNr = grammarWordTypeNr;
                        }
                    }
                    currentWordTypeNr = (short)(currentWordTypeNr - 1);
                }
                if (currentGrammarItem.isGrammarItemInUse || currentGrammarItem.isGrammarStart() || currentGrammarItem.isUndefinedWord() || currentGrammarItem.isUserDefinedWord() || GrammarList.isWordEnding(currentGrammarItem.grammarParameter()) || InputOutput.writeInterfaceText((short)4, (short)1100, currentGrammarItem.grammarString(), (short)1101, currentLangugeWordItem.anyWordTypeString(), (short)1102) == 1) continue;
                return this.addError(1, "I failed to write the 'grammar definition is not used' interface notification");
            }
            if (currentGrammarItem.definitionGrammarItem != null) continue;
            return this.startError(1, "Grammar word \"" + currentGrammarItem.grammarString() + "\" in " + currentLangugeWordItem.anyWordTypeString() + " is used, but not defined");
        } while ((currentGrammarItem = currentGrammarItem.nextGrammarItem()) != null);
        return 1;
    }

    protected byte linkLaterDefinedGrammarWords() {
        GrammarItem definitionGrammarItem = this.firstActiveGrammarItem();
        if (definitionGrammarItem == null) {
            return this.startError(1, "I couldn't find any grammar item");
        }
        String definitionGrammarString = definitionGrammarItem.grammarString();
        if (definitionGrammarString == null) {
            return this.startError(1, "The grammar string of the grammar definition word is undefined");
        }
        GrammarItem currentGrammarItem = definitionGrammarItem;
        while ((currentGrammarItem = currentGrammarItem.nextGrammarItem()) != null) {
            String grammarString = currentGrammarItem.grammarString();
            if (grammarString == null) {
                return this.startError(1, "The grammar string of the grammar definition word is undefined");
            }
            if (currentGrammarItem.definitionGrammarItem != null || currentGrammarItem.isDefinitionStart() || !definitionGrammarString.equals(grammarString)) continue;
            definitionGrammarItem.isGrammarItemInUse = true;
            currentGrammarItem.definitionGrammarItem = definitionGrammarItem;
        }
        return 1;
    }

    protected byte expandMergedWordsInReadSentence(StringBuffer readUserSentenceStringBuffer) {
        GrammarItem expandMergedWordGrammarItem = this.firstMergedWordGrammarItem_;
        if (readUserSentenceStringBuffer == null) {
            return this.startError(1, "The given read user sentence string buffer is undefined");
        }
        GlobalVariables.readUserSentenceStringBuffer = readUserSentenceStringBuffer;
        int readUserSentenceStringBufferLength = readUserSentenceStringBuffer.length();
        if (readUserSentenceStringBufferLength == 0) {
            return this.startError(1, "The given read user sentence string buffer is empty");
        }
        if (expandMergedWordGrammarItem == null) {
            return this.startError(1, "No grammar merged word definition was found");
        }
        do {
            int offset;
            if (!expandMergedWordGrammarItem.isDefinitionStart()) continue;
            GrammarItem searchMergedWordGrammarItem = expandMergedWordGrammarItem.nextDefinitionGrammarItem;
            if (searchMergedWordGrammarItem == null) {
                return this.startError(1, "I found a merged word definition without replacing merged word definition");
            }
            int previousPosition = 0;
            int startPosition = 0;
            while (startPosition < readUserSentenceStringBufferLength && (offset = readUserSentenceStringBuffer.substring(startPosition).indexOf(searchMergedWordGrammarItem.grammarString())) >= 0) {
                if ((startPosition += offset) == 0 || startPosition > 0 && Character.isWhitespace(readUserSentenceStringBuffer.charAt(startPosition - 1))) {
                    if (GrammarList.isText(offset, readUserSentenceStringBuffer.substring(previousPosition))) {
                        ++startPosition;
                        continue;
                    }
                    previousPosition = startPosition;
                    readUserSentenceStringBuffer = GlobalVariables.readUserSentenceStringBuffer = new StringBuffer(String.valueOf(readUserSentenceStringBuffer.substring(0, startPosition)) + expandMergedWordGrammarItem.grammarString() + readUserSentenceStringBuffer.substring(startPosition + searchMergedWordGrammarItem.grammarString().length()));
                    readUserSentenceStringBufferLength = readUserSentenceStringBuffer.length();
                    continue;
                }
                ++startPosition;
            }
        } while ((expandMergedWordGrammarItem = expandMergedWordGrammarItem.nextWordEndingGrammarItem()) != null);
        return 1;
    }

    protected byte shrinkMergedWordsInWriteSentence() {
        int writtenSentenceStringBufferLength;
        GrammarItem searchMergedWordGrammarItem = this.firstMergedWordGrammarItem_;
        StringBuffer writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer;
        if (writtenSentenceStringBuffer == null || (writtenSentenceStringBufferLength = writtenSentenceStringBuffer.length()) == 0) {
            return this.startError(1, "The write sentence string buffer is empty");
        }
        if (searchMergedWordGrammarItem == null) {
            return this.startError(1, "No grammar merged word definition was found");
        }
        do {
            int offset;
            if (!searchMergedWordGrammarItem.isDefinitionStart()) continue;
            GrammarItem shrinkMergedWordGrammarItem = searchMergedWordGrammarItem.nextDefinitionGrammarItem;
            if (shrinkMergedWordGrammarItem == null) {
                return this.startError(1, "I found a merged word definition without replacing merged word definition");
            }
            int previousPosition = 0;
            int startPosition = 0;
            while (startPosition < writtenSentenceStringBufferLength && (offset = writtenSentenceStringBuffer.substring(startPosition).indexOf(searchMergedWordGrammarItem.grammarString())) >= 0) {
                if ((startPosition += offset) == 0 || startPosition > 0 && Character.isWhitespace(writtenSentenceStringBuffer.charAt(startPosition - 1))) {
                    if (GrammarList.isText(offset, writtenSentenceStringBuffer.substring(previousPosition))) {
                        ++startPosition;
                        continue;
                    }
                    previousPosition = startPosition;
                    writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer = new StringBuffer(String.valueOf(writtenSentenceStringBuffer.substring(0, startPosition)) + shrinkMergedWordGrammarItem.grammarString() + writtenSentenceStringBuffer.substring(startPosition + searchMergedWordGrammarItem.grammarString().length()));
                    writtenSentenceStringBufferLength = writtenSentenceStringBuffer.length();
                    continue;
                }
                ++startPosition;
            }
        } while ((searchMergedWordGrammarItem = searchMergedWordGrammarItem.nextWordEndingGrammarItem()) != null);
        return 1;
    }

    protected String grammarStringInList(short wordTypeNr) {
        GrammarItem searchGrammarItem = this.firstActiveGrammarItem();
        while (searchGrammarItem != null) {
            if (searchGrammarItem.isDefinitionStart() && searchGrammarItem.isNewStart() && searchGrammarItem.isUserDefinedWord() && searchGrammarItem.grammarWordTypeNr() == wordTypeNr) {
                return searchGrammarItem.grammarString();
            }
            searchGrammarItem = searchGrammarItem.nextGrammarItem();
        }
        return null;
    }

    protected GrammarItem firstReadingGrammarItem() {
        return this.firstSentenceGrammarItem_;
    }

    protected GrammarItem firstWritingGrammarItem(boolean isQuestion) {
        return isQuestion && this.firstQuestionGrammarItem_ != null ? this.firstQuestionGrammarItem_ : this.firstStatementGrammarItem_;
    }

    protected GrammarResultType createGrammarItem(boolean isDefinitionStart, boolean isNewStart, boolean isOptionStart, boolean isChoiceStart, boolean isSkipOptionForWriting, short wordTypeNr, short grammarParameter, int grammarStringLength, String grammarString, GrammarItem definitionGrammarItem) {
        GrammarItem createdGrammarItem;
        GrammarResultType grammarResult = new GrammarResultType();
        if (wordTypeNr < 0 || wordTypeNr >= 26) {
            return this.startGrammarResultError(1, "The given word type number is out of bounds");
        }
        grammarResult.grammarItem = createdGrammarItem = new GrammarItem(isDefinitionStart, isNewStart, isOptionStart, isChoiceStart, isSkipOptionForWriting, wordTypeNr, grammarParameter, grammarStringLength, grammarString, definitionGrammarItem, this, this.myWordItem());
        if (this.addItemToList('+', createdGrammarItem) != 1) {
            return this.addGrammarResultError(1, "I failed to add a grammar item");
        }
        this.isCheckingGrammarNeeded_ = true;
        if (createdGrammarItem.isDefinitionStart()) {
            switch (grammarParameter) {
                case 3000: {
                    this.firstFeminineProperNounEndingGrammarItem_ = createdGrammarItem;
                    break;
                }
                case 3001: {
                    this.firstMasculineProperNounEndingGrammarItem_ = createdGrammarItem;
                    break;
                }
                case 3002: {
                    this.firstFeminineSingularNounEndingGrammarItem_ = createdGrammarItem;
                    break;
                }
                case 3003: {
                    this.firstMasculineSingularNounEndingGrammarItem_ = createdGrammarItem;
                    break;
                }
                case 3004: {
                    this.firstPluralNounEndingGrammarItem_ = createdGrammarItem;
                    break;
                }
                case 3005: {
                    this.firstMergedWordGrammarItem_ = createdGrammarItem;
                    break;
                }
                case 3006: {
                    this.firstChineseExclusiveNounGrammarItem_ = createdGrammarItem;
                    break;
                }
                case 4000: {
                    this.firstSentenceGrammarItem_ = createdGrammarItem;
                    break;
                }
                case 4010: {
                    this.firstStatementGrammarItem_ = createdGrammarItem;
                    break;
                }
                case 4020: {
                    this.firstQuestionGrammarItem_ = createdGrammarItem;
                }
            }
        }
        return grammarResult;
    }

    protected GrammarResultType findGrammar(boolean isIgnoringGrammarParameter, short grammarParameter, int grammarStringLength, String grammarString) {
        GrammarItem foundGrammarItem = null;
        GrammarItem searchGrammarItem = this.firstActiveGrammarItem();
        GrammarResultType grammarResult = new GrammarResultType();
        if (grammarString == null) {
            return this.startGrammarResultError(1, "The given grammar string is undefined");
        }
        do {
            if (searchGrammarItem.grammarString() == null) {
                return this.startGrammarResultError(1, "I found a grammar word without grammar string");
            }
            if (!searchGrammarItem.isDefinitionStart() || !isIgnoringGrammarParameter && searchGrammarItem.grammarParameter() != grammarParameter || grammarStringLength != searchGrammarItem.grammarString().length() || !grammarString.startsWith(searchGrammarItem.grammarString())) continue;
            foundGrammarItem = searchGrammarItem;
        } while (foundGrammarItem == null && (searchGrammarItem = searchGrammarItem.nextGrammarItem()) != null);
        grammarResult.grammarItem = foundGrammarItem;
        return grammarResult;
    }

    protected WordEndingResultType analyzeWordEnding(short grammarParameter, int searchWordStringLength, String searchWordString) {
        WordEndingResultType wordEndingResult = new WordEndingResultType();
        if (searchWordString == null) {
            return this.startWordEndingResultError(1, "The given search word string is undefined");
        }
        if (!GrammarList.isWordEnding(grammarParameter)) {
            return this.startWordEndingResultError(1, "The given grammar parameter is no word ending parameter");
        }
        GrammarItem searchGrammarItem = this.firstWordEndingGrammarItem(grammarParameter);
        if (searchGrammarItem != null) {
            if (searchWordStringLength == 0) {
                searchWordStringLength = searchWordString.length();
            }
            if (searchWordStringLength > 0) {
                do {
                    int wordLengthDifference;
                    String replacingWordEndingString;
                    int wordEndingStringLength;
                    String wordEndingString;
                    if (!searchGrammarItem.isDefinitionStart() || (wordEndingString = searchGrammarItem.itemString()) == null || (wordEndingStringLength = wordEndingString.length()) <= 0) continue;
                    int chineseRadicalValue = 0;
                    int replacingWordStringLength = 0;
                    GrammarItem replacingWordEndingGrammarItem = searchGrammarItem.nextDefinitionGrammarItem;
                    if (replacingWordEndingGrammarItem == null) {
                        replacingWordEndingString = null;
                    } else {
                        replacingWordEndingString = replacingWordEndingGrammarItem.grammarString();
                        if (replacingWordEndingString != null) {
                            if (Character.isDigit(wordEndingString.charAt(0))) {
                                try {
                                    chineseRadicalValue = searchWordString.codePointAt(0);
                                    if (chineseRadicalValue >= Integer.parseInt(wordEndingString) && chineseRadicalValue <= Integer.parseInt(replacingWordEndingString)) {
                                        wordEndingResult.hasFoundWordEnding = true;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {}
                            } else {
                                replacingWordStringLength = replacingWordEndingString.length();
                            }
                        }
                    }
                    if (chineseRadicalValue != 0 || (wordLengthDifference = searchWordStringLength - wordEndingStringLength) < 0 || !searchWordString.substring(wordLengthDifference).startsWith(wordEndingString)) continue;
                    wordEndingResult.hasFoundWordEnding = true;
                    wordEndingResult.wordStringLength = wordLengthDifference + replacingWordStringLength;
                    wordEndingResult.wordString = String.valueOf(searchWordString.substring(0, wordLengthDifference)) + (replacingWordEndingString == null ? "" : replacingWordEndingString);
                } while (!wordEndingResult.hasFoundWordEnding && (searchGrammarItem = searchGrammarItem.nextWordEndingGrammarItem()) != null);
            }
        }
        return wordEndingResult;
    }
}

