/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import org.mafait.thinknowlogy.Console;
import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.WordItem;

class InputOutput {
    private static boolean hasReadLine_;
    private static boolean isDisplayingExtraPromptLine_;
    private static short lastShownInterfaceParameter_;
    private static short lastUsedPromptTypeNr_;
    private static int currentPosition_;
    private static int previousProgress_;
    private static BufferedWriter testFile_;
    private static String classNameString_;
    private static StringBuffer currentStatusStringBuffer_;
    private static StringBuffer outputStringBuffer_;

    static {
        classNameString_ = "InputOutput";
    }

    InputOutput() {
    }

    private static void clearStatus() {
        currentStatusStringBuffer_ = null;
        Console.clearProgress();
    }

    private static void displayStatus(short interfaceParameter) {
        WordItem currentLanguageWordItem = GlobalVariables.currentLanguageWordItem;
        String newStatusString = currentLanguageWordItem == null ? "{no language word found}" : currentLanguageWordItem.interfaceString(interfaceParameter);
        if (newStatusString == null) {
            InputOutput.clearStatus();
        } else if (currentStatusStringBuffer_ == null || currentStatusStringBuffer_.indexOf(newStatusString) == -1) {
            currentStatusStringBuffer_ = new StringBuffer(String.valueOf(newStatusString) + (newStatusString.endsWith(".") ? "" : "..."));
            Console.displayProgressStatus(currentStatusStringBuffer_.toString());
        }
    }

    private static void returnOutputToPosition(boolean isSkippingInTestFile, boolean isWriting) {
        currentPosition_ = 0;
        InputOutput.addStringToOutput(isSkippingInTestFile, isWriting, "\r\n");
    }

    private static void addStringToOutput(boolean isSkippingInTestFile, boolean isWriting, String writeString) {
        outputStringBuffer_.append(writeString);
        if (isWriting && outputStringBuffer_.length() > 0) {
            if (isSkippingInTestFile || testFile_ == null) {
                Console.writeText(outputStringBuffer_.toString());
            } else {
                try {
                    testFile_.write(outputStringBuffer_.toString());
                }
                catch (IOException exception) {
                    Console.writeText("IOException: Failed to write to test file: \"" + outputStringBuffer_.toString() + "\".\n");
                }
            }
            outputStringBuffer_ = new StringBuffer();
        }
    }

    private static byte writeDiacriticalText(boolean isFirstCharacterToUpperCase, boolean isReturningToPosition, short promptTypeNr, String diacriticalTextString) {
        boolean hasFoundNewLine = false;
        int position = 0;
        char textChar = '?';
        StringBuffer textStringBuffer = new StringBuffer();
        if (diacriticalTextString != null) {
            isDisplayingExtraPromptLine_ = true;
            while (GlobalVariables.result == 1 && position < diacriticalTextString.length()) {
                if (diacriticalTextString.charAt(position) == '\\') {
                    if (++position < diacriticalTextString.length()) {
                        char c = InputOutput.convertDiacriticalChar(diacriticalTextString.charAt(position));
                        textChar = c;
                        if (c == '\n') {
                            hasFoundNewLine = true;
                        }
                    } else {
                        InputOutput.displayError('?', classNameString_, null, null, 1, "The text string ended with a diacritical sign");
                        GlobalVariables.result = 0;
                    }
                } else {
                    textChar = diacriticalTextString.charAt(position);
                }
                if (GlobalVariables.result != 1) continue;
                textStringBuffer.append("" + textChar);
                if (!hasFoundNewLine && (textStringBuffer.length() <= 0 || ++position >= diacriticalTextString.length() || diacriticalTextString.charAt(position) != '~')) continue;
                if (InputOutput.writeText(false, isFirstCharacterToUpperCase, isReturningToPosition, promptTypeNr, 0, null, textStringBuffer.toString()) == 1) {
                    hasFoundNewLine = false;
                    textStringBuffer = new StringBuffer();
                    continue;
                }
                InputOutput.displayError('?', classNameString_, null, null, 1, "I failed to write a text string part");
            }
            if (GlobalVariables.result == 1 && textStringBuffer.length() > 0 && InputOutput.writeText(false, isFirstCharacterToUpperCase, isReturningToPosition, promptTypeNr, 0, null, textStringBuffer.toString()) != 1) {
                InputOutput.displayError('?', classNameString_, null, null, 1, "I failed to write the last text string part");
            }
        } else {
            InputOutput.displayError('?', classNameString_, null, null, 1, "The given diacritical text string is undefined");
            GlobalVariables.result = 0;
        }
        return GlobalVariables.result;
    }

    /*
     * Unable to fully structure code
     */
    private static byte writeText(boolean isSkippingInTestFile, boolean isFirstCharacterToUpperCase, boolean isReturningToPosition, short promptTypeNr, int leftWidth, int rightWidth, int printStringLength, String promptString, String writeString) {
        block18: {
            block15: {
                block16: {
                    block17: {
                        startNewLine = false;
                        firstLetterPosition = 0;
                        i = 0;
                        length = 0;
                        writeStringBuffer = new StringBuffer();
                        if (writeString == null) break block15;
                        if (printStringLength <= 0 && leftWidth <= 0 && rightWidth <= 0) break block16;
                        if (InputOutput.currentPosition_ > 0 && isReturningToPosition) {
                            InputOutput.returnOutputToPosition(isSkippingInTestFile, false);
                        }
                        while (firstLetterPosition < printStringLength && !Character.isLetter(writeString.charAt(firstLetterPosition)) && !Character.isWhitespace(writeString.charAt(firstLetterPosition))) {
                            ++firstLetterPosition;
                        }
                        textString = !(isFirstCharacterToUpperCase == false || firstLetterPosition >= printStringLength || isReturningToPosition != false && InputOutput.currentPosition_ != 0 || promptTypeNr != 1 && promptTypeNr != 2 && promptTypeNr != 5) ? String.valueOf(writeString.substring(0, firstLetterPosition)) + Character.toUpperCase(writeString.charAt(firstLetterPosition)) + (firstLetterPosition + 1 < printStringLength ? writeString.substring(firstLetterPosition + 1, printStringLength) : "") : writeString.substring(0, printStringLength);
                        if (promptString == null) {
                            promptString = InputOutput.getPromptString(promptTypeNr);
                        }
                        if (promptString == null) break block17;
                        while (i < printStringLength || leftWidth > 0) {
                            if (InputOutput.currentPosition_ == 0 && (promptStringLength = promptString.length()) > 0) {
                                InputOutput.currentPosition_ = promptStringLength - 1;
                                writeStringBuffer.append(promptString);
                            }
                            if (i < printStringLength) {
                                if (textString.charAt(i) == '\t') {
                                    length = 8 - (InputOutput.currentPosition_ + 1) % 8;
                                } else {
                                    length = 0;
                                    wordPosition = i;
                                    do {
                                        ++length;
                                    } while (++i < printStringLength && !Character.isWhitespace(textString.charAt(i)));
                                    if (i < printStringLength && (textString.charAt(i) == '\n' || textString.charAt(i) == '\r')) {
                                        --length;
                                    }
                                    i = wordPosition;
                                }
                                if (i < printStringLength && (textString.charAt(i) == '\n' || textString.charAt(i) == '\r')) {
                                    startNewLine = true;
                                    ++i;
                                    InputOutput.currentPosition_ = 0;
                                    writeStringBuffer.append("\r\n");
                                }
                            }
                            if (!startNewLine) ** GOTO lbl47
                            startNewLine = false;
                            continue;
lbl-1000:
                            // 1 sources

                            {
                                --leftWidth;
                                ++InputOutput.currentPosition_;
                                writeStringBuffer.append(" ");
lbl47:
                                // 2 sources

                                ** while (leftWidth > 0)
                            }
lbl48:
                            // 1 sources

                            if (i >= printStringLength) continue;
                            if (textString.charAt(i) == '\t') {
                                writeStringBuffer.append(textString.charAt(i));
                                ++i;
                                InputOutput.currentPosition_ += length;
                                continue;
                            }
                            do {
                                writeStringBuffer.append(textString.charAt(i));
                                InputOutput.currentPosition_ = textString.charAt(i) == '\n' || textString.charAt(i) == '\r' ? 0 : ++InputOutput.currentPosition_;
                                ++i;
                            } while (length-- > 1);
                        }
                    }
                    while (rightWidth-- > 0) {
                        ++InputOutput.currentPosition_;
                        writeStringBuffer.append(" ");
                    }
                    InputOutput.addStringToOutput(isSkippingInTestFile, true, writeStringBuffer.toString());
                    break block18;
                }
                InputOutput.displayError('?', InputOutput.classNameString_, null, null, 1, "The given write string is empty");
                GlobalVariables.result = 0;
                break block18;
            }
            InputOutput.displayError('?', InputOutput.classNameString_, null, null, 1, "The given write string is undefined");
            GlobalVariables.result = 0;
        }
        return GlobalVariables.result;
    }

    private static byte writeText(boolean isSkippingInTestFile, boolean isFirstCharacterToUpperCase, boolean isReturningToPosition, short promptTypeNr, int queryWidth, String promptString, String textString) {
        int leftWidth = 0;
        int rightWidth = 0;
        if (textString != null) {
            int textStringLength = textString.length();
            if (textStringLength > 0 || queryWidth > 0) {
                InputOutput.clearStatus();
                InputOutput.clearProgress();
                if (promptTypeNr == 5) {
                    GlobalVariables.hasDisplayedWarning = true;
                } else if (promptTypeNr == 7) {
                    GlobalVariables.hasDisplayedIntegrityWarning = true;
                } else {
                    GlobalVariables.hasDisplayedMessage = true;
                }
                if (queryWidth > 0 && queryWidth < textStringLength) {
                    textStringLength = queryWidth;
                }
                if (queryWidth >= textStringLength) {
                    int widthDifference = queryWidth - textStringLength;
                    leftWidth = widthDifference / 2;
                    rightWidth = widthDifference - leftWidth;
                }
                if (InputOutput.writeText(isSkippingInTestFile, isFirstCharacterToUpperCase, isReturningToPosition, promptTypeNr, leftWidth, rightWidth, textStringLength, promptString, textString) == 1) {
                    lastUsedPromptTypeNr_ = (short)(promptTypeNr == 6 ? 5 : (promptTypeNr == 2 ? 1 : (int)promptTypeNr));
                } else {
                    InputOutput.displayError('?', classNameString_, null, null, 1, "I failed to write the string");
                }
            } else {
                InputOutput.displayError('?', classNameString_, null, null, 1, "The given text string is empty");
                GlobalVariables.result = 0;
            }
        } else {
            InputOutput.displayError('?', classNameString_, null, null, 1, "The given text string is undefined");
            GlobalVariables.result = 0;
        }
        return GlobalVariables.result;
    }

    private static String getPromptString(short promptTypeNr) {
        switch (promptTypeNr) {
            case 0: {
                return "> ";
            }
            case 1: {
                return "< ";
            }
            case 2: {
                return "<\t- ";
            }
            case 3: {
                return "";
            }
            case 4: {
                return "* ";
            }
            case 5: 
            case 7: {
                return "! ";
            }
            case 6: {
                return "!\t- ";
            }
        }
        return "? ";
    }

    protected static void initialize() {
        hasReadLine_ = false;
        isDisplayingExtraPromptLine_ = false;
        lastShownInterfaceParameter_ = 0;
        lastUsedPromptTypeNr_ = (short)8;
        currentPosition_ = 0;
        previousProgress_ = 0;
        testFile_ = null;
        currentStatusStringBuffer_ = null;
        outputStringBuffer_ = new StringBuffer();
    }

    protected static void startProgress(short interfaceParameter1, short shortNumber, short interfaceParameter2, int startProgress, int maxProgress) {
        WordItem currentLanguageWordItem = GlobalVariables.currentLanguageWordItem;
        Console.startProgress(startProgress, maxProgress, currentLanguageWordItem == null ? "{no language word found}" : String.valueOf(currentLanguageWordItem.interfaceString(interfaceParameter1)) + shortNumber + currentLanguageWordItem.interfaceString(interfaceParameter2) + "  " + "(" + GlobalVariables.currentSentenceNr + (GlobalVariables.currentSentenceItemNr == 0 ? "" : "," + GlobalVariables.currentSentenceItemNr) + ')');
    }

    protected static void displayProgressBar(int currentProgress) {
        if (currentProgress != previousProgress_) {
            previousProgress_ = currentProgress;
            Console.displayProgress(currentProgress);
        }
    }

    protected static void clearProgress() {
        previousProgress_ = 0;
        Console.clearProgress();
        if (currentStatusStringBuffer_ != null) {
            Console.displayProgressStatus(currentStatusStringBuffer_.toString());
        }
    }

    protected static void redirectOutputToTestFile(BufferedWriter testFile) {
        testFile_ = testFile;
    }

    protected static void displayError(char methodListChar, String classNameString, String parentClassNameString, String wordNameString, int methodLevel, String errorString) {
        StackTraceElement[] elements;
        StringBuffer errorStringBuffer = new StringBuffer();
        Throwable t = new Throwable();
        InputOutput.addStringToOutput(true, true, "");
        if (classNameString != null) {
            errorStringBuffer.append("Class: " + classNameString);
        }
        if (parentClassNameString != null) {
            errorStringBuffer.append(" / parent class " + parentClassNameString);
        }
        if ((elements = t.getStackTrace()) != null) {
            if (elements.length > 0) {
                if (methodLevel < elements.length) {
                    errorStringBuffer.append(".\nMethod: " + elements[methodLevel].getMethodName());
                } else {
                    errorStringBuffer.append(".\nMethod: {Invalid method level}");
                }
            } else {
                errorStringBuffer.append(".\nMethod: {No stack information available}");
            }
        } else {
            errorStringBuffer.append(".\nMethod: {Failed to create Throwable or StackTrace}");
        }
        if (methodListChar != '?') {
            errorStringBuffer.append(" in list <" + methodListChar + ">");
        }
        if (wordNameString != null) {
            errorStringBuffer.append(" of word \"" + wordNameString + "\"");
        }
        if (errorString != null) {
            errorStringBuffer.append(".\nError: " + errorString);
        }
        errorStringBuffer.append(".\n\n");
        Console.addError(" with current item id: (" + GlobalVariables.currentSentenceNr + ',' + GlobalVariables.currentSentenceItemNr + ')', errorStringBuffer.toString());
    }

    protected static boolean hasReadLine() {
        return hasReadLine_;
    }

    protected static char convertDiacriticalChar(char diacriticalChar) {
        switch (diacriticalChar) {
            case 't': {
                return '\t';
            }
            case 'a': {
                return '\u0007';
            }
            case '\"': {
                return '\"';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case '~': {
                return '~';
            }
        }
        return diacriticalChar;
    }

    protected static byte readLine(boolean isClearInputField, boolean isDeveloperTheCurrentUser, boolean isDisplayingLine, boolean isFirstLine, boolean isPassword, boolean isQuestion, String promptString, StringBuffer readStringBuffer, BufferedReader readFile) {
        int startPosition = 0;
        String readString = new String();
        StringBuffer promptStringBuffer = new StringBuffer();
        hasReadLine_ = false;
        lastShownInterfaceParameter_ = 0;
        if (readStringBuffer != null) {
            if (isQuestion) {
                promptStringBuffer.append("< ");
            }
            if (promptString != null) {
                promptStringBuffer.append(isQuestion && promptString.length() > 0 && Character.isLetter(promptString.charAt(0)) ? String.valueOf(Character.toUpperCase(promptString.charAt(0))) + promptString.substring(1) : promptString);
            }
            promptStringBuffer.append(isQuestion ? "? " : "> ");
            if (currentPosition_ > 0) {
                InputOutput.returnOutputToPosition(false, true);
            }
            if (isDisplayingExtraPromptLine_) {
                if (InputOutput.writeText(false, true, true, lastUsedPromptTypeNr_, 0, null, "\n") == 1) {
                    isDisplayingExtraPromptLine_ = false;
                } else {
                    InputOutput.displayError('?', classNameString_, null, null, 1, "I failed to write the line");
                }
            }
            if (GlobalVariables.result == 1) {
                int readStringLength;
                if (isPassword || readFile == null) {
                    currentPosition_ = 0;
                    if (isPassword) {
                        InputOutput.displayStatus((short)1003);
                        InputOutput.addStringToOutput(false, true, String.valueOf(promptStringBuffer.toString()) + "\n");
                        readString = Console.getPassword();
                        if (readString != null) {
                            hasReadLine_ = true;
                        } else {
                            InputOutput.displayError('?', classNameString_, null, null, 1, "The returned password string is undefined");
                            GlobalVariables.result = 0;
                        }
                    } else {
                        if (isClearInputField) {
                            InputOutput.displayStatus((short)1002);
                        } else {
                            InputOutput.clearStatus();
                        }
                        InputOutput.addStringToOutput(false, true, promptStringBuffer.toString());
                        readString = Console.readLine(isClearInputField, isQuestion);
                        if (readString != null) {
                            hasReadLine_ = true;
                        } else {
                            InputOutput.displayError('?', classNameString_, null, null, 1, "The returned read line string is undefined");
                            GlobalVariables.result = 0;
                        }
                    }
                } else {
                    try {
                        readString = readFile.readLine();
                        if (readString != null) {
                            hasReadLine_ = true;
                            if (isFirstLine && readString.length() > 0 && (readString.charAt(0) == '?' || readString.startsWith("\ufeff"))) {
                                readString = readString.substring(1);
                            }
                            if (readString.startsWith("#Dev#")) {
                                if (isDeveloperTheCurrentUser) {
                                    readString = readString.substring("#Dev#".length());
                                } else {
                                    isDisplayingLine = false;
                                }
                            }
                            if (readString.startsWith("#Java#")) {
                                readString = readString.substring("#Java#".length());
                            }
                            if (isDisplayingLine && !readString.startsWith("#C++#") && InputOutput.writeText(false, true, true, (short)0, 0, promptStringBuffer.toString(), readString.length() == 0 ? "\n" : readString) != 1) {
                                InputOutput.displayError('?', classNameString_, null, null, 1, "I failed to write the text");
                            }
                        }
                    }
                    catch (IOException exception) {
                        InputOutput.displayError('?', classNameString_, null, null, 1, exception.toString());
                        GlobalVariables.result = 0;
                    }
                }
                if (GlobalVariables.result == 1 && hasReadLine_ && readString != null && (readStringLength = readString.length()) > 0) {
                    while (startPosition < readStringLength && Character.isWhitespace(readString.charAt(startPosition))) {
                        ++startPosition;
                    }
                    readStringBuffer.append(readString.substring(startPosition));
                }
            }
        } else {
            InputOutput.displayError('?', classNameString_, null, null, 1, "The given read string buffer is undefined");
            GlobalVariables.result = 0;
        }
        return GlobalVariables.result;
    }

    protected static byte writeDiacriticalText(short promptTypeNr, String diacriticalTextString) {
        return InputOutput.writeDiacriticalText(true, true, promptTypeNr, diacriticalTextString);
    }

    protected static byte writeInterfaceText(boolean isCheckingForDuplicateInterfaceParameter, short promptTypeNr, short interfaceParameter) {
        return InputOutput.writeInterfaceText(isCheckingForDuplicateInterfaceParameter, true, promptTypeNr, interfaceParameter);
    }

    protected static byte writeInterfaceText(boolean isCheckingForDuplicateInterfaceParameter, boolean isReturningToPosition, short promptTypeNr, short interfaceParameter) {
        WordItem currentLanguageWordItem = GlobalVariables.currentLanguageWordItem;
        if (currentLanguageWordItem != null) {
            if (!isCheckingForDuplicateInterfaceParameter || interfaceParameter != lastShownInterfaceParameter_) {
                lastShownInterfaceParameter_ = interfaceParameter;
                return InputOutput.writeDiacriticalText(true, isReturningToPosition, promptTypeNr, currentLanguageWordItem.interfaceString(interfaceParameter));
            }
        } else {
            InputOutput.displayError('?', classNameString_, null, null, 1, "The current interface language word is undefined");
            GlobalVariables.result = 0;
        }
        return GlobalVariables.result;
    }

    protected static byte writeInterfaceText(short promptTypeNr, short interfaceParameter1, int intNumber, short interfaceParameter2) {
        WordItem currentLanguageWordItem = GlobalVariables.currentLanguageWordItem;
        if (currentLanguageWordItem != null) {
            return InputOutput.writeDiacriticalText(promptTypeNr, String.valueOf(currentLanguageWordItem.interfaceString(interfaceParameter1)) + intNumber + currentLanguageWordItem.interfaceString(interfaceParameter2));
        }
        InputOutput.displayError('?', classNameString_, null, null, 1, "The current interface language word is undefined");
        GlobalVariables.result = 0;
        return GlobalVariables.result;
    }

    protected static byte writeInterfaceText(short promptTypeNr, short interfaceParameter1, int intNumber, short interfaceParameter2, String textString, short interfaceParameter3) {
        WordItem currentLanguageWordItem = GlobalVariables.currentLanguageWordItem;
        if (currentLanguageWordItem != null) {
            return InputOutput.writeDiacriticalText(promptTypeNr, String.valueOf(currentLanguageWordItem.interfaceString(interfaceParameter1)) + intNumber + currentLanguageWordItem.interfaceString(interfaceParameter2) + textString + currentLanguageWordItem.interfaceString(interfaceParameter3));
        }
        InputOutput.displayError('?', classNameString_, null, null, 1, "The current interface language word is undefined");
        GlobalVariables.result = 0;
        return GlobalVariables.result;
    }

    protected static byte writeInterfaceText(short promptTypeNr, short interfaceParameter1, int intNumber1, short interfaceParameter2, int intNumber2, short interfaceParameter3, String textString, short interfaceParameter4) {
        WordItem currentLanguageWordItem = GlobalVariables.currentLanguageWordItem;
        if (currentLanguageWordItem != null) {
            return InputOutput.writeDiacriticalText(promptTypeNr, String.valueOf(currentLanguageWordItem.interfaceString(interfaceParameter1)) + intNumber1 + currentLanguageWordItem.interfaceString(interfaceParameter2) + intNumber2 + currentLanguageWordItem.interfaceString(interfaceParameter3) + textString + currentLanguageWordItem.interfaceString(interfaceParameter4));
        }
        InputOutput.displayError('?', classNameString_, null, null, 1, "The current interface language word is undefined");
        GlobalVariables.result = 0;
        return GlobalVariables.result;
    }

    protected static byte writeInterfaceText(boolean isCheckingForDuplicateInterfaceParameter, short promptTypeNr, short interfaceParameter1, String textString, short interfaceParameter2) {
        WordItem currentLanguageWordItem = GlobalVariables.currentLanguageWordItem;
        if (currentLanguageWordItem != null) {
            if (!isCheckingForDuplicateInterfaceParameter || interfaceParameter1 != lastShownInterfaceParameter_) {
                lastShownInterfaceParameter_ = interfaceParameter1;
                return InputOutput.writeDiacriticalText(promptTypeNr, String.valueOf(currentLanguageWordItem.interfaceString(interfaceParameter1)) + textString + currentLanguageWordItem.interfaceString(interfaceParameter2));
            }
        } else {
            InputOutput.displayError('?', classNameString_, null, null, 1, "The current interface language word is undefined");
            GlobalVariables.result = 0;
        }
        return GlobalVariables.result;
    }

    protected static byte writeInterfaceText(short promptTypeNr, short interfaceParameter1, String textString, short interfaceParameter2) {
        WordItem currentLanguageWordItem = GlobalVariables.currentLanguageWordItem;
        if (currentLanguageWordItem != null) {
            return InputOutput.writeDiacriticalText(promptTypeNr, String.valueOf(currentLanguageWordItem.interfaceString(interfaceParameter1)) + textString + currentLanguageWordItem.interfaceString(interfaceParameter2));
        }
        InputOutput.displayError('?', classNameString_, null, null, 1, "The current interface language word is undefined");
        GlobalVariables.result = 0;
        return GlobalVariables.result;
    }

    protected static byte writeInterfaceText(short promptTypeNr, short interfaceParameter1, String textString1, short interfaceParameter2, String textString2, short interfaceParameter3) {
        WordItem currentLanguageWordItem = GlobalVariables.currentLanguageWordItem;
        if (currentLanguageWordItem != null) {
            return InputOutput.writeDiacriticalText(promptTypeNr, String.valueOf(currentLanguageWordItem.interfaceString(interfaceParameter1)) + textString1 + currentLanguageWordItem.interfaceString(interfaceParameter2) + textString2 + currentLanguageWordItem.interfaceString(interfaceParameter3));
        }
        InputOutput.displayError('?', classNameString_, null, null, 1, "The current interface language word is undefined");
        GlobalVariables.result = 0;
        return GlobalVariables.result;
    }

    protected static byte writeInterfaceText(short promptTypeNr, short interfaceParameter1, String textString, short interfaceParameter2, int intNumber, short interfaceParameter3) {
        WordItem currentLanguageWordItem = GlobalVariables.currentLanguageWordItem;
        if (currentLanguageWordItem != null) {
            return InputOutput.writeDiacriticalText(promptTypeNr, String.valueOf(currentLanguageWordItem.interfaceString(interfaceParameter1)) + textString + currentLanguageWordItem.interfaceString(interfaceParameter2) + intNumber + currentLanguageWordItem.interfaceString(interfaceParameter3));
        }
        InputOutput.displayError('?', classNameString_, null, null, 1, "The current interface language word is undefined");
        GlobalVariables.result = 0;
        return GlobalVariables.result;
    }

    protected static byte writeText(short promptTypeNr, StringBuffer textStringBuffer1, StringBuffer textStringBuffer2) {
        if (textStringBuffer1 != null) {
            isDisplayingExtraPromptLine_ = true;
            if (InputOutput.writeText(false, true, true, promptTypeNr, 0, null, textStringBuffer1.toString()) == 1 && textStringBuffer2 != null && textStringBuffer2.length() > 0) {
                return InputOutput.writeText(false, true, false, promptTypeNr, 0, null, textStringBuffer2.toString());
            }
        } else {
            InputOutput.displayError('?', classNameString_, null, null, 1, "The given first diacritical text string buffer is undefined");
            GlobalVariables.result = 0;
        }
        return GlobalVariables.result;
    }

    protected static byte writeText(boolean isReturningToPosition, short promptTypeNr, int queryWidth, StringBuffer textStringBuffer) {
        if (textStringBuffer != null) {
            return InputOutput.writeText(false, true, isReturningToPosition, promptTypeNr, queryWidth, null, textStringBuffer.toString());
        }
        InputOutput.displayError('?', classNameString_, null, null, 1, "The given text string buffer is undefined");
        GlobalVariables.result = 0;
        return GlobalVariables.result;
    }

    protected static byte writeText(boolean isSkippingInTestFile, boolean isReturningToPosition, short promptTypeNr, int queryWidth, String textString) {
        return InputOutput.writeText(isSkippingInTestFile, true, isReturningToPosition, promptTypeNr, queryWidth, null, textString);
    }
}

