/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import org.mafait.thinknowlogy.BoolResultType;
import org.mafait.thinknowlogy.GrammarItem;
import org.mafait.thinknowlogy.List;
import org.mafait.thinknowlogy.ReadItem;
import org.mafait.thinknowlogy.ShortResultType;
import org.mafait.thinknowlogy.WordItem;

class ReadList
extends List {
    private short lastActivatedWordOrderNr_ = 0;

    private boolean hasFoundReadItem(short wordOrderNr, short wordParameter, short wordTypeNr, WordItem readWordItem) {
        ReadItem searchReadItem = this.firstActiveReadItem();
        while (searchReadItem != null) {
            if (searchReadItem.wordOrderNr() == wordOrderNr && searchReadItem.wordParameter() == wordParameter && searchReadItem.wordTypeNr() == wordTypeNr && searchReadItem.readWordItem() == readWordItem) {
                return true;
            }
            searchReadItem = searchReadItem.nextReadItem();
        }
        return false;
    }

    protected ReadList(WordItem myWordItem) {
        this.initializeListVariables('R', "ReadList", myWordItem);
    }

    @Override
    protected boolean isTemporaryList() {
        return true;
    }

    protected void clearLastActivatedWordOrderNr() {
        this.lastActivatedWordOrderNr_ = 0;
    }

    protected byte activateInactiveReadWords(short wordOrderNr) {
        ReadItem searchReadItem = this.firstInactiveReadItem();
        while (searchReadItem != null) {
            if (!searchReadItem.isPreposition() && searchReadItem.wordOrderNr() > wordOrderNr) {
                if (this.activateItem(searchReadItem) != 1) {
                    return this.addError(1, "I failed to activate an inactive item");
                }
                searchReadItem = this.nextReadListItem();
                continue;
            }
            searchReadItem = searchReadItem.nextReadItem();
        }
        return 1;
    }

    protected byte createReadItem(boolean isUncountableGeneralizationNoun, short wordOrderNr, short wordParameter, short wordTypeNr, int readStringLength, String readString, WordItem readWordItem) {
        if (wordTypeNr <= 0 || wordTypeNr >= 26) {
            return this.startError(1, "The given read word type number is undefined or out of bounds");
        }
        if (this.hasFoundReadItem(wordOrderNr, wordParameter, wordTypeNr, readWordItem)) {
            return this.startError(1, "The given read item already exists");
        }
        if (this.addItemToList('+', new ReadItem(isUncountableGeneralizationNoun, wordOrderNr, wordParameter, wordTypeNr, readStringLength, readString, readWordItem, this, this.myWordItem())) != 1) {
            return this.addError(1, "I failed to add a read item");
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    protected byte deleteReadItemsWithNonMatchingMultipleWordPart(short wordOrderNr, String sentenceString) {
        searchReadItem = this.firstActiveReadItem();
        if (sentenceString != null) ** GOTO lbl13
        return this.startError(1, "The given sentence string is undefined");
lbl-1000:
        // 1 sources

        {
            if (searchReadItem.wordOrderNr() == wordOrderNr && (readWordItem = searchReadItem.readWordItem()) != null) {
                if (readWordItem.isMultipleWord() && readWordItem.matchingMultipleWordParts(sentenceString) == 0) {
                    if (this.deleteItem(searchReadItem) != 1) {
                        return this.addError(1, "I failed to delete a read item");
                    }
                    searchReadItem = this.nextReadListItem();
                    continue;
                }
                searchReadItem = searchReadItem.nextReadItem();
                continue;
            }
            searchReadItem = searchReadItem.nextReadItem();
lbl13:
            // 4 sources

            ** while (searchReadItem != null)
        }
lbl14:
        // 1 sources

        return 1;
    }

    protected byte setGrammarParameter(boolean isValid, short startWordOrderNr, short endWordOrderNr, GrammarItem definitionGrammarItem) {
        short wordOrderNr;
        boolean hasFound = false;
        boolean isMarked = true;
        ReadItem searchReadItem = this.firstActiveReadItem();
        if (endWordOrderNr <= 0) {
            return this.startError(1, "The given end word order number is undefined");
        }
        if (startWordOrderNr >= endWordOrderNr) {
            return this.startError(1, "The given start word order number is equal or higher than the given end word order number");
        }
        if (definitionGrammarItem == null) {
            return this.startError(1, "The given grammar definition word item is undefined");
        }
        if (isValid) {
            while (isMarked && searchReadItem != null && (wordOrderNr = searchReadItem.wordOrderNr()) <= endWordOrderNr) {
                if (!searchReadItem.isMarkedBySetGrammarParameter && wordOrderNr > startWordOrderNr && wordOrderNr <= endWordOrderNr) {
                    isMarked = false;
                }
                searchReadItem = searchReadItem.nextReadItem();
            }
            searchReadItem = this.firstActiveReadItem();
        }
        while (searchReadItem != null && (wordOrderNr = searchReadItem.wordOrderNr()) <= endWordOrderNr) {
            if (wordOrderNr > startWordOrderNr && wordOrderNr <= endWordOrderNr) {
                hasFound = true;
                if (isValid) {
                    if (isMarked || definitionGrammarItem.grammarParameter() > searchReadItem.grammarParameter) {
                        String definitionGrammarString;
                        searchReadItem.isMarkedBySetGrammarParameter = false;
                        searchReadItem.grammarParameter = definitionGrammarItem.grammarParameter();
                        searchReadItem.definitionGrammarItem = definitionGrammarItem;
                        if (searchReadItem.readString == null && (definitionGrammarString = definitionGrammarItem.grammarString()) != null) {
                            searchReadItem.readString = definitionGrammarString;
                        }
                    }
                } else {
                    searchReadItem.isMarkedBySetGrammarParameter = true;
                }
            }
            searchReadItem = searchReadItem.nextReadItem();
        }
        if (!hasFound) {
            return this.startError(1, "I couldn't find any item between the given word order numbers");
        }
        return 1;
    }

    protected ReadItem firstActiveReadItem() {
        return (ReadItem)this.firstActiveItem();
    }

    protected ReadItem firstInactiveReadItem() {
        return (ReadItem)this.firstInactiveItem();
    }

    protected ReadItem nextReadListItem() {
        return (ReadItem)this.nextListItem();
    }

    /*
     * Unable to fully structure code
     */
    protected BoolResultType findMoreInterpretations() {
        block2: {
            activeReadItem = this.firstActiveReadItem();
            inactiveReadItem = this.firstInactiveReadItem();
            boolResult = new BoolResultType();
            while (inactiveReadItem != null && inactiveReadItem.nextReadItem() != null) {
                inactiveReadItem = inactiveReadItem.nextReadItem();
            }
            if (inactiveReadItem == null) break block2;
            boolResult.booleanValue = true;
            this.lastActivatedWordOrderNr_ = inactiveReadItem.wordOrderNr();
            if (this.activateItem(inactiveReadItem) == 1) ** GOTO lbl14
            return this.addBoolResultError(1, "I failed to active an inactive item");
lbl-1000:
            // 1 sources

            {
                activeReadItem.grammarParameter = 0;
                activeReadItem = activeReadItem.nextReadItem();
lbl14:
                // 2 sources

                ** while (activeReadItem != null)
            }
        }
        return boolResult;
    }

    protected BoolResultType selectMatchingWordType(short currentWordOrderNr, short wordParameter, short wordTypeNr) {
        ReadItem activeReadItem;
        boolean hasFoundMatchingWordType = false;
        ReadItem currentReadItem = this.firstActiveReadItem();
        BoolResultType boolResult = new BoolResultType();
        if (currentWordOrderNr > 0) {
            while (currentReadItem != null && currentReadItem.wordOrderNr() <= currentWordOrderNr) {
                currentReadItem = currentReadItem.nextReadItem();
            }
        }
        if ((activeReadItem = currentReadItem) != null) {
            do {
                if (currentReadItem == null) continue;
                if (currentReadItem.wordTypeNr() == wordTypeNr && currentReadItem.wordParameter() == wordParameter) {
                    hasFoundMatchingWordType = true;
                    while (activeReadItem != currentReadItem) {
                        if (this.inactivateItem(activeReadItem) != 1) {
                            return this.addBoolResultError(1, "I failed to inactive an active item");
                        }
                        activeReadItem = this.nextReadListItem();
                    }
                } else {
                    currentReadItem = currentReadItem.nextReadItem();
                }
            } while (!hasFoundMatchingWordType && currentReadItem != null && currentReadItem.wordOrderNr() == currentWordOrderNr + 1 && currentReadItem.wordOrderNr() > this.lastActivatedWordOrderNr_);
        }
        boolResult.booleanValue = hasFoundMatchingWordType;
        return boolResult;
    }

    /*
     * Unable to fully structure code
     */
    protected ShortResultType getNumberOfReadWordReferences(short wordTypeNr, WordItem readWordItem) {
        nReadWordReferences = 0;
        searchReadItem = this.firstActiveReadItem();
        shortResult = new ShortResultType();
        if (readWordItem != null) ** GOTO lbl9
        return this.startShortResultError(1, "The given read word is undefined");
lbl-1000:
        // 1 sources

        {
            if (searchReadItem.wordTypeNr() == wordTypeNr && searchReadItem.readWordItem() == readWordItem) {
                nReadWordReferences = (short)(nReadWordReferences + 1);
            }
            searchReadItem = searchReadItem.nextReadItem();
lbl9:
            // 2 sources

            ** while (searchReadItem != null)
        }
lbl10:
        // 1 sources

        searchReadItem = this.firstInactiveReadItem();
        while (searchReadItem != null) {
            if (searchReadItem.wordTypeNr() == wordTypeNr && searchReadItem.readWordItem() == readWordItem) {
                nReadWordReferences = (short)(nReadWordReferences + 1);
            }
            searchReadItem = searchReadItem.nextReadItem();
        }
        shortResult.shortValue = nReadWordReferences;
        return shortResult;
    }
}

