/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/10
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc
 * t@C  (file name)    FBeanMapper.java
 */
package net.sf.thirdi.jdbc;

import java.sql.ResultSet;
import java.util.List;
import java.util.Map;

/**
 * <i>Tv(abstract)</i>F OR}bp[
 *@.<p>
 * OR}bp[
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public interface ORMapper {
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}PBeanɃ}bsO܂B
	 * .<p>
	 *  {@link java.sql.ResultSet}PBeanɃ}bsO܂B
	 *@
	 * @param rs  {@link java.sql.ResultSet}IuWFNg
	 * @param clazz@Bean@Class
	 * @return@}bsOBeanIuWFNg
	 */
	public abstract <T> T mapRow(ResultSet rs,Class<T> clazz);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param clazz@Bean@Class
	 * @return@Bean}bsOList
	 */
	public abstract <T> List<T>  mapRowList(ResultSet rs,Class<T> clazz);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}}bsOBeanListɊi[܂B<BR>
	 *@R[hJEg̎w肪ł܂B
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param clazz@Bean@Class
	 * @param maxcount@R[hől
	 * @return@Bean}bsOList
	 */
	public abstract <T> List<T>  mapRowList(ResultSet rs,Class<T> clazz,long maxcount);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}}bsOBeanListɊi[܂B<BR>
	 * f[^oChBeanListɊi[OɃfR[^[Ă΂܂B<BR>
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param clazz@Bean@Class
	 * @param beandecorater@fR[^[
	 * @return@Bean}bsOList
	 */
	public abstract <T> List<T>  mapRowList(ResultSet rs,Class<T> clazz, BeanDecorater beandecorater);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}}bsOBeanListɊi[܂B
	 * .<p>
	@* {@link java.sql.ResultSet}}bsOBeanListɊi[܂B<BR>
	 * @f[^oChBeanListɊi[OɃfR[^[Ă΂܂B<BR>
	 *  R[hJEg̎w肪ł܂B<BR>
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param clazz@Bean@Class
	 * @param beandecorater@fR[^[
	 * @param maxcount@R[hJEgől
	 * @return@Bean}bsOList
	 */
	public abstract <T> List<T>  mapRowList(ResultSet rs,Class<T> clazz, BeanDecorater beandecorater,long maxcount);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}JKEYMapɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[܂B<BR>
	 *@J̓IWi̕Ŋi[܂B<BR>
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @return@R[h}bsOMapIuWFNg
	 */
	public abstract Map<String,?> toMap(ResultSet rs);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}JKEYMapɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[܂B<BR>
	 * J͑啶Aw\łB<BR>
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param type@^Cv
	 * @return@R[h}bsOMapIuWFNg
	 */
	public abstract Map<String,?> toMap(ResultSet rs,MappingLetterType type);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @return@R[h}bsÕXgIuWFNg
	 */
	public abstract List<Map<String,?>> toMapList(ResultSet rs);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B<BR>
	 *@ListɊi[郌R[h̍őlw肷邱Ƃł܂B@<BR>
	 *
	 * @param rs@{java.sql.ResultSet}IuWFNg
	 * @param maxcount@R[hől
	 * @return@R[h}bsÕXgIuWFNg
	 */
	public abstract List<Map<String,?>> toMapList(ResultSet rs,long maxcount);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B<BR>
	 *@ListɊi[郌R[h̃J啶AƎw肷邱Ƃł܂B@<BR>
	 *
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param type@^Cv
	 * @return@R[h}bsÕXgIuWFNg
	 */
	public abstract List<Map<String,?>> toMapList(ResultSet rs,MappingLetterType type);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B
	 * .<p>
	 * {@link java.sql.ResultSet}JKEYMapɊi[̂ListɊi[܂B<BR>
	 *@ListɊi[郌R[h̃J啶AƎw肷邱Ƃł܂B<BR>
	 * ListɊi[郌R[h̍őlw肷邱Ƃł܂B@@<BR>
	 *
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param type@^Cv
	 * @param  maxcount@R[hől
	 * @return@R[h}bsÕXgIuWFNg
	 */
	public abstract List<Map<String,?>> toMapList(ResultSet rs,MappingLetterType type,long maxcount);
	
}
