/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/14
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.impl
 * t@C  (file name)    FCSVInfoImpl.java
 */
package net.sf.thirdi.jdbc.impl;

import net.sf.thirdi.jdbc.CSVFormatMode;
import net.sf.thirdi.jdbc.CSVInfo;
import net.sf.thirdi.jdbc.MappingLetterType;

/**
 * <i>Tv(abstract)</i>F CSVInfo
 *@.<p>
 * CSVInfo
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class CSVInfoImpl implements CSVInfo{
	
	private boolean addHeaderColumn = true;
	
	private boolean removereturn = false;;
	
	private boolean escapedoublequotation = false;;
	
	private MappingLetterType type = MappingLetterType.ORIGINAL_LETTER;
	
	private CSVFormatMode mode = CSVFormatMode.ORIGINAL;
	
	private char fieldseparatorchar = ',';
	
	private String recordseparatorchar = "\r\n";
	
	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#addHeaderColumn()
	 */
	@Override
	public boolean addHeaderColumn() {
		return this.addHeaderColumn;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#getFieldSeparator()
	 */
	@Override
	public char getFieldSeparator() {
		return this.fieldseparatorchar;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#getFormatMode()
	 */
	@Override
	public CSVFormatMode getFormatMode() {
		return this.mode;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#getMappingLetterType()
	 */
	@Override
	public MappingLetterType getMappingLetterType() {
		return this.type;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#getRecordSeparator()
	 */
	@Override
	public String getRecordSeparator() {
		return this.recordseparatorchar;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#isEscapeDoubleQuotation()
	 */
	@Override
	public boolean isEscapeDoubleQuotation() {
		return this.escapedoublequotation;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#isRemoveReturn()
	 */
	@Override
	public boolean isRemoveReturn() {
		return this.removereturn;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setAddheaderColumn(boolean)
	 */
	@Override
	public void setAddheaderColumn(boolean flag) {
		this.addHeaderColumn = flag;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setEscapeDoubleQuotation(boolean)
	 */
	@Override
	public void setEscapeDoubleQuotation(boolean flag) {
		this.escapedoublequotation = flag;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setFieldSeparatorChar(char)
	 */
	@Override
	public void setFieldSeparatorChar(char separator)
			throws IllegalArgumentException {
		
		if ('\u0000' <= separator && '\u0020' > separator){
			// TODO message move to property file.
			throw new IllegalArgumentException("field separator must not be illegal character.");
		}
		
		this.fieldseparatorchar = separator;
		
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setFormtMode(net.sf.thirdi.jdbc.CSVFormatMode)
	 */
	@Override
	public void setFormtMode(CSVFormatMode mode) {
		this.mode = mode;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setMappingLetterType(net.sf.thirdi.jdbc.MappingLetterType)
	 */
	@Override
	public void setMappingLetterType(MappingLetterType type) {
		this.type = type;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setRecordSeparatorChar(String)
	 */
	@Override
	public void setRecordSeparatorChar(String separator)
			throws IllegalArgumentException {
		if (separator == null || "".equals(separator)){
			
			// TODO message move to property file.
			throw new IllegalArgumentException("Record separator must not be null or blank.");
		}
		
		this.recordseparatorchar = separator;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVInfo#setRemoveReturnMode(boolean)
	 */
	@Override
	public void setRemoveReturnMode(boolean flag) {
		this.removereturn = flag;
	}

}
