/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.constraint;

import net.sf.thirdi.validation.ByteLength;
import net.sf.thirdi.validation.spec.Constraint;
import net.sf.thirdi.validation.spec.ConstraintContext;

public final class ByteLengthConstraint implements Constraint<ByteLength> {

	private int min;

	private int max;

	public void initialize(ByteLength constraintAnnotation) {
		this.min = constraintAnnotation.min();
		this.max = constraintAnnotation.max();
		if (this.min > this.max)
			throw new IllegalArgumentException("Expected max >= min: min="
					+ this.min + ", max=" + this.max);
	}

	public boolean isValid(Object value, ConstraintContext constraintcontext) {

		int length = 0;

		if (value != null) {
			length = (String.valueOf(value)).getBytes().length;
		}
		return length >= min && length <= max;
	}

}
