/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.constraint;

import net.sf.thirdi.validation.InString;
import net.sf.thirdi.validation.spec.Constraint;
import net.sf.thirdi.validation.spec.ConstraintContext;
import net.sf.thirdi.validation.util.Assertion;

public final class InStringConstraint implements Constraint<InString> {

	private boolean nullability;

	private String[] values;

	public void initialize(InString constraintAnnotation) {
		this.nullability = constraintAnnotation.nullability();
		this.values = constraintAnnotation.value();
	}

	public boolean isValid(Object value, ConstraintContext constraintcontext) {

		if (this.nullability) {
			if (value == null)
				return true;
		}

		Assertion.isStringType(value);
		String buf = (String) value;

		if (values == null)
			return true;

		for (int i = 0; i < values.length; i++) {
			if (buf.equals(values[i])) {
				return true;
			}
		}

		return false;
	}

}
