/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.constraint;

import net.sf.thirdi.validation.ValidateWithJavaScript;
import net.sf.thirdi.validation.spec.Constraint;
import net.sf.thirdi.validation.spec.ConstraintContext;
import net.sf.thirdi.validation.util.JavaScriptUtil;

public final class ValidateWithJavaScriptConstraint implements
		Constraint<ValidateWithJavaScript> {

	private String expression;

	private boolean nullability;

	public void initialize(ValidateWithJavaScript constraintAnnotation) {
		this.expression = constraintAnnotation.expression();
		this.nullability = constraintAnnotation.nullability();

	}

	public boolean isValid(Object bean, ConstraintContext constraintcontext) {
		if (nullability) {
			if (bean == null)
				return true;
		} else {
			if (bean == null)
				throw new NullPointerException("parameter value is null.");
		}

		if (this.expression == null || "".equals(this.expression))
			throw new RuntimeException("expression is null or empty.");

		Object result = JavaScriptUtil.evaluate(expression, "_this", bean);

		if (!(result instanceof Boolean))
			throw new RuntimeException(
					"expression returnType must be boolean value.");
		return (Boolean) result;

	}

}
