/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.core;

import net.sf.thirdi.validation.spec.ConstraintContext;

public class TIConstraintContext implements ConstraintContext {

	private String message;

	private final String defaultMessage;

	protected boolean defaultDisabled = false;

	private String propertyName;

	private final Class<?> type;

	private final Object bean;

	TIConstraintContext(String defaultMessage, Class<?> type, Object bean) {
		this.defaultMessage = defaultMessage;
		this.type = type;
		this.bean = bean;
	}

	public void addError(String errorMessage) {
		this.message = errorMessage;
	}

	public void addError(String errorMessage, String propertyName) {
		this.propertyName = propertyName;
		this.message = errorMessage;
	}

	public void disableDefaultError() {
		defaultDisabled = true;
	}

	public String getDefaultErrorMessage() {
		return defaultMessage;
	}

	public Object getBean() {
		return bean;
	}

	public String getDefaultMessage() {
		return defaultMessage;
	}

	public String getMessage() {
		return message;
	}

	public String getPropertyName() {
		return propertyName;
	}

	public Class<?> getType() {
		return type;
	}

}
