/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.core;

import net.sf.thirdi.validation.message.MessageEditorImpl;
import net.sf.thirdi.validation.spec.ConstraintFactory;
import net.sf.thirdi.validation.spec.MessageEditor;
import net.sf.thirdi.validation.spec.ValidatorFactory;
import net.sf.thirdi.validation.spec.ValidatorFactoryBuilder;

public class TIValidatorFactoryBuilder implements ValidatorFactoryBuilder {

	private MessageEditor messageresolver;

	private ConstraintFactory constraintfactory;

	public ValidatorFactory build() {

		this.messageresolver = getInternalDefaultMessageResolver();
		this.constraintfactory = getInternalDefaultConstraintFactory();

		return new TIValidatorFactory(this.messageresolver,
				this.constraintfactory);
	}

	private MessageEditor getInternalDefaultMessageResolver() {
		return new MessageEditorImpl();
	}

	private ConstraintFactory getInternalDefaultConstraintFactory() {
		return new TIConstraintFactory();
	}
}
